/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), UIManager.get("InternalFrame.activeTitleGradient") != null ? null : MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.get("InternalFrame.inactiveTitleGradient") != null ? null : MetalLookAndFeel.getControl());
    MetalBumps paletteBumps;
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public void addNotify() {
        super.addNotify();
        this.updateOptionPaneState();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.wasClosable = this.frame.isClosable();
        this.selectedBackgroundKey = null;
        this.selectedForegroundKey = null;
        if (MetalLookAndFeel.usingOcean()) {
            this.setOpaque(true);
        }
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.wasClosable != this.frame.isClosable()) {
            this.frame.setClosable(this.wasClosable);
        }
    }

    protected void createButtons() {
        super.createButtons();
        Boolean bl2 = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", bl2);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton.putClientProperty("paintActive", bl2);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("paintActive", bl2);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
        if (MetalLookAndFeel.usingOcean()) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void showSystemMenu() {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    public void paintPalette(Graphics graphics) {
        boolean bl2 = MetalUtils.isLeftToRight(this.frame);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n2, n3);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n3 - 1, n2, n3 - 1);
        int n4 = bl2 ? 4 : this.buttonsWidth + 4;
        int n5 = n2 - this.buttonsWidth - 8;
        int n6 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n5, n6);
        this.paletteBumps.paintIcon(this, graphics, n4, 2);
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        MetalBumps metalBumps;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl2 = MetalUtils.isLeftToRight(this.frame);
        boolean bl3 = this.frame.isSelected();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (bl3) {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(true);
                this.maxButton.setContentAreaFilled(true);
                this.iconButton.setContentAreaFilled(true);
            }
            if (this.selectedBackgroundKey != null) {
                color = UIManager.getColor(this.selectedBackgroundKey);
            }
            if (color == null) {
                color = MetalLookAndFeel.getWindowTitleBackground();
            }
            if (this.selectedForegroundKey != null) {
                color2 = UIManager.getColor(this.selectedForegroundKey);
            }
            if (this.selectedShadowKey != null) {
                color3 = UIManager.getColor(this.selectedShadowKey);
            }
            if (color3 == null) {
                color3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            }
            if (color2 == null) {
                color2 = MetalLookAndFeel.getWindowTitleForeground();
            }
            this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, UIManager.get("InternalFrame.activeTitleGradient") != null ? null : color);
            metalBumps = this.activeBumps;
            string = "InternalFrame.activeTitleGradient";
        } else {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(false);
                this.maxButton.setContentAreaFilled(false);
                this.iconButton.setContentAreaFilled(false);
            }
            color = MetalLookAndFeel.getWindowTitleInactiveBackground();
            color2 = MetalLookAndFeel.getWindowTitleInactiveForeground();
            color3 = MetalLookAndFeel.getControlDarkShadow();
            metalBumps = this.inactiveBumps;
            string = "InternalFrame.inactiveTitleGradient";
        }
        if (!MetalUtils.drawGradient(this, graphics, string, 0, 0, n6, n7, true)) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n6, n7);
        }
        graphics.setColor(color3);
        graphics.drawLine(0, n7 - 1, n6, n7 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n6 - 1, 0, n6 - 1, 0);
        int n8 = 0;
        int n9 = bl2 ? 5 : n6 - 5;
        String string2 = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl2) {
                n9 -= icon.getIconWidth();
            }
            n5 = n7 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n9, n5);
            n9 += bl2 ? icon.getIconWidth() + 5 : -5;
        }
        if (string2 != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.frame, graphics, font);
            n4 = fontMetrics.getHeight();
            graphics.setColor(color2);
            n3 = (n7 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (bl2) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int n10 = rectangle.x - n9 - 4;
                string2 = this.getTitle(string2, fontMetrics, n10);
            } else {
                int n11 = n9 - rectangle.x - rectangle.width - 4;
                string2 = this.getTitle(string2, fontMetrics, n11);
                n9 -= SwingUtilities2.stringWidth(this.frame, fontMetrics, string2);
            }
            n8 = SwingUtilities2.stringWidth(this.frame, fontMetrics, string2);
            SwingUtilities2.drawString((JComponent)this.frame, graphics, string2, n9, n3);
            n9 += bl2 ? n8 + 5 : -5;
        }
        if (bl2) {
            n2 = n6 - this.buttonsWidth - n9 - 5;
            n5 = n9;
        } else {
            n2 = n9 - this.buttonsWidth - 5;
            n5 = this.buttonsWidth + 5;
        }
        n4 = 3;
        n3 = this.getHeight() - 2 * n4;
        metalBumps.setBumpArea(n2, n3);
        metalBumps.paintIcon(this, graphics, n5, n4);
    }

    public void setPalette(boolean bl2) {
        this.isPalette = bl2;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void updateOptionPaneState() {
        int n2 = -2;
        boolean bl2 = this.wasClosable;
        Object object = this.frame.getClientProperty("JInternalFrame.messageType");
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            n2 = (Integer)object;
        }
        switch (n2) {
            case 0: {
                this.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                bl2 = false;
                break;
            }
            case 3: {
                this.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                bl2 = false;
                break;
            }
            case 2: {
                this.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                bl2 = false;
                break;
            }
            case -1: 
            case 1: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
                bl2 = false;
                break;
            }
            default: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
            }
        }
        if (bl2 != this.frame.isClosable()) {
            this.frame.setClosable(bl2);
        }
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                MetalInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", bl2);
                MetalInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", bl2);
                MetalInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", bl2);
            } else if ("JInternalFrame.messageType".equals(string)) {
                MetalInternalFrameTitlePane.this.updateOptionPaneState();
                MetalInternalFrameTitlePane.this.frame.repaint();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    class MetalTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MetalTitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            int n4 = 30;
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                n4 += 21;
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable()) {
                n4 += 16 + (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable()) {
                n4 += 16 + (MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = MetalInternalFrameTitlePane.this.frame.getFontMetrics(MetalInternalFrameTitlePane.this.getFont());
            String string = MetalInternalFrameTitlePane.this.frame.getTitle();
            int n5 = string != null ? SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fontMetrics, string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 2 ? (n4 += n5 < (n2 = SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fontMetrics, MetalInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n5 : n2) : (n4 += n5);
            n2 = 0;
            if (MetalInternalFrameTitlePane.this.isPalette) {
                n2 = MetalInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int n7 = fontMetrics.getHeight();
                n7 += 7;
                Icon icon = MetalInternalFrameTitlePane.this.frame.getFrameIcon();
                int n8 = 0;
                if (icon != null) {
                    n8 = Math.min(icon.getIconHeight(), 16);
                }
                n2 = Math.max(n7, n8 += 5);
            }
            return new Dimension(n4, n2);
        }

        public void layoutContainer(Container container) {
            int n2;
            boolean bl2 = MetalUtils.isLeftToRight(MetalInternalFrameTitlePane.this.frame);
            int n3 = MetalInternalFrameTitlePane.this.getWidth();
            int n4 = bl2 ? n3 : 0;
            int n5 = 2;
            int n6 = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int n7 = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                if (MetalInternalFrameTitlePane.this.isPalette) {
                    n2 = 3;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(n4 += bl2 ? -n2 - (n7 + 2) : n2, n5, n7 + 2, MetalInternalFrameTitlePane.this.getHeight() - 4);
                    if (!bl2) {
                        n4 += n7 + 2;
                    }
                } else {
                    n2 = 4;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(n4 += bl2 ? -n2 - n7 : n2, n5, n7, n6);
                    if (!bl2) {
                        n4 += n7;
                    }
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable() && !MetalInternalFrameTitlePane.this.isPalette) {
                n2 = MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                MetalInternalFrameTitlePane.this.maxButton.setBounds(n4 += bl2 ? -n2 - n7 : n2, n5, n7, n6);
                if (!bl2) {
                    n4 += n7;
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable() && !MetalInternalFrameTitlePane.this.isPalette) {
                n2 = MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                MetalInternalFrameTitlePane.this.iconButton.setBounds(n4 += bl2 ? -n2 - n7 : n2, n5, n7, n6);
                if (!bl2) {
                    n4 += n7;
                }
            }
            MetalInternalFrameTitlePane.this.buttonsWidth = bl2 ? n3 - n4 : n4;
        }
    }
}

