/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private final long earliestSequenceNumber;
    private final long nextSequenceNumber;
    private final TargetedNotification[] targetedNotifications;

    public NotificationResult(long l2, long l3, TargetedNotification[] targetedNotificationArray) {
        if (targetedNotificationArray == null) {
            throw new IllegalArgumentException("Notifications null");
        }
        if (l2 < 0L || l3 < 0L) {
            throw new IllegalArgumentException("Bad sequence numbers");
        }
        this.earliestSequenceNumber = l2;
        this.nextSequenceNumber = l3;
        this.targetedNotifications = targetedNotificationArray;
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications;
    }

    public String toString() {
        return "NotificationResult: earliest=" + this.getEarliestSequenceNumber() + "; next=" + this.getNextSequenceNumber() + "; nnotifs=" + this.getTargetedNotifications().length;
    }
}

