/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    public static void sort(long[] lArray) {
        Arrays.sort1(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n2, int n3) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        Arrays.sort1(lArray, n2, n3 - n2);
    }

    public static void sort(int[] nArray) {
        Arrays.sort1(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        Arrays.sort1(nArray, n2, n3 - n2);
    }

    public static void sort(short[] sArray) {
        Arrays.sort1(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n2, int n3) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        Arrays.sort1(sArray, n2, n3 - n2);
    }

    public static void sort(char[] cArray) {
        Arrays.sort1(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n2, int n3) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        Arrays.sort1(cArray, n2, n3 - n2);
    }

    public static void sort(byte[] byArray) {
        Arrays.sort1(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n2, int n3) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        Arrays.sort1(byArray, n2, n3 - n2);
    }

    public static void sort(double[] dArray) {
        Arrays.sort2(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n2, int n3) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        Arrays.sort2(dArray, n2, n3);
    }

    public static void sort(float[] fArray) {
        Arrays.sort2(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n2, int n3) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        Arrays.sort2(fArray, n2, n3);
    }

    private static void sort2(double[] dArray, int n2, int n3) {
        long l2 = Double.doubleToLongBits(-0.0);
        int n4 = 0;
        int n5 = n2;
        int n6 = n3;
        while (n5 < n6) {
            if (dArray[n5] != dArray[n5]) {
                double d2 = dArray[n5];
                dArray[n5] = dArray[--n6];
                dArray[n6] = d2;
                continue;
            }
            if (dArray[n5] == 0.0 && Double.doubleToLongBits(dArray[n5]) == l2) {
                dArray[n5] = 0.0;
                ++n4;
            }
            ++n5;
        }
        Arrays.sort1(dArray, n2, n6 - n2);
        if (n4 != 0) {
            int n7 = Arrays.binarySearch(dArray, 0.0, n2, n6 - 1);
            while (--n7 >= 0 && dArray[n7] == 0.0) {
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray[++n7] = -0.0;
            }
        }
    }

    private static void sort2(float[] fArray, int n2, int n3) {
        int n4 = Float.floatToIntBits(-0.0f);
        int n5 = 0;
        int n6 = n2;
        int n7 = n3;
        while (n6 < n7) {
            if (fArray[n6] != fArray[n6]) {
                float f2 = fArray[n6];
                fArray[n6] = fArray[--n7];
                fArray[n7] = f2;
                continue;
            }
            if (fArray[n6] == 0.0f && Float.floatToIntBits(fArray[n6]) == n4) {
                fArray[n6] = 0.0f;
                ++n5;
            }
            ++n6;
        }
        Arrays.sort1(fArray, n2, n7 - n2);
        if (n5 != 0) {
            int n8 = Arrays.binarySearch(fArray, 0.0f, n2, n7 - 1);
            while (--n8 >= 0 && fArray[n8] == 0.0f) {
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                fArray[++n8] = -0.0f;
            }
        }
    }

    private static void sort1(long[] lArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && lArray[i3 - 1] > lArray[i3]; --i3) {
                    Arrays.swap(lArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n6 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n7 = n2;
            int n8 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(lArray, n7, n7 + n5, n7 + 2 * n5);
                n6 = Arrays.med3(lArray, n6 - n5, n6, n6 + n5);
                n8 = Arrays.med3(lArray, n8 - 2 * n5, n8 - n5, n8);
            }
            n6 = Arrays.med3(lArray, n7, n6, n8);
        }
        long l2 = lArray[n6];
        int n9 = n5 = n2;
        int n10 = n4 = n2 + n3 - 1;
        while (true) {
            if (n9 <= n4 && lArray[n9] <= l2) {
                if (lArray[n9] == l2) {
                    Arrays.swap(lArray, n5++, n9);
                }
                ++n9;
                continue;
            }
            while (n4 >= n9 && lArray[n4] >= l2) {
                if (lArray[n4] == l2) {
                    Arrays.swap(lArray, n4, n10--);
                }
                --n4;
            }
            if (n9 > n4) break;
            Arrays.swap(lArray, n9++, n4--);
        }
        int n11 = n2 + n3;
        int n12 = Math.min(n5 - n2, n9 - n5);
        Arrays.vecswap(lArray, n2, n9 - n12, n12);
        n12 = Math.min(n10 - n4, n11 - n10 - 1);
        Arrays.vecswap(lArray, n9, n11 - n12, n12);
        n12 = n9 - n5;
        if (n12 > 1) {
            Arrays.sort1(lArray, n2, n12);
        }
        if ((n12 = n10 - n4) > 1) {
            Arrays.sort1(lArray, n11 - n12, n12);
        }
    }

    private static void swap(long[] lArray, int n2, int n3) {
        long l2 = lArray[n2];
        lArray[n2] = lArray[n3];
        lArray[n3] = l2;
    }

    private static void vecswap(long[] lArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(lArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(long[] lArray, int n2, int n3, int n4) {
        return lArray[n2] < lArray[n3] ? (lArray[n3] < lArray[n4] ? n3 : (lArray[n2] < lArray[n4] ? n4 : n2)) : (lArray[n3] > lArray[n4] ? n3 : (lArray[n2] > lArray[n4] ? n4 : n2));
    }

    private static void sort1(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && nArray[i3 - 1] > nArray[i3]; --i3) {
                    Arrays.swap(nArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(nArray, n7, n7 + n5, n7 + 2 * n5);
                n8 = Arrays.med3(nArray, n8 - n5, n8, n8 + n5);
                n6 = Arrays.med3(nArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n8 = Arrays.med3(nArray, n7, n8, n6);
        }
        n7 = nArray[n8];
        n5 = n6 = n2;
        int n9 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && nArray[n5] <= n7) {
                if (nArray[n5] == n7) {
                    Arrays.swap(nArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && nArray[n4] >= n7) {
                if (nArray[n4] == n7) {
                    Arrays.swap(nArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(nArray, n5++, n4--);
        }
        int n10 = n2 + n3;
        int n11 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(nArray, n2, n5 - n11, n11);
        n11 = Math.min(n9 - n4, n10 - n9 - 1);
        Arrays.vecswap(nArray, n5, n10 - n11, n11);
        n11 = n5 - n6;
        if (n11 > 1) {
            Arrays.sort1(nArray, n2, n11);
        }
        if ((n11 = n9 - n4) > 1) {
            Arrays.sort1(nArray, n10 - n11, n11);
        }
    }

    private static void swap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
    }

    private static void vecswap(int[] nArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(nArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(int[] nArray, int n2, int n3, int n4) {
        return nArray[n2] < nArray[n3] ? (nArray[n3] < nArray[n4] ? n3 : (nArray[n2] < nArray[n4] ? n4 : n2)) : (nArray[n3] > nArray[n4] ? n3 : (nArray[n2] > nArray[n4] ? n4 : n2));
    }

    private static void sort1(short[] sArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && sArray[i3 - 1] > sArray[i3]; --i3) {
                    Arrays.swap(sArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(sArray, n7, n7 + n5, n7 + 2 * n5);
                n8 = Arrays.med3(sArray, n8 - n5, n8, n8 + n5);
                n6 = Arrays.med3(sArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n8 = Arrays.med3(sArray, n7, n8, n6);
        }
        n7 = sArray[n8];
        n5 = n6 = n2;
        int n9 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && sArray[n5] <= n7) {
                if (sArray[n5] == n7) {
                    Arrays.swap(sArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && sArray[n4] >= n7) {
                if (sArray[n4] == n7) {
                    Arrays.swap(sArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(sArray, n5++, n4--);
        }
        int n10 = n2 + n3;
        int n11 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(sArray, n2, n5 - n11, n11);
        n11 = Math.min(n9 - n4, n10 - n9 - 1);
        Arrays.vecswap(sArray, n5, n10 - n11, n11);
        n11 = n5 - n6;
        if (n11 > 1) {
            Arrays.sort1(sArray, n2, n11);
        }
        if ((n11 = n9 - n4) > 1) {
            Arrays.sort1(sArray, n10 - n11, n11);
        }
    }

    private static void swap(short[] sArray, int n2, int n3) {
        short s2 = sArray[n2];
        sArray[n2] = sArray[n3];
        sArray[n3] = s2;
    }

    private static void vecswap(short[] sArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(sArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(short[] sArray, int n2, int n3, int n4) {
        return sArray[n2] < sArray[n3] ? (sArray[n3] < sArray[n4] ? n3 : (sArray[n2] < sArray[n4] ? n4 : n2)) : (sArray[n3] > sArray[n4] ? n3 : (sArray[n2] > sArray[n4] ? n4 : n2));
    }

    private static void sort1(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && cArray[i3 - 1] > cArray[i3]; --i3) {
                    Arrays.swap(cArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(cArray, n7, n7 + n5, n7 + 2 * n5);
                n8 = Arrays.med3(cArray, n8 - n5, n8, n8 + n5);
                n6 = Arrays.med3(cArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n8 = Arrays.med3(cArray, n7, n8, n6);
        }
        n7 = cArray[n8];
        n5 = n6 = n2;
        int n9 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && cArray[n5] <= n7) {
                if (cArray[n5] == n7) {
                    Arrays.swap(cArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && cArray[n4] >= n7) {
                if (cArray[n4] == n7) {
                    Arrays.swap(cArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(cArray, n5++, n4--);
        }
        int n10 = n2 + n3;
        int n11 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(cArray, n2, n5 - n11, n11);
        n11 = Math.min(n9 - n4, n10 - n9 - 1);
        Arrays.vecswap(cArray, n5, n10 - n11, n11);
        n11 = n5 - n6;
        if (n11 > 1) {
            Arrays.sort1(cArray, n2, n11);
        }
        if ((n11 = n9 - n4) > 1) {
            Arrays.sort1(cArray, n10 - n11, n11);
        }
    }

    private static void swap(char[] cArray, int n2, int n3) {
        char c2 = cArray[n2];
        cArray[n2] = cArray[n3];
        cArray[n3] = c2;
    }

    private static void vecswap(char[] cArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(cArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(char[] cArray, int n2, int n3, int n4) {
        return cArray[n2] < cArray[n3] ? (cArray[n3] < cArray[n4] ? n3 : (cArray[n2] < cArray[n4] ? n4 : n2)) : (cArray[n3] > cArray[n4] ? n3 : (cArray[n2] > cArray[n4] ? n4 : n2));
    }

    private static void sort1(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && byArray[i3 - 1] > byArray[i3]; --i3) {
                    Arrays.swap(byArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(byArray, n7, n7 + n5, n7 + 2 * n5);
                n8 = Arrays.med3(byArray, n8 - n5, n8, n8 + n5);
                n6 = Arrays.med3(byArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n8 = Arrays.med3(byArray, n7, n8, n6);
        }
        n7 = byArray[n8];
        n5 = n6 = n2;
        int n9 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && byArray[n5] <= n7) {
                if (byArray[n5] == n7) {
                    Arrays.swap(byArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && byArray[n4] >= n7) {
                if (byArray[n4] == n7) {
                    Arrays.swap(byArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(byArray, n5++, n4--);
        }
        int n10 = n2 + n3;
        int n11 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(byArray, n2, n5 - n11, n11);
        n11 = Math.min(n9 - n4, n10 - n9 - 1);
        Arrays.vecswap(byArray, n5, n10 - n11, n11);
        n11 = n5 - n6;
        if (n11 > 1) {
            Arrays.sort1(byArray, n2, n11);
        }
        if ((n11 = n9 - n4) > 1) {
            Arrays.sort1(byArray, n10 - n11, n11);
        }
    }

    private static void swap(byte[] byArray, int n2, int n3) {
        byte by = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by;
    }

    private static void vecswap(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(byArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(byte[] byArray, int n2, int n3, int n4) {
        return byArray[n2] < byArray[n3] ? (byArray[n3] < byArray[n4] ? n3 : (byArray[n2] < byArray[n4] ? n4 : n2)) : (byArray[n3] > byArray[n4] ? n3 : (byArray[n2] > byArray[n4] ? n4 : n2));
    }

    private static void sort1(double[] dArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && dArray[i3 - 1] > dArray[i3]; --i3) {
                    Arrays.swap(dArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n6 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n7 = n2;
            int n8 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(dArray, n7, n7 + n5, n7 + 2 * n5);
                n6 = Arrays.med3(dArray, n6 - n5, n6, n6 + n5);
                n8 = Arrays.med3(dArray, n8 - 2 * n5, n8 - n5, n8);
            }
            n6 = Arrays.med3(dArray, n7, n6, n8);
        }
        double d2 = dArray[n6];
        int n9 = n5 = n2;
        int n10 = n4 = n2 + n3 - 1;
        while (true) {
            if (n9 <= n4 && dArray[n9] <= d2) {
                if (dArray[n9] == d2) {
                    Arrays.swap(dArray, n5++, n9);
                }
                ++n9;
                continue;
            }
            while (n4 >= n9 && dArray[n4] >= d2) {
                if (dArray[n4] == d2) {
                    Arrays.swap(dArray, n4, n10--);
                }
                --n4;
            }
            if (n9 > n4) break;
            Arrays.swap(dArray, n9++, n4--);
        }
        int n11 = n2 + n3;
        int n12 = Math.min(n5 - n2, n9 - n5);
        Arrays.vecswap(dArray, n2, n9 - n12, n12);
        n12 = Math.min(n10 - n4, n11 - n10 - 1);
        Arrays.vecswap(dArray, n9, n11 - n12, n12);
        n12 = n9 - n5;
        if (n12 > 1) {
            Arrays.sort1(dArray, n2, n12);
        }
        if ((n12 = n10 - n4) > 1) {
            Arrays.sort1(dArray, n11 - n12, n12);
        }
    }

    private static void swap(double[] dArray, int n2, int n3) {
        double d2 = dArray[n2];
        dArray[n2] = dArray[n3];
        dArray[n3] = d2;
    }

    private static void vecswap(double[] dArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(dArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(double[] dArray, int n2, int n3, int n4) {
        return dArray[n2] < dArray[n3] ? (dArray[n3] < dArray[n4] ? n3 : (dArray[n2] < dArray[n4] ? n4 : n2)) : (dArray[n3] > dArray[n4] ? n3 : (dArray[n2] > dArray[n4] ? n4 : n2));
    }

    private static void sort1(float[] fArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 < 7) {
            for (int i2 = n2; i2 < n3 + n2; ++i2) {
                for (int i3 = i2; i3 > n2 && fArray[i3 - 1] > fArray[i3]; --i3) {
                    Arrays.swap(fArray, i3, i3 - 1);
                }
            }
            return;
        }
        int n7 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n8 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n8 = Arrays.med3(fArray, n8, n8 + n5, n8 + 2 * n5);
                n7 = Arrays.med3(fArray, n7 - n5, n7, n7 + n5);
                n6 = Arrays.med3(fArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n7 = Arrays.med3(fArray, n8, n7, n6);
        }
        float f2 = fArray[n7];
        n5 = n6 = n2;
        int n9 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && fArray[n5] <= f2) {
                if (fArray[n5] == f2) {
                    Arrays.swap(fArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && fArray[n4] >= f2) {
                if (fArray[n4] == f2) {
                    Arrays.swap(fArray, n4, n9--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(fArray, n5++, n4--);
        }
        int n10 = n2 + n3;
        int n11 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(fArray, n2, n5 - n11, n11);
        n11 = Math.min(n9 - n4, n10 - n9 - 1);
        Arrays.vecswap(fArray, n5, n10 - n11, n11);
        n11 = n5 - n6;
        if (n11 > 1) {
            Arrays.sort1(fArray, n2, n11);
        }
        if ((n11 = n9 - n4) > 1) {
            Arrays.sort1(fArray, n10 - n11, n11);
        }
    }

    private static void swap(float[] fArray, int n2, int n3) {
        float f2 = fArray[n2];
        fArray[n2] = fArray[n3];
        fArray[n3] = f2;
    }

    private static void vecswap(float[] fArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(fArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(float[] fArray, int n2, int n3, int n4) {
        return fArray[n2] < fArray[n3] ? (fArray[n3] < fArray[n4] ? n3 : (fArray[n2] < fArray[n4] ? n4 : n2)) : (fArray[n3] > fArray[n4] ? n3 : (fArray[n2] > fArray[n4] ? n4 : n2));
    }

    public static void sort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0);
    }

    public static void sort(Object[] objectArray, int n2, int n3) {
        Arrays.rangeCheck(objectArray.length, n2, n3);
        Object[] objectArray2 = Arrays.cloneSubarray(objectArray, n2, n3);
        Arrays.mergeSort(objectArray2, objectArray, n2, n3, -n2);
    }

    private static <T> T[] cloneSubarray(T[] TArray, int n2, int n3) {
        int n4 = n3 - n2;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n2, objectArray, 0, n4);
        return objectArray;
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n5 < 7) {
            for (int i2 = n2; i2 < n3; ++i2) {
                for (int i3 = i2; i3 > n2 && ((Comparable)objectArray2[i3 - 1]).compareTo(objectArray2[i3]) > 0; --i3) {
                    Arrays.swap(objectArray2, i3, i3 - 1);
                }
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n8, -n4);
        Arrays.mergeSort(objectArray2, objectArray, n8, n3, -n4);
        if (((Comparable)objectArray[n8 - 1]).compareTo(objectArray[n8]) <= 0) {
            System.arraycopy(objectArray, n2, objectArray2, n6, n5);
            return;
        }
        int n9 = n2;
        int n10 = n8;
        for (int i4 = n6; i4 < n7; ++i4) {
            objectArray2[i4] = n10 >= n3 || n9 < n8 && ((Comparable)objectArray[n9]).compareTo(objectArray[n10]) <= 0 ? objectArray[n9++] : objectArray[n10++];
        }
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    public static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        Object[] objectArray = (Object[])TArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0);
        } else {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0, comparator);
        }
    }

    public static <T> void sort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        Arrays.rangeCheck(TArray.length, n2, n3);
        Object[] objectArray = Arrays.cloneSubarray(TArray, n2, n3);
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, n2, n3, -n2);
        } else {
            Arrays.mergeSort(objectArray, TArray, n2, n3, -n2, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3, int n4, Comparator comparator) {
        int n5 = n3 - n2;
        if (n5 < 7) {
            for (int i2 = n2; i2 < n3; ++i2) {
                for (int i3 = i2; i3 > n2 && comparator.compare(objectArray2[i3 - 1], objectArray2[i3]) > 0; --i3) {
                    Arrays.swap(objectArray2, i3, i3 - 1);
                }
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = (n2 += n4) + (n3 += n4) >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n8, -n4, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n8, n3, -n4, comparator);
        if (comparator.compare(objectArray[n8 - 1], objectArray[n8]) <= 0) {
            System.arraycopy(objectArray, n2, objectArray2, n6, n5);
            return;
        }
        int n9 = n2;
        int n10 = n8;
        for (int i4 = n6; i4 < n7; ++i4) {
            objectArray2[i4] = n10 >= n3 || n9 < n8 && comparator.compare(objectArray[n9], objectArray[n10]) <= 0 ? objectArray[n9++] : objectArray[n10++];
        }
    }

    private static void rangeCheck(int n2, int n3, int n4) {
        if (n3 > n4) {
            throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n4 + ")");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (n4 > n2) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
    }

    public static int binarySearch(long[] lArray, long l2) {
        int n2 = 0;
        int n3 = lArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            long l3 = lArray[n4];
            if (l3 < l2) {
                n2 = n4 + 1;
                continue;
            }
            if (l3 > l2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = nArray.length - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            int n6 = nArray[n5];
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(short[] sArray, short s2) {
        int n2 = 0;
        int n3 = sArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            short s3 = sArray[n4];
            if (s3 < s2) {
                n2 = n4 + 1;
                continue;
            }
            if (s3 > s2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(char[] cArray, char c2) {
        int n2 = 0;
        int n3 = cArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            char c3 = cArray[n4];
            if (c3 < c2) {
                n2 = n4 + 1;
                continue;
            }
            if (c3 > c2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        int n2 = 0;
        int n3 = byArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            byte by2 = byArray[n4];
            if (by2 < by) {
                n2 = n4 + 1;
                continue;
            }
            if (by2 > by) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(double[] dArray, double d2) {
        return Arrays.binarySearch(dArray, d2, 0, dArray.length - 1);
    }

    private static int binarySearch(double[] dArray, double d2, int n2, int n3) {
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >> 1;
            double d3 = dArray[n5];
            if (d3 < d2) {
                n4 = -1;
            } else if (d3 > d2) {
                n4 = 1;
            } else {
                long l2;
                long l3 = Double.doubleToLongBits(d3);
                int n6 = l3 == (l2 = Double.doubleToLongBits(d2)) ? 0 : (n4 = l3 < l2 ? -1 : 1);
            }
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(float[] fArray, float f2) {
        return Arrays.binarySearch(fArray, f2, 0, fArray.length - 1);
    }

    private static int binarySearch(float[] fArray, float f2, int n2, int n3) {
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >> 1;
            float f3 = fArray[n5];
            if (f3 < f2) {
                n4 = -1;
            } else if (f3 > f2) {
                n4 = 1;
            } else {
                int n6;
                int n7 = Float.floatToIntBits(f3);
                int n8 = n7 == (n6 = Float.floatToIntBits(f2)) ? 0 : (n4 = n7 < n6 ? -1 : 1);
            }
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        int n2 = 0;
        int n3 = objectArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Comparable comparable = (Comparable)objectArray[n4];
            int n5 = comparable.compareTo(object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static <T> int binarySearch(T[] TArray, T t2, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch(TArray, t2);
        }
        int n2 = 0;
        int n3 = TArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            T t3 = TArray[n4];
            int n5 = comparator.compare(t3, t2);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n2 = lArray.length;
        if (lArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] == lArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n2 = sArray.length;
        if (sArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (sArray[i2] == sArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n2 = cArray.length;
        if (cArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = byArray.length;
        if (byArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n2 = blArray.length;
        if (blArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (blArray[i2] == blArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n2 = dArray.length;
        if (dArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Double.doubleToLongBits(dArray[i2]) == Double.doubleToLongBits(dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n2 = fArray.length;
        if (fArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Float.floatToIntBits(fArray[i2]) == Float.floatToIntBits(fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n2 = objectArray.length;
        if (objectArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            Object object2 = objectArray2[i2];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] lArray, long l2) {
        Arrays.fill(lArray, 0, lArray.length, l2);
    }

    public static void fill(long[] lArray, int n2, int n3, long l2) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            lArray[i2] = l2;
        }
    }

    public static void fill(int[] nArray, int n2) {
        Arrays.fill(nArray, 0, nArray.length, n2);
    }

    public static void fill(int[] nArray, int n2, int n3, int n4) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            nArray[i2] = n4;
        }
    }

    public static void fill(short[] sArray, short s2) {
        Arrays.fill(sArray, 0, sArray.length, s2);
    }

    public static void fill(short[] sArray, int n2, int n3, short s2) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            sArray[i2] = s2;
        }
    }

    public static void fill(char[] cArray, char c2) {
        Arrays.fill(cArray, 0, cArray.length, c2);
    }

    public static void fill(char[] cArray, int n2, int n3, char c2) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            cArray[i2] = c2;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n2, int n3, byte by) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = by;
        }
    }

    public static void fill(boolean[] blArray, boolean bl2) {
        Arrays.fill(blArray, 0, blArray.length, bl2);
    }

    public static void fill(boolean[] blArray, int n2, int n3, boolean bl2) {
        Arrays.rangeCheck(blArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            blArray[i2] = bl2;
        }
    }

    public static void fill(double[] dArray, double d2) {
        Arrays.fill(dArray, 0, dArray.length, d2);
    }

    public static void fill(double[] dArray, int n2, int n3, double d2) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            dArray[i2] = d2;
        }
    }

    public static void fill(float[] fArray, float f2) {
        Arrays.fill(fArray, 0, fArray.length, f2);
    }

    public static void fill(float[] fArray, int n2, int n3, float f2) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            fArray[i2] = f2;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n2, int n3, Object object) {
        Arrays.rangeCheck(objectArray.length, n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            objectArray[i2] = object;
        }
    }

    public static <T> List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n2 = 1;
        for (long l2 : lArray) {
            int n3 = (int)(l2 ^ l2 >>> 32);
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n2 = 1;
        for (short s2 : sArray) {
            n2 = 31 * n2 + s2;
        }
        return n2;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 1;
        for (char c2 : cArray) {
            n2 = 31 * n2 + c2;
        }
        return n2;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n2 = 1;
        for (byte by : byArray) {
            n2 = 31 * n2 + by;
        }
        return n2;
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n2 = 1;
        for (boolean bl2 : blArray) {
            n2 = 31 * n2 + (bl2 ? 1231 : 1237);
        }
        return n2;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n2 = 1;
        for (float f2 : fArray) {
            n2 = 31 * n2 + Float.floatToIntBits(f2);
        }
        return n2;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n2 = 1;
        for (double d2 : dArray) {
            long l2 = Double.doubleToLongBits(d2);
            n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        }
        return n2;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (Object object : objectArray) {
            n2 = 31 * n2 + (object == null ? 0 : object.hashCode());
        }
        return n2;
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (Object object : objectArray) {
            int n3 = 0;
            if (object instanceof Object[]) {
                n3 = Arrays.deepHashCode((Object[])object);
            } else if (object instanceof byte[]) {
                n3 = Arrays.hashCode((byte[])object);
            } else if (object instanceof short[]) {
                n3 = Arrays.hashCode((short[])object);
            } else if (object instanceof int[]) {
                n3 = Arrays.hashCode((int[])object);
            } else if (object instanceof long[]) {
                n3 = Arrays.hashCode((long[])object);
            } else if (object instanceof char[]) {
                n3 = Arrays.hashCode((char[])object);
            } else if (object instanceof float[]) {
                n3 = Arrays.hashCode((float[])object);
            } else if (object instanceof double[]) {
                n3 = Arrays.hashCode((double[])object);
            } else if (object instanceof boolean[]) {
                n3 = Arrays.hashCode((boolean[])object);
            } else if (object != null) {
                n3 = object.hashCode();
            }
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n2 = objectArray.length;
        if (objectArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            Object object2 = objectArray2[i2];
            if (object == object2) continue;
            if (object == null) {
                return false;
            }
            boolean bl2 = object instanceof Object[] && object2 instanceof Object[] ? Arrays.deepEquals((Object[])object, (Object[])object2) : (object instanceof byte[] && object2 instanceof byte[] ? Arrays.equals((byte[])object, (byte[])object2) : (object instanceof short[] && object2 instanceof short[] ? Arrays.equals((short[])object, (short[])object2) : (object instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object, (int[])object2) : (object instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object, (long[])object2) : (object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : (object instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object, (float[])object2) : (object instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object, (double[])object2) : (object instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object, (boolean[])object2) : object.equals(object2)))))))));
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        if (sArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(sArray[0]);
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        if (cArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(byArray[0]);
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(blArray[0]);
        for (int i2 = 1; i2 < blArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(blArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        if (fArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(fArray[0]);
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        if (dArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(dArray[0]);
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(dArray[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 == 0) {
                stringBuilder.append('[');
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(String.valueOf(objectArray[i2]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String deepToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n2 = 20 * objectArray.length;
        if (objectArray.length != 0 && n2 <= 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        Arrays.deepToString(objectArray, stringBuilder, new HashSet<Object[]>());
        return stringBuilder.toString();
    }

    private static void deepToString(Object[] objectArray, StringBuilder stringBuilder, Set<Object[]> set) {
        if (objectArray == null) {
            stringBuilder.append("null");
            return;
        }
        set.add(objectArray);
        stringBuilder.append('[');
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object;
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            if ((object = objectArray[i2]) == null) {
                stringBuilder.append("null");
                continue;
            }
            Class<? extends Object> clazz = object.getClass();
            if (clazz.isArray()) {
                if (clazz == byte[].class) {
                    stringBuilder.append(Arrays.toString((byte[])object));
                    continue;
                }
                if (clazz == short[].class) {
                    stringBuilder.append(Arrays.toString((short[])object));
                    continue;
                }
                if (clazz == int[].class) {
                    stringBuilder.append(Arrays.toString((int[])object));
                    continue;
                }
                if (clazz == long[].class) {
                    stringBuilder.append(Arrays.toString((long[])object));
                    continue;
                }
                if (clazz == char[].class) {
                    stringBuilder.append(Arrays.toString((char[])object));
                    continue;
                }
                if (clazz == float[].class) {
                    stringBuilder.append(Arrays.toString((float[])object));
                    continue;
                }
                if (clazz == double[].class) {
                    stringBuilder.append(Arrays.toString((double[])object));
                    continue;
                }
                if (clazz == boolean[].class) {
                    stringBuilder.append(Arrays.toString((boolean[])object));
                    continue;
                }
                if (set.contains(object)) {
                    stringBuilder.append("[...]");
                    continue;
                }
                Arrays.deepToString((Object[])object, stringBuilder, set);
                continue;
            }
            stringBuilder.append(object.toString());
        }
        stringBuilder.append("]");
        set.remove(objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private Object[] a;

        ArrayList(E[] EArray) {
            if (EArray == null) {
                throw new NullPointerException();
            }
            this.a = EArray;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public E get(int n2) {
            return (E)this.a[n2];
        }

        @Override
        public E set(int n2, E e2) {
            Object object = this.a[n2];
            this.a[n2] = e2;
            return (E)object;
        }

        @Override
        public int indexOf(Object object) {
            if (object == null) {
                for (int i2 = 0; i2 < this.a.length; ++i2) {
                    if (this.a[i2] != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < this.a.length; ++i3) {
                    if (!object.equals(this.a[i3])) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }
    }
}

