/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import sun.misc.SoftCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final SoftCache subclassAudits = new SoftCache(5);
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private PutFieldImpl curPut;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(outputStream);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
    }

    public void useProtocolVersion(int n2) throws IOException {
        if (this.handles.size() != 0) {
            throw new IllegalStateException("stream non-empty");
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.protocol = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version: " + n2);
            }
        }
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        if (this.enableOverride) {
            this.writeObjectOverride(object);
            return;
        }
        try {
            this.writeObject0(object, false);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
        try {
            this.writeObject0(object, true);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    public void defaultWriteObject() throws IOException {
        if (this.curObj == null || this.curDesc == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        this.bout.setBlockDataMode(false);
        this.defaultWriteFields(this.curObj, this.curDesc);
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        if (this.curPut == null) {
            if (this.curObj == null || this.curDesc == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            this.curPut = new PutFieldImpl(this.curDesc);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        if (this.curPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.bout.setBlockDataMode(false);
        this.curPut.writeFields();
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(121);
        this.clear();
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl2) throws SecurityException {
        SecurityManager securityManager;
        if (bl2 == this.enableReplace) {
            return bl2;
        }
        if (bl2 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = bl2;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-21267);
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.writeNonProxy(this);
    }

    @Override
    public void write(int n2) throws IOException {
        this.bout.write(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.bout.write(byArray, 0, byArray.length, false);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(byArray, n2, n3, false);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this.bout.writeBoolean(bl2);
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.bout.writeByte(n2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.bout.writeShort(n2);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.bout.writeChar(n2);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.bout.writeInt(n2);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.bout.writeLong(l2);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.bout.writeFloat(f2);
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.bout.writeDouble(d2);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.bout.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.bout.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.bout.writeUTF(string);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else {
            int n2 = this.handles.lookup(string);
            if (n2 != -1) {
                this.writeHandle(n2);
            } else {
                this.writeString(string, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySubclass() {
        Class<? extends Object> clazz = this.getClass();
        Object object = subclassAudits;
        synchronized (object) {
            Boolean bl2 = (Boolean)subclassAudits.get(clazz);
            if (bl2 == null) {
                bl2 = new Boolean(ObjectOutputStream.auditSubclass(clazz));
                subclassAudits.put(clazz, bl2);
            }
            if (bl2.booleanValue()) {
                return;
            }
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != ObjectOutputStream.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            clazz2.getDeclaredMethod("putFields", new Class[0]);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl2;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object clazz, boolean bl2) throws IOException {
        block27: {
            boolean bl3 = this.bout.setBlockDataMode(false);
            ++this.depth;
            try {
                Class<? extends Object> clazz2;
                ObjectStreamClass objectStreamClass;
                int n2;
                clazz = this.subs.lookup(clazz);
                if (clazz == null) {
                    this.writeNull();
                    return;
                }
                if (!bl2 && (n2 = this.handles.lookup(clazz)) != -1) {
                    this.writeHandle(n2);
                    return;
                }
                if (clazz instanceof Class) {
                    this.writeClass(clazz, bl2);
                    return;
                }
                if (clazz instanceof ObjectStreamClass) {
                    this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl2);
                    return;
                }
                Class<? extends Object> clazz3 = clazz;
                Class<? extends Object> clazz4 = clazz.getClass();
                while ((objectStreamClass = ObjectStreamClass.lookup(clazz4, true)).hasWriteReplaceMethod() && (clazz = objectStreamClass.invokeWriteReplace(clazz)) != null && (clazz2 = clazz.getClass()) != clazz4) {
                    clazz4 = clazz2;
                }
                if (this.enableReplace) {
                    clazz2 = this.replaceObject(clazz);
                    if (clazz2 != clazz && clazz2 != null) {
                        clazz4 = clazz2.getClass();
                        objectStreamClass = ObjectStreamClass.lookup(clazz4, true);
                    }
                    clazz = clazz2;
                }
                if (clazz != clazz3) {
                    this.subs.assign(clazz3, clazz);
                    if (clazz == null) {
                        this.writeNull();
                        return;
                    }
                    if (!bl2 && (n2 = this.handles.lookup(clazz)) != -1) {
                        this.writeHandle(n2);
                        return;
                    }
                    if (clazz instanceof Class) {
                        this.writeClass(clazz, bl2);
                        return;
                    }
                    if (clazz instanceof ObjectStreamClass) {
                        this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl2);
                        return;
                    }
                }
                if (clazz instanceof String) {
                    this.writeString((String)((Object)clazz), bl2);
                    break block27;
                }
                if (clazz4.isArray()) {
                    this.writeArray(clazz, objectStreamClass, bl2);
                    break block27;
                }
                if (clazz instanceof Enum) {
                    this.writeEnum((Enum)((Object)clazz), objectStreamClass, bl2);
                    break block27;
                }
                if (clazz instanceof Serializable) {
                    this.writeOrdinaryObject(clazz, objectStreamClass, bl2);
                    break block27;
                }
                throw new NotSerializableException(clazz4.getName());
            }
            finally {
                --this.depth;
                this.bout.setBlockDataMode(bl3);
            }
        }
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int n2) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + n2);
    }

    private void writeClass(Class clazz, boolean bl2) throws IOException {
        this.bout.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookup(clazz, true), false);
        this.handles.assign(bl2 ? null : clazz);
    }

    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        int n2;
        if (objectStreamClass == null) {
            this.writeNull();
        } else if (!bl2 && (n2 = this.handles.lookup(objectStreamClass)) != -1) {
            this.writeHandle(n2);
        } else if (objectStreamClass.isProxy()) {
            this.writeProxyDesc(objectStreamClass, bl2);
        } else {
            this.writeNonProxyDesc(objectStreamClass, bl2);
        }
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        this.bout.writeByte(125);
        this.handles.assign(bl2 ? null : objectStreamClass);
        Class<?> clazz = objectStreamClass.forClass();
        Class[] classArray = clazz.getInterfaces();
        this.bout.writeInt(classArray.length);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.bout.writeUTF(classArray[i2].getName());
        }
        this.bout.setBlockDataMode(true);
        this.annotateProxyClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        this.bout.writeByte(114);
        this.handles.assign(bl2 ? null : objectStreamClass);
        if (this.protocol == 1) {
            objectStreamClass.writeNonProxy(this);
        } else {
            this.writeClassDescriptor(objectStreamClass);
        }
        Class<?> clazz = objectStreamClass.forClass();
        this.bout.setBlockDataMode(true);
        this.annotateClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeString(String string, boolean bl2) throws IOException {
        this.handles.assign(bl2 ? null : string);
        long l2 = this.bout.getUTFLength(string);
        if (l2 <= 65535L) {
            this.bout.writeByte(116);
            this.bout.writeUTF(string, l2);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(string, l2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        this.bout.writeByte(117);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl2 ? null : object);
        Class<?> clazz = objectStreamClass.forClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.bout.writeInt(nArray.length);
                this.bout.writeInts(nArray, 0, nArray.length);
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.bout.writeInt(byArray.length);
                this.bout.write(byArray, 0, byArray.length, true);
                return;
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.bout.writeInt(lArray.length);
                this.bout.writeLongs(lArray, 0, lArray.length);
                return;
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.bout.writeInt(fArray.length);
                this.bout.writeFloats(fArray, 0, fArray.length);
                return;
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.bout.writeInt(dArray.length);
                this.bout.writeDoubles(dArray, 0, dArray.length);
                return;
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.bout.writeInt(sArray.length);
                this.bout.writeShorts(sArray, 0, sArray.length);
                return;
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.bout.writeInt(cArray.length);
                this.bout.writeChars(cArray, 0, cArray.length);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError();
                boolean[] blArray = (boolean[])object;
                this.bout.writeInt(blArray.length);
                this.bout.writeBooleans(blArray, 0, blArray.length);
            }
            return;
        } else {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            this.bout.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeObject0(objectArray[i2], false);
            }
        }
    }

    private void writeEnum(Enum enum_, ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        this.bout.writeByte(126);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperDesc();
        this.writeClassDesc(objectStreamClass2.forClass() == Enum.class ? objectStreamClass : objectStreamClass2, false);
        this.handles.assign(bl2 ? null : enum_);
        this.writeString(enum_.name(), false);
    }

    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl2) throws IOException {
        objectStreamClass.checkSerialize();
        this.bout.writeByte(115);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl2 ? null : object);
        if (objectStreamClass.isExternalizable() && !objectStreamClass.isProxy()) {
            this.writeExternalData((Externalizable)object);
        } else {
            this.writeSerialData(object, objectStreamClass);
        }
    }

    private void writeExternalData(Externalizable externalizable) throws IOException {
        Object object = this.curObj;
        ObjectStreamClass objectStreamClass = this.curDesc;
        PutFieldImpl putFieldImpl = this.curPut;
        this.curObj = externalizable;
        this.curDesc = null;
        this.curPut = null;
        if (this.protocol == 1) {
            externalizable.writeExternal(this);
        } else {
            this.bout.setBlockDataMode(true);
            externalizable.writeExternal(this);
            this.bout.setBlockDataMode(false);
            this.bout.writeByte(120);
        }
        this.curObj = object;
        this.curDesc = objectStreamClass;
        this.curPut = putFieldImpl;
    }

    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i2 = 0; i2 < classDataSlotArray.length; ++i2) {
            ObjectStreamClass objectStreamClass2 = classDataSlotArray[i2].desc;
            if (objectStreamClass2.hasWriteObjectMethod()) {
                Object object2 = this.curObj;
                ObjectStreamClass objectStreamClass3 = this.curDesc;
                PutFieldImpl putFieldImpl = this.curPut;
                this.curObj = object;
                this.curDesc = objectStreamClass2;
                this.curPut = null;
                this.bout.setBlockDataMode(true);
                objectStreamClass2.invokeWriteObject(object, this);
                this.bout.setBlockDataMode(false);
                this.bout.writeByte(120);
                this.curObj = object2;
                this.curDesc = objectStreamClass3;
                this.curPut = putFieldImpl;
                continue;
            }
            this.defaultWriteFields(object, objectStreamClass2);
        }
    }

    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.checkDefaultSerialize();
        int n2 = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n2) {
            this.primVals = new byte[n2];
        }
        objectStreamClass.getPrimFieldValues(object, this.primVals);
        this.bout.write(this.primVals, 0, n2, false);
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        Object[] objectArray = new Object[objectStreamClass.getNumObjFields()];
        int n3 = objectStreamFieldArray.length - objectArray.length;
        objectStreamClass.getObjFieldValues(object, objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.writeObject0(objectArray[i2], objectStreamFieldArray[n3 + i2].isUnshared());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException iOException) throws IOException {
        this.clear();
        boolean bl2 = this.bout.setBlockDataMode(false);
        try {
            this.bout.writeByte(123);
            this.writeObject0(iOException, false);
            this.clear();
        }
        finally {
            this.bout.setBlockDataMode(bl2);
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream outputStream) {
            this.out = outputStream;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean bl2) throws IOException {
            if (this.blkmode == bl2) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = bl2;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        public void write(int n2) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)n2;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length, false);
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3, false);
        }

        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
            if (!bl2 && !this.blkmode) {
                this.drain();
                this.out.write(byArray, n2, n3);
                return;
            }
            while (n3 > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (n3 >= 1024 && !bl2 && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(byArray, n2, 1024);
                    n2 += 1024;
                    n3 -= 1024;
                    continue;
                }
                int n4 = Math.min(n3, 1024 - this.pos);
                System.arraycopy(byArray, n2, this.buf, this.pos, n4);
                this.pos += n4;
                n2 += n4;
                n3 -= n4;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int n2) throws IOException {
            if (n2 <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)n2;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                Bits.putInt(this.hbuf, 1, n2);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        public void writeBoolean(boolean bl2) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            Bits.putBoolean(this.buf, this.pos++, bl2);
        }

        public void writeByte(int n2) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)n2;
        }

        public void writeChar(int n2) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putChar(this.buf, this.pos, (char)n2);
                this.pos += 2;
            } else {
                this.dout.writeChar(n2);
            }
        }

        public void writeShort(int n2) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putShort(this.buf, this.pos, (short)n2);
                this.pos += 2;
            } else {
                this.dout.writeShort(n2);
            }
        }

        public void writeInt(int n2) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putInt(this.buf, this.pos, n2);
                this.pos += 4;
            } else {
                this.dout.writeInt(n2);
            }
        }

        public void writeFloat(float f2) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putFloat(this.buf, this.pos, f2);
                this.pos += 4;
            } else {
                this.dout.writeFloat(f2);
            }
        }

        public void writeLong(long l2) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putLong(this.buf, this.pos, l2);
                this.pos += 8;
            } else {
                this.dout.writeLong(l2);
            }
        }

        public void writeDouble(double d2) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putDouble(this.buf, this.pos, d2);
                this.pos += 8;
            } else {
                this.dout.writeDouble(d2);
            }
        }

        public void writeBytes(String string) throws IOException {
            int n2;
            int n3 = string.length();
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < n3; i2 += n2) {
                if (n4 >= n5) {
                    n4 = 0;
                    n5 = Math.min(n3 - i2, 256);
                    string.getChars(i2, i2 + n5, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n2 = Math.min(n5 - n4, 1024 - this.pos);
                int n6 = this.pos + n2;
                while (this.pos < n6) {
                    this.buf[this.pos++] = (byte)this.cbuf[n4++];
                }
            }
        }

        public void writeChars(String string) throws IOException {
            int n2;
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; i2 += n2) {
                n2 = Math.min(n3 - i2, 256);
                string.getChars(i2, i2 + n2, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, n2);
            }
        }

        public void writeUTF(String string) throws IOException {
            this.writeUTF(string, this.getUTFLength(string));
        }

        void writeBooleans(boolean[] blArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int n5 = Math.min(n4, n2 + (1024 - this.pos));
                while (n2 < n5) {
                    Bits.putBoolean(this.buf, this.pos++, blArray[n2++]);
                }
            }
        }

        void writeChars(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 1022;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 1;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putChar(this.buf, this.pos, cArray[n2++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(cArray[n2++]);
            }
        }

        void writeShorts(short[] sArray, int n2, int n3) throws IOException {
            int n4 = 1022;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 1;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putShort(this.buf, this.pos, sArray[n2++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(sArray[n2++]);
            }
        }

        void writeInts(int[] nArray, int n2, int n3) throws IOException {
            int n4 = 1020;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 2;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putInt(this.buf, this.pos, nArray[n2++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(nArray[n2++]);
            }
        }

        void writeFloats(float[] fArray, int n2, int n3) throws IOException {
            int n4 = 1020;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 2;
                    int n7 = Math.min(n5 - n2, n6);
                    ObjectOutputStream.floatsToBytes(fArray, n2, this.buf, this.pos, n7);
                    n2 += n7;
                    this.pos += n7 << 2;
                    continue;
                }
                this.dout.writeFloat(fArray[n2++]);
            }
        }

        void writeLongs(long[] lArray, int n2, int n3) throws IOException {
            int n4 = 1016;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 3;
                    int n7 = Math.min(n5, n2 + n6);
                    while (n2 < n7) {
                        Bits.putLong(this.buf, this.pos, lArray[n2++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(lArray[n2++]);
            }
        }

        void writeDoubles(double[] dArray, int n2, int n3) throws IOException {
            int n4 = 1016;
            int n5 = n2 + n3;
            while (n2 < n5) {
                if (this.pos <= n4) {
                    int n6 = 1024 - this.pos >> 3;
                    int n7 = Math.min(n5 - n2, n6);
                    ObjectOutputStream.doublesToBytes(dArray, n2, this.buf, this.pos, n7);
                    n2 += n7;
                    this.pos += n7 << 3;
                    continue;
                }
                this.dout.writeDouble(dArray[n2++]);
            }
        }

        long getUTFLength(String string) {
            int n2;
            int n3 = string.length();
            long l2 = 0L;
            for (int i2 = 0; i2 < n3; i2 += n2) {
                n2 = Math.min(n3 - i2, 256);
                string.getChars(i2, i2 + n2, this.cbuf, 0);
                for (int i3 = 0; i3 < n2; ++i3) {
                    char c2 = this.cbuf[i3];
                    if (c2 >= '\u0001' && c2 <= '\u007f') {
                        ++l2;
                        continue;
                    }
                    if (c2 > '\u07ff') {
                        l2 += 3L;
                        continue;
                    }
                    l2 += 2L;
                }
            }
            return l2;
        }

        void writeUTF(String string, long l2) throws IOException {
            if (l2 > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)l2);
            if (l2 == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        void writeLongUTF(String string) throws IOException {
            this.writeLongUTF(string, this.getUTFLength(string));
        }

        void writeLongUTF(String string, long l2) throws IOException {
            this.writeLong(l2);
            if (l2 == (long)string.length()) {
                this.writeBytes(string);
            } else {
                this.writeUTFBody(string);
            }
        }

        private void writeUTFBody(String string) throws IOException {
            int n2;
            int n3 = 1021;
            int n4 = string.length();
            for (int i2 = 0; i2 < n4; i2 += n2) {
                n2 = Math.min(n4 - i2, 256);
                string.getChars(i2, i2 + n2, this.cbuf, 0);
                for (int i3 = 0; i3 < n2; ++i3) {
                    char c2 = this.cbuf[i3];
                    if (this.pos <= n3) {
                        if (c2 <= '\u007f' && c2 != '\u0000') {
                            this.buf[this.pos++] = (byte)c2;
                            continue;
                        }
                        if (c2 > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c2 >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c2 >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c2 >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c2 >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c2 <= '\u007f' && c2 != '\u0000') {
                        this.write(c2);
                        continue;
                    }
                    if (c2 > '\u07ff') {
                        this.write(0xE0 | c2 >> 12 & 0xF);
                        this.write(0x80 | c2 >> 6 & 0x3F);
                        this.write(0x80 | c2 >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c2 >> 6 & 0x1F);
                    this.write(0x80 | c2 >> 0 & 0x3F);
                }
            }
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int n2, float f2) {
            this.loadFactor = f2;
            this.spine = new int[n2];
            this.next = new int[n2];
            this.objs = new Object[n2];
            this.threshold = (int)((float)n2 * f2);
            this.clear();
        }

        int assign(Object object) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(object, this.size);
            return this.size++;
        }

        int lookup(Object object) {
            if (this.size == 0) {
                return -1;
            }
            int n2 = this.hash(object) % this.spine.length;
            int n3 = this.spine[n2];
            while (n3 >= 0) {
                if (this.objs[n3] == object) {
                    return n3;
                }
                n3 = this.next[n3];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object object, int n2) {
            int n3 = this.hash(object) % this.spine.length;
            this.objs[n2] = object;
            this.next[n2] = this.spine[n3];
            this.spine[n3] = n2;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.insert(this.objs[i2], i2);
            }
        }

        private void growEntries() {
            int n2 = (this.next.length << 1) + 1;
            int[] nArray = new int[n2];
            System.arraycopy(this.next, 0, nArray, 0, this.size);
            this.next = nArray;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.objs, 0, objectArray, 0, this.size);
            this.objs = objectArray;
        }

        private int hash(Object object) {
            return System.identityHashCode(object) & Integer.MAX_VALUE;
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
        }

        public void put(String string, boolean bl2) {
            Bits.putBoolean(this.primVals, this.getFieldOffset(string, Boolean.TYPE), bl2);
        }

        public void put(String string, byte by) {
            this.primVals[this.getFieldOffset((String)string, Byte.TYPE)] = by;
        }

        public void put(String string, char c2) {
            Bits.putChar(this.primVals, this.getFieldOffset(string, Character.TYPE), c2);
        }

        public void put(String string, short s2) {
            Bits.putShort(this.primVals, this.getFieldOffset(string, Short.TYPE), s2);
        }

        public void put(String string, int n2) {
            Bits.putInt(this.primVals, this.getFieldOffset(string, Integer.TYPE), n2);
        }

        public void put(String string, float f2) {
            Bits.putFloat(this.primVals, this.getFieldOffset(string, Float.TYPE), f2);
        }

        public void put(String string, long l2) {
            Bits.putLong(this.primVals, this.getFieldOffset(string, Long.TYPE), l2);
        }

        public void put(String string, double d2) {
            Bits.putDouble(this.primVals, this.getFieldOffset(string, Double.TYPE), d2);
        }

        public void put(String string, Object object) {
            this.objVals[this.getFieldOffset((String)string, Object.class)] = object;
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            objectOutput.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n2 = objectStreamFieldArray.length - this.objVals.length;
            for (int i2 = 0; i2 < this.objVals.length; ++i2) {
                if (objectStreamFieldArray[n2 + i2].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                objectOutput.writeObject(this.objVals[i2]);
            }
        }

        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n2 = objectStreamFieldArray.length - this.objVals.length;
            for (int i2 = 0; i2 < this.objVals.length; ++i2) {
                ObjectOutputStream.this.writeObject0(this.objVals[i2], objectStreamFieldArray[n2 + i2].isUnshared());
            }
        }

        private int getFieldOffset(String string, Class clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField == null) {
                throw new IllegalArgumentException("no such field");
            }
            return objectStreamField.getOffset();
        }
    }

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int n2, float f2) {
            this.htab = new HandleTable(n2, f2);
            this.reps = new Object[n2];
        }

        void assign(Object object, Object object2) {
            int n2 = this.htab.assign(object);
            while (n2 >= this.reps.length) {
                this.grow();
            }
            this.reps[n2] = object2;
        }

        Object lookup(Object object) {
            int n2 = this.htab.lookup(object);
            return n2 >= 0 ? this.reps[n2] : object;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] objectArray = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, objectArray, 0, this.reps.length);
            this.reps = objectArray;
        }
    }
}

