/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected Entry[] fGrammars = null;
    protected boolean fPoolIsLocked;
    protected int fGrammarCount = 0;
    private static final boolean DEBUG = false;

    public XMLGrammarPoolImpl() {
        this.fGrammars = new Entry[11];
        this.fPoolIsLocked = false;
    }

    public XMLGrammarPoolImpl(int n2) {
        this.fGrammars = new Entry[n2];
        this.fPoolIsLocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar[] retrieveInitialGrammarSet(String string) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int n2 = this.fGrammars.length;
            Grammar[] grammarArray = new Grammar[this.fGrammarCount];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Entry entry = this.fGrammars[i2];
                while (entry != null) {
                    if (entry.desc.getGrammarType().equals(string)) {
                        grammarArray[n3++] = entry.grammar;
                    }
                    entry = entry.next;
                }
            }
            Grammar[] grammarArray2 = new Grammar[n3];
            System.arraycopy(grammarArray, 0, grammarArray2, 0, n3);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return grammarArray2;
        }
    }

    public void cacheGrammars(String string, Grammar[] grammarArray) {
        if (!this.fPoolIsLocked) {
            for (int i2 = 0; i2 < grammarArray.length; ++i2) {
                this.putGrammar(grammarArray[i2]);
            }
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        return this.getGrammar(xMLGrammarDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putGrammar(Grammar grammar) {
        if (this.fPoolIsLocked) return;
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            XMLGrammarDescription xMLGrammarDescription = grammar.getGrammarDescription();
            int n2 = this.hashCode(xMLGrammarDescription);
            int n3 = (n2 & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n3];
            while (entry != null) {
                if (entry.hash == n2 && this.equals(entry.desc, xMLGrammarDescription)) {
                    entry.grammar = grammar;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                entry = entry.next;
            }
            this.fGrammars[n3] = entry = new Entry(n2, xMLGrammarDescription, grammar, this.fGrammars[n3]);
            ++this.fGrammarCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int n2 = this.hashCode(xMLGrammarDescription);
            int n3 = (n2 & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n3];
            while (entry != null) {
                if (entry.hash == n2 && this.equals(entry.desc, xMLGrammarDescription)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return entry.grammar;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar removeGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int n2 = this.hashCode(xMLGrammarDescription);
            int n3 = (n2 & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n3];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n2 && this.equals(entry.desc, xMLGrammarDescription)) {
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        this.fGrammars[n3] = entry.next;
                    }
                    Grammar grammar = entry.grammar;
                    entry.grammar = null;
                    --this.fGrammarCount;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return grammar;
                }
                entry2 = entry;
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int n2 = this.hashCode(xMLGrammarDescription);
            int n3 = (n2 & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n3];
            while (entry != null) {
                if (entry.hash == n2 && this.equals(entry.desc, xMLGrammarDescription)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public void lockPool() {
        this.fPoolIsLocked = true;
    }

    public void unlockPool() {
        this.fPoolIsLocked = false;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.fGrammars.length; ++i2) {
            if (this.fGrammars[i2] == null) continue;
            this.fGrammars[i2].clear();
            this.fGrammars[i2] = null;
        }
        this.fGrammarCount = 0;
    }

    public boolean equals(XMLGrammarDescription xMLGrammarDescription, XMLGrammarDescription xMLGrammarDescription2) {
        return xMLGrammarDescription.equals(xMLGrammarDescription2);
    }

    public int hashCode(XMLGrammarDescription xMLGrammarDescription) {
        return xMLGrammarDescription.hashCode();
    }

    protected static final class Entry {
        public int hash;
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public Entry next;

        protected Entry(int n2, XMLGrammarDescription xMLGrammarDescription, Grammar grammar, Entry entry) {
            this.hash = n2;
            this.desc = xMLGrammarDescription;
            this.grammar = grammar;
            this.next = entry;
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            if (this.next != null) {
                this.next.clear();
                this.next = null;
            }
        }
    }
}

