/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable;
    private static final char[] lookUpHexAlphabet;

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = n2 * 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = byArray[i2];
            if (n4 < 0) {
                n4 += 256;
            }
            cArray[i2 * 2] = lookUpHexAlphabet[n4 >> 4];
            cArray[i2 * 2 + 1] = lookUpHexAlphabet[n4 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n3 = n2 / 2;
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = hexNumberTable[cArray[i2 * 2]];
            if (by == -1) {
                return null;
            }
            byte by2 = hexNumberTable[cArray[i2 * 2 + 1]];
            if (by2 == -1) {
                return null;
            }
            byArray[i2] = (byte)(by << 4 | by2);
        }
        return byArray;
    }

    static {
        int n2;
        hexNumberTable = new byte[255];
        lookUpHexAlphabet = new char[16];
        for (n2 = 0; n2 < 255; ++n2) {
            HexBin.hexNumberTable[n2] = -1;
        }
        for (n2 = 57; n2 >= 48; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 48);
        }
        for (n2 = 70; n2 >= 65; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 65 + 10);
        }
        for (n2 = 102; n2 >= 97; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 97 + 10);
        }
        for (n2 = 0; n2 < 10; ++n2) {
            HexBin.lookUpHexAlphabet[n2] = (char)(48 + n2);
        }
        for (n2 = 10; n2 <= 15; ++n2) {
            HexBin.lookUpHexAlphabet[n2] = (char)(65 + n2 - 10);
        }
    }
}

