/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Signature
extends Attribute {
    private int signature_index;

    public Signature(Signature signature) {
        this(signature.getNameIndex(), signature.getLength(), signature.getSignatureIndex(), signature.getConstantPool());
    }

    Signature(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, dataInputStream.readUnsignedShort(), constantPool);
    }

    public Signature(int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)10, n2, n3, constantPool);
        this.signature_index = n4;
    }

    public void accept(Visitor visitor) {
        System.err.println("Visiting non-standard Signature object");
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.signature_index);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int n2) {
        this.signature_index = n2;
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    private static boolean identStart(int n2) {
        return n2 == 84 || n2 == 76;
    }

    private static boolean identPart(int n2) {
        return n2 == 47 || n2 == 59;
    }

    private static final void matchIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuffer stringBuffer) {
        int n2 = myByteArrayInputStream.read();
        if (n2 == -1) {
            throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(n2)) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = 1;
            while (Character.isJavaIdentifierPart((char)n2)) {
                stringBuffer2.append((char)n2);
                ++n3;
                n2 = myByteArrayInputStream.read();
            }
            if (n2 == 58) {
                myByteArrayInputStream.skip("Ljava/lang/Object".length());
                stringBuffer.append(stringBuffer2);
                n2 = myByteArrayInputStream.read();
                myByteArrayInputStream.unread();
            } else {
                for (int i2 = 0; i2 < n3; ++i2) {
                    myByteArrayInputStream.unread();
                }
            }
            return;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        n2 = myByteArrayInputStream.read();
        do {
            stringBuffer3.append((char)n2);
        } while ((n2 = myByteArrayInputStream.read()) != -1 && (Character.isJavaIdentifierPart((char)n2) || n2 == 47));
        stringBuffer.append(stringBuffer3.toString().replace('/', '.'));
        if (n2 != -1) {
            myByteArrayInputStream.unread();
        }
    }

    private static final void matchGJIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuffer stringBuffer) {
        Signature.matchIdent(myByteArrayInputStream, stringBuffer);
        int n2 = myByteArrayInputStream.read();
        if (n2 == 60 || n2 == 40) {
            stringBuffer.append((char)n2);
            Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
            while ((n2 = myByteArrayInputStream.read()) != 62 && n2 != 41) {
                if (n2 == -1) {
                    throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " reaching EOF");
                }
                stringBuffer.append(", ");
                myByteArrayInputStream.unread();
                Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
            }
            stringBuffer.append((char)n2);
        } else {
            myByteArrayInputStream.unread();
        }
        n2 = myByteArrayInputStream.read();
        if (Signature.identStart(n2)) {
            myByteArrayInputStream.unread();
            Signature.matchGJIdent(myByteArrayInputStream, stringBuffer);
        } else {
            if (n2 == 41) {
                myByteArrayInputStream.unread();
                return;
            }
            if (n2 != 59) {
                throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " read " + (char)n2);
            }
        }
    }

    public static String translate(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Signature.matchGJIdent(new MyByteArrayInputStream(string), stringBuffer);
        return stringBuffer.toString();
    }

    public static final boolean isFormalParameterList(String string) {
        return string.startsWith("<") && string.indexOf(58) > 0;
    }

    public static final boolean isActualParameterList(String string) {
        return string.startsWith("L") && string.endsWith(">;");
    }

    public final String toString() {
        String string = this.getSignature();
        return "Signature(" + string + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        return (Signature)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String string) {
            super(string.getBytes());
        }

        final int mark() {
            return this.pos;
        }

        final String getData() {
            return new String(this.buf);
        }

        final void reset(int n2) {
            this.pos = n2;
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

