/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private ArrayList eventQueue = new ArrayList();
    private Thread thread = null;
    private ArrayList<ClipInfo> autoClosingClips = new ArrayList();
    private ArrayList<LineMonitor> lineMonitors = new ArrayList();
    static final int LINE_MONITOR_TIME = 400;

    EventDispatcher() {
    }

    synchronized void start() {
        if (this.thread == null) {
            this.thread = JSSecurityManager.createThread(this, "Java Sound Event Dispatcher", true, -1, true);
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        int n2 = eventInfo.getListenerCount();
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    ((LineListener)eventInfo.getListener(i2)).update(lineEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            for (int i3 = 0; i3 < n2; ++i3) {
                try {
                    ((MetaEventListener)eventInfo.getListener(i3)).meta(metaMessage);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n3 = shortMessage.getStatus();
            if ((n3 & 0xF0) == 176) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    try {
                        ((ControllerEventListener)eventInfo.getListener(i4)).controlChange(shortMessage);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (this.eventQueue.size() == 0) {
                    if (this.autoClosingClips.size() > 0 || this.lineMonitors.size() > 0) {
                        int n2 = 5000;
                        if (this.lineMonitors.size() > 0) {
                            n2 = 400;
                        }
                        this.wait(n2);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.eventQueue.size() > 0) {
                eventInfo = (EventInfo)this.eventQueue.remove(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        } else {
            if (this.autoClosingClips.size() > 0) {
                this.closeAutoClosingClips();
            }
            if (this.lineMonitors.size() > 0) {
                this.monitorLines();
            }
        }
    }

    private synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.add(eventInfo);
        this.notifyAll();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.dispatchEvents();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    void sendAudioEvents(Object object, List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.start();
        EventInfo eventInfo = new EventInfo(object, list);
        this.postEvent(eventInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAutoClosingClips() {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            long l2 = System.currentTimeMillis();
            for (int i2 = this.autoClosingClips.size() - 1; i2 >= 0; --i2) {
                ClipInfo clipInfo = this.autoClosingClips.get(i2);
                if (!clipInfo.isExpired(l2)) continue;
                AutoClosingClip autoClosingClip = clipInfo.getClip();
                if (!autoClosingClip.isOpen() || !autoClosingClip.isAutoClosing()) {
                    this.autoClosingClips.remove(i2);
                    continue;
                }
                if (autoClosingClip.isRunning() || autoClosingClip.isActive() || !autoClosingClip.isAutoClosing()) continue;
                autoClosingClip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAutoClosingClipIndex(AutoClosingClip autoClosingClip) {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            for (int i2 = this.autoClosingClips.size() - 1; i2 >= 0; --i2) {
                if (!autoClosingClip.equals(this.autoClosingClips.get(i2).getClip())) continue;
                return i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipOpened(AutoClosingClip autoClosingClip) {
        int n2 = 0;
        Object object = this.autoClosingClips;
        synchronized (object) {
            n2 = this.getAutoClosingClipIndex(autoClosingClip);
            if (n2 == -1) {
                this.autoClosingClips.add(new ClipInfo(autoClosingClip));
            }
        }
        if (n2 == -1) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    void autoClosingClipClosed(AutoClosingClip autoClosingClip) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorLines() {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            for (int i2 = 0; i2 < this.lineMonitors.size(); ++i2) {
                this.lineMonitors.get(i2).checkLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLineMonitor(LineMonitor lineMonitor) {
        Object object = this.lineMonitors;
        synchronized (object) {
            if (this.lineMonitors.indexOf(lineMonitor) >= 0) {
                return;
            }
            this.lineMonitors.add(lineMonitor);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLineMonitor(LineMonitor lineMonitor) {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            if (this.lineMonitors.indexOf(lineMonitor) < 0) {
                return;
            }
            this.lineMonitors.remove(lineMonitor);
        }
    }

    private class ClipInfo {
        private AutoClosingClip clip;
        private long expiration;

        ClipInfo(AutoClosingClip autoClosingClip) {
            this.clip = autoClosingClip;
            this.expiration = System.currentTimeMillis() + 5000L;
        }

        AutoClosingClip getClip() {
            return this.clip;
        }

        boolean isExpired(long l2) {
            return l2 > this.expiration;
        }
    }

    private class EventInfo {
        private Object event;
        private Object[] listeners;

        EventInfo(Object object, List list) {
            this.event = object;
            this.listeners = list.toArray();
        }

        Object getEvent() {
            return this.event;
        }

        int getListenerCount() {
            return this.listeners.length;
        }

        Object getListener(int n2) {
            return this.listeners[n2];
        }
    }

    static interface LineMonitor {
        public void checkLine();
    }
}

