/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class PackageWriter
extends BandStructure {
    Package pkg;
    OutputStream finalOut;
    HashSet requiredEntries;
    HashMap backCountTable;
    int[][] attrCounts;
    int[] maxFlags;
    HashMap[] allLayouts;
    Attribute.Layout[] attrDefsWritten;
    private Code curCode;
    private Package.Class curClass;
    private ConstantPool.Entry[] curCPMap;
    int[] codeHist = new int[256];
    int[] ldcHist = new int[20];

    PackageWriter(Package package_, OutputStream outputStream) throws IOException {
        super(false);
        this.pkg = package_;
        this.finalOut = outputStream;
    }

    void write() throws IOException {
        boolean bl2 = false;
        try {
            if (this.verbose > 0) {
                Utils.log.info("Setting up constant pool...");
            }
            this.setup();
            if (this.verbose > 0) {
                Utils.log.info("Packing...");
            }
            this.writeConstantPool();
            this.writeFiles();
            this.writeAttrDefs();
            this.writeInnerClasses();
            this.writeClassesAndByteCodes();
            this.writeAttrCounts();
            if (this.verbose > 1) {
                this.printCodeHist();
            }
            if (this.verbose > 0) {
                Utils.log.info("Coding...");
            }
            this.all_bands.chooseBandCodings();
            this.writeFileHeader();
            this.writeAllBandsTo(this.finalOut);
            bl2 = true;
        }
        catch (Exception exception) {
            Utils.log.log(Level.WARNING, "Error on output: " + exception, exception);
            if (this.verbose > 0) {
                this.finalOut.close();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("error packing", exception);
        }
    }

    void setup() {
        this.requiredEntries = new HashSet();
        this.setArchiveOptions();
        this.trimClassAttributes();
        this.collectAttributeLayouts();
        this.pkg.buildGlobalConstantPool(this.requiredEntries);
        this.setBandIndexes();
        this.makeNewAttributeBands();
        this.collectInnerClasses();
    }

    void setArchiveOptions() {
        Object object;
        int n2;
        int n3 = this.pkg.default_modtime;
        int n4 = this.pkg.default_modtime;
        int n5 = -1;
        int n6 = 0;
        this.archiveOptions |= this.pkg.default_options;
        for (Package.File file : this.pkg.files) {
            n2 = file.modtime;
            int n7 = file.options;
            if (n3 == 0) {
                n3 = n4 = n2;
            } else {
                if (n3 > n2) {
                    n3 = n2;
                }
                if (n4 < n2) {
                    n4 = n2;
                }
            }
            n5 &= n7;
            n6 |= n7;
        }
        if (this.pkg.default_modtime == 0) {
            this.pkg.default_modtime = n3;
        }
        if (n3 != 0 && n3 != n4) {
            this.archiveOptions |= 0x40;
        }
        if (!PackageWriter.testBit(this.archiveOptions, 32) && n5 != -1) {
            if (PackageWriter.testBit(n5, 1)) {
                this.archiveOptions |= 0x20;
                --n5;
                --n6;
            }
            this.pkg.default_options |= n5;
            if (n5 != n6 || n5 != this.pkg.default_options) {
                this.archiveOptions |= 0x80;
            }
        }
        HashMap hashMap = new HashMap();
        int n8 = 0;
        n2 = -1;
        for (Package.Class clazz : this.pkg.classes) {
            int n9;
            int n10 = clazz.getVersion();
            object = (int[])hashMap.get(new Integer(n10));
            if (object == null) {
                object = new int[1];
                hashMap.put(new Integer(n10), object);
            }
            if (n8 >= (n9 = (object[0] = object[0] + 1))) continue;
            n8 = n9;
            n2 = n10;
        }
        hashMap.clear();
        if (n2 == -1) {
            n2 = 0;
        }
        char c2 = (char)(n2 >>> 16);
        char c3 = (char)n2;
        this.pkg.default_class_majver = (short)c2;
        this.pkg.default_class_minver = (short)c3;
        String string = Package.versionStringOf(c2, c3);
        if (this.verbose > 0) {
            Utils.log.info("Consensus version number is " + string);
        }
        object = this.pkg.classes.iterator();
        while (object.hasNext()) {
            Package.Class clazz = (Package.Class)object.next();
            if (clazz.getVersion() == n2) continue;
            Attribute attribute = this.makeClassFileVersionAttr(clazz.minver, clazz.majver);
            if (this.verbose > 1) {
                Object object2 = clazz.getVersionString();
                String string2 = string;
                Utils.log.fine("Version " + (String)object2 + " of " + clazz + " doesn't match package version " + (String)string2);
            }
            clazz.addAttribute(attribute);
        }
        for (Package.File file : this.pkg.files) {
            long l2 = file.getFileLength();
            if (l2 == (long)((int)l2)) continue;
            this.archiveOptions |= 0x100;
            if (this.verbose <= 0) break;
            Utils.log.info("Note: Huge resource file " + file.getFileName() + " forces 64-bit sizing");
            break;
        }
        int n11 = 0;
        int n12 = 0;
        for (Object object2 : this.pkg.classes) {
            for (Package.Class.Method method : ((Package.Class)object2).getMethods()) {
                if (method.code == null) continue;
                if (method.code.attributeSize() == 0) {
                    ++n12;
                    continue;
                }
                if (PackageWriter.shortCodeHeader(method.code) == 0) continue;
                n11 += 3;
            }
        }
        if (n11 > n12) {
            this.archiveOptions |= 4;
        }
        if (this.verbose > 0) {
            Utils.log.info("archiveOptions = 0b" + Integer.toBinaryString(this.archiveOptions));
        }
    }

    void writeFileHeader() throws IOException {
        this.pkg.checkVersion();
        this.writeArchiveMagic();
        this.writeArchiveHeader();
    }

    private void putMagicInt32(int n2) throws IOException {
        int n3 = n2;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.archive_magic.putByte(0xFF & n3 >>> 24);
            n3 <<= 8;
        }
    }

    void writeArchiveMagic() throws IOException {
        this.putMagicInt32(this.pkg.magic);
    }

    void writeArchiveHeader() throws IOException {
        boolean bl2;
        boolean bl3;
        int n2 = 0;
        boolean bl4 = PackageWriter.testBit(this.archiveOptions, 1);
        if (!bl4) {
            bl4 |= this.band_headers.length() != 0;
            if (bl4 |= this.attrDefsWritten.length != 0) {
                this.archiveOptions |= 1;
            }
        }
        if (!bl4) {
            n2 += 2;
        }
        if (!(bl3 = PackageWriter.testBit(this.archiveOptions, 16))) {
            bl3 |= this.archiveNextCount > 0;
            if (bl3 |= this.pkg.default_modtime != 0) {
                this.archiveOptions |= 0x10;
            }
        }
        if (!bl3) {
            n2 += 5;
        }
        if (!(bl2 = PackageWriter.testBit(this.archiveOptions, 2)) && (bl2 |= this.pkg.cp.haveNumbers())) {
            this.archiveOptions |= 2;
        }
        if (!bl2) {
            n2 += 4;
        }
        this.archive_header_0.putInt(this.pkg.package_minver);
        this.archive_header_0.putInt(this.pkg.package_majver);
        this.archive_header_0.putInt(this.archiveOptions);
        assert (this.archive_header_0.length() == 3);
        if (bl3) {
            assert (this.archive_header_S.length() == 0);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 1);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 2);
        }
        if (bl3) {
            this.archive_header_1.putInt(this.archiveNextCount);
            this.archive_header_1.putInt(this.pkg.default_modtime);
            this.archive_header_1.putInt(this.pkg.files.size());
        } else assert (this.pkg.files.size() == 0);
        if (bl4) {
            this.archive_header_1.putInt(this.band_headers.length());
            this.archive_header_1.putInt(this.attrDefsWritten.length);
        } else {
            assert (this.band_headers.length() == 0);
            assert (this.attrDefsWritten.length == 0);
        }
        this.writeConstantPoolCounts(bl2);
        this.archive_header_1.putInt(this.pkg.getAllInnerClasses().size());
        this.archive_header_1.putInt(this.pkg.default_class_minver);
        this.archive_header_1.putInt(this.pkg.default_class_majver);
        this.archive_header_1.putInt(this.pkg.classes.size());
        assert (this.archive_header_0.length() + this.archive_header_S.length() + this.archive_header_1.length() == 26 - n2);
        this.archiveSize0 = 0L;
        this.archiveSize1 = this.all_bands.outputSize();
        this.archiveSize0 += this.archive_magic.outputSize();
        this.archiveSize0 += this.archive_header_0.outputSize();
        this.archiveSize0 += this.archive_header_S.outputSize();
        this.archiveSize1 -= this.archiveSize0;
        if (bl3) {
            int n3 = (int)(this.archiveSize1 >>> 32);
            int n4 = (int)(this.archiveSize1 >>> 0);
            this.archive_header_S.patchValue(0, n3);
            this.archive_header_S.patchValue(1, n4);
            int n5 = UNSIGNED5.getLength(0);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n3) - n5);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n4) - n5);
        }
        if (this.verbose > 1) {
            Utils.log.fine("archive sizes: " + this.archiveSize0 + "+" + this.archiveSize1);
        }
        assert (this.all_bands.outputSize() == this.archiveSize0 + this.archiveSize1);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeConstantPoolCounts(boolean bl2) throws IOException {
        int n2 = 0;
        while (true) {
            block8: {
                if (n2 >= ConstantPool.TAGS_IN_ORDER.length) {
                    return;
                }
                byte by = ConstantPool.TAGS_IN_ORDER[n2];
                int n3 = this.pkg.cp.getIndexByTag(by).size();
                switch (by) {
                    case 1: {
                        if (n3 > 0) assert (this.pkg.cp.getIndexByTag(by).get(0) == ConstantPool.getUtf8Entry(""));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (bl2) break;
                        assert (n3 == 0);
                        break block8;
                    }
                }
                this.archive_header_1.putInt(n3);
            }
            ++n2;
        }
    }

    protected ConstantPool.Index getCPIndex(byte by) {
        return this.pkg.cp.getIndexByTag(by);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        if (this.verbose > 0) {
            Utils.log.info("Writing CP");
        }
        block14: for (int i2 = 0; i2 < ConstantPool.TAGS_IN_ORDER.length; ++i2) {
            byte by = ConstantPool.TAGS_IN_ORDER[i2];
            ConstantPool.Index index = indexGroup.getIndexByTag(by);
            ConstantPool.Entry[] entryArray = index.cpMap;
            if (this.verbose > 0) {
                Utils.log.info("Writing " + entryArray.length + " " + ConstantPool.tagName(by) + " entries...");
            }
            if (this.optDumpBands) {
                PrintStream printStream = new PrintStream(PackageWriter.getDumpStream(index, ".idx"));
                PackageWriter.printArrayTo(printStream, entryArray, 0, entryArray.length);
                printStream.close();
            }
            switch (by) {
                case 1: {
                    this.writeUtf8Bands(entryArray);
                    continue block14;
                }
                case 3: {
                    ConstantPool.Entry entry;
                    for (int i3 = 0; i3 < entryArray.length; ++i3) {
                        entry = (ConstantPool.NumberEntry)entryArray[i3];
                        int n2 = (Integer)((ConstantPool.NumberEntry)entry).numberValue();
                        this.cp_Int.putInt(n2);
                    }
                    continue block14;
                }
                case 4: {
                    ConstantPool.Entry entry;
                    for (int i4 = 0; i4 < entryArray.length; ++i4) {
                        entry = (ConstantPool.NumberEntry)entryArray[i4];
                        float f2 = ((Float)((ConstantPool.NumberEntry)entry).numberValue()).floatValue();
                        int n3 = Float.floatToIntBits(f2);
                        this.cp_Float.putInt(n3);
                    }
                    continue block14;
                }
                case 5: {
                    ConstantPool.Entry entry;
                    for (int i5 = 0; i5 < entryArray.length; ++i5) {
                        entry = (ConstantPool.NumberEntry)entryArray[i5];
                        long l2 = (Long)((ConstantPool.NumberEntry)entry).numberValue();
                        this.cp_Long_hi.putInt((int)(l2 >>> 32));
                        this.cp_Long_lo.putInt((int)(l2 >>> 0));
                    }
                    continue block14;
                }
                case 6: {
                    ConstantPool.Entry entry;
                    for (int i6 = 0; i6 < entryArray.length; ++i6) {
                        entry = (ConstantPool.NumberEntry)entryArray[i6];
                        double d2 = (Double)((ConstantPool.NumberEntry)entry).numberValue();
                        long l3 = Double.doubleToLongBits(d2);
                        this.cp_Double_hi.putInt((int)(l3 >>> 32));
                        this.cp_Double_lo.putInt((int)(l3 >>> 0));
                    }
                    continue block14;
                }
                case 8: {
                    ConstantPool.Entry entry;
                    for (int i7 = 0; i7 < entryArray.length; ++i7) {
                        entry = (ConstantPool.StringEntry)entryArray[i7];
                        this.cp_String.putRef(((ConstantPool.StringEntry)entry).ref);
                    }
                    continue block14;
                }
                case 7: {
                    ConstantPool.Entry entry;
                    for (int i8 = 0; i8 < entryArray.length; ++i8) {
                        entry = (ConstantPool.ClassEntry)entryArray[i8];
                        this.cp_Class.putRef(((ConstantPool.ClassEntry)entry).ref);
                    }
                    continue block14;
                }
                case 13: {
                    this.writeSignatureBands(entryArray);
                    continue block14;
                }
                case 12: {
                    ConstantPool.Entry entry;
                    for (int i9 = 0; i9 < entryArray.length; ++i9) {
                        entry = (ConstantPool.DescriptorEntry)entryArray[i9];
                        this.cp_Descr_name.putRef(((ConstantPool.DescriptorEntry)entry).nameRef);
                        this.cp_Descr_type.putRef(((ConstantPool.DescriptorEntry)entry).typeRef);
                    }
                    continue block14;
                }
                case 9: {
                    this.writeMemberRefs(by, entryArray, this.cp_Field_class, this.cp_Field_desc);
                    continue block14;
                }
                case 10: {
                    this.writeMemberRefs(by, entryArray, this.cp_Method_class, this.cp_Method_desc);
                    continue block14;
                }
                case 11: {
                    this.writeMemberRefs(by, entryArray, this.cp_Imethod_class, this.cp_Imethod_desc);
                    continue block14;
                }
                default: {
                    assert (false);
                    continue block14;
                }
            }
        }
    }

    void writeUtf8Bands(ConstantPool.Entry[] entryArray) throws IOException {
        int n2;
        int n3;
        if (entryArray.length == 0) {
            return;
        }
        assert (entryArray[0].stringValue().equals(""));
        char[][] cArrayArray = new char[entryArray.length][];
        for (int i2 = 0; i2 < cArrayArray.length; ++i2) {
            cArrayArray[i2] = entryArray[i2].stringValue().toCharArray();
        }
        int[] nArray = new int[entryArray.length];
        char[] cArray = new char[]{};
        for (n3 = 0; n3 < cArrayArray.length; ++n3) {
            int n4;
            char[] cArray2 = cArrayArray[n3];
            n2 = Math.min(cArray2.length, cArray.length);
            for (n4 = 0; n4 < n2 && cArray2[n4] == cArray[n4]; ++n4) {
            }
            nArray[n3] = n4;
            if (n3 >= 2) {
                this.cp_Utf8_prefix.putInt(n4);
            } else assert (n4 == 0);
            cArray = cArray2;
        }
        for (n3 = 0; n3 < cArrayArray.length; ++n3) {
            int n5;
            int n6;
            char[] cArray3 = cArrayArray[n3];
            int n7 = nArray[n3];
            n2 = cArray3.length - nArray[n3];
            boolean bl2 = false;
            if (n2 == 0) {
                bl2 = n3 >= 1;
            } else if (this.optBigStrings && this.effort > 1 && n2 > 100) {
                n6 = 0;
                for (n5 = 0; n5 < n2; ++n5) {
                    if (cArray3[n7 + n5] <= '\u007f') continue;
                    ++n6;
                }
                if (n6 > 100) {
                    bl2 = this.tryAlternateEncoding(n3, n6, cArray3, n7);
                }
            }
            if (n3 < 1) {
                assert (!bl2);
                assert (n2 == 0);
                continue;
            }
            if (bl2) {
                this.cp_Utf8_suffix.putInt(0);
                this.cp_Utf8_big_suffix.putInt(n2);
                continue;
            }
            assert (n2 != 0);
            this.cp_Utf8_suffix.putInt(n2);
            for (n6 = 0; n6 < n2; ++n6) {
                n5 = cArray3[n7 + n6];
                this.cp_Utf8_chars.putInt(n5);
            }
        }
        if (this.verbose > 0) {
            n3 = this.cp_Utf8_chars.length();
            int n8 = this.cp_Utf8_big_chars.length();
            int n9 = n3 + n8;
            Utils.log.info("Utf8string #CHARS=" + n9 + " #PACKEDCHARS=" + n8);
        }
    }

    private boolean tryAlternateEncoding(int n2, int n3, char[] cArray, int n4) {
        int n5 = cArray.length - n4;
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = cArray[n4 + i2];
        }
        CodingChooser codingChooser = this.getCodingChooser();
        Coding coding = this.cp_Utf8_big_chars.regularCoding;
        String string = "(Utf8_big_" + n2 + ")";
        int[] nArray2 = new int[]{0, 0};
        if (this.verbose > 1 || codingChooser.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + string);
        }
        CodingMethod codingMethod = codingChooser.choose(nArray, coding, nArray2);
        Coding coding2 = this.cp_Utf8_chars.regularCoding;
        if (this.verbose > 1) {
            Utils.log.fine("big string[" + n2 + "] len=" + n5 + " #wide=" + n3 + " size=" + nArray2[0] + "/z=" + nArray2[1] + " coding " + codingMethod);
        }
        if (codingMethod != coding2) {
            int n6 = nArray2[1];
            int[] nArray3 = codingChooser.computeSize(coding2, nArray);
            int n7 = nArray3[1];
            int n8 = Math.max(5, n7 / 1000);
            if (this.verbose > 1) {
                Utils.log.fine("big string[" + n2 + "] normalSize=" + nArray3[0] + "/z=" + nArray3[1] + " win=" + (n6 < n7 - n8));
            }
            if (n6 < n7 - n8) {
                BandStructure.IntBand intBand = this.cp_Utf8_big_chars.newIntBand(string);
                intBand.initializeValues(nArray);
                return true;
            }
        }
        return false;
    }

    void writeSignatureBands(ConstantPool.Entry[] entryArray) throws IOException {
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            ConstantPool.SignatureEntry signatureEntry = (ConstantPool.SignatureEntry)entryArray[i2];
            this.cp_Signature_form.putRef(signatureEntry.formRef);
            for (int i3 = 0; i3 < signatureEntry.classRefs.length; ++i3) {
                this.cp_Signature_classes.putRef(signatureEntry.classRefs[i3]);
            }
        }
    }

    void writeMemberRefs(byte by, ConstantPool.Entry[] entryArray, BandStructure.CPRefBand cPRefBand, BandStructure.CPRefBand cPRefBand2) throws IOException {
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)entryArray[i2];
            cPRefBand.putRef(memberEntry.classRef);
            cPRefBand2.putRef(memberEntry.descRef);
        }
    }

    void writeFiles() throws IOException {
        int n2 = this.pkg.files.size();
        if (n2 == 0) {
            return;
        }
        int n3 = this.archiveOptions;
        boolean bl2 = PackageWriter.testBit(n3, 256);
        boolean bl3 = PackageWriter.testBit(n3, 64);
        boolean bl4 = PackageWriter.testBit(n3, 128);
        if (!bl4) {
            for (Package.File file : this.pkg.files) {
                if (!file.isClassStub()) continue;
                bl4 = true;
                this.archiveOptions = n3 |= 0x80;
                break;
            }
        }
        if (bl2 || bl3 || bl4 || !this.pkg.files.isEmpty()) {
            this.archiveOptions = n3 |= 0x10;
        }
        for (Package.File file : this.pkg.files) {
            this.file_name.putRef(file.name);
            long l2 = file.getFileLength();
            this.file_size_lo.putInt((int)l2);
            if (bl2) {
                this.file_size_hi.putInt((int)(l2 >>> 32));
            }
            if (bl3) {
                this.file_modtime.putInt(file.modtime - this.pkg.default_modtime);
            }
            if (bl4) {
                this.file_options.putInt(file.options);
            }
            file.writeTo(this.file_bits.collectorStream());
            if (this.verbose <= 1) continue;
            Utils.log.fine("Wrote " + l2 + " bytes of " + file.name.stringValue());
        }
        if (this.verbose > 0) {
            Utils.log.info("Wrote " + n2 + " resource files");
        }
    }

    void collectAttributeLayouts() {
        int n2;
        this.maxFlags = new int[4];
        this.allLayouts = new HashMap[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.allLayouts[i2] = new HashMap();
        }
        for (Package.Class clazz : this.pkg.classes) {
            this.visitAttributeLayoutsIn(0, clazz);
            for (Package.Class.Member member : clazz.getFields()) {
                this.visitAttributeLayoutsIn(1, member);
            }
            for (Package.Class.Member member : clazz.getMethods()) {
                this.visitAttributeLayoutsIn(2, member);
                if (((Package.Class.Method)member).code == null) continue;
                this.visitAttributeLayoutsIn(3, ((Package.Class.Method)member).code);
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            int n3 = this.allLayouts[n2].size();
            boolean bl2 = this.haveFlagsHi(n2);
            if (n3 >= 24) {
                int n4 = 1 << 9 + n2;
                this.archiveOptions |= n4;
                bl2 = true;
                if (this.verbose > 0) {
                    Utils.log.info("Note: Many " + Attribute.contextName(n2) + " attributes forces 63-bit flags");
                }
            }
            if (this.verbose > 1) {
                Utils.log.fine(Attribute.contextName(n2) + ".maxFlags = 0x" + Integer.toHexString(this.maxFlags[n2]));
                Utils.log.fine(Attribute.contextName(n2) + ".#layouts = " + n3);
            }
            assert (this.haveFlagsHi(n2) == bl2);
        }
        this.initAttrIndexLimit();
        for (n2 = 0; n2 < 4; ++n2) {
            assert ((this.attrFlagMask[n2] & (long)this.maxFlags[n2]) == 0L);
        }
        this.backCountTable = new HashMap();
        this.attrCounts = new int[4][];
        for (n2 = 0; n2 < 4; ++n2) {
            long l2 = ((long)this.maxFlags[n2] | this.attrFlagMask[n2]) ^ 0xFFFFFFFFFFFFFFFFL;
            assert (this.attrIndexLimit[n2] > 0);
            assert (this.attrIndexLimit[n2] < 64);
            l2 &= (1L << this.attrIndexLimit[n2]) - 1L;
            int n5 = 0;
            Map.Entry[] entryArray = new Map.Entry[this.allLayouts[n2].size()];
            this.allLayouts[n2].entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    int n2 = -(((int[])entry.getValue())[0] - ((int[])entry2.getValue())[0]);
                    if (n2 != 0) {
                        return n2;
                    }
                    return ((Comparable)entry.getKey()).compareTo(entry2.getKey());
                }
            });
            this.attrCounts[n2] = new int[this.attrIndexLimit[n2] + entryArray.length];
            for (int i3 = 0; i3 < entryArray.length; ++i3) {
                int n6;
                Map.Entry entry = entryArray[i3];
                Attribute.Layout layout = (Attribute.Layout)entry.getKey();
                int n7 = ((int[])entry.getValue())[0];
                Integer n8 = (Integer)this.attrIndexTable.get(layout);
                if (n8 != null) {
                    n6 = n8;
                } else if (l2 != 0L) {
                    while ((l2 & 1L) == 0L) {
                        l2 >>>= 1;
                        ++n5;
                    }
                    --l2;
                    n6 = this.setAttributeLayoutIndex(layout, n5);
                } else {
                    n6 = this.setAttributeLayoutIndex(layout, -1);
                }
                this.attrCounts[n2][n6] = n7;
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                int[] nArray = new int[elementArray.length];
                for (int i4 = 0; i4 < elementArray.length; ++i4) {
                    assert (elementArray[i4].kind == 10);
                    if (elementArray[i4].flagTest((byte)8)) continue;
                    nArray[i4] = -1;
                }
                this.backCountTable.put(layout, nArray);
                if (n8 != null) continue;
                ConstantPool.Utf8Entry utf8Entry = ConstantPool.getUtf8Entry(layout.name());
                ConstantPool.Utf8Entry utf8Entry2 = ConstantPool.getUtf8Entry(layout.layout());
                this.requiredEntries.add(utf8Entry);
                this.requiredEntries.add(utf8Entry2);
                if (this.verbose <= 0) continue;
                if (n6 < this.attrIndexLimit[n2]) {
                    Utils.log.info("Using free flag bit 1<<" + n6 + " for " + n7 + " occurrences of " + layout);
                    continue;
                }
                Utils.log.info("Using overflow index " + n6 + " for " + n7 + " occurrences of " + layout);
            }
        }
        this.maxFlags = null;
        this.allLayouts = null;
    }

    void visitAttributeLayoutsIn(int n2, Attribute.Holder holder) {
        int n3 = n2;
        this.maxFlags[n3] = this.maxFlags[n3] | holder.flags;
        for (Attribute attribute : holder.getAttributes()) {
            Attribute.Layout layout = attribute.layout();
            int[] nArray = (int[])this.allLayouts[n2].get(layout);
            if (nArray == null) {
                nArray = new int[1];
                this.allLayouts[n2].put(layout, nArray);
            }
            if (nArray[0] >= Integer.MAX_VALUE) continue;
            nArray[0] = nArray[0] + 1;
        }
    }

    void writeAttrDefs() throws IOException {
        int n2;
        int n3;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (n3 = 0; n3 < 4; ++n3) {
            int n4 = this.attrDefs[n3].size();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n3;
                if (i2 < this.attrIndexLimit[n3]) {
                    assert ((n5 |= i2 + 1 << 2) < 256);
                    if (!PackageWriter.testBit(this.attrDefSeen[n3], 1L << i2)) continue;
                }
                Attribute.Layout layout = (Attribute.Layout)this.attrDefs[n3].get(i2);
                arrayList.add(new Object[]{new Integer(n5), layout});
                assert (new Integer(i2).equals(this.attrIndexTable.get(layout)));
            }
        }
        n3 = arrayList.size();
        Object[][] objectArrayArray = new Object[n3][];
        arrayList.toArray((T[])objectArrayArray);
        Arrays.sort(objectArrayArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                int n2 = ((Comparable)objectArray[0]).compareTo(objectArray2[0]);
                if (n2 != 0) {
                    return n2;
                }
                Object v2 = PackageWriter.this.attrIndexTable.get(objectArray[1]);
                Object v3 = PackageWriter.this.attrIndexTable.get(objectArray2[1]);
                assert (v2 != null);
                assert (v3 != null);
                return ((Comparable)v2).compareTo(v3);
            }
        });
        this.attrDefsWritten = new Attribute.Layout[n3];
        PrintStream printStream = !this.optDumpBands ? null : new PrintStream(PackageWriter.getDumpStream(this.attr_definition_headers, ".def"));
        int[] nArray = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            nArray[n2] = this.attrIndexLimit[n2];
        }
        for (n2 = 0; n2 < objectArrayArray.length; ++n2) {
            int n6;
            Attribute.Layout layout;
            int n7 = (Integer)objectArrayArray[n2][0];
            this.attrDefsWritten[n2] = layout = (Attribute.Layout)objectArrayArray[n2][1];
            assert ((n7 & 3) == layout.ctype());
            this.attr_definition_headers.putByte(n7);
            this.attr_definition_name.putRef(ConstantPool.getUtf8Entry(layout.name()));
            this.attr_definition_layout.putRef(ConstantPool.getUtf8Entry(layout.layout()));
            boolean bl2 = false;
            if (!$assertionsDisabled) {
                bl2 = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl2) {
                n6 = (n7 >> 2) - 1;
                if (n6 < 0) {
                    int n8 = layout.ctype();
                    int n9 = nArray[n8];
                    nArray[n8] = n9 + 1;
                    n6 = n9;
                }
                int n10 = (Integer)this.attrIndexTable.get(layout);
                assert (n6 == n10);
            }
            if (printStream == null) continue;
            n6 = (n7 >> 2) - 1;
            printStream.println(n6 + " " + layout);
        }
        if (printStream != null) {
            printStream.close();
        }
    }

    void writeAttrCounts() throws IOException {
        block0: for (int i2 = 0; i2 < 4; ++i2) {
            BandStructure.MultiBand multiBand = this.attrBands[i2];
            BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 4);
            Attribute.Layout[] layoutArray = new Attribute.Layout[this.attrDefs[i2].size()];
            this.attrDefs[i2].toArray(layoutArray);
            boolean bl2 = true;
            while (true) {
                for (int i3 = 0; i3 < layoutArray.length; ++i3) {
                    int n2;
                    Attribute.Layout layout = layoutArray[i3];
                    if (layout == null || bl2 != this.isPredefinedAttr(i2, i3) || (n2 = this.attrCounts[i2][i3]) == 0) continue;
                    int[] nArray = (int[])this.backCountTable.get(layout);
                    for (int i4 = 0; i4 < nArray.length; ++i4) {
                        if (nArray[i4] >= 0) {
                            int n3 = nArray[i4];
                            nArray[i4] = -1;
                            intBand.putInt(n3);
                            assert (layout.getCallables()[i4].flagTest((byte)8));
                            continue;
                        }
                        assert (!layout.getCallables()[i4].flagTest((byte)8));
                    }
                }
                if (!bl2) continue block0;
                bl2 = false;
            }
        }
    }

    void trimClassAttributes() {
        for (Package.Class clazz : this.pkg.classes) {
            clazz.minimizeSourceFile();
        }
    }

    void collectInnerClasses() {
        HashMap<ConstantPool.ClassEntry, Package.InnerClass> hashMap = new HashMap<ConstantPool.ClassEntry, Package.InnerClass>();
        for (Object object : this.pkg.classes) {
            if (!((Package.Class)object).hasInnerClasses()) continue;
            for (Package.InnerClass innerClass : ((Package.Class)object).getInnerClasses()) {
                Package.InnerClass innerClass2 = hashMap.put(innerClass.thisClass, innerClass);
                if (innerClass2 == null || innerClass2.equals(innerClass) || !innerClass2.predictable) continue;
                hashMap.put(innerClass2.thisClass, innerClass2);
            }
        }
        Object[] objectArray = new Package.InnerClass[hashMap.size()];
        hashMap.values().toArray(objectArray);
        hashMap = null;
        Arrays.sort(objectArray);
        this.pkg.setAllInnerClasses(Arrays.asList(objectArray));
        for (Object object : this.pkg.classes) {
            ((Package.Class)object).minimizeLocalICs();
        }
    }

    void writeInnerClasses() throws IOException {
        for (Package.InnerClass innerClass : this.pkg.getAllInnerClasses()) {
            int n2 = innerClass.flags;
            assert ((n2 & 0x10000) == 0);
            if (!innerClass.predictable) {
                n2 |= 0x10000;
            }
            this.ic_this_class.putRef(innerClass.thisClass);
            this.ic_flags.putInt(n2);
            if (innerClass.predictable) continue;
            this.ic_outer_class.putRef(innerClass.outerClass);
            this.ic_name.putRef(innerClass.name);
        }
    }

    void writeLocalInnerClasses(Package.Class clazz) throws IOException {
        List list = clazz.getInnerClasses();
        this.class_InnerClasses_N.putInt(list.size());
        for (Package.InnerClass innerClass : list) {
            this.class_InnerClasses_RC.putRef(innerClass.thisClass);
            if (innerClass.equals(this.pkg.getGlobalInnerClass(innerClass.thisClass))) {
                this.class_InnerClasses_F.putInt(0);
                continue;
            }
            int n2 = innerClass.flags;
            if (n2 == 0) {
                n2 = 65536;
            }
            this.class_InnerClasses_F.putInt(n2);
            this.class_InnerClasses_outer_RCN.putRef(innerClass.outerClass);
            this.class_InnerClasses_name_RUN.putRef(innerClass.name);
        }
    }

    void writeClassesAndByteCodes() throws IOException {
        Package.Class[] classArray = new Package.Class[this.pkg.classes.size()];
        this.pkg.classes.toArray(classArray);
        if (this.verbose > 0) {
            Utils.log.info("  ...scanning " + classArray.length + " classes...");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Package.Class clazz = classArray[i2];
            if (this.verbose > 1) {
                Utils.log.fine("Scanning " + clazz);
            }
            ConstantPool.ClassEntry classEntry = clazz.thisClass;
            ConstantPool.ClassEntry classEntry2 = clazz.superClass;
            ConstantPool.ClassEntry[] classEntryArray = clazz.interfaces;
            assert (classEntry2 != classEntry);
            if (classEntry2 == null) {
                classEntry2 = classEntry;
            }
            this.class_this.putRef(classEntry);
            this.class_super.putRef(classEntry2);
            this.class_interface_count.putInt(clazz.interfaces.length);
            for (int i3 = 0; i3 < classEntryArray.length; ++i3) {
                this.class_interface.putRef(classEntryArray[i3]);
            }
            this.writeMembers(clazz);
            this.writeAttrs(0, clazz, clazz);
            if (this.verbose <= 0 || ++n2 % 1000 != 0) continue;
            Utils.log.info("Have scanned " + n2 + " classes...");
        }
    }

    void writeMembers(Package.Class clazz) throws IOException {
        Object object2;
        List list = clazz.getFields();
        this.class_field_count.putInt(list.size());
        for (Object object2 : list) {
            this.field_descr.putRef(((Package.Class.Member)object2).getDescriptor());
            this.writeAttrs(1, (Attribute.Holder)object2, clazz);
        }
        List list2 = clazz.getMethods();
        this.class_method_count.putInt(list2.size());
        object2 = list2.iterator();
        while (object2.hasNext()) {
            Package.Class.Method method = (Package.Class.Method)object2.next();
            this.method_descr.putRef(method.getDescriptor());
            this.writeAttrs(2, method, clazz);
            assert (method.code != null == (method.getAttribute(this.attrCodeEmpty) != null));
            if (method.code == null) continue;
            this.writeCodeHeader(method.code);
            this.writeByteCodes(method.code);
        }
    }

    void writeCodeHeader(Code code) throws IOException {
        boolean bl2 = PackageWriter.testBit(this.archiveOptions, 4);
        int n2 = code.attributeSize();
        int n3 = PackageWriter.shortCodeHeader(code);
        if (!bl2 && n2 > 0) {
            n3 = 0;
        }
        if (this.verbose > 2) {
            int n4 = code.getMethod().getArgumentSize();
            Utils.log.fine("Code sizes info " + code.max_stack + " " + code.max_locals + " " + code.getHandlerCount() + " " + n4 + " " + n2 + (n3 > 0 ? " SHORT=" + n3 : ""));
        }
        this.code_headers.putByte(n3);
        if (n3 == 0) {
            this.code_max_stack.putInt(code.getMaxStack());
            this.code_max_na_locals.putInt(code.getMaxNALocals());
            this.code_handler_count.putInt(code.getHandlerCount());
        } else {
            assert (bl2 || n2 == 0);
            assert (code.getHandlerCount() < this.shortCodeHeader_h_limit);
        }
        this.writeCodeHandlers(code);
        if (n3 == 0 || bl2) {
            this.writeAttrs(3, code, code.thisClass());
        }
    }

    void writeCodeHandlers(Code code) throws IOException {
        int n2 = code.getHandlerCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.code_handler_class_RCN.putRef(code.handler_class[i2]);
            int n3 = code.encodeBCI(code.handler_start[i2]);
            this.code_handler_start_P.putInt(n3);
            int n4 = code.encodeBCI(code.handler_end[i2]) - n3;
            this.code_handler_end_PO.putInt(n4);
            n3 += n4;
            n4 = code.encodeBCI(code.handler_catch[i2]) - n3;
            this.code_handler_catch_PO.putInt(n4);
        }
    }

    void writeAttrs(int n2, final Attribute.Holder holder, Package.Class clazz) throws IOException {
        BandStructure.MultiBand multiBand = this.attrBands[n2];
        BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 0);
        BandStructure.IntBand intBand2 = PackageWriter.getAttrBand(multiBand, 1);
        boolean bl2 = this.haveFlagsHi(n2);
        assert (this.attrIndexLimit[n2] == (bl2 ? 63 : 32));
        if (holder.attributes == null) {
            intBand2.putInt(holder.flags);
            if (bl2) {
                intBand.putInt(0);
            }
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("Transmitting attrs for " + holder + " flags=" + Integer.toHexString(holder.flags));
        }
        long l2 = this.attrFlagMask[n2];
        long l3 = 0L;
        int n3 = 0;
        Object object = holder.attributes.listIterator();
        while (object.hasNext()) {
            boolean bl3;
            BandStructure.Band[] bandArray;
            Attribute attribute = (Attribute)object.next();
            Attribute.Layout layout = attribute.layout();
            int n4 = (Integer)this.attrIndexTable.get(layout);
            assert (this.attrDefs[n2].get(n4) == layout);
            if (this.verbose > 3) {
                Utils.log.fine("add attr @" + n4 + " " + attribute + " in " + holder);
            }
            if (n4 < this.attrIndexLimit[n2] && PackageWriter.testBit(l2, 1L << n4)) {
                if (this.verbose > 3) {
                    Utils.log.fine("Adding flag bit 1<<" + n4 + " in " + Long.toHexString(l2));
                }
                assert (!PackageWriter.testBit((long)holder.flags, 1L << n4));
                l3 |= 1L << n4;
                l2 -= 1L << n4;
            } else {
                l3 |= 0x10000L;
                ++n3;
                if (this.verbose > 3) {
                    Utils.log.fine("Adding overflow attr #" + n3);
                }
                bandArray = PackageWriter.getAttrBand(multiBand, 3);
                bandArray.putInt(n4);
            }
            if (layout.bandCount == 0) {
                if (layout != this.attrInnerClassesEmpty) continue;
                this.writeLocalInnerClasses((Package.Class)holder);
                continue;
            }
            assert (attribute.fixups == null);
            bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
            assert (bandArray != null);
            assert (bandArray.length == layout.bandCount);
            final int[] nArray = (int[])this.backCountTable.get(layout);
            assert (nArray != null);
            assert (nArray.length == layout.getCallables().length);
            if (this.verbose > 2) {
                Utils.log.fine("writing " + attribute + " in " + holder);
            }
            boolean bl4 = bl3 = n2 == 1 && layout == this.attrConstantValue;
            if (bl3) {
                this.setConstantValueIndex((Package.Class.Field)holder);
            }
            attribute.parse(clazz, attribute.bytes(), 0, attribute.size(), new Attribute.ValueStream(){

                public void putInt(int n2, int n3) {
                    ((BandStructure.IntBand)bandArray[n2]).putInt(n3);
                }

                public void putRef(int n2, ConstantPool.Entry entry) {
                    ((BandStructure.CPRefBand)bandArray[n2]).putRef(entry);
                }

                public int encodeBCI(int n2) {
                    Code code = (Code)holder;
                    return code.encodeBCI(n2);
                }

                public void noteBackCall(int n2) {
                    assert (nArray[n2] >= 0);
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                }
            });
            if (!bl3) continue;
            this.setConstantValueIndex(null);
        }
        if (n3 > 0) {
            object = PackageWriter.getAttrBand(multiBand, 2);
            ((BandStructure.IntBand)object).putInt(n3);
        }
        intBand2.putInt(holder.flags | (int)l3);
        if (bl2) {
            intBand.putInt((int)(l3 >>> 32));
        } else assert (l3 >>> 32 == 0L);
        assert (((long)holder.flags & l3) == 0L) : holder + ".flags=" + Integer.toHexString(holder.flags) + "^" + Long.toHexString(l3);
    }

    private void beginCode(Code code) {
        assert (this.curCode == null);
        this.curCode = code;
        this.curClass = code.m.thisClass();
        this.curCPMap = code.getCPMap();
    }

    private void endCode() {
        this.curCode = null;
        this.curClass = null;
        this.curCPMap = null;
    }

    private int initOpVariant(Instruction instruction, ConstantPool.Entry entry) {
        if (instruction.getBC() != 183) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        if (memberEntry.descRef.nameRef.stringValue() != "<init>") {
            return -1;
        }
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        if (classEntry == this.curClass.thisClass) {
            return 230;
        }
        if (classEntry == this.curClass.superClass) {
            return 231;
        }
        if (classEntry == entry) {
            return 232;
        }
        return -1;
    }

    private int selfOpVariant(Instruction instruction) {
        int n2 = instruction.getBC();
        if (n2 < 178 || n2 > 184) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        int n3 = 202 + (n2 - 178);
        if (classEntry == this.curClass.thisClass) {
            return n3;
        }
        if (classEntry == this.curClass.superClass) {
            return n3 + 14;
        }
        return -1;
    }

    void writeByteCodes(Code code) throws IOException {
        this.beginCode(code);
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        boolean bl2 = false;
        ConstantPool.Entry entry = null;
        block39: for (Instruction instruction = code.instructionAt(0); instruction != null; instruction = instruction.next()) {
            Instruction instruction2;
            int n2;
            if (this.verbose > 3) {
                Utils.log.fine(instruction.toString());
            }
            if (instruction.isWide()) {
                if (this.verbose > 1) {
                    Utils.log.fine("_wide opcode in " + code);
                    Utils.log.fine(instruction.toString());
                }
                this.bc_codes.putByte(196);
                this.codeHist[196] = this.codeHist[196] + 1;
            }
            if ((n2 = instruction.getBC()) == 42 && this.selfOpVariant(instruction2 = code.instructionAt(instruction.getNextPC())) >= 0) {
                bl2 = true;
                continue;
            }
            int n3 = this.initOpVariant(instruction, entry);
            if (n3 >= 0) {
                if (bl2) {
                    this.bc_codes.putByte(42);
                    this.codeHist[42] = this.codeHist[42] + 1;
                    bl2 = false;
                }
                this.bc_codes.putByte(n3);
                int n4 = n3;
                this.codeHist[n4] = this.codeHist[n4] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                int n5 = indexGroup.getOverloadingIndex(memberEntry);
                this.bc_initref.putInt(n5);
                continue;
            }
            int n6 = this.selfOpVariant(instruction);
            if (n6 >= 0) {
                boolean bl3 = Instruction.isFieldOp(n2);
                boolean bl4 = n6 >= 216;
                boolean bl5 = bl2;
                bl2 = false;
                if (bl5) {
                    n6 += 7;
                }
                this.bc_codes.putByte(n6);
                int n7 = n6;
                this.codeHist[n7] = this.codeHist[n7] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                BandStructure.CPRefBand cPRefBand = this.selfOpRefBand(n6);
                ConstantPool.Index index = indexGroup.getMemberIndex(memberEntry.tag, memberEntry.classRef);
                cPRefBand.putRef((ConstantPool.Entry)memberEntry, index);
                continue;
            }
            assert (!bl2);
            int n8 = n2;
            this.codeHist[n8] = this.codeHist[n8] + 1;
            switch (n2) {
                case 170: 
                case 171: {
                    int n9;
                    this.bc_codes.putByte(n2);
                    Instruction.Switch switch_ = (Instruction.Switch)instruction;
                    int n10 = switch_.getAlignedPC();
                    int n11 = switch_.getNextPC();
                    int n12 = switch_.getCaseCount();
                    this.bc_case_count.putInt(n12);
                    this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getDefaultLabel());
                    for (n9 = 0; n9 < n12; ++n9) {
                        this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getCaseLabel(n9));
                    }
                    if (n2 == 170) {
                        this.bc_case_value.putInt(switch_.getCaseValue(0));
                        continue block39;
                    }
                    for (n9 = 0; n9 < n12; ++n9) {
                        this.bc_case_value.putInt(switch_.getCaseValue(n9));
                    }
                    continue block39;
                }
                default: {
                    int n13 = instruction.getBranchLabel();
                    if (n13 >= 0) {
                        this.bc_codes.putByte(n2);
                        this.putLabel(this.bc_label, code, instruction.getPC(), n13);
                        continue block39;
                    }
                    ConstantPool.Entry entry2 = instruction.getCPRef(this.curCPMap);
                    if (entry2 != null) {
                        BandStructure.CPRefBand cPRefBand;
                        if (n2 == 187) {
                            entry = entry2;
                        }
                        if (n2 == 18) {
                            byte by = entry2.tag;
                            this.ldcHist[by] = this.ldcHist[by] + 1;
                        }
                        int n14 = n2;
                        block3 : switch (instruction.getCPTag()) {
                            case 20: {
                                switch (entry2.tag) {
                                    case 3: {
                                        cPRefBand = this.bc_intref;
                                        switch (n2) {
                                            case 18: {
                                                n14 = 234;
                                                break block3;
                                            }
                                            case 19: {
                                                n14 = 237;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 4: {
                                        cPRefBand = this.bc_floatref;
                                        switch (n2) {
                                            case 18: {
                                                n14 = 235;
                                                break block3;
                                            }
                                            case 19: {
                                                n14 = 238;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 5: {
                                        cPRefBand = this.bc_longref;
                                        assert (n2 == 20);
                                        n14 = 20;
                                        break block3;
                                    }
                                    case 6: {
                                        cPRefBand = this.bc_doubleref;
                                        assert (n2 == 20);
                                        n14 = 239;
                                        break block3;
                                    }
                                    case 8: {
                                        cPRefBand = this.bc_stringref;
                                        switch (n2) {
                                            case 18: {
                                                n14 = 18;
                                                break block3;
                                            }
                                            case 19: {
                                                n14 = 19;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    case 7: {
                                        cPRefBand = this.bc_classref;
                                        switch (n2) {
                                            case 18: {
                                                n14 = 233;
                                                break block3;
                                            }
                                            case 19: {
                                                n14 = 236;
                                                break block3;
                                            }
                                        }
                                        assert (false);
                                        break block3;
                                    }
                                    default: {
                                        cPRefBand = null;
                                        assert (false);
                                        break block3;
                                    }
                                }
                            }
                            case 7: {
                                if (entry2 == this.curClass.thisClass) {
                                    entry2 = null;
                                }
                                cPRefBand = this.bc_classref;
                                break;
                            }
                            case 9: {
                                cPRefBand = this.bc_fieldref;
                                break;
                            }
                            case 10: {
                                cPRefBand = this.bc_methodref;
                                break;
                            }
                            case 11: {
                                cPRefBand = this.bc_imethodref;
                                break;
                            }
                            default: {
                                cPRefBand = null;
                                assert (false);
                                break;
                            }
                        }
                        this.bc_codes.putByte(n14);
                        cPRefBand.putRef(entry2);
                        if (n2 == 197) {
                            assert (instruction.getConstant() == code.getByte(instruction.getPC() + 3));
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block39;
                        }
                        if (n2 == 185) {
                            assert (instruction.getLength() == 5);
                            assert (instruction.getConstant() == 1 + ((ConstantPool.MemberEntry)entry2).descRef.typeRef.computeSize(true) << 8);
                            continue block39;
                        }
                        assert (instruction.getLength() == (n2 == 18 ? 2 : 3));
                        continue block39;
                    }
                    int n15 = instruction.getLocalSlot();
                    if (n15 >= 0) {
                        this.bc_codes.putByte(n2);
                        this.bc_local.putInt(n15);
                        int n16 = instruction.getConstant();
                        if (n2 == 132) {
                            if (!instruction.isWide()) {
                                this.bc_byte.putByte(0xFF & n16);
                                continue block39;
                            }
                            this.bc_short.putInt(0xFFFF & n16);
                            continue block39;
                        }
                        assert (n16 == 0);
                        continue block39;
                    }
                    this.bc_codes.putByte(n2);
                    int n17 = instruction.getPC() + 1;
                    int n18 = instruction.getNextPC();
                    if (n17 >= n18) continue block39;
                    switch (n2) {
                        case 17: {
                            this.bc_short.putInt(0xFFFF & instruction.getConstant());
                            continue block39;
                        }
                        case 16: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block39;
                        }
                        case 188: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block39;
                        }
                    }
                    assert (false);
                    continue block39;
                }
            }
        }
        this.bc_codes.putByte(255);
        ++this.bc_codes.elementCountForDebug;
        this.codeHist[255] = this.codeHist[255] + 1;
        this.endCode();
    }

    void printCodeHist() {
        int n2;
        assert (this.verbose > 0);
        Object[] objectArray = new String[this.codeHist.length];
        int n3 = 0;
        for (n2 = 0; n2 < this.codeHist.length; ++n2) {
            n3 += this.codeHist[n2];
        }
        for (n2 = 0; n2 < this.codeHist.length; ++n2) {
            if (this.codeHist[n2] == 0) {
                objectArray[n2] = "";
                continue;
            }
            String string = Instruction.byteName(n2);
            String string2 = "" + this.codeHist[n2];
            string2 = "         ".substring(string2.length()) + string2;
            String string3 = "" + this.codeHist[n2] * 10000 / n3;
            while (string3.length() < 4) {
                string3 = "0" + string3;
            }
            string3 = string3.substring(0, string3.length() - 2) + "." + string3.substring(string3.length() - 2);
            objectArray[n2] = string2 + "  " + string3 + "%  " + string;
        }
        Arrays.sort(objectArray);
        System.out.println("Bytecode histogram [" + n3 + "]");
        n2 = objectArray.length;
        while (--n2 >= 0) {
            if (objectArray[n2] == "") continue;
            System.out.println((String)objectArray[n2]);
        }
        for (n2 = 0; n2 < this.ldcHist.length; ++n2) {
            int n4 = this.ldcHist[n2];
            if (n4 == 0) continue;
            System.out.println("ldc " + ConstantPool.tagName(n2) + " " + n4);
        }
    }
}

