/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.fsm;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.fsm.GuardedAction;
import com.sun.corba.se.spi.orbutil.fsm.Action;
import com.sun.corba.se.spi.orbutil.fsm.ActionBase;
import com.sun.corba.se.spi.orbutil.fsm.FSM;
import com.sun.corba.se.spi.orbutil.fsm.FSMImpl;
import com.sun.corba.se.spi.orbutil.fsm.Guard;
import com.sun.corba.se.spi.orbutil.fsm.Input;
import com.sun.corba.se.spi.orbutil.fsm.State;
import com.sun.corba.se.spi.orbutil.fsm.StateEngine;
import com.sun.corba.se.spi.orbutil.fsm.StateImpl;
import java.util.Set;
import org.omg.CORBA.INTERNAL;

public class StateEngineImpl
implements StateEngine {
    private static Action emptyAction = new ActionBase("Empty"){

        public void doIt(FSM fSM, Input input) {
        }
    };
    private boolean initializing = true;
    private Action defaultAction = new ActionBase("Invalid Transition"){

        public void doIt(FSM fSM, Input input) {
            throw new INTERNAL("Invalid transition attempted from " + fSM.getState() + " under " + input);
        }
    };

    public StateEngine add(State state, Input input, Guard guard, Action action, State state2) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl stateImpl = (StateImpl)state;
        GuardedAction guardedAction = new GuardedAction(guard, action, state2);
        stateImpl.addGuardedAction(input, guardedAction);
        return this;
    }

    public StateEngine add(State state, Input input, Action action, State state2) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl stateImpl = (StateImpl)state;
        GuardedAction guardedAction = new GuardedAction(action, state2);
        stateImpl.addGuardedAction(input, guardedAction);
        return this;
    }

    public StateEngine setDefault(State state, Action action, State state2) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl stateImpl = (StateImpl)state;
        stateImpl.setDefaultAction(action);
        stateImpl.setDefaultNextState(state2);
        return this;
    }

    public StateEngine setDefault(State state, State state2) throws IllegalArgumentException, IllegalStateException {
        return this.setDefault(state, emptyAction, state2);
    }

    public StateEngine setDefault(State state) throws IllegalArgumentException, IllegalStateException {
        return this.setDefault(state, state);
    }

    public void done() throws IllegalStateException {
        this.mustBeInitializing();
        this.initializing = false;
    }

    public void setDefaultAction(Action action) throws IllegalStateException {
        this.mustBeInitializing();
        this.defaultAction = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(FSM fSM, Input input, boolean bl2) {
        if (bl2) {
            ORBUtility.dprint(this, "doIt enter: currentState = " + fSM.getState() + " in = " + input);
        }
        try {
            this.innerDoIt(fSM, input, bl2);
        }
        finally {
            if (bl2) {
                ORBUtility.dprint(this, "doIt exit");
            }
        }
    }

    private StateImpl getDefaultNextState(StateImpl stateImpl) {
        StateImpl stateImpl2 = (StateImpl)stateImpl.getDefaultNextState();
        if (stateImpl2 == null) {
            stateImpl2 = stateImpl;
        }
        return stateImpl2;
    }

    private Action getDefaultAction(StateImpl stateImpl) {
        Action action = stateImpl.getDefaultAction();
        if (action == null) {
            action = this.defaultAction;
        }
        return action;
    }

    private void innerDoIt(FSM fSM, Input input, boolean bl2) {
        if (bl2) {
            ORBUtility.dprint(this, "Calling innerDoIt with input " + input);
        }
        StateImpl stateImpl = null;
        StateImpl stateImpl2 = null;
        Action action = null;
        boolean bl3 = false;
        block0: do {
            Set set;
            bl3 = false;
            stateImpl = (StateImpl)fSM.getState();
            stateImpl2 = this.getDefaultNextState(stateImpl);
            action = this.getDefaultAction(stateImpl);
            if (bl2) {
                ORBUtility.dprint(this, "currentState      = " + stateImpl);
                ORBUtility.dprint(this, "in                = " + input);
                ORBUtility.dprint(this, "default nextState = " + stateImpl2);
                ORBUtility.dprint(this, "default action    = " + action);
            }
            if ((set = stateImpl.getGuardedActions(input)) == null) continue;
            for (GuardedAction guardedAction : set) {
                Guard.Result result = guardedAction.getGuard().evaluate(fSM, input);
                if (bl2) {
                    ORBUtility.dprint(this, "doIt: evaluated " + guardedAction + " with result " + result);
                }
                if (result == Guard.Result.ENABLED) {
                    stateImpl2 = (StateImpl)guardedAction.getNextState();
                    action = guardedAction.getAction();
                    if (!bl2) continue block0;
                    ORBUtility.dprint(this, "nextState = " + stateImpl2);
                    ORBUtility.dprint(this, "action    = " + action);
                    continue block0;
                }
                if (result != Guard.Result.DEFERED) continue;
                bl3 = true;
                continue block0;
            }
        } while (bl3);
        this.performStateTransition(fSM, input, stateImpl2, action, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performStateTransition(FSM fSM, Input input, StateImpl stateImpl, Action action, boolean bl2) {
        boolean bl3;
        block17: {
            StateImpl stateImpl2 = (StateImpl)fSM.getState();
            boolean bl4 = bl3 = !stateImpl2.equals(stateImpl);
            if (bl3) {
                if (bl2) {
                    ORBUtility.dprint(this, "doIt: executing postAction for state " + stateImpl2);
                }
                try {
                    stateImpl2.postAction(fSM);
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        ORBUtility.dprint(this, "doIt: postAction threw " + throwable);
                    }
                    if (!(throwable instanceof ThreadDeath)) break block17;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        try {
            if (action != null) {
                action.doIt(fSM, input);
            }
        }
        finally {
            if (bl3) {
                block19: {
                    if (bl2) {
                        ORBUtility.dprint(this, "doIt: executing preAction for state " + stateImpl);
                    }
                    try {
                        stateImpl.preAction(fSM);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            ORBUtility.dprint(this, "doIt: preAction threw " + throwable);
                        }
                        if (!(throwable instanceof ThreadDeath)) break block19;
                        throw (ThreadDeath)throwable;
                    }
                }
                ((FSMImpl)fSM).internalSetState(stateImpl);
            }
            if (bl2) {
                ORBUtility.dprint(this, "doIt: state is now " + stateImpl);
            }
        }
    }

    public FSM makeFSM(State state) throws IllegalStateException {
        this.mustNotBeInitializing();
        return new FSMImpl(this, state);
    }

    private void mustBeInitializing() throws IllegalStateException {
        if (!this.initializing) {
            throw new IllegalStateException("Invalid method call after initialization completed");
        }
    }

    private void mustNotBeInitializing() throws IllegalStateException {
        if (this.initializing) {
            throw new IllegalStateException("Invalid method call before initialization completed");
        }
    }
}

