/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

final class ProtocolVersion {
    static final ProtocolVersion NONE = new ProtocolVersion(-1, "NONE");
    static final ProtocolVersion SSL20Hello = new ProtocolVersion(2, "SSLv2Hello");
    static final ProtocolVersion SSL30 = new ProtocolVersion(768, "SSLv3");
    static final ProtocolVersion TLS10 = new ProtocolVersion(769, "TLSv1");
    static final ProtocolVersion MIN = SSL30;
    static final ProtocolVersion MAX = TLS10;
    static final ProtocolVersion DEFAULT = TLS10;
    static final ProtocolVersion DEFAULT_HELLO = SSL20Hello;
    final int v;
    final byte major;
    final byte minor;
    final String name;

    private ProtocolVersion(int n, String string) {
        this.v = n;
        this.name = string;
        this.major = (byte)(n >>> 8);
        this.minor = (byte)(n & 0xFF);
    }

    private static ProtocolVersion valueOf(int n) {
        if (n == ProtocolVersion.SSL30.v) {
            return SSL30;
        }
        if (n == ProtocolVersion.TLS10.v) {
            return TLS10;
        }
        if (n == ProtocolVersion.SSL20Hello.v) {
            return SSL20Hello;
        }
        int n2 = n >>> 8 & 0xFF;
        int n3 = n & 0xFF;
        return new ProtocolVersion(n, "Unknown " + n2 + "." + n3);
    }

    static ProtocolVersion valueOf(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        return ProtocolVersion.valueOf(n3);
    }

    static ProtocolVersion valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Protocol cannot be null");
        }
        if (string.equals(ProtocolVersion.SSL30.name)) {
            return SSL30;
        }
        if (string.equals(ProtocolVersion.TLS10.name)) {
            return TLS10;
        }
        if (string.equals(ProtocolVersion.SSL20Hello.name)) {
            return SSL20Hello;
        }
        throw new IllegalArgumentException(string);
    }

    public String toString() {
        return this.name;
    }
}

