/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.util.WinRegistry;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class WinConfig
extends Config {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private String _systemExeHome;

    public String getPlatformUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                byte[] byArray = WinConfig.getPlatformUserHomeImpl();
                if (byArray != null) {
                    string = new String(byArray);
                }
                if (string == null) {
                    string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
                }
            }
            this._userHome = string + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._userHome;
    }

    public String getPlatformSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = WinConfig.getPlatformSystemHomeImpl() + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._systemHome;
    }

    public String getPlatformOSHome() {
        if (this._osHome == null) {
            this._osHome = WinConfig.getPlatformSystemHomeImpl();
        }
        return this._osHome;
    }

    public String getSystemJavawsPath() {
        String string;
        if (this._systemExeHome == null) {
            this._systemExeHome = WinConfig.getSystemExecutableHomeImpl();
        }
        if (!new File(string = this._systemExeHome + File.separator + "javaws.exe").exists()) {
            return super.getSystemJavawsPath();
        }
        return string;
    }

    public String getPlatformExtension() {
        return ".exe";
    }

    public String toExecArg(String string) {
        return "\"" + string + "\"";
    }

    public String getLibraryPrefix() {
        return "";
    }

    public String getLibrarySufix() {
        return ".dll";
    }

    public boolean useAltFileSystemView() {
        return true;
    }

    public boolean systemLookAndFeelDefault() {
        return true;
    }

    public String getPlatformSpecificJavaName() {
        return "javaw.exe";
    }

    public String getSessionSpecificString() {
        return "";
    }

    public String getDebugJavaPath(String string) {
        return string.substring(0, string.lastIndexOf(".")).concat("_g.exe");
    }

    public native boolean showDocument(String var1);

    public native String getBrowserPath();

    public String getMozillaUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\registry.dat");
                if (file.exists()) {
                    string2 = NSPreferences.getNS6UserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public native int addRemoveProgramsAdd(String var1, String var2, boolean var3);

    public native int addRemoveProgramsRemove(String var1);

    private static native byte[] getPlatformUserHomeImpl();

    private static native String getPlatformSystemHomeImpl();

    private static native String getSystemExecutableHomeImpl();

    static {
        if (Config.isDebugMode()) {
            System.load(Config.getJavaHome() + File.separator + "bin" + File.separator + "deploy_g.dll");
        } else {
            System.load(Config.getJavaHome() + File.separator + "bin" + File.separator + "deploy.dll");
        }
    }
}

