/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app;

import com.siemens.mp.app.Application;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class MessageBox
extends Alert
implements CommandListener {
    public static final int NONE = -1;
    public static final int LEFT_BUTTON = 0;
    public static final int RIGHT_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    private int mBoxId = 0;
    private int mResult;
    private CommandListener mListener = null;
    private Displayable mNextDisplayable = null;
    private String mTitle = Application.sThis.getAppTitle();
    private String mBodyText = "";
    private String[] mButtonTexts = new String[2];
    private Command[] mButtonCommands = new Command[2];
    private int mMapCKButtonId;

    public MessageBox() {
        super("", "", null, AlertType.INFO);
        this.mButtonCommands[0] = null;
        this.mButtonCommands[1] = null;
        this.mResult = -1;
        this.mMapCKButtonId = -1;
    }

    public final void show() {
        Command oldCmd;
        if (this.mTitle == null) {
            this.mTitle = Application.sThis.getAppTitle();
        }
        if (this.mButtonCommands[1] != null) {
            this.removeCommand(this.mButtonCommands[1]);
        }
        if (this.mMapCKButtonId < 0) {
            int n = this.mMapCKButtonId = this.mButtonCommands[1] != null ? 1 : 0;
        }
        if ((oldCmd = this.mButtonCommands[this.mMapCKButtonId]) != null) {
            this.mButtonCommands[this.mMapCKButtonId] = new Command(oldCmd.getLabel(), oldCmd.getCommandType(), oldCmd.getPriority());
        }
        if (this.mButtonCommands[0] != null) {
            this.addCommand(this.mButtonCommands[0]);
        }
        if (this.mButtonCommands[1] != null) {
            this.addCommand(this.mButtonCommands[1]);
        }
        this.addCommand(Application.BACK_COMMAND);
        super.setTitle(this.mTitle);
        super.setString(this.mBodyText);
        this.setCommandListener(this);
        Application.sThis.setDisplayable((Displayable)this);
    }

    public final void setListener(CommandListener pListener) {
        this.mListener = pListener;
    }

    public final void setNextDisplayable(Displayable pNextDisplayable) {
        this.mNextDisplayable = pNextDisplayable;
    }

    public final void setBodyText(String pBodyText) {
        this.mBodyText = pBodyText;
    }

    public final void setBodyTextResId(int pBodyTextResId) {
        this.setBodyText(Application.getLocalizedText(pBodyTextResId));
    }

    public final void setTitle(String pTitle) {
        this.mTitle = pTitle;
    }

    public final void setTitleResId(int pTitleResId) {
        if (pTitleResId < 0) {
            this.setTitle(Application.sThis.getAppTitle());
        } else {
            this.setTitle(Application.getLocalizedText(pTitleResId));
        }
    }

    private void setButtonText(int pButtonId, String pText, char pSKChar) {
        if (pButtonId < 0 || pButtonId > 1) {
            throw new IndexOutOfBoundsException();
        }
        this.mButtonTexts[pButtonId] = pText;
        if (pText != null) {
            if (pSKChar != '\u0000') {
                this.mMapCKButtonId = pButtonId;
            }
            this.mButtonCommands[pButtonId] = pButtonId == 0 ? new Command(pText, 4, 2) : new Command(pText, 4, 1);
        } else {
            this.mButtonCommands[pButtonId] = null;
            if (pButtonId == this.mMapCKButtonId) {
                this.mMapCKButtonId = -1;
            }
        }
    }

    public final void setButtonText(int pButtonId, String pText) {
        this.setButtonText(pButtonId, pText, '\u0000');
    }

    public final void setButtonTextResId(int pButtonId, int pResId) {
        char skchar = '\u0000';
        if (pResId >= 0) {
            this.setButtonText(pButtonId, Application.getLocalizedText(pResId), skchar);
        } else {
            this.setButtonText(pButtonId, null, '\u0000');
        }
    }

    public final void setBoxId(int pBoxId) {
        this.mBoxId = pBoxId;
    }

    public final int getBoxId() {
        return this.mBoxId;
    }

    public final int getResult() {
        return this.mResult;
    }

    public final void commandAction(Command pCommand, Displayable pDisplayable) {
        this.mResult = -1;
        if (pCommand.getLabel().equals(this.mButtonTexts[0])) {
            this.mResult = 0;
        }
        if (pCommand.getLabel().equals(this.mButtonTexts[1])) {
            this.mResult = 1;
        }
        if (pCommand == Application.BACK_COMMAND) {
            this.mResult = 2;
        }
        if (this.mResult != -1) {
            if (this.mNextDisplayable != null && Application.sThis != null) {
                Application.sThis.setDisplayable(this.mNextDisplayable);
            }
            if (this.mListener != null) {
                this.mListener.commandAction(new Command("MSGBOX:" + this.mBoxId + ":" + this.mResult, 1, 0), (Displayable)this);
            }
        }
    }
}

