/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.framework;

import j2meunit.framework.AssertionFailedError;

public class Assert {
    public void assertEquals(long expected, long actual) {
        this.assertEquals((String)null, expected, actual);
    }

    public void assertEquals(Object expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, long expected, long actual) {
        this.assertEquals(message, new Long(expected), new Long(actual));
    }

    public void assertEquals(String message, Object expected, Object actual) {
        this.onAssertion();
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.failNotEquals(message, expected, actual);
    }

    public void assertNotNull(Object object) {
        this.assertNotNull(null, object);
    }

    public void assertNotNull(String message, Object object) {
        this.assertTrue(message, object != null);
    }

    public void assertNull(Object object) {
        this.assertNull(null, object);
    }

    public void assertNull(String message, Object object) {
        this.assertTrue(message, object == null);
    }

    public void assertSame(Object expected, Object actual) {
        this.assertSame(null, expected, actual);
    }

    public void assertSame(String message, Object expected, Object actual) {
        this.onAssertion();
        if (expected == actual) {
            return;
        }
        this.failNotSame(message, expected, actual);
    }

    public void assertTrue(String message, boolean condition) {
        this.onAssertion();
        if (!condition) {
            this.fail(message);
        }
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(null, condition);
    }

    public void fail() {
        this.fail(null);
    }

    public void fail(String message) {
        throw new AssertionFailedError(message);
    }

    protected void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        this.fail(String.valueOf(formatted) + "expected:<" + expected + "> but was:<" + actual + ">");
    }

    protected void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        this.fail(String.valueOf(formatted) + "expected same");
    }

    protected void onAssertion() {
    }
}

