/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.PersistenceManager;
import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.Unit;
import com.siemens.mp.app.calculatorconverter.UnitConverterData;
import com.siemens.mp.app.calculatorconverter.UnitConverterUI;
import com.siemens.mp.app.j2meunit.framework.TestCase;
import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

public class UnitConverterDataTest
extends TestCase {
    public UnitConverterDataTest(String testName, TestMethod testMethod) {
        super(testName, testMethod);
    }

    public UnitConverterDataTest() {
    }

    public Test suite() {
        TestSuite aSuite = new TestSuite();
        aSuite.addTest(new UnitConverterDataTest("getCategoriesTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitConverterDataTest)tc).getCategoriesTest();
            }
        }));
        aSuite.addTest(new UnitConverterDataTest("getUnitsByCategoryTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitConverterDataTest)tc).getUnitsByCategoryTest();
            }
        }));
        aSuite.addTest(new UnitConverterDataTest("currencyConversionTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitConverterDataTest)tc).currencyConversionTest();
            }
        }));
        aSuite.addTest(new UnitConverterDataTest("editCurrencyTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitConverterDataTest)tc).editCurrencyTest();
            }
        }));
        aSuite.addTest(new UnitConverterDataTest("saveValuesTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitConverterDataTest)tc).saveValuesTest();
            }
        }));
        return aSuite;
    }

    public final void getCategoriesTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.001]_001", "getCategoriesTest");
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_001_01");
        UnitConverterData data = new UnitConverterData();
        this.writeLogInput("0");
        this.writeLogExpected("Length");
        this.writeLogCurrent(data.getCategory(0).getName());
        this.assertEquals("Length", data.getCategory(0).getName());
        this.writeLogInput("1");
        this.writeLogExpected("Temperature");
        this.writeLogCurrent(data.getCategory(1).getName());
        this.assertEquals("Temperature", data.getCategory(1).getName());
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        this.writeLogCurrent(data.getCategory(2).getName());
        this.assertEquals("Currency", data.getCategory(2).getName());
        this.writeLogInput("3");
        this.writeLogExpected("Energy");
        this.writeLogCurrent(data.getCategory(3).getName());
        this.assertEquals("Energy", data.getCategory(3).getName());
        this.writeLogInput("4");
        this.writeLogExpected("Velocity");
        this.writeLogCurrent(data.getCategory(4).getName());
        this.assertEquals("Velocity", data.getCategory(4).getName());
        this.writeLogInput("5");
        this.writeLogExpected("Mass");
        this.writeLogCurrent(data.getCategory(5).getName());
        this.assertEquals("Mass", data.getCategory(5).getName());
        this.writeLogInput("6");
        this.writeLogExpected("Area");
        this.writeLogCurrent(data.getCategory(6).getName());
        this.assertEquals("Area", data.getCategory(6).getName());
        this.writeLogInput("7");
        this.writeLogExpected("Volume_MEASURE");
        this.writeLogCurrent(data.getCategory(7).getName());
        this.assertEquals("Volume_MEASURE", data.getCategory(7).getName());
        this.writeLogInput("8");
        this.writeLogExpected("Power");
        this.writeLogCurrent(data.getCategory(8).getName());
        this.assertEquals("Power", data.getCategory(8).getName());
        this.writeLogInput("9");
        this.writeLogExpected("Time");
        this.writeLogCurrent(data.getCategory(9).getName());
        this.assertEquals("Time", data.getCategory(9).getName());
        this.writeLogInput("10");
        this.writeLogExpected("Pressure");
        this.writeLogCurrent(data.getCategory(10).getName());
        this.assertEquals("Pressure", data.getCategory(10).getName());
        this.writeLogResultPass();
    }

    public final void getUnitsByCategoryTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.001]_002", "getUnitsByCategoryTest");
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_01");
        UnitConverterData data = new UnitConverterData();
        this.writeLogInput("0");
        this.writeLogExpected("Length");
        data.setSelectedCategoryIndex(0);
        Category category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Length", category.getName());
        this.writeLogExpected("10");
        this.writeLogCurrent(category.size());
        this.assertEquals(10L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Millimetres");
        Unit unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Millimetres", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Centimetres");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Centimetres", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Inches");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Inches", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Feet");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Feet", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("Yards");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Yards", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("Metres");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Metres", unit.getName());
        this.writeLogInput("6");
        this.writeLogExpected("Kilometres");
        unit = category.getUnit(6);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilometres", unit.getName());
        this.writeLogInput("7");
        this.writeLogExpected("Miles");
        unit = category.getUnit(7);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Miles", unit.getName());
        this.writeLogInput("8");
        this.writeLogExpected("NauticalMiles");
        unit = category.getUnit(8);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("NauticalMiles", unit.getName());
        this.writeLogInput("9");
        this.writeLogExpected("LightYear");
        unit = category.getUnit(9);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("LightYear", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_02");
        this.writeLogInput("1");
        this.writeLogExpected("Temperature");
        data.setSelectedCategoryIndex(1);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Temperature", category.getName());
        this.writeLogExpected("3");
        this.writeLogCurrent(category.size());
        this.assertEquals(3L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Celsius");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Celsius", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Fahrenheit");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Fahrenheit", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Kelvin");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kelvin", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_03");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        data.setSelectedCategoryIndex(2);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogExpected("0");
        this.writeLogCurrent(category.size());
        this.assertEquals(0L, category.size());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_04");
        this.writeLogInput("3");
        this.writeLogExpected("Energy");
        data.setSelectedCategoryIndex(3);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Energy", category.getName());
        this.writeLogExpected("8");
        this.writeLogCurrent(category.size());
        this.assertEquals(8L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Calories");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Calories", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Kilocalories");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilocalories", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Joules");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Joules", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Kilojoules");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilojoules", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("Wattsecond");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Wattsecond", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("Watthour");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Watthour", unit.getName());
        this.writeLogInput("6");
        this.writeLogExpected("Kilowatthour");
        unit = category.getUnit(6);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilowatthour", unit.getName());
        this.writeLogInput("7");
        this.writeLogExpected("Electronvolts");
        unit = category.getUnit(7);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Electronvolts", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_05");
        this.writeLogInput("4");
        this.writeLogExpected("Velocity");
        data.setSelectedCategoryIndex(4);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Velocity", category.getName());
        this.writeLogExpected("6");
        this.writeLogCurrent(category.size());
        this.assertEquals(6L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("KilometresPerH");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("KilometresPerH", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("MilesPerH");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("MilesPerH", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("MetresPerSec");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("MetresPerSec", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("MilesPerSec");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("MilesPerSec", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("Knots");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Knots", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("Mach");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Mach", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_06");
        this.writeLogInput("5");
        this.writeLogExpected("Mass");
        data.setSelectedCategoryIndex(5);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Mass", category.getName());
        this.writeLogExpected("7");
        this.writeLogCurrent(category.size());
        this.assertEquals(7L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Milligrams");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Milligrams", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Grains");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Grains", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Grams");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Grams", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Ounces");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Ounces", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("Pounds");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Pounds", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("Kilograms");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilograms", unit.getName());
        this.writeLogInput("6");
        this.writeLogExpected("MetricTons");
        unit = category.getUnit(6);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("MetricTons", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_07");
        this.writeLogInput("6");
        this.writeLogExpected("Area");
        data.setSelectedCategoryIndex(6);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Area", category.getName());
        this.writeLogExpected("11");
        this.writeLogCurrent(category.size());
        this.assertEquals(11L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("SquareMm");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareMm", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("SquareCm");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareCm", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("SquareInches");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareInches", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("SquareFeet");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareFeet", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("SquareYards");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareYards", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("SquareMetres");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareMetres", unit.getName());
        this.writeLogInput("6");
        this.writeLogExpected("SquareKm");
        unit = category.getUnit(6);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareKm", unit.getName());
        this.writeLogInput("7");
        this.writeLogExpected("SquareMiles");
        unit = category.getUnit(7);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("SquareMiles", unit.getName());
        this.writeLogInput("8");
        this.writeLogExpected("Acres");
        unit = category.getUnit(8);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Acres", unit.getName());
        this.writeLogInput("9");
        this.writeLogExpected("Ares");
        unit = category.getUnit(9);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Ares", unit.getName());
        this.writeLogInput("10");
        this.writeLogExpected("Hectares");
        unit = category.getUnit(10);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Hectares", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_08");
        this.writeLogInput("7");
        this.writeLogExpected("Volume_MEASURE");
        data.setSelectedCategoryIndex(7);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Volume_MEASURE", category.getName());
        this.writeLogExpected("16");
        this.writeLogCurrent(category.size());
        this.assertEquals(16L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Millilitres");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Millilitres", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Centilitres");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Centilitres", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Litres");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Litres", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("CubicMm");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("CubicMm", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("CubicCm");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("CubicCm", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("CubicInches");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("CubicInches", unit.getName());
        this.writeLogInput("6");
        this.writeLogExpected("CubicFeet");
        unit = category.getUnit(6);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("CubicFeet", unit.getName());
        this.writeLogInput("7");
        this.writeLogExpected("CubicMetres");
        unit = category.getUnit(7);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("CubicMetres", unit.getName());
        this.writeLogInput("8");
        this.writeLogExpected("GallonsUS");
        unit = category.getUnit(8);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("GallonsUS", unit.getName());
        this.writeLogInput("9");
        this.writeLogExpected("GallonsUK");
        unit = category.getUnit(9);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("GallonsUK", unit.getName());
        this.writeLogInput("10");
        this.writeLogExpected("PintsUK");
        unit = category.getUnit(10);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("PintsUK", unit.getName());
        this.writeLogInput("11");
        this.writeLogExpected("LiquidOzUS");
        unit = category.getUnit(11);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("LiquidOzUS", unit.getName());
        this.writeLogInput("12");
        this.writeLogExpected("LiquidOzUK");
        unit = category.getUnit(12);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("LiquidOzUK", unit.getName());
        this.writeLogInput("13");
        this.writeLogExpected("DryPints");
        unit = category.getUnit(13);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("DryPints", unit.getName());
        this.writeLogInput("14");
        this.writeLogExpected("LiquidPintsUS");
        unit = category.getUnit(14);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("LiquidPintsUS", unit.getName());
        this.writeLogInput("15");
        this.writeLogExpected("Barrels");
        unit = category.getUnit(15);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Barrels", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_09");
        this.writeLogInput("8");
        this.writeLogExpected("Power");
        data.setSelectedCategoryIndex(8);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Power", category.getName());
        this.writeLogExpected("4");
        this.writeLogCurrent(category.size());
        this.assertEquals(4L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Horsepower");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Horsepower", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Kilowatts");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Kilowatts", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Watts");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Watts", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Milliwatts");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Milliwatts", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_10");
        this.writeLogInput("9");
        this.writeLogExpected("Time");
        data.setSelectedCategoryIndex(9);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Time", category.getName());
        this.writeLogExpected("6");
        this.writeLogCurrent(category.size());
        this.assertEquals(6L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Seconds");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Seconds", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Minutes");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Minutes", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Hours");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Hours", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Days");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Days", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("Weeks");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Weeks", unit.getName());
        this.writeLogInput("5");
        this.writeLogExpected("Years");
        unit = category.getUnit(5);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Years", unit.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_002_11");
        this.writeLogInput("10");
        this.writeLogExpected("Pressure");
        data.setSelectedCategoryIndex(10);
        category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Pressure", category.getName());
        this.writeLogExpected("5");
        this.writeLogCurrent(category.size());
        this.assertEquals(5L, category.size());
        this.writeLogInput("0");
        this.writeLogExpected("Bars");
        unit = category.getUnit(0);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Bars", unit.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Atmospheres");
        unit = category.getUnit(1);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Atmospheres", unit.getName());
        this.writeLogInput("2");
        this.writeLogExpected("Pascals");
        unit = category.getUnit(2);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Pascals", unit.getName());
        this.writeLogInput("3");
        this.writeLogExpected("Torr");
        unit = category.getUnit(3);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("Torr", unit.getName());
        this.writeLogInput("4");
        this.writeLogExpected("PoundsPerSqInch");
        unit = category.getUnit(4);
        this.writeLogCurrent(unit.getName());
        this.assertEquals("PoundsPerSqInch", unit.getName());
        this.writeLogResultPass();
    }

    public final void currencyConversionTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.002]_001", "currencyConversionTest");
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.002]_002", "currencyConversionTest");
        UnitConverterData data = new UnitConverterData();
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.002]_001_01");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        data.setSelectedCategoryIndex(2);
        Category category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogInput("Euro");
        this.writeLogInput("1");
        this.writeLogInput("0");
        this.writeLogInput("true");
        category.addUnit("Euro", 1.0, 0.0, true, 0);
        this.writeLogInput("0");
        Unit unit1 = category.getUnit(0);
        this.writeLogExpected("Euro");
        this.writeLogCurrent(unit1.getName());
        this.assertEquals("Euro", unit1.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.002]_001_02");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogInput("Real");
        this.writeLogInput("3.5");
        this.writeLogInput("0");
        this.writeLogInput("false");
        category.addUnit("Real", 3.5, 0.0, false, 0);
        this.writeLogInput("1");
        Unit unit2 = category.getUnit(1);
        this.writeLogExpected("Real");
        this.writeLogCurrent(unit2.getName());
        this.assertEquals("Real", unit2.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.002]_002_01");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        try {
            this.writeLogInput("2");
            this.writeLogInput("Euro");
            this.writeLogInput("Real");
            this.writeLogExpected("7");
            double operand = 2.0;
            double result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(7L, (long)result);
            this.writeLogResultPass();
        }
        catch (UIException uie) {
            this.fail(uie.getMessage());
        }
    }

    public final void editCurrencyTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.003]_001", "editCurrencyTest");
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.003]_002", "editCurrencyTest");
        UnitConverterData data = new UnitConverterData();
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.003]_001_01");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        data.setSelectedCategoryIndex(2);
        Category category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogInput("Euro");
        this.writeLogInput("1");
        this.writeLogInput("0");
        this.writeLogInput("true");
        category.addUnit("Euro", 1.0, 0.0, true, 0);
        this.writeLogInput("0");
        Unit unit1 = category.getUnit(0);
        this.writeLogExpected("Euro");
        this.writeLogCurrent(unit1.getName());
        this.assertEquals("Euro", unit1.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.003]_001_02");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogInput("Real");
        this.writeLogInput("3.5");
        this.writeLogInput("0");
        this.writeLogInput("false");
        category.addUnit("Real", 3.5, 0.0, false, 0);
        this.writeLogInput("1");
        Unit unit2 = category.getUnit(1);
        this.writeLogExpected("Real");
        this.writeLogCurrent(unit2.getName());
        this.assertEquals("Real", unit2.getName());
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.003]_002_01");
        this.writeLogInput("2");
        this.writeLogExpected("Currency");
        this.writeLogCurrent(category.getName());
        this.assertEquals("Currency", category.getName());
        this.writeLogInput("1");
        this.writeLogExpected("Real");
        unit2 = category.getUnit(1);
        this.writeLogCurrent(unit2.getName());
        this.assertEquals("Real", unit2.getName());
        this.writeLogInput("RealVenda");
        this.writeLogInput("3");
        unit2.setName("RealVenda");
        unit2.setFactor(3.0);
        this.writeLogExpected("RealVenda");
        this.writeLogCurrent(unit2.getName());
        this.assertEquals("RealVenda", unit2.getName());
        this.writeLogExpected("3");
        this.writeLogCurrent((long)unit2.getFactor());
        this.assertEquals(3L, (long)unit2.getFactor());
        this.writeLogResultPass();
    }

    public final void saveValuesTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.008]_001", "saveValuesTest");
        PersistenceManager persistence = new PersistenceManager();
        UnitConverterData data = new UnitConverterData();
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.008]_001_01");
        this.writeLogInput("1");
        this.writeLogExpected("Temperature");
        data.setSelectedCategoryIndex(1);
        Category category = data.getSelectedCategory();
        this.writeLogCurrent(category.getName());
        this.assertEquals("Temperature", category.getName());
        this.writeLogInput("Celsius");
        this.writeLogInput("Fahrenheit");
        category.setFirstUnit(0);
        category.setSecondUnit(1);
        this.writeLogInput("20");
        double numToBeConverted = 20.0;
        try {
            double result = UnitConverterUI.convert(numToBeConverted, category.getFirstUnit(), category.getSecondUnit());
            this.assertEquals(68L, (long)result);
        }
        catch (UIException uie) {
            this.fail(uie.getMessage());
        }
        persistence.addToWriteQueue(data);
        persistence.shutdown();
        try {
            persistence.waitForWriteComplete(5000);
        }
        catch (InterruptedException uie) {
            this.fail(uie.getMessage());
        }
        UnitConverterData data2 = new UnitConverterData();
        persistence = new PersistenceManager();
        persistence.addToReadQueue(data2);
        try {
            persistence.waitForReadComplete(data2, -1);
        }
        catch (InterruptedException uie) {
            this.fail(uie.getMessage());
        }
        category = data2.getSelectedCategory();
        this.writeLogExpected("Temperature");
        this.writeLogCurrent(category.getName());
        this.assertEquals("Temperature", category.getName());
        this.writeLogExpected("Celsius");
        this.writeLogCurrent(category.getFirstUnit().getName());
        this.assertEquals("Celsius", category.getFirstUnit().getName());
        this.writeLogExpected("Fahrenheit");
        this.writeLogCurrent(category.getSecondUnit().getName());
        this.assertEquals("Fahrenheit", category.getSecondUnit().getName());
        this.writeLogExpected("20");
        this.writeLogCurrent((long)category.getLastValue());
        this.assertEquals(20L, (long)category.getLastValue());
        this.writeLogResultPass();
    }
}

