/*
 * Decompiled with CFR 0.152.
 */
package com.benq.mobile.digitalmanual.reference;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Strings {
    private static final String LOCALE_PROPERTY = "microedition.locale";
    private static final String PATH_SEPARATOR = "/";
    private static final String STRINGS_DIR = "/strings";
    private static final String STRING_FILE = "Reference.txt";
    private static final Strings _instance = new Strings();
    private String[] _strings = this.readStrings(System.getProperty("microedition.locale"));

    private Strings() {
    }

    private String getFilename(String locale) {
        return "/strings/" + locale + PATH_SEPARATOR + STRING_FILE;
    }

    private static Strings getInstance() {
        return _instance;
    }

    public static String getString(int id) {
        return Strings.getInstance()._strings[id];
    }

    private String[] readStrings(String locale) {
        InputStream in = this.getClass().getResourceAsStream(this.getFilename(locale.toLowerCase()));
        if (in == null && (in = this.getClass().getResourceAsStream(this.getFilename(""))) == null) {
            throw new RuntimeException("failed to load strings");
        }
        return new UnicodeStringReader(in).readLines();
    }

    private class UnicodeStringReader
    extends DataInputStream {
        private static final int FINISHED = -1;
        private static final int READ_CHARACTERS = 2;
        private static final int READ_NEWLINE = 3;
        private int _state = 2;

        private UnicodeStringReader(InputStream in) {
            super(in);
            try {
                if (this.readChar() != '\ufeff') {
                    throw new RuntimeException("Not a valid Unicode-16 file.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this._state = -1;
            }
        }

        private int handleReadCharacters(Vector lines, StringBuffer buf) {
            try {
                char ch = this.readChar();
                if (!this.isNewline(ch)) {
                    buf.append(ch);
                    return 2;
                }
                lines.addElement(buf.toString());
                buf.setLength(0);
                return 3;
            }
            catch (EOFException e) {
                return -1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }

        private int handleReadNewlines(Vector lines, StringBuffer buf) {
            try {
                char ch = this.readChar();
                if (!this.isNewline(ch)) {
                    buf.append(ch);
                    return 2;
                }
                return 3;
            }
            catch (EOFException e) {
                return -1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }

        private boolean isNewline(char ch) {
            return ch == '\r' || ch == '\n';
        }

        public String[] readLines() {
            Vector lines = new Vector();
            StringBuffer buf = new StringBuffer();
            while (this._state != -1) {
                switch (this._state) {
                    case 2: {
                        this._state = this.handleReadCharacters(lines, buf);
                        break;
                    }
                    case 3: {
                        this._state = this.handleReadNewlines(lines, buf);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown state while reading strings: " + this._state);
                    }
                }
            }
            return this.toArray(lines);
        }

        private String[] toArray(Vector v) {
            String[] strings = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                strings[i] = (String)v.elementAt(i);
                ++i;
            }
            return strings;
        }
    }
}

