/*
 * Decompiled with CFR 0.152.
 */
package com.benq.mobile.digitalmanual.layout;

import java.util.Vector;
import javax.microedition.lcdui.Font;

public class TextSplitter {
    private StringBuffer _currentLine;
    private String _currentWord;
    private final Font _font;
    private int _index;
    private Vector _lines;
    private final int _width;
    private String[] _words;

    public TextSplitter(Font font, int width) {
        this._font = font;
        this._width = width;
    }

    private boolean currentWordFits() {
        if (this._currentLine.length() > 0) {
            return this.fits(this._currentLine.toString() + " " + this._currentWord);
        }
        return this.fits(this._currentWord);
    }

    private boolean fits(String str) {
        return this._font.stringWidth(str) < this._width;
    }

    private void handleDoesFit() {
        if (this._currentLine.length() > 0) {
            this._currentLine.append(" ");
        }
        this._currentLine.append(this._currentWord);
        ++this._index;
        this.nextWord();
    }

    private void handleDoesNotFit() {
        if (this._currentLine.length() == 0) {
            String[] split = this.splitWord(this._currentWord);
            this._currentLine.append(split[0]);
            this._lines.addElement(this._currentLine.toString());
            this._currentLine.setLength(0);
            this._currentWord = split[1];
        } else {
            this._lines.addElement(this._currentLine.toString());
            this._currentLine.setLength(0);
        }
    }

    private void initialize(String text) {
        this._words = TextSplitter.toWords(text);
        this._lines = new Vector();
        this._currentLine = new StringBuffer();
        this._index = 0;
        this.nextWord();
    }

    private void nextWord() {
        this._currentWord = this._index < this._words.length ? this._words[this._index] : null;
    }

    public String[] split(String text) {
        if (text == null) {
            return new String[0];
        }
        if (text.length() == 0) {
            return new String[]{""};
        }
        this.initialize(text);
        while (this._currentWord != null) {
            if (this.currentWordFits()) {
                this.handleDoesFit();
                continue;
            }
            this.handleDoesNotFit();
        }
        if (this._currentLine.length() > 0) {
            this._lines.addElement(this._currentLine.toString());
        }
        this._lines.addElement("");
        return TextSplitter.toStringArray(this._lines);
    }

    private String[] splitWord(String string) {
        StringBuffer word = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (!this.fits(word.toString() + ch)) {
                return new String[]{word.toString(), string.substring(i)};
            }
            word.append(ch);
            ++i;
        }
        return new String[]{word.toString(), ""};
    }

    private static String[] toStringArray(Vector words) {
        String[] strings = new String[words.size()];
        int i = 0;
        while (i < words.size()) {
            strings[i] = (String)words.elementAt(i);
            ++i;
        }
        return strings;
    }

    private static String[] toWords(String text) {
        String word;
        int SPACE = 32;
        Vector<String> words = new Vector<String>();
        int start = 0;
        int index = text.indexOf(32);
        while (index != -1) {
            if (index > start) {
                word = text.substring(start, index);
                words.addElement(word);
            }
            start = index + 1;
            index = text.indexOf(32, start);
        }
        if (start < text.length()) {
            word = text.substring(start);
            words.addElement(word);
        }
        return TextSplitter.toStringArray(words);
    }
}

