/*
 * Decompiled with CFR 0.152.
 */
package com.benq.mobile.digitalmanual.layout;

import com.benq.mobile.digitalmanual.layout.TextSplitter;
import javax.microedition.lcdui.StringItem;

public class AutoScrollingStringItem
extends StringItem {
    private int _height = 40;
    private String[] _lines = null;
    private final int _linesToDisplay;
    private String _text = null;
    private int _width = 132;
    private int counter = 0;

    public AutoScrollingStringItem(int linesToDisplay) {
        super("", "");
        this._linesToDisplay = linesToDisplay;
    }

    public boolean fitsWithoutScrolling() {
        int requiredHeight = this.getFont().getHeight() * (this.getLines().length - 1);
        return requiredHeight <= this._height;
    }

    private String getCurrentText() {
        int n;
        int index;
        StringBuffer buf = new StringBuffer();
        if (this.fitsWithoutScrolling()) {
            index = 0;
            n = this.getLines().length - 1;
        } else {
            index = this.counter;
            n = this._linesToDisplay;
        }
        int i = 0;
        while (i < n) {
            if (index >= this.getLines().length) {
                index = 0;
            }
            buf.append(this.getLines()[index]);
            if (i < n - 1) {
                buf.append("\n");
            }
            ++index;
            ++i;
        }
        return buf.toString();
    }

    private String[] getLines() {
        if (this._lines == null) {
            if (this._text == null) {
                this._lines = new String[0];
                return this._lines;
            }
            try {
                int rightMargin = 10;
                this._lines = new TextSplitter(this.getFont(), this._width - 10).split(this._text);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this._lines;
    }

    public void scrollBackward() {
        if (this.fitsWithoutScrolling()) {
            return;
        }
        if (this.counter == 0) {
            return;
        }
        --this.counter;
        if (this.counter < 0) {
            this.counter = this.getLines().length - 1;
        }
        this.setText(this.getCurrentText());
    }

    public void scrollForward() {
        if (this.fitsWithoutScrolling()) {
            return;
        }
        if (this.counter + this._linesToDisplay + 1 >= this.getLines().length) {
            return;
        }
        ++this.counter;
        if (this.counter >= this.getLines().length) {
            this.counter = 0;
        }
        this.setText(this.getCurrentText());
    }

    public void setFullText(String text) {
        this._text = text;
        this.counter = 0;
        this.setText(this.getCurrentText());
    }

    public void setPreferredSize(int width, int height) {
        this._width = width;
        this._height = height;
        super.setPreferredSize(width, height);
    }
}

