/*
 * Decompiled with CFR 0.152.
 */
package com.benq.mobile.digitalmanual.layout;

import com.benq.mobile.digitalmanual.layout.AnimationTextLayout;
import com.benq.mobile.digitalmanual.layout.ImageTextLayout;
import com.benq.mobile.digitalmanual.layout.TextOnlyLayout;
import com.benq.mobile.digitalmanual.reference.SplashScreen;
import com.benq.mobile.digitalmanual.reference.Strings;
import com.siemens.mp.lcdui.XList;
import com.siemens.mp.lcdui.XListConfig;
import com.siemens.mp.lcdui.XListStateListener;
import com.siemens.mp.lcduiextension.ICloseable;
import com.siemens.mp.lcduiextension.ListItem;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public abstract class ListLayout
extends XList
implements ICloseable,
CommandListener,
XListStateListener {
    protected MIDlet _midlet = null;
    private ListItem[] mListItems = null;
    private Displayable mParent = null;

    public ListLayout(MIDlet midlet, Displayable parent) {
        super(null, 3, new XListConfig());
        try {
            this._midlet = midlet;
            this.mParent = parent;
            this.initDisplayable();
            this.configureDisplayable();
            this.configureCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void append(ListItem listitem) {
        if (!listitem.isHidden()) {
            int lIndex = this.append(listitem.getCaption(), listitem.getIcon());
            Font lFont = listitem.getFont();
            if (lFont != null) {
                this.setFont(lIndex, lFont);
            }
        }
    }

    public void close() {
        if (this.mParent != null && this.mParent instanceof ICloseable) {
            ICloseable closeableParent = (ICloseable)this.mParent;
            closeableParent.close((Displayable)this);
        } else if (this.mParent == null && this._midlet instanceof ICloseable) {
            ((ICloseable)this._midlet).close();
        }
    }

    public void close(Displayable child) {
        Display.getDisplay((MIDlet)this._midlet).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.equals(List.SELECT_COMMAND)) {
            int index = this.getSelectedIndex();
            this.onItemSelected(index);
        } else {
            this.commandExecuted(command, displayable);
        }
    }

    protected void commandExecuted(Command command, Displayable displayable) {
        switch (command.getCommandType()) {
            case 5: {
                Display.getDisplay((MIDlet)this._midlet).setCurrent((Displayable)new SplashScreen(this._midlet, (Displayable)this));
                break;
            }
            case 2: {
                this.close();
                break;
            }
            case 7: {
                if (!(this._midlet instanceof ICloseable)) break;
                ((ICloseable)this._midlet).close();
                break;
            }
        }
    }

    protected void configureCommands() {
        this.addCommand(new Command(Strings.getString(110), 2, 0));
        this.addCommand(new Command(Strings.getString(111), 7, 6));
        this.addCommand(new Command(Strings.getString(112), 5, 5));
    }

    protected abstract void configureDisplayable();

    protected ListItem createListItem(int textId) {
        return new ListItem(Strings.getString(textId), null, false);
    }

    protected MIDlet getMidlet() {
        return this._midlet;
    }

    public void highlightStateChanged(XList xlist, int selectedIndex) {
    }

    private void initDisplayable() {
        this.setXListStateListener(this);
        this.setCommandListener(this);
    }

    protected abstract void onItemSelected(int var1);

    protected void setListItems(ListItem[] items) {
        this.mListItems = items;
        int i = 0;
        while (i < this.mListItems.length) {
            this.append(this.mListItems[i]);
            ++i;
        }
    }

    protected void setTitle(int titleId) {
        this.setTitle(Strings.getString(titleId));
    }

    protected void showAnimTextScreen(int titleId, int textId, String[] frames) {
        Display.getDisplay((MIDlet)this.getMidlet()).setCurrent((Displayable)new AnimationTextLayout(this.getMidlet(), (Displayable)this, titleId, textId, frames));
    }

    protected void showImageTextScreen(int titleId, int textId, int imageId) {
        Display.getDisplay((MIDlet)this.getMidlet()).setCurrent((Displayable)new ImageTextLayout(this.getMidlet(), (Displayable)this, titleId, textId, imageId));
    }

    protected void showTextOnlyScreen(int titleId, int textId) {
        Display.getDisplay((MIDlet)this.getMidlet()).setCurrent((Displayable)new TextOnlyLayout(this.getMidlet(), (Displayable)this, titleId, textId));
    }
}

