/*
 * Decompiled with CFR 0.152.
 */
package com.benq.mobile.digitalmanual.layout;

import com.benq.mobile.digitalmanual.reference.ReferenceMidlet;
import com.benq.mobile.digitalmanual.reference.SplashScreen;
import com.benq.mobile.digitalmanual.reference.Strings;
import com.siemens.mp.internationalisation.LiteralResources;
import com.siemens.mp.lcdui.Form;
import com.siemens.mp.lcduiextension.ICloseable;
import com.siemens.mp.lcduiextension.XCommand;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public abstract class BaseLayout
extends Form
implements ICloseable,
CommandListener,
ItemCommandListener {
    private static final LiteralResources IMAGE_NAMES = LiteralResources.getInstance();
    private final int _linesToDisplay;
    private ReferenceMidlet _midlet = null;
    private Displayable _parent = null;
    protected StringItem _stringItem = null;
    private int _textId;
    private int _titleId;

    public BaseLayout(MIDlet midlet, Displayable parent, int titleId, int textId, int linesToDisplay) {
        super(null);
        this._midlet = (ReferenceMidlet)midlet;
        this._parent = parent;
        this._titleId = titleId;
        this._textId = textId;
        this._linesToDisplay = linesToDisplay;
        this.setTitle("");
        this.setCommandListener(this);
    }

    public void addCommand(int resource, int commandType, int priority) {
        this.addCommand((Command)new XCommand(Strings.getString(resource), null, commandType, priority));
    }

    public void addCommand(int resource, int commandType) {
        int priority = 1;
        if (commandType == 7) {
            priority = 0;
        }
        this.addCommand(resource, commandType, priority);
    }

    public void close(Displayable child) {
        Display.getDisplay((MIDlet)this._midlet).setCurrent((Displayable)this);
    }

    public void close() {
        if (this._parent != null && this._parent instanceof ICloseable) {
            ICloseable closeableParent = (ICloseable)this._parent;
            closeableParent.close((Displayable)this);
        } else if (this._parent == null && this._midlet instanceof ICloseable) {
            this._midlet.close();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        switch (command.getCommandType()) {
            case 5: {
                Display.getDisplay((MIDlet)this.getMidlet()).setCurrent((Displayable)new SplashScreen(this.getMidlet(), (Displayable)this));
                break;
            }
            case 7: {
                this.close();
                break;
            }
            case 4: {
                this.quitMidlet();
                break;
            }
        }
    }

    public void commandAction(Command command, Item item) {
    }

    protected void configureCommands() {
        this.addCommand(new Command(Strings.getString(110), 7, 7));
        this.addCommand(new Command(Strings.getString(111), 4, 6));
        this.addCommand(new Command(Strings.getString(112), 5, 5));
    }

    protected void configureDisplayable() {
        this.setTitle(Strings.getString(this.getTitleId()));
        this.setText(Strings.getString(this.getTextId()));
    }

    protected StringItem createStringItem(int linesToDisplay) {
        return new StringItem("", "");
    }

    protected String getImageString(int intID) {
        return IMAGE_NAMES.getString(intID);
    }

    protected MIDlet getMidlet() {
        return this._midlet;
    }

    protected int getTextId() {
        return this._textId;
    }

    protected int getTitleId() {
        return this._titleId;
    }

    protected void initText() {
        this._stringItem = this.createStringItem(this._linesToDisplay);
        Font font = Font.getFont((int)32, (int)0, (int)0);
        this._stringItem.setFont(font);
        this._stringItem.setLayout(17);
        this._stringItem.setPreferredSize(132, font.getHeight() * this._linesToDisplay);
        this.append((Item)this._stringItem);
    }

    protected void quitMidlet() {
        this._midlet.close();
    }

    protected void setText(String text) {
        this._stringItem.setText(text);
    }
}

