// BrowseCHMDialog.cpp : implementation file
//

#include "stdafx.h"
#include "BrowseCHMFiles.h"
#include "BrowseCHMDialog.h"
#include "defines.h"
#include "Shlwapi.h"//For PathFileExists()

// CBrowseCHMDialog dialog

IMPLEMENT_DYNAMIC(CBrowseCHMDialog, CDialog)
CBrowseCHMDialog::CBrowseCHMDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CBrowseCHMDialog::IDD, pParent)
{
}

CBrowseCHMDialog::~CBrowseCHMDialog()
{
}

CString CBrowseCHMDialog::PatternsToFind [eTotalTypes] = {"*.chm", "*.doc"};

/*
For files which come with Microsoft windows, just give their application exetuble
(.exe) name. For those which are separately installed, give the location from where
their command names can be found in the registry.
*/
CString CBrowseCHMDialog::ApplicationsForHelpDocuments [eTotalTypes] = {"hh.exe ", "SOFTWARE\\Classes\\Applications\\WINWORD.EXE\\Shell\\open\\command"};

void CBrowseCHMDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_LISTBOX_CHM_FILES_LIST, m_objCHMListBox);
    DDX_Control(pDX, IDC_BUTTON_CHM_OPEN, m_objButtonOpen);
}


BEGIN_MESSAGE_MAP(CBrowseCHMDialog, CDialog)
    ON_BN_CLICKED(IDC_BUTTON_BROWSE_CHM_FILES, OnBnClickedButtonBrowseChmFiles)
    ON_BN_CLICKED(IDC_BUTTON_CHM_OPEN, OnBnClickedButtonChmOpen)
    ON_LBN_DBLCLK(IDC_LISTBOX_CHM_FILES_LIST, OnLbnDblclkListboxChmFilesList)
    ON_LBN_SELCHANGE(IDC_LISTBOX_CHM_FILES_LIST, OnLbnSelchangeListboxChmFilesList)
    ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
END_MESSAGE_MAP()


// CBrowseCHMDialog message handlers

BOOL CBrowseCHMDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
    
    //set controls
    SetWindowText(FRESH_DIALOG_TITLE);
    m_objButtonOpen.EnableWindow(FALSE);
    m_objCHMListBox.ShowScrollBar(SB_HORZ, FALSE);

    m_nOriginalHorizontalExtentOfListBox = 0;
    m_nNewHorizontalExtentOfListBox = 0;
    CalculateOriginalHozizontalExtentOfListBox();
    m_strTmpFolder = "";

    CreateTmpDirectory();//create the temp folder when the work is about to start
 
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBrowseCHMDialog::OnBnClickedButtonBrowseChmFiles()
{
    DWORD dResult = 0L;
    int nCount = 0;

    m_objCHMListBox.ResetContent();
    m_nNewHorizontalExtentOfListBox = 0;
    m_strProjectPath = "";

    //set controls
    SetWindowText(WINDOW_TEXT_SEARCHING);
    ((CButton*)GetDlgItem (IDC_BUTTON_BROWSE_CHM_FILES))->EnableWindow(FALSE);
    ((CButton*)GetDlgItem (IDCANCEL))->EnableWindow(FALSE);
    ((CStatic*)GetDlgItem(IDC_STATIC_SEARCH_PATH))->SetWindowText("");
    m_objCHMListBox.ShowScrollBar(SB_HORZ, FALSE);

    dResult = ::GetModuleFileName(CURRENT_MODULE_HANDLE, m_strProjectPath.GetBuffer(_MAX_PATH), _MAX_PATH); //Read_PCSIMU_InstallPathFromRegistry ( m_strProjectPath );
  	m_strProjectPath.ReleaseBuffer();

    if ( dResult == 0 ) // function fails
    {
        DisplayErrorMessage ( "Registry Error: " );
        return;
    }// else, Executable Path gotten, continue...

    int nPos = m_strProjectPath.ReverseFind('\\');

    m_strProjectPath = m_strProjectPath.Left(nPos);//trailing backslash removed
    
    CString strPathString(STR_SEARCH_PATH);
    strPathString += m_strProjectPath;

    ((CStatic*)GetDlgItem(IDC_STATIC_SEARCH_PATH))->SetWindowText(strPathString);

    SearchAllFoldersForHelpFiles ( m_strProjectPath );

    nCount = m_objCHMListBox.GetCount();

    CString strTitleString(WINDOW_TEXT_LISTING_FILES);
    strTitleString += " - ";
    strTitleString += STR_TOTAL_FILES_FOUND;

    if (nCount != LB_ERR)
    {
        strTitleString.Format("%s%d",strTitleString, nCount);
    }
    else
    {
        strTitleString += "Error counting number of files !";
    }
        
    SetWindowText(strTitleString);
    ((CButton*)GetDlgItem (IDC_BUTTON_BROWSE_CHM_FILES))->EnableWindow(TRUE);
    ((CButton*)GetDlgItem (IDCANCEL))->EnableWindow(TRUE);
    m_objButtonOpen.EnableWindow(FALSE);//Disable again since may have been enabled previously

    if ( m_nNewHorizontalExtentOfListBox <= m_nOriginalHorizontalExtentOfListBox )
        m_objCHMListBox.ShowScrollBar(SB_HORZ, FALSE);
    else
    {
        m_objCHMListBox.ShowScrollBar(SB_HORZ, TRUE);
        m_objCHMListBox.SetHorizontalExtent(m_nNewHorizontalExtentOfListBox);
    }
}

void CBrowseCHMDialog::OnBnClickedButtonChmOpen()
{
    CString strFileSelected("");
    int nItemSelected = m_objCHMListBox.GetCurSel();

    m_objCHMListBox.GetText(nItemSelected, strFileSelected);
    
    STARTUPINFO si;
	::ZeroMemory(&si, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_SHOW;

	PROCESS_INFORMATION pi;
	
    char chCommandLine[255];
    memset (chCommandLine,0,255);

    if( 0 == strFileSelected.Right(LENGTH_OF_EXTENSION).CompareNoCase(PatternsToFind[eTypeCHM].Right(LENGTH_OF_EXTENSION)))
    {
        strcpy (chCommandLine, ApplicationsForHelpDocuments[eTypeCHM]);
    }//add cases with "else if" for files types which come with Microsoft Windows
    else        
    {
        CString strApplicationPath(""), strApplicationName("");
        LONG lResult = 0L;
        char chShortenedApplicationName[MAX_PATH];
        memset(chShortenedApplicationName, 0, MAX_PATH);
        
        /*
            Extendibility provided to add as many types of Help docs as required.
        */

        if( 0 == strFileSelected.Right(LENGTH_OF_EXTENSION).CompareNoCase(PatternsToFind[eTypeDOC].Right(LENGTH_OF_EXTENSION)))
        {
            strApplicationName = ApplicationsForHelpDocuments[eTypeDOC];
        }
        //keep adding cases here with "else if" with types from "enum TypesOfHelpDocuments"
            
        lResult = Read_ApplicationPathFromRegistry(strApplicationName, strApplicationPath);
        if ( lResult != ERROR_SUCCESS )
        {
            DisplayErrorMessage ( "Required application not found: " );
            return;
        }// else, Application Path read from registry, continue...
        
        int nPosition = strApplicationPath.ReverseFind('.');
        strApplicationPath = strApplicationPath.Left(nPosition + LENGTH_OF_EXTENSION);
        
        if (strApplicationPath.GetAt(0) == '\"')
            strApplicationPath = strApplicationPath.Mid(1);
        
        DWORD dwResult = GetShortPathName (strApplicationPath, chShortenedApplicationName, MAX_PATH);
        if (dwResult)
        {
            strcpy(chCommandLine, chShortenedApplicationName);
        }
        else
        {
            strcpy (chCommandLine, "\"");
            strcat (chCommandLine, strApplicationPath.GetBuffer(strApplicationPath.GetLength()));
            strApplicationPath.ReleaseBuffer();
            strcat (chCommandLine, "\"");
        }
        strcat(chCommandLine, " ");//space between application name and file name
    }
    
    /*
    Variable "file" cannot be empty, since one of the types must be found.
    Because only the files with extensions sought are there in the list box.
    */
    
    strcat (chCommandLine, "\"");//enclose file name within quotes
    
    if( SHOW_DIRECTLY == OpenUsingTmpFolder(strFileSelected) )
    {
        strcat (chCommandLine, m_strProjectPath.GetBuffer(m_strProjectPath.GetLength()));//trailing backslash has been removed
        m_strProjectPath.ReleaseBuffer();
    }
    else // FIRST_COPY_IN_TMP_FOLDER
    {
        CopyFileInTmpFolder(strFileSelected);
    }

    strcat (chCommandLine, strFileSelected.GetBuffer(strFileSelected.GetLength()));
    strFileSelected.ReleaseBuffer();
    strcat (chCommandLine, "\"");//enclose file name within quotes

	if(::CreateProcess(NULL, chCommandLine,
        NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS,NULL,NULL,&si, &pi))
	{
        ::CloseHandle(pi.hThread);
		/* Multiple help files can be opened.
        Let User handle the termination of the process
        by closing the help file only after it is not required anymore.
        ::WaitForSingleObject(pi.hProcess, INFINITE);
		::CloseHandle(pi.hProcess);
        */
    }
    else
    {
        DisplayErrorMessage("Error: ");
    }
}


/////////////////////////////////////////////////////////////////////////////////////

            //Private Functions for CBrowseCHMDialog

/////////////////////////////////////////////////////////////////////////////////////


LONG CBrowseCHMDialog::Read_ApplicationPathFromRegistry ( CString strApplicationToFind, CString &strApplicationPath )
{
    char  szClass[20]= "\0";
    BYTE qValue[255] ="\0";
    HKEY  ReadKey;
    DWORD dwDispos;
    ULONG type= REG_SZ;
    ULONG size= 255;
    LONG  nResult = 0;

    nResult = RegCreateKeyEx(HKEY_FOR_APPLICATION_PATH, strApplicationToFind, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &ReadKey, &dwDispos);

    if ( nResult == ERROR_SUCCESS )
    {
        nResult = RegQueryValueEx( ReadKey, DEFAULT_KEY, 0, &type, (BYTE *) qValue, &size);

        if ( nResult == ERROR_SUCCESS )
        {
            strcpy(strApplicationPath.GetBuffer((int)strlen((const char*)qValue)), (const char *) qValue);
            strApplicationPath.ReleaseBuffer();
        }//else, no need to copy

        RegCloseKey(ReadKey);
    }//else, no need to try to read the value
    return nResult;
}

void CBrowseCHMDialog::SearchAllFoldersForHelpFiles ( CString strSearchPath )
{
    CFileFind fileFinder;
    BOOL bFileFound = FALSE;

    if (strSearchPath.Right(1) != "\\")
        strSearchPath += "\\";

    strSearchPath += STR_WILDCARD;

    bFileFound = fileFinder.FindFile ( strSearchPath );
    
    while ( bFileFound )
    {
        bFileFound = fileFinder.FindNextFile ();
        
        if(fileFinder.IsDots())
            continue;
		else if(fileFinder.IsDirectory())
        {
            SearchAllFoldersForHelpFiles ( fileFinder.GetFilePath() );
            
            /*
            Extendibility provided to add as many types of Help docs as required.
            */
            for (int nCounter = 0; nCounter < eTotalTypes; nCounter++)
            {
                FindHelpFilesAndPopulateListBox ( fileFinder.GetFilePath(), (TypesOfHelpDocuments)nCounter );
            }
        }
        /*
        else, nothing to do, if a file is encountered
        */
    }
}

void CBrowseCHMDialog::FindHelpFilesAndPopulateListBox ( CString strSearchPath, TypesOfHelpDocuments nType )
{
    CFileFind fileFinder;
    CString strFileNameExcludingInstallPath("");
    BOOL bFileFound = FALSE;

    unsigned short nLength = m_strProjectPath.GetLength();

    if (strSearchPath.Right(1) != "\\")
        strSearchPath += "\\";

    strSearchPath += PatternsToFind[nType];

    bFileFound = fileFinder.FindFile ( strSearchPath );
    
    while ( bFileFound )
    {
        bFileFound = fileFinder.FindNextFile ();
        if (m_strProjectPath.Right(1) == "\\")
            nLength--;            
        strFileNameExcludingInstallPath = (fileFinder.GetFilePath()).Mid(nLength);
        m_objCHMListBox.AddString ( strFileNameExcludingInstallPath );
        CalculateNewHozizontalExtentOfListBox( strFileNameExcludingInstallPath );
    }
}

void CBrowseCHMDialog::DisplayErrorMessage(LPCTSTR strErrorPrompt, LPCTSTR strTrailingMsg)
{
	LPVOID lpMsgBuf;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL, GetLastError(),0,(LPTSTR) &lpMsgBuf,0,NULL) ;
	AfxMessageBox(CString(strErrorPrompt) + (char*)lpMsgBuf + CString(strTrailingMsg), MB_ICONSTOP);
}

void CBrowseCHMDialog::OnLbnDblclkListboxChmFilesList()
{
    OnBnClickedButtonChmOpen();
}

void CBrowseCHMDialog::OnLbnSelchangeListboxChmFilesList()
{
    m_objButtonOpen.EnableWindow(TRUE);
}

void CBrowseCHMDialog::CalculateNewHozizontalExtentOfListBox (CString strFilePath)
{
    CClientDC dc(this);

    CFont * f = m_objCHMListBox.GetFont();
    dc.SelectObject(f);

    CSize sz = dc.GetTextExtent(strFilePath, _tcslen(strFilePath));
    sz.cx += 3 * ::GetSystemMetrics(SM_CXBORDER);
    if(sz.cx > m_nNewHorizontalExtentOfListBox)
    {
        m_nNewHorizontalExtentOfListBox = sz.cx;
    }
}

void CBrowseCHMDialog::CalculateOriginalHozizontalExtentOfListBox ()
{
    CClientDC dc(this);

    CFont * f = m_objCHMListBox.GetFont();
    dc.SelectObject(f);

    CSize sz = dc.GetTextExtent(MAX_STRING_WITHOUT_SCROLL, _tcslen(MAX_STRING_WITHOUT_SCROLL));
    m_nOriginalHorizontalExtentOfListBox = sz.cx + 3 * ::GetSystemMetrics(SM_CXBORDER);
}

void CBrowseCHMDialog::CreateTmpDirectory()
{
    char chSystemDirectory[MAX_PATH];
    
    memset(chSystemDirectory,0,MAX_PATH);    
    
    if(::GetSystemDirectory(chSystemDirectory, MAX_PATH))//success
        m_strTmpFolder = chSystemDirectory;
    else //system directory not gotten
        m_strTmpFolder = ALT_PATH_FOR_TMP_FOLDER;

    if (m_strTmpFolder.Right(1) != "\\")
        m_strTmpFolder += "\\";

    m_strTmpFolder += STR_TMP_FOLDER_NAME;

    if(FALSE == CreateDirectory(m_strTmpFolder, NULL))
    {
        if(ERROR_ALREADY_EXISTS != GetLastError())
            DisplayErrorMessage("Temp Folder Creation Error...\n", "\nThe files with a \"#\" in their path may not be viewed !");
    }
}

void CBrowseCHMDialog::OnBnClickedCancel()
{
    if(IsTmpFolderValid())
    {
        CFileFind filefinder;
        CFileStatus status;
        
        BOOL bRemovable = TRUE;

        BOOL bFound = filefinder.FindFile(m_strTmpFolder + STR_BACKSLASH + STR_WILDCARD);
        while(bFound)
        {	
            bFound = filefinder.FindNextFile();		
            if(filefinder.IsDots())
                continue;
            else if(filefinder.IsDirectory())
            {
                MessageBox("Error deleting  folder:\n" + m_strTmpFolder + "\nAnother folder found in the folder!", "Unauthorized access ", MB_ICONINFORMATION);
                bRemovable = FALSE;
                break;
            }
            else
            {
				::ZeroMemory(&status,sizeof(CFileStatus));
                CFile::GetStatus( filefinder.GetFilePath(), status );
				status.m_attribute = CFile::Attribute::normal;//remove all attributes, e.g. readonly
				CFile::SetStatus( filefinder.GetFilePath(), status );
                if(!DeleteFile(filefinder.GetFilePath()))
				{
                    DisplayErrorMessage("File Delete Error: ", "Cannot delete temp folder - " + m_strTmpFolder + " !");
                    bRemovable = FALSE;
                    break;
                }
            }
        }
        
        filefinder.Close();
        if(bRemovable)
        {
           if(!::RemoveDirectory(m_strTmpFolder))
                DisplayErrorMessage("Temp Folder Delete Error...\n");
        }
    }
    OnCancel();
}

BOOL CBrowseCHMDialog::IsTmpFolderValid(void)
{
    return(!m_strTmpFolder.IsEmpty() && PathFileExists(m_strTmpFolder) && (GetFileAttributes(LPCTSTR(m_strTmpFolder)) & FILE_ATTRIBUTE_DIRECTORY));
}

BOOL CBrowseCHMDialog::OpenUsingTmpFolder(CString strFileSelected)
{
    BOOL bHashInInstallPath, bHashInFileName;

    /*
    Check if we have to copy the file to tmp folder and then show or directly.
    Conditions to be checked are:
    1. Install Path contains #
    2. File Name contains #
    3. A Tmp folder exists

    SHOW_DIRECTLY when:
    - If there is # in the Install_Path itself, no need to copy to TMP folder first.
    - If no # in either Install_Path and File name, no need to copy to TMP.
    - If no # in Install_path and # is there in File name but TMP folder does not exist
    
    OTHERWISE, use TMP FOLDER
    */

    if( -1 != m_strProjectPath.Find(HASH) )// '#' there in the INSTALL_PATH
        bHashInInstallPath = TRUE;
    else
        bHashInInstallPath = FALSE;
     
    if( -1 != strFileSelected.Find(HASH) )// '#' there in the File Name
        bHashInFileName = TRUE;
    else
        bHashInFileName = FALSE;
    
    
    if( 0 == strFileSelected.Right(LENGTH_OF_EXTENSION).CompareNoCase(PatternsToFind[eTypeDOC].Right(LENGTH_OF_EXTENSION)))
    {// "OR" with more types which are not affected
        return SHOW_DIRECTLY; // because Word Docs are not affected by a "#" in the path or file name
    }//return directly for the applications which are not affected by "#"
    else //for the applications affected by "#"
    {
        /*
            check whether a "#" encountered.
            If No, open directly.
            If yes, check whether the Temp folder was created successfully.
            If yes, copy file in the Temp folder first and open from there.
            If No, cant do anything; open directly :(
        */
        if( ( bHashInInstallPath || bHashInFileName ) && ( IsTmpFolderValid() ) )
            return FIRST_COPY_IN_TMP_FOLDER;
        else
            return SHOW_DIRECTLY;
    }
}

void CBrowseCHMDialog::CopyFileInTmpFolder(CString& strFilePath)
{
    /*
    Copy the file in Tmp Folder, replace all "#" with "_", and return the new path
    */
    
    CString strOriginalFileName(""), strNewFileName("");
    int nFilePos = strFilePath.ReverseFind('\\');
    
    //no trailing backslash in m_strTmpFolder
    
    strNewFileName = m_strTmpFolder + STR_BACKSLASH;
    strNewFileName += strFilePath.Mid(nFilePos+1);
    strNewFileName.Replace(HASH, UNDERSCORE);//to remove all "#" from file name
        
    strOriginalFileName = m_strProjectPath + strFilePath;
    
    if(!::CopyFile(strOriginalFileName, strNewFileName, FALSE))//could not copy
    {
        DisplayErrorMessage("File could not be copied to TMP folder...\n", "\nFile may not be viewed because it has some special characters in its path !");
    }
    else //file copied to TMP folder successfully
    {
        // SetAttribute to normal to avoid any prospective problems; do nothing if cannot be set
        SetFileAttributes(strNewFileName, FILE_ATTRIBUTE_NORMAL);
        strFilePath = strNewFileName;
    }
}
