/*
			 Siemens AG
		 Mobile Radio Terminals
		  Munich, Germany

.AUTHOR         Lehmann Juergen (MCH)

.SHORT_DESCR    Dialog window for PC-MMI, 

.SW_COMPONENT   PC-MMI-Environment

.SW_TYPE        Support-File

.STATUS         TEST

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
  1.0    01.12.99  Kh.Kellerer  file created
  1.1    25.01.00  N.Faisst     changed type cast from FARPROC to DLGPROC
                                due to migration Borland C -> MS-VC
  1.2    02.02.00  H.Sauer      WNDPROC cast only in MS_VC ( otherwise no cast )
  1.3    08.03.00  J.Lehmann    handling for PDU-Mode added
  1.4    12.05.00  J.Lehmann    after an output focus stays on the aktive window
  1.5    14.06.00  J.Lehmann    function dummies removed
  1.6    03.07.00  Ch.Lukasch   handling for XON/XOFF added
  1.7	 26.07.00  Kh.Kellerer  ENIP3 and serial support added
  1.8	 16.10.00  R.Peters     AT^SBNW command enhanced, now it is possible to load files in the sim, e.g. AT^SBNW="bmp",0 file=test.bmp
  1.9	 13.03.01  B.Wiesweg    AT^SBNW command enhanced, now RC waiting for answer from converter
  2.0    21.03.01  J.Lehmann    adaptation for new serial interface
  2.1	 21.06.01  B.Wiesweg    files with 0 bytes allowed
  2.2    18.01.02  J.Lehmann    adaptations for PC-MMI to work with new remote control interface
===================================================================================
09.00.00 2002-01-30  Juergen Lehmann (MCH)
         Adaptations for PC-MMI: old stuff removed and new functions for SAPI access introduced
09.00.01 2002-02-11  Juergen Lehmann (MCH)
         Adaptations for PC-MMI: SERIAL_1 replaced by SERIAL_0 because this is the right interface
09.01.00 2002-03-07  Juergen Lehmann (MCH)
         New parameter 'stConInfo *Info' added to functions 'OpenIOWireS0', 'RegisterComHandleWireS0'
         and 'ChangeComHandleWireS0'
09.02.00 2002-07-05  Lehmann Juergen (MCH)
         Changes for new RC dialog: Now the dialog could be used as any serial device. Former
         it always registered as 'WIRE_S0' to the SAPI.
09.02.01 2002-08-13 Christoph Scharenberg (KLF)
         Bugfix for error when compiling PC simulation due to changes in
         header ddserhw.h (put count 2043):
         Added include ddserhw_ci.h as an intermediate solution.
09.03.01 2002-09-25  J.Kobek      changed serDevS0.CablePlgInDetect to serDevS0.CableUnplugDetect
09.03.02 2003-04-02  K.Eltermann  corrected CTRL-Z in RC cmd console
09.03.03 2003-05-19  N.Barisits (VIE)
         added include directive for inc_private_alias.h
         patched _fmemset() to memset()
09.03.03 2003-11-03  R.Vretska (VIE)
         use MOPI_ExecuteFunction
09.04.00 2004-01-08  R.Vretska (VIE)
         add IRDA and BLUETOOTH
10.00.00 2004-01-09  Lehmann Juergen (MCH)
         bugfix for MOPI
10.00.01 2004-06-21 Alex Nagy (BS/MCH)
         PC-MMI replaced inc_private_alias.h by the C2C concept
10.00.02 2004-06-16 Schuetzenhofer Christoph(MUC) \n
         XRC_PostUser_Xon declared as extern\n
         because declaration moved from exportglob to exportcomp\n
10.00.03 2004-07-01 Schuetzenhofer Christoph (MUC) \n
         Button not used or without function disabled \n
10.00.04 2004-08-31 Schuetzenhofer Christoph (MUC)\n
         Enhanced functionality for MAX_RC_DIALOGS multiple Instances and
         get last commands in input promt by arrow up and down


.VERSION        10.00.04

.DATE           2004-08-31

*/


extern "C"
{
#include <global.h>
#include "gbs.h"
#include "mopiext.h"
#include "procid.h"
#include "comdevs.h"
#include "xs_sapih.h"
#include "xaglob.h"
#include "xai_user.h"
#include "ddserhw.h"
#include "ddserhw_ci.h"
}

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "winmain.h"
#include "winrc.h"

#ifdef __WIN32__
extern HANDLE /*hStdIn, */hStdOut; /* standard input, output handles */
#endif

//defines
#define ATC_LOG_FILE_NAME		"atc.log"
#define ATC_LOG_FILE_DIR		"c:\\tmp"
#define ATC_LOG_WINDOW_LINES	12
#define STRING_LF				0x0A
#define RC_BUFFER_SIZE			XRC_RX_BUFFER_SIZE
#define RC_LOG_BUFFER_SIZE		32000
#define FEATURE_IMPLEMENTED         0      // some functions are inactive till implementation is finished
#define MAX_RC_DIALOGS          3          // can be increased without any changes up to NUMBER_OF_XRC_PROCESSES
#define INSTANCE_NOT_FOUND      MAX_RC_DIALOGS
#define NO_INSTANCE             0xFF
#define NO_DIALOG_FOUND			0xFF
#define RC_COMMAND_BUFFER_SIZE  255

//externals
extern "C" HWND DispGetWinHandle(void);
extern "C" void XRC_PostUser_Xon (unsigned int Instance);
extern void resizeConBufAndWindow(HANDLE hConsole, SHORT xSize, SHORT ySize);

typedef struct 
{	
	enSDev Device;
    unsigned int DeviceInstance;
    HWND hRcDialog;
    
} DIALOG_DEVICE_HANDLE;


//Prototypes
void LogFileInit(void);
void atc_print_d(const char *fmt, ...);
void generateLogOutput(int size, char *pRCBuffer,unsigned int Instance);
LRESULT CALLBACK EditProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

unsigned char RC_LogBuffer[MAX_RC_DIALOGS][RC_LOG_BUFFER_SIZE];
char RC_ComandBuffer[MAX_RC_DIALOGS][RC_COMMAND_BUFFER_SIZE][RC_COMMAND_BUFFER_SIZE];
unsigned char * pWrite_LogBuffer[MAX_RC_DIALOGS]; //= &RC_LogBuffer[MAX_RC_DIALOGS][0];

//Statics
static char atc_logfilename[100];
static int file_created;
static bool atc_print_d_log_file;
static bool atc_print_window_output = 0;
static unsigned int logLines;
static bool atc_LogCheckbox;
static bool atc_XonOffCheckbox;

DLGPROC fnOldEdit ;

const char XRC_SAPI_WIRES0[]		="WIRE_S0";
const char XRC_SAPI_IRDA_S0[]		="IRDA_S0";
const char XRC_SAPI_BLUETOOTH_S0[]	="BLUETOOTH_S0";
const char XRC_SAPI_WIRE_S1[]		="WIRE_S1";
const char XRC_SAPI_IRDA_S1[]		="IRDA_S1";
const char XRC_SAPI_BLUETOOTH_S1[]	="BLUETOOTH_S1";
const char XRC_SAPI_USB[]			="USB";
const char XRC_SAPI_IRDA[]		    ="IRDA";
const char XRC_SAPI_BLUETOOTH[]	    ="BLUETOOTH";
const char XRC_SAPI_ACC_SDEV[]		="ACC_SDEV";
const char XRC_SAPI_VCP[]			="VCP";
const char XRC_SAPI_BFC2SAPI[]		="BFC2SAPI";
const char XRC_SAPI_TCP_IRDA[]		="TCP_IRDA";
const char XRC_SAPI_TCP_WIRE[]		="TCP_WIRE";
const char XRC_SAPI_OBEX_TCP[]		="OBEX_TCP";
const char XRC_SAPI_D_MUX_07_10[]	="D_MUX_07_10";
const char XRC_SAPI_BT_AV_RC[]		="BT_AV_RC";
const char XRC_SAPI_BT_AV_STREAM[]	="BT_AV_STREAM";

// there must be exactly one line for every entry of the
// enum enSDev in comdevs.h
const char * const XRC_SAPI_STRING[]=
{
	XRC_SAPI_WIRES0,
	XRC_SAPI_IRDA_S0,
	XRC_SAPI_BLUETOOTH_S0,
	XRC_SAPI_WIRE_S1,
	XRC_SAPI_IRDA_S1,
	XRC_SAPI_BLUETOOTH_S1,
	XRC_SAPI_USB,
 	XRC_SAPI_IRDA,
 	XRC_SAPI_BLUETOOTH,
	XRC_SAPI_ACC_SDEV,
	XRC_SAPI_VCP,
	XRC_SAPI_BFC2SAPI,
	XRC_SAPI_TCP_IRDA,
	XRC_SAPI_TCP_WIRE,
	XRC_SAPI_OBEX_TCP,
	XRC_SAPI_D_MUX_07_10,
	XRC_SAPI_BT_AV_RC,
	XRC_SAPI_BT_AV_STREAM
};
#define XRC_SAPI_MAX_SDevices	(sizeof(XRC_SAPI_STRING)/sizeof(char *))

extern "C"
{

#pragma argsused
#define TX_BUFFER_LEN	1000
#define TEMP_BUFFER_LEN	10


////////////////////////////////////////////////////////////////////////////////
//  
//   #####     #    ######    ###
//  #     #   # #   #     #    #
//  #        #   #  #     #    #
//   #####  #     # ######     #
//        # ####### #          #
//  #     # #     # #          #
//   #####  #     # #         ###
//  
////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------
//--- DEFINES
//----------------------------------------------------------------------------------------

//--- for communciation handler

#define HANDLE_NOT_FREE             0
#define HANDLE_FREE                 1

//--- software-flowcontrol default values
#define DC1		                    0x11
#define DC3		                    0x13
#define XON_DEFAULT	                DC1
#define XOFF_DEFAULT	            DC3

/* =========================================================================
                         D E F A U L T   V A L U E S
   ========================================================================= */

        /* === default baudrate === */
#define DEFAULT_BAUDRATE_WIRE		19200L

        /* === cable detection === */
#define CABLE_DETECTION_WIRE                ON

        /* === autobauding === */
#define HW_AUTOBAUDING_WIRE                 ON



//----------------------------------------------------------------------------------------
//--- GLOBALS
//----------------------------------------------------------------------------------------
bit                     bEscRequest;              // Escape Sequence Request
bit                     bXoffFromDte;             // XOFF send by DTE
bit                     bXonFromDte;              // XON send by DTE
bit                     bInFCModeSoftware;        // Software FlowControl (PC->Mobile)
bit                     bCableRemoved;            // flag from Int

stSerDevStatus          serDev[MAX_RC_DIALOGS];                // own serial parameters

unsigned int            TxWriteOffset;
unsigned int            TxReadOffset;
unsigned int            InternalFlowControl;
unsigned int            sendBytes;


//----------------------------------------------------------------------------------------
//--- LOCALS
//----------------------------------------------------------------------------------------
V24STATUS        V24Status;
bit              bSerial_is_initialized[MAX_RC_DIALOGS];
bit              bHandle_is_not_free[MAX_RC_DIALOGS];

SDHandle         DevHndl[MAX_RC_DIALOGS];              // own Device Handle

IOHandle         IOHndl[MAX_RC_DIALOGS];               // own Communication Handle
pIOHandle        pAppIOHndl[MAX_RC_DIALOGS];            // ptr to Communication Handle of
                                                    // connected application

bit              bSendXON;
bit              bSendXOFF;

bit              bEscTimerMerker;
Timer            EscapeTimer;

bit              bCableInsert;

//SM: autobaud test
static bit              ActivateAutobauding;
static bit              AutobaudingAllowed;

static stSerialParam    InterfaceParam;

static BOOL bCableIn = FALSE; //VR: avoid exit on closing window

UINT16 count;
char pBuffer[1000];


//----------------------------------------------------------------------------------------
//--- PROTOTYPES
//----------------------------------------------------------------------------------------
extern void InitSerialDevices ( void );


void InitHardware (void);
void InitProtocol (void);
void InitDevAndComHndl (unsigned int i);

void ActivateFlowCtrl (unsigned int value);
void SetTxWriteOffset ( unsigned int len );

void CableIn ( void );
void CableOut ( void );

void TxTask ( void );
void RxTask ( void );


unsigned int OpenIO (pIOHandle *pComHandle, enSApp SApp, stConInfo *Info);
void RegisterComHandle (IOHandle *pComHandle, stConInfo *Info);
pIOHandle ChangeComHandle (pIOHandle pNewIOHandle, unsigned int Instance, enSApp OldSApp, stConInfo *Info);
void CloseIO (unsigned int Instance);
enSApp GetConnectedSApp (unsigned int DevInstance, unsigned int *ConnectedSAppInstance);

static BOOL DiscoverReq (void *DiscoverParams, DiscoverReqCallbackFun CallbackFun);
BOOL ConnectReq (void *ConnectDevice, ConnectReqCallbackFun CallbackFun);


void ReadDataCallback (unsigned int Instance);
unsigned int WriteData (unsigned char* pData, unsigned int len, unsigned int Instance);
V24STATUS* V24GetStatus ( unsigned int Instance);
void V24SetStatus (V24STATUS status, unsigned int Instance);
void SetEscapeChar (char Escape, unsigned int Instance);
void SetFlowControl (FCMODE DceByDte, FCMODE DteByDce, unsigned char Xon, unsigned char Xoff, unsigned int Instance);
void Autobaud (BOOL mode, unsigned int Instance);
unsigned long GetActBaudrate ( unsigned int Instance);
void SetBaudrate (unsigned long Baudrate, unsigned int Instance);
unsigned int GetListOfSupportedBaudrates (unsigned long *pTableBaudrate, unsigned int MaxEntries, unsigned int Instance);
void FlushBuffer (enBUFFER BufferToClear, unsigned int Instance);

void EndCallback(unsigned int Instance, void *stEndParam, enSApp ownApp, unsigned int ownInstance);
void ReconstructIOHndl (void);

FCMODE FlwCtrlGet (unsigned int *pV24);

void InitSerialDevice   ( stSerialParam *,  unsigned int DevInstance);

#define XRC_READ_DATA	0
#define XRC_ESC_CALLB	1

void WinSim_CallSapiFunction(UINT32 FunctionId);

} //end extern C

unsigned int iGetCurrDialogfromHWND(HWND hWindow);
unsigned int iGetCurrentDialogfromInstance(unsigned Instance);
unsigned int iGetNextFreeDialog(void);
bool bCheckInstanceAvail(unsigned int Instance);
void vInitDialogDevHndlStr(void);
void vInitRCBuffer(void);
void vDeleteRCandComBuffer(unsigned int ActDialog);
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// RC Message Dialog
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
static DIALOG_DEVICE_HANDLE  sDialogDeviceHld[MAX_RC_DIALOGS];  
//HWND hRcDialog[MAX_RC_DIALOGS];
//HWND hRcDialog;
unsigned int CurrDialog ;
UINT8 CurrentArrowUpCommand[MAX_RC_DIALOGS], CurrentCommand [MAX_RC_DIALOGS];
static unsigned int UsedDialogs = 0 ; 
////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////

#pragma argsused
////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK RcDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
////////////////////////////////////////////////////////////////////////////////
{
	// RNP, for getting file name with SBNW command ----------------------------
	static int  nNofPackets;    // Number of packtes to send
	static int  nCommand;		// Flag to send command or data
	static char szSaveBuf[256]; // Buffer with original command line
	// --------------------------------------------------------------------------
		
	switch (message)
	{
			case WM_CLOSE:
				{
					if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
					{
						break;
					}
					DestroyWindow(hwndDlg);
					atc_print_window_output = 0;
					CableOut();
					sDialogDeviceHld[CurrDialog].hRcDialog = 0;
					sDialogDeviceHld[CurrDialog].Device = NO_SERIAL_DEVICE;
					sDialogDeviceHld[CurrDialog].DeviceInstance = NO_INSTANCE;
					vDeleteRCandComBuffer(CurrDialog);
					UsedDialogs--;
					return TRUE;
				}
			case WM_COMMAND:
			{
					switch(LOWORD(wParam))
					{
					case IDC_XRC_OPEN_COM:
						{
							enSDev eDev;
							unsigned int Instance;

							if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
							{
								break;
							}
							
							if ( (eDev =(enSDev) SendMessage(GetDlgItem(hwndDlg, IDC_XRC_SAPI), CB_GETCURSEL, 0, 0)) != CB_ERR )
							{
								Instance = SendMessage(GetDlgItem(hwndDlg, IDC_XRC_INSTANCE), CB_GETCURSEL, 0, 0);
								if (bCheckInstanceAvail( Instance ))
							{
									sDialogDeviceHld[CurrDialog].DeviceInstance = Instance;
									sDialogDeviceHld[CurrDialog].Device = eDev;
							    }
							    else
							    {
							    	print_d("Instance already opened in other RC Dialog");
									MessageBox( DispGetWinHandle(), "Error: Instance already opened in other RC Dialog","PC-Simulator: RC Command Dialog",(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
									break;
							    }
								 
								InitDevAndComHndl(CurrDialog);
								// ---  register at Communication Handler  -----------
								InitComDevice(sDialogDeviceHld[CurrDialog].Device, &DevHndl[CurrDialog]);

								//enable all window parts
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_EDIT), TRUE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_CTRL_Z), TRUE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_ESCAPE), TRUE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_RETURN), TRUE);
								//EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_XON_OFF), TRUE);
								//EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_LOG_CHECKBOX), TRUE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_CLOSE_COM), TRUE);

								CableIn();
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_SAPI), FALSE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_INSTANCE), FALSE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_OPEN_COM), FALSE);
								EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_WAIT_ON_OFF), FALSE);

								SetFocus(DispGetWinHandle());
							}
							break;
						}

					case IDC_XRC_CLOSE_COM:
						{
							if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
							{
								break;
							}
							
							//disable all window parts
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_EDIT), FALSE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_CTRL_Z), FALSE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_ESCAPE), FALSE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_RETURN), FALSE);
							//EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_XON_OFF), FALSE);
							//EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_LOG_CHECKBOX), FALSE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_CLOSE_COM), FALSE);
							
							CableOut();

							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_SAPI), TRUE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_INSTANCE), TRUE);
							EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_OPEN_COM), TRUE);
							//EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_WAIT_ON_OFF), TRUE);

							sDialogDeviceHld[CurrDialog].Device = NO_SERIAL_DEVICE;
					                sDialogDeviceHld[CurrDialog].DeviceInstance = NO_INSTANCE;

							break;
						}


					case ID_XRC_RETURN: //---------------------------------------------
						{
							// Return Key pressed or button return clicked
							if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
							{
								break;
							}
							if( HIWORD( wParam) == BN_CLICKED )
							{ 
								// Get command from edit control ----------------------
								GetDlgItemText( hwndDlg, IDC_XRC_EDIT, pBuffer,RC_BUFFER_SIZE ); 
								
								// store command in command buffer and set positions numbers
								(CurrentCommand[CurrDialog])++;
								CurrentArrowUpCommand[CurrDialog] = CurrentCommand[CurrDialog];
								strcpy(&(RC_ComandBuffer[CurrDialog][(CurrentCommand[CurrDialog])][0]),pBuffer);
								

								strcat(pBuffer,"\r");
								count = (UINT16) strlen((const char *)pBuffer);
								//atc_print_d("%s",pBuffer);      is sent in Execute Function
								
								//Message to remote control
								MOPI_ExecuteFunction(NOPROCESS_PID,WinSim_CallSapiFunction,XRC_READ_DATA);
								return TRUE;
							}
						break; // ID_RETURN -------------------------------------------
						}
					case ID_XRC_CTRL_Z:
						{
							// CTRL-Z Key
							if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
							{
								break;
							}
							if(HIWORD(wParam) == BN_CLICKED)
							{
								GetDlgItemText(hwndDlg,IDC_XRC_EDIT,pBuffer,RC_BUFFER_SIZE); //alt RC_CommandBuffer
								strcat(pBuffer,"\r");
								count = (UINT16) strlen((const char *)pBuffer);
								//atc_print_d("%s",pBuffer); is sent in Execute Function
								pBuffer[count-1]='\x1A';
								
								//Message to remote control
								MOPI_ExecuteFunction(NOPROCESS_PID,WinSim_CallSapiFunction,XRC_READ_DATA);

								strcat(pBuffer,"\n");
								//generateLogOutput((int) count, pBuffer); is sent in Execute Function
								SendDlgItemMessage(hwndDlg,IDC_XRC_LOGBOX,WM_SETTEXT,0,(LPARAM)&(RC_LogBuffer[CurrDialog]));
								
								return TRUE;
							}
							break;
						}
					case ID_XRC_ESCAPE:
						{
							// ESC Key
							if ( (CurrDialog = iGetCurrDialogfromHWND(hwndDlg))== INSTANCE_NOT_FOUND )
							{
								break;
							}
							if(HIWORD(wParam) == BN_CLICKED)
							{
								GetDlgItemText(hwndDlg,IDC_XRC_EDIT,pBuffer,RC_BUFFER_SIZE); //alt RC_CommandBuffer
								strcat(pBuffer,"\r");
								count = (UINT16) strlen((const char *)pBuffer);
								if(count == 1)
								{
									memset(pBuffer,0x00,1000);
									strcpy(pBuffer,"+++");
									MOPI_ExecuteFunction(NOPROCESS_PID,WinSim_CallSapiFunction,XRC_ESC_CALLB);
								}
								else
								{
									//append 'Escape'-character
									pBuffer[count]='\x1A';

									MOPI_ExecuteFunction(NOPROCESS_PID,WinSim_CallSapiFunction,XRC_READ_DATA);
								}

								//atc_print_d("%s",pBuffer);is sent in Execute Function								
								strcat(pBuffer,"\n");
								//generateLogOutput((int) count, pBuffer);is sent in Execute Function
								SendDlgItemMessage(hwndDlg,IDC_XRC_LOGBOX,WM_SETTEXT,0,(LPARAM)&(RC_LogBuffer[CurrDialog]));
								
								return TRUE;
							}
							break;
						}
#if FEATURES_IMPLEMENTED
					case IDC_XRC_LOG_CHECKBOX:
						{
							// Checkbox Short Log
							if(HIWORD(wParam) == BN_CLICKED)
							{
								atc_LogCheckbox?atc_LogCheckbox=FALSE:atc_LogCheckbox=TRUE;
								SendDlgItemMessage(hwndDlg,IDC_XRC_LOG_CHECKBOX,BM_SETCHECK,atc_LogCheckbox,0);
							}
							break;
						}
					case IDC_XRC_CLEAR_LOG:
						{
							// Checkbox Short Log
							if(HIWORD(wParam) == BN_CLICKED)
							{
								RC_LogBuffer[CurrDialog][0]= 0;
								logLines= 1;
								SendDlgItemMessage(hwndDlg,IDC_XRC_LOGBOX,WM_SETTEXT,0,(LPARAM)&(RC_LogBuffer[CurrDialog]));
							}
							break;
						}
					case IDC_XRC_XON_OFF:
						{
							// Checkbox Xon_Xoff
							if(HIWORD(wParam) == BN_CLICKED)
							{
								atc_XonOffCheckbox?atc_XonOffCheckbox=FALSE:atc_XonOffCheckbox=TRUE;
								if (atc_XonOffCheckbox == FALSE)
									XRC_PostUser_Xon(sDialogDeviceHld[CurrDialog].Device);
								
								SendDlgItemMessage(hwndDlg,IDC_XRC_XON_OFF,BM_SETCHECK,atc_XonOffCheckbox,0);
								
							}
							break;
						}
#endif		//NOT_IMPLEMENTED				
					default:
						break;
			}
      }
   }
   return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
extern "C" void open_rc_command_dialog( void )
////////////////////////////////////////////////////////////////////////////////
{
	HWND hEdit;

	char tempString[100];
	unsigned int i, nextFreeDialog;
	static bool  iFirstTime = TRUE;

	//init logfile and output in the first call of function
    if (iFirstTime)
    {
		iFirstTime = FALSE;
		atc_print_d_log_file= 1;
		atc_print_window_output = 1;
		logLines= 1;
		vInitDialogDevHndlStr();
		vInitRCBuffer();

    }

	if( UsedDialogs >= MAX_RC_DIALOGS )
	{
		print_d("Max. number of RC Command Dialog opened!");
		MessageBox( DispGetWinHandle(), "Error: Max number of RC Dialog Window opened","PC-Simulator: RC Command Dialog",(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
		return;
	}
	else
	{
		if( (nextFreeDialog = iGetNextFreeDialog()) == NO_DIALOG_FOUND )
		{
			print_d("No free Dialog found !");
			MessageBox( DispGetWinHandle(), "Error: No free Dialog !","PC-Simulator: RC Command Dialog",(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
			return;
	}
		CurrDialog =  nextFreeDialog;
    }

	sDialogDeviceHld[CurrDialog].hRcDialog = CreateDialog(MainApp::hInstance,MAKEINTRESOURCE(DLG_XRC_COMMAND),DispGetWinHandle(),(DLGPROC)RcDialogProc);
	
	if (sDialogDeviceHld[CurrDialog].hRcDialog == NULL)
	{
		print_d("ERROR in creating RC Command Dialog!");
		MessageBox( DispGetWinHandle(), "Error: Could not create RC Dialog Window",
			"PC-Simulator: RC Command Dialog",
			(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
		return;
	}

	// Init the SAPI device list
	for ( i=0; i<XRC_SAPI_MAX_SDevices; i++)
	{
		sprintf(tempString, "%s", XRC_SAPI_STRING[i]);
		SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_SAPI, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) tempString);

	}
	SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_SAPI, CB_SETCURSEL, 0, 0);

	// Init the SAPI Instance list
	for ( i=0; i<MAX_RC_DIALOGS; i++)
	{
		sprintf(tempString, "%d", i);
		SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_INSTANCE, CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) tempString);

	}
	SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_INSTANCE, CB_SETCURSEL, 0, 0);


	//Checkbox status setzen
	atc_LogCheckbox= TRUE;
	atc_XonOffCheckbox = FALSE;
	SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog,IDC_XRC_LOG_CHECKBOX,BM_SETCHECK,1,0);
	SetLastError(0);
	hEdit= GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog,IDC_XRC_EDIT);
	fnOldEdit = (DLGPROC) SetWindowLong (hEdit, GWL_WNDPROC	, (LPARAM) EditProc) ;
	if(GetLastError())
	{
		print_d("ERROR in RC Dialog Window: can not set new dlgproc!");
		MessageBox( DispGetWinHandle(), "ERROR in RC Dialog Window: can not set new dlgproc!",
			"PC-Simulator: RC Command Dialog",
			(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
		return;
	}
	//disable all window parts
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_EDIT), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_CTRL_Z), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_ESCAPE), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, ID_XRC_RETURN), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_XON_OFF), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_WAIT_ON_OFF), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_LOG_CHECKBOX), FALSE);
	EnableWindow(GetDlgItem(sDialogDeviceHld[CurrDialog].hRcDialog, IDC_XRC_CLOSE_COM), FALSE);

	ShowWindow(sDialogDeviceHld[CurrDialog].hRcDialog,SW_SHOW);
	
	UsedDialogs++;
}

void WinSim_CallSapiFunction(UINT32 FunctionId)
{
	switch(FunctionId)
	{
		case XRC_READ_DATA:
			{
				pAppIOHndl[CurrDialog]->ReadData((unsigned char *)pBuffer, count, pAppIOHndl[CurrDialog]->Connection.SAppInstanz);
				break;
			}
		case XRC_ESC_CALLB:
			{
				pAppIOHndl[CurrDialog]->EscapeCallback(pAppIOHndl[CurrDialog]->Connection.SAppInstanz);
				break;
			}
		default:
			break;
	}
}




// prints command to PCMMI RC console an to Log file
////////////////////////////////////////////////////////////////////////////////
void generateLogOutput(int size, char *pRCBuffer, unsigned int Instance)
////////////////////////////////////////////////////////////////////////////////
{
#if 0
	unsigned int loglen;
	char *pLf, *pString;
	unsigned int i;
	
	if(atc_print_window_output == 1)
	{
		if(atc_LogCheckbox)
		{
			//Short Log active
			pString = pRCBuffer;
			for(i=0; i==size; i++)
			{
				if(pString+i == STRING_LF)
				{
					logLines++;
				}
			}
			
			if(logLines > ATC_LOG_WINDOW_LINES)
			{
				for(;logLines - ATC_LOG_WINDOW_LINES > 0; logLines--)
				{
					pLf= strchr(RC_LogBuffer[Instance],STRING_LF);
					if(pLf == NULL)
					{
						MessageBox( DispGetWinHandle(), "Error: No Lf found in ATC Log Box",
							"PC-Simulator: RC Command Dialog",
							(MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
						return;
					}
					memmove(RC_LogBuffer[Instance], pLf+1, (unsigned int)(RC_LOG_BUFFER_SIZE-(pLf-RC_LogBuffer[Instance])-1));
				}
			}
		}
		else
		{
			//long Log active
			if(size + strlen(RC_LogBuffer[Instance])>  RC_LOG_BUFFER_SIZE)
			{
				//Platz schaffen
				loglen= strlen(RC_LogBuffer[Instance]);
				memmove(RC_LogBuffer[Instance], RC_LogBuffer[Instance]+RC_BUFFER_SIZE, RC_LOG_BUFFER_SIZE-RC_BUFFER_SIZE);
				RC_LogBuffer[Instance][loglen-RC_BUFFER_SIZE]= 0; //string terminator
			}
		}
		
		strcat(RC_LogBuffer[Instance],pRCBuffer);
#endif
	unsigned int i, actLine,ActDialog;

	char * pString = pRCBuffer;
	for(i=0; i==(unsigned int)size; i++)
	{
		if(*(pString+i) == STRING_LF)
		{
			logLines++;
		}
	}
	ActDialog = iGetCurrentDialogfromInstance(Instance);	
	memcpy(pWrite_LogBuffer[ActDialog],pRCBuffer,size);
	pWrite_LogBuffer[ActDialog]+=size;
	atc_print_d("%s",pRCBuffer); //for Logfile
	SendDlgItemMessage(sDialogDeviceHld[ActDialog].hRcDialog,IDC_XRC_LOGBOX,WM_SETTEXT,0,(LPARAM)&(RC_LogBuffer[ActDialog]));
       	
	actLine=SendMessage(GetDlgItem(sDialogDeviceHld[ActDialog].hRcDialog, IDC_XRC_LOGBOX),EM_GETLINECOUNT,0,0);
	SendMessage(GetDlgItem(sDialogDeviceHld[ActDialog].hRcDialog, IDC_XRC_LOGBOX),EM_LINESCROLL,0,actLine);
}

////////////////////////////////////////////////////////////////////////////////
void atc_LogFileInit(void)
////////////////////////////////////////////////////////////////////////////////
{
	char *ep = getenv("TMP");
	if (ep == 0)
	{
		strcpy(atc_logfilename,ATC_LOG_FILE_DIR);
	}
	else
	{
		strcpy(atc_logfilename,ep);
	}
	
	strcat(atc_logfilename,"\\"ATC_LOG_FILE_NAME);
	atc_print_d_log_file= 1;
	
}

//prints commands to logfile
////////////////////////////////////////////////////////////////////////////////
void atc_print_d(const char *fmt, ...)
////////////////////////////////////////////////////////////////////////////////
{
	char buffer[500];
	
	
	va_list va;
	va_start(va, fmt);
	vsprintf(buffer, fmt, va);
	va_end(va);
	
	atc_LogFileInit();
	
	if (atc_print_d_log_file)
	{
		FILE *fh;
		
		if (file_created == 0)
		{
			fh = fopen(atc_logfilename, "wb");
			file_created = 1;
		}
		else
			fh = fopen(atc_logfilename, "ab");
		
		if (fh != NULL)
		{
			fprintf(fh, "%s\n", buffer);
			fclose(fh);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK EditProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
////////////////////////////////////////////////////////////////////////////////
{
	if (iMsg == WM_KEYUP )
	{
		switch(wParam)
		{
			case VK_RETURN:
				{
					SendMessage (GetParent (hwnd), WM_COMMAND,ID_XRC_RETURN,0) ;
					break;
				}
			case VK_ESCAPE:
				{
					SendMessage (GetParent (hwnd), WM_COMMAND,ID_XRC_ESCAPE,0) ;
					break;
				}
			case VK_UP:
				{
					if ( (CurrDialog = iGetCurrDialogfromHWND(GetParent (hwnd)))== INSTANCE_NOT_FOUND )
					{
						break;
					}
					(CurrentArrowUpCommand[CurrDialog])--;
					SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog ,IDC_XRC_EDIT,WM_SETTEXT,0,(LPARAM)&(RC_ComandBuffer[CurrDialog][(CurrentArrowUpCommand[CurrDialog])]));
					//SendMessage(hwnd ,EM_LINEINDEX,0,sizeof(RC_ComandBuffer[CurrDialog][(CurrentArrowUpCommand[CurrDialog])]));
					break;
				}
			case VK_DOWN:
				{
					if ( (CurrDialog = iGetCurrDialogfromHWND(GetParent (hwnd)))== INSTANCE_NOT_FOUND )
					{
						break;
					}
					(CurrentArrowUpCommand[CurrDialog])++;
					SendDlgItemMessage(sDialogDeviceHld[CurrDialog].hRcDialog,IDC_XRC_EDIT,WM_SETTEXT,0,(LPARAM)&(RC_ComandBuffer[CurrDialog][(CurrentArrowUpCommand[CurrDialog])]));			
					break;
				}
			default:
				break;
		}
	}

#ifdef _MSC_VER
	return CallWindowProc ((WNDPROC)fnOldEdit, hwnd, iMsg, wParam, lParam) ;
#else
	return CallWindowProc (fnOldEdit, hwnd, iMsg, wParam, lParam) ;
#endif
}

unsigned int iGetCurrDialogfromHWND(HWND hWindow)
{
	unsigned int i,WinAddr,DialogAddr;
	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		WinAddr = (unsigned int) hWindow;
		DialogAddr =(unsigned int) sDialogDeviceHld[i].hRcDialog;

		if ( WinAddr == DialogAddr )
		{
			return i;
		}
	}
	// not found
	return 	INSTANCE_NOT_FOUND;
}

unsigned int iGetCurrentDialogfromInstance(unsigned Instance)
{
	unsigned int i;

	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		 sDialogDeviceHld[i].hRcDialog;

		 if ( Instance == sDialogDeviceHld[i].DeviceInstance )
		{
			return i;
		}
	}
	// not found
	return 	INSTANCE_NOT_FOUND;
}

unsigned int iGetNextFreeDialog(void)
{
	unsigned int i;
	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		if (		(sDialogDeviceHld[i].hRcDialog == 0)               &&
					(sDialogDeviceHld[i].Device == NO_SERIAL_DEVICE)    &&
					(sDialogDeviceHld[i].DeviceInstance == NO_INSTANCE)    )
		{
			return i;
		}
	}
	return NO_DIALOG_FOUND;
}

bool bCheckInstanceAvail(unsigned int Instance )
{
	unsigned int i;
	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		if (Instance == sDialogDeviceHld[i].DeviceInstance)
		{
			return FALSE;
		}
	}
	return TRUE;
	
}

void vInitDialogDevHndlStr(void)
{
	unsigned int i;
	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		sDialogDeviceHld[i].hRcDialog = 0;
		sDialogDeviceHld[i].Device = NO_SERIAL_DEVICE;
		sDialogDeviceHld[i].DeviceInstance = NO_INSTANCE;
		//sDialogDeviceHld[i].hRcDialog->unused = 0;
		CurrentArrowUpCommand[i]=0;
		CurrentCommand[i]=0;
	}
}
void vInitRCBuffer(void)
{
	unsigned int i;
	for (i=0; i < MAX_RC_DIALOGS; i++)
	{
		pWrite_LogBuffer[i] = &RC_LogBuffer[i][0];
	}
}

void vDeleteRCandComBuffer(unsigned int ActDialog)
{
	unsigned int i,j;

	for(i=0; i< RC_COMMAND_BUFFER_SIZE ; i++)
	{
		for(j=0; j< RC_COMMAND_BUFFER_SIZE;j++)
			RC_ComandBuffer[ActDialog][i][j] = 0x00;
	}

	for(i=0; i< RC_LOG_BUFFER_SIZE ; i++)
		RC_LogBuffer[ActDialog][i] = 0x00;

	pWrite_LogBuffer[ActDialog] = &RC_LogBuffer[ActDialog][0];
}

//function dummys
extern "C"
{
	////////////////////////////////////////////////////////////////////////////////
	//  
	//   #####     #    ######    ###
	//  #     #   # #   #     #    #
	//  #        #   #  #     #    #
	//   #####  #     # ######     #
	//        # ####### #          #
	//  #     # #     # #          #
	//   #####  #     # #         ###
	//  
	////////////////////////////////////////////////////////////////////////////////
	

	/*************************************************************************/
	/* Initialisation of the serial hardware */
	/*************************************************************************/
	extern void InitSerialDevices ( void )
	{
		/************************************************/
		/* serial configuration is set in sincl ser_cfg */
		/************************************************/
		unsigned int i;
		/* initialise serial 0*/
		InterfaceParam.Baudrate = DEFAULT_BAUDRATE_WIRE;
		InterfaceParam.Autobaud = HW_AUTOBAUDING_WIRE;
		InterfaceParam.WireConnectionCheck = CABLE_DETECTION_WIRE;
		for (i=0;i<MAX_RC_DIALOGS;i++)
			InitSerialDevice(&InterfaceParam,i);
		
	}
        
   

	//----------------------------------------------------------------------------------------
	//  Function    :  InitSerialDevice
	//----------------------------------------------------------------------------------------
	//  Description :  initializing of Serial Interface for connection
	//
	//  Note        :  hardaware & protocoll initialisation will be in "OpenIO" performed
	//
	//  Arguments   :  pSerialParam :  pointer to Structure stSerialParam = {
	//                                                      unsigned long Baudrate;
	//                                                      unsigned int  Autobauding;
	//                                                      unsigned int  WireConnectionCheck: }
	//
	//  Return      :  Callback-Function for Powersaver
	//----------------------------------------------------------------------------------------
	void InitSerialDevice ( stSerialParam * pSerialParam, unsigned int ActDialog)
	{
		/* check if the serial is already initialized */
		if (bSerial_is_initialized[ActDialog])
		{
			/* only update the parameters */
			serDev[ActDialog].Baudrate         = pSerialParam->Baudrate;
			serDev[ActDialog].Autobaud         = pSerialParam->Autobaud;
			serDev[ActDialog].CableUnplugDetect = pSerialParam->WireConnectionCheck;
			
			/* new Baudrate */
			SetBaudrate (serDev[ActDialog].Baudrate, sDialogDeviceHld[ActDialog].DeviceInstance);
			
			return;
		}
		
		
		// ---  set default init status of Serial Device  --
		serDev[ActDialog].Baudrate         = pSerialParam->Baudrate;
		serDev[ActDialog].Autobaud         = pSerialParam->Autobaud;
		serDev[ActDialog].CableUnplugDetect = pSerialParam->WireConnectionCheck;
		serDev[ActDialog].EscapeChar       = '+';
		serDev[ActDialog].DTE_to_DCE       = FC_NONE;                // PC     -> Mobile (DceByDte)
		serDev[ActDialog].DCE_to_DTE       = FC_NONE;                // Mobile -> PC     (DteByDce)
		serDev[ActDialog].xonSign          = XON_DEFAULT;
		serDev[ActDialog].xoffSign         = XOFF_DEFAULT;
		
		// ---  initializing of protocol  --------------------
		InitProtocol();
		
		// ---  init of own Device & Communication Handle  ---
		//InitDevAndComHndl(DevInstance);
				
		bSerial_is_initialized[ActDialog] = 1;
		
		//ddsermon_DriverUpdate(Device, NO_SERIAL_APP, NULLP);
		
		return;
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  ExitSerialDevice
	//----------------------------------------------------------------------------------------
	//  Description :  exit the serial 0 device driver
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void ExitSerialDevice ( void )
	{
		// ---  disconnect a possible connection  ---
		if (bHandle_is_not_free[CurrDialog])
		{
			DisconnectSDev(sDialogDeviceHld[CurrDialog].Device,sDialogDeviceHld[CurrDialog].DeviceInstance);
			bHandle_is_not_free[CurrDialog] = 0;
		}
		
		//--- canceling at the communication handler
		ExitComDevice (sDialogDeviceHld[CurrDialog].Device);
		
		/* clear buffers and free all frames */
		
		
		/* clear the initialisation-flag */
		bSerial_is_initialized[CurrDialog] = 0;
	}
	
	//----------------------------------------------------------------------------------------
	//  Function    :  InitProtocol
	//----------------------------------------------------------------------------------------
	//  Description :  initialisation of receiver queue etc. assignmet of actual tasks
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void InitProtocol (void)
	{
		//--------------------------------------------------//
		//      R E C E I V E R                             //
		//--------------------------------------------------//
		bEscRequest   = 0;
		bXoffFromDte  = 0;
		bXonFromDte   = 0;
		
		//--------------------------------------------------//
		//      T R A N S M I T T E R                       //
		//--------------------------------------------------//
		TxWriteOffset = 0;
		TxReadOffset  = 0;
		InternalFlowControl = 0;
		bSendXON  = 0;
		bSendXOFF = 0;
		sendBytes = 0;
		
		// ---  reset V24Status  -----------------------
		memset(&V24Status,0x00,sizeof(V24STATUS));
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  InitDevAndComHndl
	//----------------------------------------------------------------------------------------
	//  Description :  initialisation of own Device & Communication Handle
	//
	//  Note        :  if Device isn't opened its Communication Handle points to NULLP
	//
	//  Arguments   :  i Instance number of device
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void InitDevAndComHndl (unsigned int ActDialog)
	{

		// ---  initialize own Device Handle and ... ---------
		DevHndl[ActDialog].OpenIOSDev        = OpenIO;
		DevHndl[ActDialog].RegisterComHandle = RegisterComHandle;
		DevHndl[ActDialog].ChangeComHandle   = ChangeComHandle;
		DevHndl[ActDialog].CloseIO           = CloseIO;
		DevHndl[ActDialog].GetConnectedSApp  = GetConnectedSApp;
		DevHndl[ActDialog].DiscoverReq       = DiscoverReq;
		DevHndl[ActDialog].ConnectReq        = ConnectReq;
		
		
		// ---  initialize own IO Handle ---------------------
		InitIOHandle(&IOHndl[ActDialog]);                        // Dummy initialisation
		
		IOHndl[ActDialog].ReadDataCallback               = ReadDataCallback;
		IOHndl[ActDialog].WriteData                      = WriteData;
		IOHndl[ActDialog].V24GetStatus                   = V24GetStatus;
		IOHndl[ActDialog].V24SetStatus                   = V24SetStatus;
		IOHndl[ActDialog].SetEscapeChar                  = SetEscapeChar;
		IOHndl[ActDialog].SetFlowControl                 = SetFlowControl;
		if ( serDev[ActDialog].Autobaud )
		{
			IOHndl[ActDialog].Autobaud                   = Autobaud;
		}
		IOHndl[ActDialog].GetActBaudrate                 = GetActBaudrate;
		IOHndl[ActDialog].SetBaudrate                    = SetBaudrate;
		IOHndl[ActDialog].GetListOfSupportedBaudrates    = GetListOfSupportedBaudrates;
		IOHndl[ActDialog].FlushBuffer                    = FlushBuffer;
		
		IOHndl[ActDialog].Connection.ConnectedSDev       = sDialogDeviceHld[ActDialog].Device;
		IOHndl[ActDialog].Connection.SDeviceInstanz      = sDialogDeviceHld[ActDialog].DeviceInstance;
		
		bHandle_is_not_free[ActDialog] = 0;
		
		// ---  set communication IO Handle  -----------------
		pAppIOHndl[ActDialog] = NULLP;
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//
	//       I N T E R F A C E   F O R   C O M M U N I C A T I O N   H A N D L E R
	//
	//----------------------------------------------------------------------------------------
	
	//----------------------------------------------------------------------------------------
	//  Function    :  openIO
	//----------------------------------------------------------------------------------------
	//  Description :  Device initialisation & hand-over of handle to communication handler
	//
	//  Note        :
	//
	//  Arguments   :  pointer to Communication Handle
	//
	//  Return      :  0 :  handle is'nt free
	//                 1 :  handle is free
	//----------------------------------------------------------------------------------------
	//lint -esym(715, SApp)
	//lint -esym(715, Info)
	unsigned int OpenIO (pIOHandle *pComHandle, enSApp SApp, stConInfo *Info)
	{
		

		// ---  do we have a free handle ?  ----------
		if (bHandle_is_not_free[CurrDialog])
		{
			*pComHandle = NULLP;                    // no free handle available
			return HANDLE_NOT_FREE;
		}
		else
		{
			*pComHandle = &IOHndl[CurrDialog];        // own handle
			bHandle_is_not_free[CurrDialog] = 1;
			return HANDLE_FREE;
		}
	}
	//lint +esym(715, SApp)
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  RegisterComHandle
	//----------------------------------------------------------------------------------------
	//  Description :  handing-over of valid communication handle
	//
	//  Note        :  due to callback future of transmitter the valid communication handle of
	//                 connected application must be hand over to transmitter at this place
	//
	//  Arguments   :  pointer to Communication Handle of connected application
	//
	//  Return      :
	//----------------------------------------------------------------------------------------
	void RegisterComHandle (IOHandle *pComHandle, stConInfo *Info)
	{
		//V24STATUS status;
		
	    Info = Info; //ToDo
    		
		// ---  Did you get a valid IO Handle ?  ---------
		if(pComHandle == NULLP)
		{
			// no valid Handle avaiable
			//EXIT( EXIT_NO_APP_IOHANDLE );
			return;
		}
		else
		{
			pAppIOHndl[CurrDialog] = pComHandle;              // Handle assignment
		}
		
		
		{
			SetBaudrate (serDev[CurrDialog].Baudrate, sDialogDeviceHld[CurrDialog].DeviceInstance);      // must be done explicitly hier !!!
			
			// --- Enable Autobauding by setting Baudrate to 0 ----
			if(serDev[CurrDialog].Autobaud)
			{
				SetBaudrate(0UL, sDialogDeviceHld[CurrDialog].DeviceInstance);
			}
		}
		//ddsermon_DriverUpdate(sDialogDeviceHld[CurrDialog].Device, pComHandle->Connection.ConnectedSApp, FlwCtrlGet);
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  ChangeComHandle
	//----------------------------------------------------------------------------------------
	//  Description :  change the communication handle to the new
	//
	//  Note        :  if BFB reconfig the serial
	//                 Instance is ignored, because we only have one
	//                 OldSApp is ignored, because it's not necessary
	//
	//  Arguments   :  pointer to Communication Handle of connected application
	//
	//  Return      :  pointer to the own handle
	//----------------------------------------------------------------------------------------
	//lint -esym(715, Instance)
	//lint -esym(715, OldSApp)
	pIOHandle ChangeComHandle (pIOHandle pNewIOHandle, unsigned int Instance, enSApp OldSApp, stConInfo *Info)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);
		pIOHandle   IOHandle = NULLP;
		
	    Info = Info; //ToDo

		// ---  Did you get a valid IO Handle ?  ---------
		if(pNewIOHandle == NULLP)
		{
			// no valid Handle avaiable
			//EXIT( EXIT_NO_APP_IOHANDLE );
			return NULLP;
		}
		else
		{
			if (pAppIOHndl[ActDialog]->Connection.ConnectedSApp == BFB)
			{
				// --- Reconfig Serial to Normal  --------
				ReconstructIOHndl();
				IOHandle = &IOHndl[ActDialog];
				//ddsermon_DriverUpdate(sDialogDeviceHld[CurrDialog].Device, pNewIOHandle->Connection.ConnectedSApp, FlwCtrlGet);
			}
			else
			{
				{
					IOHandle = &IOHndl[ActDialog];
					//ddsermon_DriverUpdate(sDialogDeviceHld[CurrDialog].Device, pNewIOHandle->Connection.ConnectedSApp, FlwCtrlGet);
				}
			}
			pAppIOHndl[ActDialog] = pNewIOHandle;    // Handle assignment
		}
		return IOHandle;
	}
	//lint +esym(715, Instance)
	//lint +esym(715, OldSApp)
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  closeIO
	//----------------------------------------------------------------------------------------
	//  Description :  closing of Device
	//
	//  Note        :  S0 can have only 1 instance (number=0)! If another instance is given as
	//                 parameter an exit occurs.
	//
	//  Arguments   :  Instance :  Device Instance
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void CloseIO (unsigned int Instance)
	{
		unsigned int ActDialog;
		if( (ActDialog = iGetCurrentDialogfromInstance(Instance)) !=  INSTANCE_NOT_FOUND)
		{
			 
			if( (pAppIOHndl[ActDialog]!= NULLP) && (pAppIOHndl[ActDialog]->Connection.ConnectedSApp == BFB) )
			{
				// --- Reconfig Serial to Normal  ----------------
				ReconstructIOHndl();
			}
			
			//--------------------------------------------------//
			//      R E C E I V E R                             //
			//--------------------------------------------------//
			bEscRequest   = 0;
			bXoffFromDte  = 0;
			bXonFromDte   = 0;
			
			//--------------------------------------------------//
			//      T R A N S M I T T E R                       //
			//--------------------------------------------------//
			TxWriteOffset = 0;
			TxReadOffset  = 0;
			InternalFlowControl = 0;
			bSendXON  = 0;
			bSendXOFF = 0;
			
			// ---  reset V24Status  -----------------------
			memset(&V24Status,0x00,sizeof(V24STATUS));
			
			
			pAppIOHndl[ActDialog]  = NULLP;              // no application connected
			bHandle_is_not_free[ActDialog] = 0;
			
			//ddsermon_DriverUpdate(sDialogDeviceHld[CurrDialog].Device, NO_SERIAL_APP, NULLP);
		}
		else
		{
		}
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  GetConnectedSApp
	//----------------------------------------------------------------------------------------
	//  Description :  returns connected application
	//
	//  Note        :  S0 can have only 1 instance (number=0)! If another instance is given
	//                 as parameter an exit occurs.
	//
	//  Arguments   :  actInstanz            :  owner instance
	//                *ConnectedSAppInstance :  instance of connected application
	//
	//  Return      :  connected application
	//----------------------------------------------------------------------------------------
	enSApp GetConnectedSApp (unsigned int DevInstance, unsigned int *ConnectedSAppInstance)
	{	
		unsigned int ActDialog = iGetCurrentDialogfromInstance(DevInstance);
		if(NULLP == pAppIOHndl[ActDialog])
		{
			return NO_SERIAL_APP;
		}
		*ConnectedSAppInstance = pAppIOHndl[ActDialog]->Connection.SAppInstanz;
		return (pAppIOHndl[ActDialog]->Connection.ConnectedSApp);
	}
	
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  DiscoverReq
	//----------------------------------------------------------------------------------------
	//  Description :  Discovery not supported by Wire
	//
	//  Note        :  
	//
	//  Arguments   :  
	//
	//  Return      :  FALSE
	//----------------------------------------------------------------------------------------
	/*lint -esym(715,DiscoverParams)*/
	/*lint -esym(715,CallbackFun)*/
	BOOL DiscoverReq (void *DiscoverParams, DiscoverReqCallbackFun CallbackFun)
	{
		return FALSE;
	}
	/*lint +esym(715,DiscoverParams)*/
	/*lint +esym(715,CallbackFun)*/
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  ConnectReq
	//----------------------------------------------------------------------------------------
	//  Description :  ConnectRequest not supported by Wire
	//
	//  Note        :  
	//
	//  Arguments   :  
	//
	//  Return      :  FALSE
	//----------------------------------------------------------------------------------------
	/*lint -esym(715,ConnectDevice)*/
	/*lint -esym(715,CallbackFun)*/
	BOOL ConnectReq (void *ConnectDevice, ConnectReqCallbackFun CallbackFun)
	{
		return FALSE;
	}
	/*lint +esym(715,ConnectDevice)*/
	/*lint +esym(715,CallbackFun)*/
	
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  ReconstructIOHndl
	//----------------------------------------------------------------------------------------
	//  Description :  reconstructs own IO-Handle after reconfiguration for BFB-Mode
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void ReconstructIOHndl (void)
	{
		// ---  reset baudrate  ------------------------------
		SetBaudrate (serDev[CurrDialog].Baudrate, sDialogDeviceHld[CurrDialog].DeviceInstance);
		
		InitProtocol();
		
		// --- Enable Autobauding by setting Baudrate to 0 ----
		if(serDev[CurrDialog].Autobaud)
		{
			SetBaudrate(0UL, sDialogDeviceHld[CurrDialog].DeviceInstance);
		}
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//
	//       F U N C T I O N S   F O R   S - A P I
	//
	//----------------------------------------------------------------------------------------
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  ReadDataCallback
	//----------------------------------------------------------------------------------------
	//  Description :  the connected application inform that data can be read again
	//
	//  Note        :  Flow Control will be deactivate in Receiver Tsk if Buffer free capacity
	//                 is falling down at least to 50%
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void ReadDataCallback ( unsigned int Instance)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);
		ActivateFlowCtrl(sDialogDeviceHld[ActDialog].Device);
		V24Status.InFlowActive = 0;
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  WriteData
	//----------------------------------------------------------------------------------------
	//  Description :  connected application call it due to sending data
	//
	//  Note        :
	//
	//  Arguments   :  *Data :  pointer to data to be copied
	//                  len  :  length of data set
	//
	//  Return      :   number of copied bytes
	//----------------------------------------------------------------------------------------
	unsigned int WriteData (unsigned char* pData, unsigned int len, unsigned int Instance)
	{
		//Aufruf der Windowsfunktion zum Schreiben der Daten auf das Terminal
		char TxBuffer[TX_BUFFER_LEN];
		
		memset(TxBuffer, 0x00, TX_BUFFER_LEN);
		
		memcpy(TxBuffer, pData, len);
		
		if (atc_XonOffCheckbox)
		{
			return 0;
		}
		generateLogOutput(len, TxBuffer,Instance);

		return len;
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  V24GetStatus
	//----------------------------------------------------------------------------------------
	//  Description :  return pointer to status of V24-Interface
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  V24 - Status
	//----------------------------------------------------------------------------------------
	V24STATUS* V24GetStatus (unsigned int Instance)
	{
		return (&V24Status);
	}
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  V24SetStatus
	//----------------------------------------------------------------------------------------
	//  Description :  set a new out value in V24 Interface status
	//
	//  Note        :  only the DCD status will be effected
	//
	//  Arguments   :  Status :  new status of V24 Interface
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void V24SetStatus (V24STATUS status, unsigned int Instance)
	{
		// ---  only DCD is used!!  ------------------
		V24Status.DCD = status.DCD;
		//setDCD( (unsigned char) !V24StatusS0.DCD);  // set DCD signal
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  SetEscapeChar
	//----------------------------------------------------------------------------------------
	//  Description :  set a valid Escape sign
	//
	//  Note        :
	//
	//  Arguments   :  Escape :  new valid Escape sign
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void SetEscapeChar (char Escape, unsigned int Instance)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);
		serDev[ActDialog].EscapeChar = Escape;
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  SetFlowControl
	//----------------------------------------------------------------------------------------
	//  Description :  setting the koind of Flow Control
	//
	//  Note        :
	//
	//  Arguments   :  DceByDte :  Flow Control Mode in IN direction  (PC -> Mobile)
	//                 DteByDce :  Flow Control Mode in OUT direction (Mobile -> PC)
	//                 Xon      :  character for XON
	//                 Xoff     :  character for XOFF
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void SetFlowControl (FCMODE DceByDte, FCMODE DteByDce, unsigned char Xon, unsigned char Xoff, unsigned int Instance)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);
		if ( DteByDce == FC_NONE )
		{
			// ---  no flowcontrol to PC  ------------
			// ---  we allow the PC to send  ---------
			ActivateFlowCtrl(0);
		}
		
		serDev[ActDialog].DTE_to_DCE = DceByDte;             // PC       -> Mobile
		serDev[ActDialog].DCE_to_DTE = DteByDce;             // Mobile   -> PC
		serDev[ActDialog].xonSign    = Xon;
		serDev[ActDialog].xoffSign   = Xoff;
		
		if ( (serDev[ActDialog].DTE_to_DCE == FC_SOFT) || (serDev[ActDialog].DTE_to_DCE == FC_BOTH) )
		{
			bInFCModeSoftware = 1;
		}
		else
		{
			bInFCModeSoftware = 0;
			V24Status.OutFlowActive = 0;
		}
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  Autobaud
	//----------------------------------------------------------------------------------------
	//  Description :  enables and disables autobauding
	//
	//  Note        :
	//
	//  Arguments   :  mode  :
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void Autobaud (BOOL mode, unsigned int Instance)
	{
		if (AutobaudingAllowed)
		{
			if (mode)
			{
				ActivateAutobauding = 1;
			}
			else
			{
				ActivateAutobauding = 0;
			}
		}
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  GetActBaudrate
	//----------------------------------------------------------------------------------------
	//  Description :  returns actual Baudrate
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  actual Baudrate
	//----------------------------------------------------------------------------------------
	unsigned long GetActBaudrate ( unsigned int Instance)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);
		return (serDev[ActDialog].Baudrate);
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  SetBaudrate
	//----------------------------------------------------------------------------------------
	//  Description :  set a new Baudrate
	//
	//  Note        :
	//
	//  Arguments   :  Baudrate :  a new Baudrate to be set
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void SetBaudrate (unsigned long Baudrate, unsigned int Instance)
	{
		unsigned int ActDialog = iGetCurrentDialogfromInstance(Instance);

		if ( Baudrate == 0UL )
		{
			AutobaudingAllowed = 1;
			Autobaud (TRUE, sDialogDeviceHld[ActDialog].Device);
			serDev[ActDialog].Baudrate = Baudrate;
		}
		else
		{
			Autobaud (FALSE, sDialogDeviceHld[CurrDialog].Device);
			AutobaudingAllowed = 0;
			{
				serDev[ActDialog].Baudrate = Baudrate;           // save intern
			}
		}
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  GetListOfSupportedBaudrates
	//----------------------------------------------------------------------------------------
	//  Description :  set a new Baudrate
	//
	//  Note        :
	//
	//  Arguments   :  Baudrate :  a new Baudrate to be set
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	unsigned int GetListOfSupportedBaudrates (unsigned long *pTableBaudrate, unsigned int MaxEntries, unsigned int Instance)
	{
		unsigned int MaxNumberOfBaudrates;
		unsigned int AutobaudOffset, i;
		
		pTableBaudrate = pTableBaudrate;
		
		if ( serDev[Instance].Autobaud )
		{
			AutobaudOffset = 1;
			pTableBaudrate[0] = 0UL;
		}
		else
		{
			AutobaudOffset = 0;
		}
		
		MaxNumberOfBaudrates = 10; //Sorry for add 1
		for(i=0;i<(MaxNumberOfBaudrates);i++)
		{
			*(pTableBaudrate+i+AutobaudOffset) = (1000*((unsigned long) i+1));
		}
				
		return ( MaxNumberOfBaudrates+AutobaudOffset );
	}
	
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  FlushBuffer
	//----------------------------------------------------------------------------------------
	//  Description :  set a new Baudrate
	//
	//  Note        :
	//
	//  Arguments   :  Baudrate :  a new Baudrate to be set
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void FlushBuffer (enBUFFER BufferToClear, unsigned int Instance)
	{
		BufferToClear = BufferToClear;
	}
	
	
	
	
	
	
	
	//----------------------------------------------------------------------------------------
	//
	//       F U N C T I O N S   F O R   S E R I A L  0
	//
	//----------------------------------------------------------------------------------------
	

	//----------------------------------------------------------------------------------------
	//  Function    :  ActivateFlowCtrl
	//----------------------------------------------------------------------------------------
	//  Description :  depending on function parameter activates or deativates IN-Flow Control
	//
	//  Note        :
	//
	//  Arguments   :  value :  1 :  activates Flow Control
	//                          0 :  deactivates Flow Control
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void ActivateFlowCtrl (unsigned int value)
	{
		//    V24StatusS0.InFlowActive = value;
		
		if(V24Status.CTS != value)
		{
			V24Status.CTS = value;
			
			if((serDev[CurrDialog].DCE_to_DTE == FC_HARD) || (serDev[CurrDialog].DCE_to_DTE == FC_BOTH))
			{
				//setCTS( (unsigned char) value);
			}
			
			if((serDev[CurrDialog].DCE_to_DTE == FC_SOFT) || (serDev[CurrDialog].DCE_to_DTE == FC_BOTH))
			{
				if(value)
				{
					// ---  send XOFF from CTE  ----
					bSendXOFF = 1;
				}
				else
				{
					// ---  send XON from CTE  -----
					bSendXON = 1;
				}
			}
			//?        pAppIOHndl->V24StatusCallback(V24StatusS0);
		}
	}
	
		
	//----------------------------------------------------------------------------------------
	//  Function    :  CableIn
	//----------------------------------------------------------------------------------------
	//  Description :
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void CableIn( void )
	{
		stConInfo       DevInfo;

		/*if (bCableIn == TRUE)
		{
			return;
		}*/
		bCableIn = TRUE;

		if(BFC2SAPI == sDialogDeviceHld[CurrDialog].Device)
		{
			DevInfo.Type = APP_INFO;
			DevInfo.info.AppInfo.Instance = sDialogDeviceHld[CurrDialog].DeviceInstance;
			DevInfo.info.AppInfo.EndCallback = EndCallback;
		}
		else
		{
			DevInfo.Type = NO_INFO;
		}

		// ---  inform accessories driver  ---------
		//here we start to transmit data
		//if( !ConnectSDevSApp(sDialogDeviceHld[CurrDialog].Device, GIPSY, &DevInfo) )
		if( !ConnectSDevSApp(sDialogDeviceHld[CurrDialog].Device, RCCP, &DevInfo) )
		{
			// --- connection with Gipsy failed.. --
			// --- ...only remote control  ---------
			if( !ConnectSDevSApp(sDialogDeviceHld[CurrDialog].Device, RCCP, &DevInfo) )
			{
				// ---  connection failed again  ---
				// EXIT(EXIT_NO_CONNECTION);
			}
		}
	}
	
	
	
	//----------------------------------------------------------------------------------------
	//  Function    :  CableOut
	//----------------------------------------------------------------------------------------
	//  Description :
	//
	//  Note        :
	//
	//  Arguments   :  none
	//
	//  Return      :  none
	//----------------------------------------------------------------------------------------
	void CableOut( void )
	{
		// ---  inform accessories driver  ---------
		//setDataIndication ( 0 );
		//end of data transmission
		
		if (bCableIn == FALSE)
		{
			return;
		}
		bCableIn = FALSE;

		// --- kill the connection to the application ---
		DisconnectSDev(sDialogDeviceHld[CurrDialog].Device,sDialogDeviceHld[CurrDialog].DeviceInstance);
	}		
	
	
		
	//----------------------------------------------------------------------------------------
	//  Function    :  FlwCtrlGet
	//----------------------------------------------------------------------------------------
	//  Description :  gets actual flow control state to serial monitor
	//
	//  Note        :
	//
	//  Arguments   :  pFlwCtrlDir :  pointer of Flow Control Direction
	//
	//  Return      :  kind of flow control
	//----------------------------------------------------------------------------------------
	FCMODE FlwCtrlGet(unsigned int *pFlwCtrlDir)
	{
		
		*pFlwCtrlDir = 0;
		
		if(serDev[CurrDialog].DTE_to_DCE != FC_NONE)
		{
			if(V24Status.InFlowActive)    { *pFlwCtrlDir |= 0x01; }
			if(V24Status.OutFlowActive)   { *pFlwCtrlDir |= 0x02; }
		}
		
		return serDev[CurrDialog].DTE_to_DCE;
	}

void EndCallback(unsigned int Instance, void *stEndParam, enSApp ownApp, unsigned int ownInstance)
{
	if(sDialogDeviceHld[CurrDialog].DeviceInstance!=Instance)
	{
		char Array[]="!!Problem with Endcallback!!";

		generateLogOutput(sizeof(Array),Array,sDialogDeviceHld[CurrDialog].DeviceInstance);
	}
		
	DisconnectSDev(sDialogDeviceHld[CurrDialog].Device , sDialogDeviceHld[CurrDialog].DeviceInstance );
}

} //extern "C"

