/*! \file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME mmicmdtreeh.h


.CSVERSION 1.1

.VERSION 01.17.13

.DATE 2004-07-19

.SHORT_DESCR:   interface of mmi command window

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (BS)
         Initial Version. New UserInterface of PC-MMI-Test Environment
01.00.01 2003-17-07 Walter Stroell (VIE)
         introducing MOPI_ExecuteFunction() instead of
         GbsExtEnterSimulatedPIDSection() / GbsExtLeaveSimulatedPIDSection(),
         see implemenatation of msmdev_send_accessory_msg2()
01.01.00 2003-08-11 Murat Korkmaz
         Bugfix, setfocus after mmicmd call
01.02.00 2003-09-25  Harpreet Singh (Ulm)
         resolved compile time warnings
01.03.00 2003-09-02 Marco Hahn (SAL)
         added MMS command dialog
01.04.00 2003-10-23 Murat Korkmaz
         Removing of old PC-SIMU GUI sources
01.05.00 2003-09-23 Guenther Karl (VIE)
         added MMS commonds
01.06.00 2003-10-01 Markus Schmidt (extern GOD)
         add MMS Client Debug Dialog
         remove commands of 01.30.00 (e.g. E_MMI_CMD_MMS_PDULOG_ON)
01.07.00 2003-10-27 Klaus Staudenmaier (ULM)
         Removing of the HeapView
01.08.00  2003-10-29 Harpreet Singh
          Added Memory assistant dialog in Command window
          for Java parameters
01.09.00 2003-11-04 Christoph Scharenberg (KLF)
         mec#42634 Added functionality for Java build-in applications
01.10.00 2003-11-13 Klaus Staudenmaier (ULM)
         Introduced MopiExecuteFunction for Mobile Switch off
01.10.01 2003-11-17 Zhang qi fan(PEK)
         Added localization support for SMTK
01.11.02 2003-11-24 Stefan Franke (SAL)
         Update to the new function WinMms_ShowDbgDlg instead of OpenMMSDbgDlg
01.12.00 2003-11-25 Walter Stroell (VIE)
         SMSSIM_ToggleVoiceMessage called via MOPI_ExecuteFunction
01.12.01 2003-11-28 Zhang qi fan (PEK)
         Localization support for SMTK
01.12.02 2003-12-04 Klaus Staudenmaier (ULM)
         introduced featureIsAvailable()
01.09.00  2003-10-29 Gagan Kashyap (ULM)
          Added the Accessory Commands in command window and its
          handling
01.12.04  2003-12-02 U. Mennchen
          activation of Bluetooth Dialog is now done depending on the
            define BLUETOOTH_AVAILABLE_PCMMI in btpcmmi_.h
01.12.05  2003-12-12 K. Staudenmaier (ULM)
          Removed msmdeval related code
01.12.06  2003-12-18 M. Sefcik (BTS)
          Simulation of Explicit Call Transfer added.
01.12.07  2003-12-18 Alexander Nagy (Bardenheuer SW)
          deactivated MMC Explorer Test commands MMCInserted() and MMCRemoved()
01.13.00  2004-01-20 Marcus Heintz (Bardenheuer SW)
          Test commands for SAE_S
01.13.01  2004-01-21 W. Stroell (VIE)
          bugfix - MOPI_ExecuteFunction used again for accessory MMI commands
          (WAS_SendMessageToClient)
          +++++++++++++++++++++++++++ ATTENTION! +++++++++++++++++++++
          It's mandatory to take notice of the "PCMMI guidelines"
          located at C_mopi/S_mopi/mopi/doc/mopi_pcmmi_guidelines.doc !
          +++++++++++++++++++++++++++ ATTENTION! +++++++++++++++++++++
01.13.02  2004-02-03 Marcus Heintz (Bardenheuer SW)
          Test commands for SAE_S available
01.13.03  2004-02-03 Alexander Nagy (Bardenheuer SW)
          deactivated old MMC Explorer Test menu
01.13.04  2004-02-10 M.Kremnican (BTS)
          Changes to support the msmonoff integration, night design simulation procedure
          ShowNightDesignTrigger moved here from winkcmd.cpp
01.14.00  2004-02-17 K. Staudenmaier (ULM)
          Temporary fix replaced pb_callbackSwitchOff with void SaveSIMImage
01.14.04  2004-2-19  zhang qifan(PEK)
          MMI command window clean up for only SMTK
01,14.05  2004-2-24 J. Kohmann (KLF)
          Temporary fix (pb_callbackSwitchOff) replaced again
01.15.00  2004-02-25 M.Kremnican (BTS)
          pb_callbackSwitchOff reincluded, SaveSIMImage deleted
01.15.01  2004-03-02 Alexander Nagy (Bardenheuer SW)
          activated MMC Explorer Test menu items E_MMI_CMD_MMC_Insert and E_MMI_CMD_MMC_Remove
01.15.02  2004-03-04 Alexander Nagy (Bardenheuer Software)
          check compiler flag USE_MMC_SIMU to de/activate MMC Explorer Test menu
01.15.03  2004-03-04 Zhang Jing (PEK)
          modify for SMTK emulator
01.16.00  2004-03-25 Leena Khera(SISL,India)
          Added the support for Night Deisgn Dialog in r65 PCSIMU
          Array szPatternText,szTriggerText and function ShowNightDesignTrigger modified.
01.17.00  2004-05-06 Li Yang (PEK)
          "choose network" on emulator shall update the value of "home_plmn" after selecting network in SMTK emulator.
01.17.01  2004-05-06 Zhang qi fan (PEK)
          update command items for Shaped-UI command list(SMTK emulators only)
01.17.02  2004-05-14 Murat Korkmaz
          Bug Fix home zone off -> on.
01.17.03  2004-05-17  Alexander Nagy (Bardenheuer Software)
          - removed mms simulation for MMI_MMS_AVAILABLE == 0
01.17.04  2004-05-28 Du Chun (PEK)
          Seperate SHAPED UI feature from JAVA_SDK.
01.17.05  2004-05-28 Du Chun (PEK)
          Execute SMTK phone commands in same function.
01.17.06  2004-6-16 Sun Min(PEK)
          Use new icons for commands tree .
01.17.07  2004-6-17 Fang Yunchao (PEK)
          Add UNICODE support
01.17.08  2004-06-21 Sun Min(PEK)
          Fix bug of initializing commands tree in PC_MMI
01.17.09  2004-07-06 Walter Stroell(VIE)
          ExecuteSMTKPhoneCommand() called via MOPI_ExecuteCommand() now
01.17.10  2004-07-09 Marian Kremnican (BTS)
          New command to setup the NITZ frame data added (see cmdSetupNitz() )
01.17.11  2004-07-12 Walter Stroell(VIE)
          MOPI_ExecuteCommand() from ExecuteSMTKPhoneCommand() moved to specific
          sub command
01.17.12  2004-07-13 Robert Vretska(VIE)
          add MOPI_ExecuteCommand() for simulate_sim_refresh
01.17.13  2004-07-19 Christoph Scharenberg (KLF)
          mec#89129 MOPI/Windows context fix concerning call for built-in Java applications
01.17.14  2004-07-21 Ulrich Maruhn (MCH)
          merge of version 43 with version 42, 43 is a patch of the idb from Klaus Staudenmaier   
01.17.15  2004-07-22 Marian Kremnican (BTS)
          add MOPI_ExecuteCommand() for cmdSetupNitz
01.17.16  2004-12-04 Frank Schultze (Mch)
          Use MOPI_ExecuteFunction to start Java application
01.17.17  2005-01-26 Li Yang (PEK)
          add new item MPM Connection in Command list Window

**************************************Jerry*********************************
02.00.00  2006-03-17  Gurpreet Sabharwal(SISL ,India)
                      Removed Java Support And Functionality





*/

#include "mmiconf.h"

#include "smsafxh.h"
#include "simuapph.h"
#include "mmicmdtreeh.h"

// MPM Connection//
#import "SPhoneObserver.tlb" no_namespace   
#include <windows.h>                        
#include <stdio.h>                          
#include "psapi.h"                          



#include "smsafxh.h"

extern "C"
{
#include <global.h>
#include "llisth.h"
#include "listview.h"
}

#include <stdlib.h>
#include <stdio.h>
#include "winmain.h"
#include "winrc.h"
#include "simsimh.h"
//#include "upsimh.h"

#ifdef JAVA_SDK
extern "C"{
#include "Sim_al.h"
}
#endif

extern "C"
{
#include "gbs.h"
#include "gbsext.h"
#include "mopiext.h"
#include "msmsim.h"
#include "msmonoff.h"
#include "msmlow.h"
#include "mmsim.h"
#include "mmi.h"
#include "aoc_al.h"
#include "power_al.h"
#include "ck_data.h"
#include "ataldech.h"
#include "apptoolk.h"
#include "sms_simh.h"
#include "ck_data.h"
#include "ck_port.h"
#include "ck_state.h"
#include "mmiconf.h"


#ifdef MMI_NIGHTDESIGN_AVAILABLE
#include "msmled.h"
#endif

//#include "ob_tcp.h"

#include "skviewh.h"

#include "blackberry.h"
#if BLACKBERRY_AVAILABLE > 0
    #include "blackberrydlg.h"
#endif
//#include "jenv.h"   //JAVA
#include "sim_regh.h"

#include "accdefs.h"

// following includes needed for Simulation of Carkit GPS
// JLehmann: This is not the suitable file for this Carkit Simulation!!!
#include "xai_user.h"
#include "xauserh.h"
#include "adaclogh.h"
#include "mm_al.h"

// SyncML
#include "sa_mainh.h"

//-- SAE_S--MOBSIM ---------------------------------------------------------
#include "sae_s_h.h"




#define SERIAL_1    1
// previous includes needed for Simulation of Carkit GPS


#ifdef MMI_BROWSER_AVAILABLE
#undef MMI_BROWSER_AVAILABLE
#endif
#define MMI_BROWSER_AVAILABLE 0



#if MMI_VOICEDIAL_AVAILABLE
    #include "procid.h"
    #include "wrecog.h"
    WordID GetVoiceDialId( void );
    #define VD_PID MMI_PID
#endif

#include "browser_sim.h"

#include "btoothf.h"

#define DBG_DEBUGGING_ACTIVE OFF // TODO: set to OFF before put
#include "debug.h"

unsigned char tempPlmn[5];

/* header included by niharika */
#include "sms_res.h"
#include "laihlib.h"
#include "mm_al.h"
#include "mmalmm.h"
#include "choosenet.h"
#include "setupnitz.h"
#include "AlarmSetDlgh.h"

#include "fsuiinfoh.h"
#include "mmi_msg.h"
#include "was.h"


#include "simjava.h"
#include "simjappworldclock.h"
#include "simjappstartupassistant.h"
#include "aumamon.h"

// mms debug dialog header
#if MMI_MMS_AVAILABLE
extern "C"
{
    #include "winmms.h"
}
#endif //#if MMI_MMS_AVAILABLE

/* Bluetooth include by U. Mennchen */
#include "btpcmmi_.h"

/*
 *  defines
 */

#define CMD_WINDOW_TOP_POS_PERCENTAGE       0.025
#define CMD_WINDOW_VERT_SIZE_PERCENTAGE     0.95
#define CMD_WINDOW_PIXEL_PER_COMMAND_LINE   20
#define MMI_WINDOW_TOP_POS                  100

#define CARKIT_GPS_LOGO_TIMER       1
#define CARKIT_BTN_LONG_PRESS_TIMER 2

void RemoteLock(void);
void RemoteUnlock(void);
void TKRefresh(void);
void PhonebookRefresh(void);
void TKEventDownload(void);
void SSSIM_USSDNotify (void);
void SSSIM_USSDRequest (void);
//extern void SendDaDiConfigChange( void );
extern HWND DispGetWinHandle(void);
void open_cbs_message_box( void );
void open_rc_command_dialog (void );
void EnipCommandWindowInit(void);
void open_feature_window(void);
void open_accessory_window(void);
void disconnect_accessory(void);
extern void OpenOmaMonitorDialog( void );

void MSMAL_CreateParserDokumentation (void);
extern void AOC_AL_ChargingNowActive( void );
#if MMI_PROFILES_AVAILABLE
extern void ProfileAL_PCSIMU_Init( void );
#endif
#if MMI_VOICEDIAL_AVAILABLE
void SendVoiceDialMessage(int selindex);
#endif

#ifdef MMI_NIGHTDESIGN_AVAILABLE
void open_nightdesign_window(void);
void MsmLed_ClearCurrentPattern(t_LED_EnumFunction Trigger);
void MsmLed_SetNextPattern(t_LED_EnumFunction Trigger);
#endif

// MMC Explorer Test commands
#include "mmc_cfg_simu.h"
#if USE_MMC_SIMU
extern "C" void Simu_Mmc_NotifyInsert( UINT32 fParam ) ;
extern "C" void Simu_Mmc_NotifyRemove( UINT32 fParam );
#endif

extern "C" void WAS_UpdatePayLoadData(unsigned int);
extern "C" void WAS_SendMessageToClient(T_MOPI_MsgId);

}

void WAS_SendMessageToClient_Mopi(UINT32 param )
{
    WAS_SendMessageToClient( (T_MOPI_MsgId)param );
}

void open_IrDA_command_dialog(void);
bool featureIsAvailable( void );
void open_Wire_command_dialog (void);
static void OpenAuMaMon(void);

extern HWND GetMMIDispHandle(void);
// following externals needed for Simulation of Carkit GPS
extern unsigned int crc_error;
extern bool sending_allowed;
extern bool transfer_finished;
static char mg_Filename[ 128];
static char mg_UrlName[ 128-5];
static UINT32 save_sim_image_when_switching_off;

#ifdef LOCALIZATION_SUPPORT
#include "localizationapi.h"//KZ added it
void ChangeUILanguageOption(void);
#endif

extern T_MMI_CMD_Entry array_SMTK_MMI_CMD_Entries[];
extern void RunTimeHeapInfo();

//MPM Connection//
extern BOOL InitMPMWire(void);
extern void CloseMPMWire(void);
extern int MPMConnectState;
extern int WireSimuState;
extern unsigned int MPMWirePort;
void startMPMConnection();  
extern "C" BOOL CheckMPMProcess();
extern "C" void ExitMPMConnectionProcess();
int CheckMPMProcessName(DWORD processID);


void FilesystemNotifyNoFreeSpace()
{

//    GbsPostMessageP2( MMI_PID, FS_NOTIFICATION, FS_SN_NoFreeSpace, 0, 0 );
}


void FilesystemNotifyFreeSpace()
{
 
//    GbsPostMessageP2( MMI_PID, FS_NOTIFICATION, FS_SN_FreeSpace, 0, 0 );
}



static void cmd_save_simsim_data( void )
{
    psimsim->save_new_img();
}

static void cmd_set_csp_state_false( void )
{
    MMI_SetCSPState(False);
}

static void OpenAlarmDlg( void )
{
    // opens the dialog for changing all alarm related settings
    static CAlarmSetDlg* pDlg=NULL;

    if(pDlg)
    {
        // dialog already open, maybe hidden
        pDlg->ShowWindow(SW_SHOW);
        return;
    }

    pDlg=new CAlarmSetDlg;

    if(pDlg)
    {
        pDlg->Create(IDD_ALARM_SETTINGS, NULL);
        pDlg->ShowWindow(SW_SHOW);
    }
}

static void OpenAuMaMon(void)
{
    CAuMaMonDlg* pDlg=NULL;
    if(pDlg)
    {
        //dialog already open, maybe hidden
        pDlg->ShowWindow(SW_SHOW);
        return;
    }
    pDlg=new CAuMaMonDlg;

    if(pDlg)
    {
        pDlg->Create(IDD_AUMAMON_DIALOG,NULL);
        pDlg->ShowWindow(SW_SHOW);
    }
}

#if BLACKBERRY_AVAILABLE > 0
static void OpenBlackBerryDlg( void )
{
    // opens the dialog for BlackBerry
    static CBlackBerryDlg* pBbDlg=NULL;

    if(pBbDlg)
    {
        // dialog already open, maybe hidden
        pBbDlg->ShowWindow(SW_SHOW);
        return;
    }

    pBbDlg=new CBlackBerryDlg;

    if(pBbDlg)
    {
        pBbDlg->Create(IDD_BLACKBERRY_DLG, NULL);
        pBbDlg->ShowWindow(SW_SHOW);
    }
}
#endif


/*
 *  Just a wrapper for MOPI_ExecuteFunction
 */

void startApp (UINT32 par)
{
    char * path = (char *) par;
  
  //  Kauai_Start (path, TRUE);
}

//----------------------------------------------------------------
void startJavaApplication(void)
{
    static OPENFILENAMEA  ofn;
    static char          classpath   [ _MAX_PATH];
    static char          ReturnedFile[ _MAX_PATH];
    int                  result;
    static bool          DirInit= FALSE;

    ReturnedFile[0]     = '\0';

    if ( DirInit == FALSE)
    {
        ReadSimulatorRegistryString( "KJAVA_CLASSPATH", (char*) &classpath, &result);

        //get the first path of classpath
        if (result == 0)
        {
            char *tmp = strchr(classpath, ';');
            if (tmp)
                *tmp = 0;
        }

        //fill in the data for the file selector
        memset( &ofn, 0, sizeof( OPENFILENAME));
        ofn.lStructSize     = sizeof( OPENFILENAME);
        ofn.lpstrFilter     = "Java applications (.class; .jar; .jad)\0*.class; *.jar; *.jad\0\0";
        ofn.lpstrFile       = ReturnedFile;
        ofn.lpstrInitialDir = classpath;                //NULL;
        ofn.nMaxFile        = sizeof( ReturnedFile);
        ofn.lpstrTitle      = "Start Java Application";
        ofn.Flags           = OFN_FILEMUSTEXIST | OFN_LONGNAMES;
#ifdef JAVA_SDK
        ofn.hwndOwner       = AfxGetApp()->m_pMainWnd->m_hWnd;
#endif
        DirInit= TRUE;
    }
    else
    {
        ofn.lpstrInitialDir = ReturnedFile;             // = NULL = last directory
    }

    if( GetOpenFileNameA( &ofn))
    {
        MOPI_ExecuteFunction(MMI_PID, startApp, (UINT32) ReturnedFile);
    }

    BringWindowToTop( GetMMIDispHandle() );
}

static void cmdSetupNitz()
{
    CSetupNitz dlgSetupNitz;
    if(dlgSetupNitz.DoModal()==IDOK)
    {
        dlgSetupNitz.UpdateNitzInfos();
    }
}

/* function defined by niharika */
static void cmdChooseNetwork()
{
     UINT16 lac;

    CChooseNet objChooseNet;
    if(objChooseNet.DoModal()==IDOK)
    {
        LAILIB_ascii2code(tempPlmn,(LPSTR)(LPCTSTR)objChooseNet.m_strMCC,(LPSTR)(LPCTSTR)objChooseNet.m_strMNC);
    lac = _ttoi(objChooseNet.m_strLAC);
        tempPlmn[3] = (lac >> 8) & 0xFF;
        tempPlmn[4] = lac & 0xFF;

        MMAL_service_change_indication(MM_FULL_SERVICE, 0, tempPlmn );

#ifdef JAVA_SDK
    memcpy(sim_data_al.home_plmn,tempPlmn,sizeof(sim_data_al.home_plmn));
#endif

    }
}
#ifndef JAVA_SDK

static void JAppCallMemoryAssistant_Mopi( UINT32 param )
{
    CSimJava * pMemoryAssistantDialog = (CSimJava*)param;
    AUTO_pWSTRINGSAFE( Buffer, EMAXPATH );

    pMemoryAssistantDialog->GetApplicationPath( pBuffer );
    
//    JavaApplications_StartMemoryAssistantByPath( pMemoryAssistantDialog->GetApplicationMemoryLimit(), pBuffer );
}

static void OpenJappDialogMemoryAssistant()
{
    // This variable must be 'static' to keep it in memory after termination of this function.
    // It will be referenced when JAppCallMemoryAssistant_Mopi() is execute but this will
    // happen asynchronously: the function passed to MOPI_ExecuteFunction() will be scheduled
    // for deferred execution.
    static CSimJava MemoryAssistantDialog;

    if(MemoryAssistantDialog.DoModal() == IDOK)
    {
        // Asynchronous execution of passed function!
        MOPI_ExecuteFunction( NO_PROCESS_PID, JAppCallMemoryAssistant_Mopi,
                              (UINT32)(&MemoryAssistantDialog) );
        return;
    }
}
static void JAppCallWorldClock_Mopi( UINT32 param )
{

  //  JavaApplications_StartWorldClock( (T_JavaApplications_WorldClockMode)param );
}

static void OpenJAppDialogWorldClock()
{
    SimJAppWorldClock WorldClockDialog;

    if (WorldClockDialog.DoModal() == IDOK)
    {
        // Asynchronous execution of passed function!    
        
     //   MOPI_ExecuteFunction( NO_PROCESS_PID, JAppCallWorldClock_Mopi,
   //                           (UINT32)WorldClockDialog.GetMode() );
        return;
    }
}


static void JAppCallStartUpAssistant_Mopi( UINT32 param )
{
//    JavaApplications_StartStartUpAssistant( (int)param );
}

static void OpenJAppDialogStartUpAssistant()
{
    SimJAppStartUpAssistant StartUpAssistantDialog;

    if (StartUpAssistantDialog.DoModal() == IDOK)
    {
        // Asynchronous execution of passed function!
        MOPI_ExecuteFunction( NO_PROCESS_PID, JAppCallStartUpAssistant_Mopi,
                              (UINT32)StartUpAssistantDialog.GetFlagVector() );
        return;
    }
}


static void JAppCallCalculator_Mopi( UINT32 param )
{
 
 //   JavaApplications_StartCalculator();
}

static void JAppCallCalculator()
{
    // Asynchronous execution of passed function!
    MOPI_ExecuteFunction( NO_PROCESS_PID, JAppCallCalculator_Mopi, 0 );
}


static void JAppCallUnitConverter_Mopi( UINT32 param )
{

//    JavaApplications_StartUnitConverter();
}

static void JAppCallUnitConverter()
{
    // Asynchronous execution of passed function!
    MOPI_ExecuteFunction( NO_PROCESS_PID, JAppCallUnitConverter_Mopi, 0 );
}
#endif

//Du Chun, Execute the SMTK phone Commands in one function.
extern int GetSizeofSMTKMPCmd();
void ExecuteSMTKPhoneCommand(E_MMI_COMMANDS E_MMI_CMD);


/*!\var array_MMI_CMD_Entries
 *  Array of \ref struct_T_MMI_CMD_Entry
 */
static T_MMI_CMD_Entry array_MMI_CMD_Entries[]=
{
    //Command Name,                                    Command Tooltip,
    //Image closed,                                    Image opened,
    //Command Enum,                                    additional check command pointer

    {IDS_MMI_CMD_MSM_COMMANDS,                         IDS_MMI_CMD_MSM_COMMANDS_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_MSM_MOBILE_TERMINATING_CALL,          IDS_MMI_CMD_MSM_MOBILE_TERMINATING_CALL_TOOLTIP,
     IMG_RECEIVING_CALL,                               IMG_RECEIVING_CALL,
     E_MMI_CMD_MSM_Mobile_Terminating_Call,            featureIsAvailable},

    {IDS_MMI_CMD_MSM_DISCONNECT_CALL_BY_NET,           IDS_MMI_CMD_MSM_DISCONNECT_CALL_BY_NET_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MSM_Disconnect_Call_by_Net,         featureIsAvailable},
#ifndef JAVA_SDK
    {IDS_MMI_CMD_MSM_INTERRUPT_CALL_REEST_PROC,        IDS_MMI_CMD_MSM_INTERRUPT_CALL_REEST_PROC_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MSM_Interrupt_Call_Reest_Proc,      featureIsAvailable},
#endif
     {IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_ON_OFF,    IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_ON_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_disconnect_progress_is_on_off,  msm_sim_disc_progress_clear_is_pos},

    {IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_OFF_ON,    IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_disconnect_progress_is_off_on,  msm_sim_disc_progress_set_is_pos},

    {IDS_MMI_CMD_MOC_RELEASE_WITH_BUSY_IS_ON_OFF,      IDS_MMI_CMD_MOC_RELEASE_WITH_BUSY_IS_ON_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_release_with_busy_is_on_off,    msm_sim_MOC_busy_clear_is_pos},

    {IDS_MMI_CMD_MOC_RELEASE_WITH_BUSSY_IS_OFF_ON,     IDS_MMI_CMD_MOC_RELEASE_WITH_BUSSY_IS_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_release_with_busy_is_off_on,    msm_sim_MOC_busy_set_is_pos},

    {IDS_MMI_CMD_MOC_CCBS_IS_SUPPORTED_OFF,            IDS_MMI_CMD_MOC_CCBS_IS_SUPPORTED_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_CCBS_is_supported_off,          msm_sim_CCBS_clear_is_pos},

    {IDS_MMI_CMD_MOC_CCBS_IS_NOT_SUPPORTED_ON,         IDS_MMI_CMD_MOC_CCBS_IS_NOT_SUPPORTED_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MOC_CCBS_is_not_supported_on,       msm_sim_CCBS_set_is_pos},
#ifndef JAVA_SDK
    {IDS_MMI_CMD_HZ_HOMEZONE_ON_OFF,                   IDS_MMI_CMD_HZ_HOMEZONE_ON_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_HZ_Homezone_on_off,                 NULL},

    {IDS_MMI_CMD_HZ_HOMEZONE_OFF_ON,                   IDS_MMI_CMD_HZ_HOMEZONE_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_HZ_Homezone_off_on,                 NULL},
#endif
    {IDS_MMI_CMD_MSM_EXPLICIT_CALL_TRANSFER,           IDS_MMI_CMD_MSM_EXPLICIT_CALL_TRANSFER_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_Explicit_Call_Transfer,             featureIsAvailable},

// CBS: Send CBS - Message
#ifndef JAVA_SDK
    {IDS_MMI_CMD_CBS_SEND_CBS_MESSAGE,                 IDS_MMI_CMD_CBS_SEND_CBS_MESSAGE_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_CBS_Send_CBS_Message,                   NULL},
#endif // JAVA_SDK

// MM Services
    {IDS_MMI_CMD_MM_SERVICES,                          IDS_MMI_CMD_MM_SERVICES_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE ,                         IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_MM_NO_SERVICE,                        IDS_MMI_CMD_MM_NO_SERVICE_TOOLTIP,
     IMG_NO_SERVICE,                                   IMG_NO_SERVICE,
     E_MMI_CMD_MM_No_Service,                          NULL},
#ifndef JAVA_SDK
    {IDS_MMI_CMD_MM_LIMITED_SERVICE,                   IDS_MMI_CMD_MM_LIMITED_SERVICE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MM_Limited_Service,                     NULL},
#endif
    {IDS_MMI_CMD_MM_FULL_SERVICE,                      IDS_MMI_CMD_MM_FULL_SERVICE_TOOLTIP,
     IMG_FULL_SERVICE,                                 IMG_FULL_SERVICE,
     E_MMI_CMD_MM_Full_Service,                        NULL},

#ifndef JAVA_SDK
    {IDS_MMI_CMD_MM_AVAILABLE_PLMN_INDICATION,         IDS_MMI_CMD_MM_AVAILABLE_PLMN_INDICATION_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MM_Available_PLMN_Indication,           NULL},

    {IDS_MMI_CMD_MM_PLMN_SCANN_REJECT,                 IDS_MMI_CMD_MM_PLMN_SCANN_REJECT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MM_PLMN_Scann_Reject,                   NULL},

// ACCESSORY
    {IDS_MMI_CMD_ACCESSORY_CONNECT_DISCONNECT,         IDS_MMI_CMD_ACCESSORY_CONNECT_DISCONNECT_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_DISCONNECT_ACCESSORY,                 IDS_MMI_CMD_DISCONNECT_ACCESSORY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Disconnect_Accessory,                   NULL},

    {IDS_MMI_CMD_CONNECT_CARKIT_COMFORT_VOICE,                 IDS_MMI_CMD_CONNECT_CARKIT_COMFORT_VOICE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Carkit_Comfort_Voice,           NULL},

    {IDS_MMI_CMD_CONNECT_CARKIT_COMFORT,                 IDS_MMI_CMD_CONNECT_CARKIT_COMFORT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Carkit_Comfort,                   NULL},

    {IDS_MMI_CMD_CONNECT_CARKIT_PROF_BT,                 IDS_MMI_CMD_CONNECT_CARKIT_PROF_BT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Carkit_Prof_Bt,                 NULL},

    {IDS_MMI_CMD_CONNECT_CARKIT_LINEFIT,                 IDS_MMI_CMD_CONNECT_CARKIT_LINEFIT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Carkit_Linefit,                 NULL},

    {IDS_MMI_CMD_CONNECT_CARKIT_PORTABLE,                 IDS_MMI_CMD_CONNECT_CARKIT_PORTABLE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Carkit_Portable,                NULL},

    {IDS_MMI_CMD_CONNECT_HEADSET_MONO,                 IDS_MMI_CMD_CONNECT_HEADSET_MONO_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Headset_Mono,                   NULL},

    {IDS_MMI_CMD_CONNECT_HEADSET_STEREO,               IDS_MMI_CMD_CONNECT_HEADSET_STEREO_TOOLTIP,
      IMG_WINDOW_RED,                                  IMG_WINDOW_RED,
     E_MMI_CMD_Connect_Headset_Stereo,                 NULL},


#endif // JAVA_SDK

// POWER //
    {IDS_MMI_CMD_POWER,                                IDS_MMI_CMD_POWER_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_END_LOW_POWER,                        IDS_MMI_CMD_END_LOW_POWER_TOOLTIP,
     IMG_END_LOW_POWER,                                IMG_END_LOW_POWER,
     E_MMI_CMD_Power_End_Low_Power,                    NULL},

    {IDS_MMI_CMD_BEGIN_LOW_POWER,                      IDS_MMI_CMD_BEGIN_LOW_POWER_TOOLTIP,
     IMG_BEGIN_LOW_POWER,                              IMG_BEGIN_LOW_POWER,
     E_MMI_CMD_Power_Begin_Low_Power,                  NULL},

#ifndef JAVA_SDK
// AOC Commands //
    {IDS_MMI_CMD_AOC_COMMANDS,                         IDS_MMI_CMD_AOC_COMMANDS_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

     {IDS_MMI_CMD_AOC_ACTIVE,                          IDS_MMI_CMD_AOC_ACTIVE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_AOC_active,                             NULL},

     {IDS_MMI_CMD_AOC_WARNINGS,                        IDS_MMI_CMD_AOC_WARNINGS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_AOC_Warnings,                           NULL},

// Audio //
    {IDS_MMI_CMD_AUDIO_COMMANDS,                       IDS_MMI_CMD_AUDIO_COMMANDS_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

     {IDS_MMI_CMD_AUDIO_COMMANDS_SHOW_AUMAMON,         IDS_MMI_CMD_AUDIO_COMMANDS_SHOW_AUMAMON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_AUMA_ShowPanel,                         NULL},

// CK Commands //
    {IDS_MMI_CMD_CK_COMMANDS,                          IDS_MMI_CMD_CK_COMMANDS_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_CK_REFRESH,                           IDS_MMI_CMD_CK_REFRESH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_CK_Refresh,                             NULL},

    {IDS_MMI_CMD_CK_PHONEBOOK_REFRESH,                 IDS_MMI_CMD_CK_PHONEBOOK_REFRESH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_CK_Phonebook_Refresh,                   NULL},

    {IDS_MMI_CMD_CK_SIM_ROM_ACTIVATION,                IDS_MMI_CMD_CK_SIM_ROM_ACTIVATION_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_CK_Sim_Rom_Activation,                  NULL},

    {IDS_MMI_CMD_CK_SAVE_SIM_IMAGE,                    IDS_MMI_CMD_CK_SAVE_SIM_IMAGE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_CK_Save_SIM_Image,                      NULL},

// SAT: Toolkit Commands //
    {IDS_MMI_CMD_SAT_TOOLKIT_COMMANDS,                 IDS_MMI_CMD_SAT_TOOLKIT_COMMANDS_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_00_SOFT_REFRESH,          IDS_MMI_CMD_SAT_TOOLKIT_00_SOFT_REFRESH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_00_soft_refresh,                        NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_01_HARD_REFRESH,          IDS_MMI_CMD_SAT_TOOLKIT_01_HARD_REFRESH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_01_hard_refresh,                        NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_02_MORE_TIME,             IDS_MMI_CMD_SAT_TOOLKIT_02_MORE_TIME_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_02_more_time,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_03_PLAY_TONE,             IDS_MMI_CMD_SAT_TOOLKIT_03_PLAY_TONE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_03_play_tone,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_04_DISPLAY_TEXT_1,        IDS_MMI_CMD_SAT_TOOLKIT_04_DISPLAY_TEXT_1_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_04_display_text1,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_05_DISPLAY_TEXT_2,        IDS_MMI_CMD_SAT_TOOLKIT_05_DISPLAY_TEXT_2_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_05_display_text2,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_06_DISPLAY_TEXT_3,        IDS_MMI_CMD_SAT_TOOLKIT_06_DISPLAY_TEXT_3_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_06_display_text3,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_07_DISPLAY_TEXT_4,        IDS_MMI_CMD_SAT_TOOLKIT_07_DISPLAY_TEXT_4_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_07_display_text4,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_08_GET_INKEY,             IDS_MMI_CMD_SAT_TOOLKIT_08_GET_INKEY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_08_get_inkey,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_09_RESPONSE,              IDS_MMI_CMD_SAT_TOOLKIT_09_RESPONSE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_09_response,                            NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_10_SET_UP_IDLE_MODE_TEXT, IDS_MMI_CMD_SAT_TOOLKIT_10_SET_UP_IDLE_MODE_TEXT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_10_set_up_idle_mode_text,               NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_11_CALL_CONTROL_1,        IDS_MMI_CMD_SAT_TOOLKIT_11_CALL_CONTROL_1_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_11_call_control_1,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_12_CALL_CONTROL_2,        IDS_MMI_CMD_SAT_TOOLKIT_12_CALL_CONTROL_2_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_12_call_control_2,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_13_CALL_CONTROL_3,        IDS_MMI_CMD_SAT_TOOLKIT_13_CALL_CONTROL_3_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_13_call_control_3,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_14_CALL_CONTROL_4,        IDS_MMI_CMD_SAT_TOOLKIT_14_CALL_CONTROL_4_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_14_call_control_4,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_15_CALL_CONTROL_5,        IDS_MMI_CMD_SAT_TOOLKIT_15_CALL_CONTROL_5_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_15_call_control_5,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_16_GET_INPUT,             IDS_MMI_CMD_SAT_TOOLKIT_16_GET_INPUT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_16_get_input,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_17_POLL_INTERVAL,         IDS_MMI_CMD_SAT_TOOLKIT_17_POLL_INTERVAL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_17_poll_interval,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_18_POLLING_OFF,           IDS_MMI_CMD_SAT_TOOLKIT_18_POLLING_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_18_polling_off,                         NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_19_PROVIDE_LOCAL_INFO,    IDS_MMI_CMD_SAT_TOOLKIT_19_PROVIDE_LOCAL_INFO_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_19_provide_local_info,                  NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_20_SET_UP_MENU,           IDS_MMI_CMD_SAT_TOOLKIT_20_SET_UP_MENU_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_20_set_up_menu,                         NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_21_SET_UP_EVENT_LIST,     IDS_MMI_CMD_SAT_TOOLKIT_21_SET_UP_EVENT_LIST_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_21_set_up_event_list,                   NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_22_SELECT_ITEM,           IDS_MMI_CMD_SAT_TOOLKIT_22_SELECT_ITEM_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_22_select_item,                         NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_23_SEND_SMS,              IDS_MMI_CMD_SAT_TOOLKIT_23_SEND_SMS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_23_send_SMS,                            NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_24_SEND_SS,               IDS_MMI_CMD_SAT_TOOLKIT_24_SEND_SS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_24_send_SS,                             NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_25_SET_UP_CALL,           IDS_MMI_CMD_SAT_TOOLKIT_25_SET_UP_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_25_set_up_call,                         NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_26_SEND_USSD,             IDS_MMI_CMD_SAT_TOOLKIT_26_SEND_USSD_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_26_send_USSD,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_27_SET_UP_EVENT_LIST,     IDS_MMI_CMD_SAT_TOOLKIT_27_SET_UP_EVENT_LIST_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_27_set_up_event_list,                   NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_28_TIMER_MANAGEMENT,      IDS_MMI_CMD_SAT_TOOLKIT_28_TIMER_MANAGEMENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_28_timer_management,                    NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_29_LAUNCH_BROWSER,        IDS_MMI_CMD_SAT_TOOLKIT_29_LAUNCH_BROWSER_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_29_launch_browser,                      NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_30_LANGUAGE_NOTIFICATION, IDS_MMI_CMD_SAT_TOOLKIT_30_LANGUAGE_NOTIFICATION_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_30_language_notification,               NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_31_TKT_FILE_REFERENCE,    IDS_MMI_CMD_SAT_TOOLKIT_31_TKT_FILE_REFERENCE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_31_TKT_file_reference,                  NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_32_OPEN_CHANNEL,          IDS_MMI_CMD_SAT_TOOLKIT_32_OPEN_CHANNEL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_32_Open_Channel,                        NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_33_SEND_DATA,             IDS_MMI_CMD_SAT_TOOLKIT_33_SEND_DATA_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_33_Send_Data,                           NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_34_RECEIVE_DATA,          IDS_MMI_CMD_SAT_TOOLKIT_34_RECEIVE_DATA_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_34_Receive_Data,                        NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_35_CLOSE_CHANNEL,         IDS_MMI_CMD_SAT_TOOLKIT_35_CLOSE_CHANNEL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_35_Close_Channel,                       NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_36_GET_CHANNEL_STATUS,    IDS_MMI_CMD_SAT_TOOLKIT_36_GET_CHANNEL_STATUS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_36_Get_Channel_Status,                  NULL},

    {IDS_MMI_CMD_SAT_TOOLKIT_EVENT_DOWNLOAD,           IDS_MMI_CMD_SAT_TOOLKIT_EVENT_DOWNLOAD_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Event_Download,                         NULL},

// Internet Browser
    {IDS_MMI_CMD_UP_BROWSER_COMMANDS,                  IDS_MMI_CMD_UP_BROWSER_COMMANDS_TOOLTIP,
    IMG_FOLDER_ORANGE_CLOSE,                           IMG_FOLDER_ORANGE_OPEN,
    E_MMI_CMD_NoCommand,                               NULL},

    {IDS_MMI_CMD_BROWSERACTIVATE,                      IDS_MMI_CMD_BROWSERACTIVATE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_BrowserActivate,                        NULL},

    {IDS_MMI_CMD_TERMINATE_BROWSER,                    IDS_MMI_CMD_TERMINATE_BROWSER_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Browser_Terminate,                      NULL},

    {IDS_MMI_CMD_LOAD_CONTENT,                         IDS_MMI_CMD_LOAD_CONTENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Browser_LoadContent,                    NULL},

    {IDS_MMI_CMD_RUN_UNIT_TESTS,                       IDS_MMI_CMD_RUN_UNIT_TESTS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Browser_RunUnitTests,                   NULL},



/*#if MMI_BROWSER_AVAILABLE > 0
// UP.Browser: Commands //
    {IDS_MMI_CMD_UP_BROWSER_COMMANDS,                  IDS_MMI_CMD_UP_BROWSER_COMMANDS_TOOLTIP,
    IMG_FOLDER_ORANGE_CLOSE,                           IMG_FOLDER_ORANGE_OPEN,
    E_MMI_CMD_NoCommand,                               NULL},

    {IDS_MMI_CMD_ACTIVATE,                             IDS_MMI_CMD_ACTIVATE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Activate,                               NULL},

    {IDS_MMI_CMD_TERMINATE,                            IDS_MMI_CMD_TERMINATE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Terminate,                              NULL},

    {IDS_MMI_CMD_LOAD_CONTENT,                         IDS_MMI_CMD_LOAD_CONTENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Load_Content,                           NULL},

    {IDS_MMI_CMD_SEND_ALERT,                           IDS_MMI_CMD_SEND_ALERT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_Alert,                             NULL},

    {IDS_MMI_CMD_REMOVE_ALERT,                         IDS_MMI_CMD_REMOVE_ALERT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Remove_Alert,                           NULL},

    {IDS_MMI_CMD_NO_SECURITY,                          IDS_MMI_CMD_NO_SECURITY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_No_security,                            NULL},

    {IDS_MMI_CMD_SECURITY_CLASS_1,                     IDS_MMI_CMD_SECURITY_CLASS_1_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Security_Class_1,                       NULL},

    {IDS_MMI_CMD_SECURITY_CLASS_2,                     IDS_MMI_CMD_SECURITY_CLASS_2_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Security_Class_2,                       NULL},

    {IDS_MMI_CMD_SEND_PROVSM,                          IDS_MMI_CMD_SEND_PROVSM_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_ProvSM,                            NULL},

    {IDS_MMI_CMD_SEND_WAP_OTAP,                        IDS_MMI_CMD_SEND_WAP_OTAP_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_WAP_OTAP,                          NULL},
#endif // MMI_BROWSER_AVAILABLE
*/

#if USE_MMC_SIMU
// MMC Explorer: Tests //
     {IDS_MMI_CMD_MMC_EXPLORER_TESTS,                  IDS_MMI_CMD_MMC_EXPLORER_TESTS_TOOLTIP,
    IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
    E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_MMC_INSERT,                          IDS_MMI_CMD_MMC_INSERT_TOOLTIP,
    IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
    E_MMI_CMD_MMC_Insert,                             NULL},

    {IDS_MMI_CMD_MMC_REMOVE,                          IDS_MMI_CMD_MMC_REMOVE_TOOLTIP,
    IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
    E_MMI_CMD_MMC_Remove,                             NULL},
/*
   {IDS_MMI_CMD_GET_ENTRIES_SIZES,                     IDS_MMI_CMD_GET_ENTRIES_SIZES_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Get_Entries_Sizes,                      NULL},

   {IDS_MMI_CMD_READ_DIRECTORY,                        IDS_MMI_CMD_READ_DIRECTORY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Read_Directory,                         NULL},

   {IDS_MMI_CMD_READ_WRITE_FILES,                      IDS_MMI_CMD_READ_WRITE_FILES_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Read_Write_Files,                       NULL},

   {IDS_MMI_CMD_MMC_SELECT_FILE_W,                     IDS_MMI_CMD_MMC_SELECT_FILE_W_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMC_Select_File_W,                      NULL},

   {IDS_MMI_CMD_MMC_SELECT_FOLDER_W,                   IDS_MMI_CMD_MMC_SELECT_FOLDER_W_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMC_Select_Folder_W,                    NULL},

   {IDS_MMI_CMD_MMC_SAVE_AS_COPY,                      IDS_MMI_CMD_MMC_SAVE_AS_COPY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMC_Save_As_Copy,                       NULL},

   {IDS_MMI_CMD_MMC_SAVE_AS_MOVE,                      IDS_MMI_CMD_MMC_SAVE_AS_MOVE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMC_Save_As_Move,                       NULL},
*/
#endif //#if USE_MMC_SIMU

// MMI: No CSP //
    {IDS_MMI_CMD_MMI_NO_CSP,                           IDS_MMI_CMD_MMI_NO_CSP_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_MMI_No_CSP,                             NULL},
#endif // JAVA_SDK

// SMS Commands //
    {IDS_MMI_CMD_SMS_COMMANDS,                         IDS_MMI_CMD_SMS_COMMANDS_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_SMS_INCOMMING_SMS,                    IDS_MMI_CMD_SMS_INCOMMING_SMS_TOOLTIP,
     IMG_SHORTMESSAGES,                                IMG_SHORTMESSAGES,
     E_MMI_CMD_SMS_Incoming_Short_Message,             NULL},
#ifndef JAVA_SDK
    {IDS_MMI_CMD_SMS_IMMEDIATE_MESSAGE,                IDS_MMI_CMD_SMS_IMMEDIATE_MESSAGE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SMS_Immediate_Message,                  NULL},

    {IDS_MMI_CMD_SMS_SATUS_REPORT,                     IDS_MMI_CMD_SMS_SATUS_REPORT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SMS_Status_Report,                      NULL},

    {IDS_MMI_CMD_SMS_TOGGLE_VOICE_MESSAGE,             IDS_MMI_CMD_SMS_TOGGLE_VOICE_MESSAGE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SMS_Toggle_Voice_Message,               NULL},
#endif
//#ifndef JAVA_SDK
// EMS Commands //
    {IDS_MMI_CMD_EMS_COMMANDS,                         IDS_MMI_CMD_EMS_COMMANDS_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_EMS_BUILD_INCOMMING_SMS,              IDS_MMI_CMD_EMS_BUILD_INCOMMING_SMS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_EMS_Build_Incoming_Short_Message,       NULL},

    {IDS_MMI_CMD_EMS_SEND_NEXT_SEGMENT,                IDS_MMI_CMD_EMS_SEND_NEXT_SEGMENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_EMS_Send_Next_Segment_of_EMS_Message,   NULL},
#ifndef JAVA_SDK
// SS Commands //
    {IDS_MMI_CMD_SS_COMMANDS,                          IDS_MMI_CMD_SS_COMMANDS_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_SS_USSD_NOTIFY,                       IDS_MMI_CMD_SS_USSD_NOTIFY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SS_USSD_Notify,                         NULL},

    {IDS_MMI_CMD_SS_USSD_REQUEST,                      IDS_MMI_CMD_SS_USSD_REQUEST_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SS_USSD_Request,                        NULL},

// RC Commands//
    {IDS_MMI_CMD_RC_COMMANDS,                          IDS_MMI_CMD_RC_COMMANDS_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_RC_REMOTE_LOCK,                       IDS_MMI_CMD_RC_REMOTE_LOCK_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_RC_Remote_Lock,                         NULL},

    {IDS_MMI_CMD_RC_REMOTE_UNLOCK,                     IDS_MMI_CMD_RC_REMOTE_UNLOCK_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_RC_Remote_Unlock,                       NULL},

    {IDS_MMI_CMD_RC_COMMAND_DIALOG,                    IDS_MMI_CMD_RC_COMMAND_DIALOG_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_RC_Command_Dialog,                      NULL},

// OMA: Monitor Dialog //
    {IDS_MMI_CMD_OMA_MONITORING_DIALOG,                IDS_MMI_CMD_OMA_MONITORING_DIALOG_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_OMA_Monitor_Dialog,                     NULL},

// ENIP: Commands //
    {IDS_MMI_CMD_ENIP_COMMANDS,                        IDS_MMI_CMD_ENIP_COMMANDS_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_ENIP_Commands,                          NULL},

// Show CSM and Dialog Stack //
    {IDS_MMI_CMD_SHOW_CSM_DIALOG_STACK,                IDS_MMI_CMD_SHOW_CSM_DIALOG_STACK_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Show_CSM_and_Dialog_Stack,              NULL},

// Voice Dialling / Memo, Ext. Feat. //
    {IDS_MMI_CMD_VOICE_DIALLING_MEMO,                  IDS_MMI_CMD_VOICE_DIALLING_MEMO_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_CREATE_DOCUMENTATION,                 IDS_MMI_CMD_CREATE_DOCUMENTATION_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Create_Documentation,                   NULL},

#if MMI_PROFILES_AVAILABLE
    {IDS_MMI_CMD_INITIALIZE_PROFILES,                  IDS_MMI_CMD_INITIALIZE_PROFILES_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Initialize_Profiles,                    NULL},
#endif // MMI_PROFILES_AVAILABLE
#if MMI_VOICEDIAL_AVAILABLE

    {IDS_MMI_CMD_VD_TRAIN_WR_ACK_TRAIN,                IDS_MMI_CMD_VD_TRAIN_WR_ACK_TRAIN_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_ACK_TRAIN,                  NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_OK,             IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_OK_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_OK,               NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_REJ_TRAIN,                IDS_MMI_CMD_VD_TRAIN_WR_REJ_TRAIN_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_REJ_TRAIN,                  NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_IND_TIMEOUT,              IDS_MMI_CMD_VD_TRAIN_WR_IND_TIMEOUT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_IND_TIMEOUT,                NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_DIFFERENT,      IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_DIFFERENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_DIFFERENT,        NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_SIMILAR,        IDS_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_SIMILAR_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_SIMILAR,          NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_ACK_END_TRAINING,         IDS_MMI_CMD_VD_TRAIN_WR_ACK_END_TRAINING_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_ACK_END_TRAINING,           NULL},

    {IDS_MMI_CMD_VD_TRAIN_WR_REJ_END_TRAINING,         IDS_MMI_CMD_VD_TRAIN_WR_REJ_END_TRAINING_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_TRAIN_WR_REJ_END_TRAINING,           NULL},

    {IDS_MMI_CMD_VD_PLAY_WR_ACK_PLAY,                  IDS_MMI_CMD_VD_PLAY_WR_ACK_PLAY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_PLAY_WR_ACK_PLAY,                    NULL},

    {IDS_MMI_CMD_VD_PLAY_WR_IND_PLAYED,                IDS_MMI_CMD_VD_PLAY_WR_IND_PLAYED_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_PLAY_WR_IND_PLAYED,                  NULL},

    {IDS_MMI_CMD_VD_PLAY_WR_REJ_PLAY,                  IDS_MMI_CMD_VD_PLAY_WR_REJ_PLAY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_PLAY_WR_REJ_PLAY,                    NULL},

    {IDS_MMI_CMD_VD_REC_WR_ACK_RECOGNIZE,              IDS_MMI_CMD_VD_REC_WR_ACK_RECOGNIZE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_REC_WR_ACK_RECOGNIZE,                NULL},

    {IDS_MMI_CMD_VD_REC_WR_IND_RECOG_UNIQUE,           IDS_MMI_CMD_VD_REC_WR_IND_RECOG_UNIQUE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_REC_WR_IND_RECOG_UNIQUE,             NULL},

    {IDS_MMI_CMD_VD_REC_WR_IND_RECOG_UNCERTAIN,        IDS_MMI_CMD_VD_REC_WR_IND_RECOG_UNCERTAIN_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_REC_WR_IND_RECOG_UNCERTAIN,          NULL},

    {IDS_MMI_CMD_VD_REC_WR_IND_RECOG_REJECTED,         IDS_MMI_CMD_VD_REC_WR_IND_RECOG_REJECTED_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_REC_WR_IND_RECOG_REJECTED,           NULL},

    {IDS_MMI_CMD_VD_REC_WR_REJ_RECOGNIZE,              IDS_MMI_CMD_VD_REC_WR_REJ_RECOGNIZE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_REC_WR_REJ_RECOGNIZE,                NULL},

    {IDS_MMI_CMD_VD_DEL_WR_ACK_DELETE,                 IDS_MMI_CMD_VD_DEL_WR_ACK_DELETE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_DEL_WR_ACK_DELETE,                   NULL},

    {IDS_MMI_CMD_VD_DEL_WR_ACK_DELETE_ALL,             IDS_MMI_CMD_VD_DEL_WR_ACK_DELETE_ALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_VD_DEL_WR_ACK_DELETE_ALL,               NULL},
#endif // MMI_VOICEDIAL_AVAILABLE
#ifdef MMI_NIGHTDESIGN_AVAILABLE
// Night Design triggering //
    {IDS_MMI_CMD_ND_TRIGGERING,                        IDS_MMI_CMD_ND_TRIGGERING_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_OFF,                IDS_MMI_CMD_ND_ASSERT_TRIGGER_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_off,                  NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_PB_CALL,            IDS_MMI_CMD_ND_ASSERT_TRIGGER_PB_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_PB_call,              NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_OTHER_CALL,         IDS_MMI_CMD_ND_ASSERT_TRIGGER_OTHER_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_other_call,           NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_CALL_GROUP1,        IDS_MMI_CMD_ND_ASSERT_TRIGGER_CALL_GROUP1_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_call_group1,          NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_CALL_GROUP2,        IDS_MMI_CMD_ND_ASSERT_TRIGGER_CALL_GROUP2_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_call_group2,          NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_DURING_CALL,        IDS_MMI_CMD_ND_ASSERT_TRIGGER_DURING_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_during_call,          NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_INCOMMING_MSG,      IDS_MMI_CMD_ND_ASSERT_TRIGGER_INCOMMING_MSG_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_incoming_msg,         NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_ALARM,              IDS_MMI_CMD_ND_ASSERT_TRIGGER_ALARM_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_alarm,                NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_CARKIT,             IDS_MMI_CMD_ND_ASSERT_TRIGGER_CARKIT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_carkit,               NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_NET_SEARCH,         IDS_MMI_CMD_ND_ASSERT_TRIGGER_NET_SEARCH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_net_search,           NULL},

    {IDS_MMI_CMD_ND_ASSERT_TRIGGER_LOW_BATTERY,        IDS_MMI_CMD_ND_ASSERT_TRIGGER_LOW_BATTERY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_assert_Trigger_low_battery,          NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_PB_CALL,           IDS_MMI_CMD_ND_RELEASE_TRIGGER_PB_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_PB_call,             NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_OTHER_CALL,        IDS_MMI_CMD_ND_RELEASE_TRIGGER_OTHER_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_other_call,          NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_CALL_GROUP1,       IDS_MMI_CMD_ND_RELEASE_TRIGGER_CALL_GROUP1_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_call_group1,         NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_CALL_GROUP2,       IDS_MMI_CMD_ND_RELEASE_TRIGGER_CALL_GROUP2_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_call_group2,         NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_DURING_CALL,       IDS_MMI_CMD_ND_RELEASE_TRIGGER_DURING_CALL_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_during_call,         NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_INCOMMING_MSG,     IDS_MMI_CMD_ND_RELEASE_TRIGGER_INCOMMING_MSG_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_incoming_msg,        NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_ALARM,             IDS_MMI_CMD_ND_RELEASE_TRIGGER_ALARM_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_alarm,               NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_CARKIT,            IDS_MMI_CMD_ND_RELEASE_TRIGGER_CARKIT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_carkit,              NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_NET_SEARCH,        IDS_MMI_CMD_ND_RELEASE_TRIGGER_NET_SEARCH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_net_search,          NULL},

    {IDS_MMI_CMD_ND_RELEASE_TRIGGER_LOW_BATTERY,       IDS_MMI_CMD_ND_RELEASE_TRIGGER_LOW_BATTERY_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_ND_release_Trigger_low_battery,         NULL},
#endif //MMI_NIGHTDESIGN_AVAILABLE
#endif // JAVA_SDK

// Switch Off  //
    {IDS_MMI_CMD_SWITCH_OFF,                           IDS_MMI_CMD_SWITCH_OFF_TOOLTIP,
     IMG_SWITCHOFF,                                    IMG_SWITCHOFF,
     E_MMI_CMD_Switch_Off,                             NULL},
#ifndef JAVA_SDK
// Switch Off and Save SIM Image //
    {IDS_MMI_CMD_SWITCH_OFF_SAVE_IMAGE,                IDS_MMI_CMD_SWITCH_OFF_SAVE_IMAGE_TOOLTIP,
     IMG_POWER_OFF_SAVE,                               IMG_POWER_OFF_SAVE,
     E_MMI_CMD_Switch_Off_and_Save_SIM_Image,          NULL},

// Softkeys //
    {IDS_MMI_CMD_SOFTKEYS,                             IDS_MMI_CMD_SOFTKEYS_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Softkeys,                               NULL},

// SyncML //
    {IDS_MMI_CMD_SYNCML,                               IDS_MMI_CMD_SYNCML_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_SYNCML_SYNC,                          IDS_MMI_CMD_SYNCML_SYNC_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SyncML_Sync,                            NULL},

    {IDS_MMI_CMD_SYNCML_ABORT_SYNC,                    IDS_MMI_CMD_SYNCML_ABORT_SYNC_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_SyncML_Abort_Sync,                      NULL},

#if BT_AVAILABLE_PCMMI>0
//Bluetooth //
    {IDS_MMI_CMD_BLUETOOTH,                            IDS_MMI_CMD_BLUETOOTH_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Bluetooth,                              NULL},
#endif // BT_AVAILABLE_PCMMI

// Alarm Functionality//
    {IDS_MMI_CMD_ALARM_FUNCTIONALITY,                  IDS_MMI_CMD_ALARM_FUNCTIONALITY_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Alarm_Functionality,                    NULL},

// IrDA //
    {IDS_MMI_CMD_IRDA,                                 IDS_MMI_CMD_IRDA_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_IrDA,                                   NULL},

// Wire simulation //
    {IDS_MMI_CMD_WIRE_SIMULATION,                      IDS_MMI_CMD_WIRE_SIMULATION_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Wire_simulation,                        NULL},

// MPM Connection  // 
    {IDS_MMI_CMD_MPM_CONNECTION,                       IDS_MMI_CMD_MPM_CONNECTION_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_MPM_connection,                        NULL},

#endif // JAVA_SDK

// Start Java Application //
    {IDS_MMI_CMD_START_JAVA_APPLICATION,               IDS_MMI_CMD_START_JAVA_APPLICATION_TOOLTIP,
     IMG_START_JAVA_APP,                               IMG_START_JAVA_APP,
     E_MMI_CMD_Start_Java_Application,                 NULL},

// Choose Network //
    {IDS_MMI_CMD_CHOOSE_NETWORK,                       IDS_MMI_CMD_CHOOSE_NETWORK_TOOLTIP,
     IMG_CHOOSE_NETWORK,                               IMG_CHOOSE_NETWORK,
     E_MMI_CMD_Choose_Network,                         NULL},

// Setup NITZ frame data
    {IDS_MMI_CMD_SETUP_NITZ,                           IDS_MMI_CMD_SETUP_NITZ_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Setup_NITZ_Frame_Values,                NULL},

// Filesystem //
    {IDS_MMI_CMD_FILESYSTEM,                           IDS_MMI_CMD_FILESYSTEM_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

    {IDS_MMI_CMD_SEND_NO_FREE_SPACE,                   IDS_MMI_CMD_SEND_NO_FREE_SPACE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_No_Free_Space,                     NULL},

    {IDS_MMI_CMD_SEND_FREE_SPACE,                      IDS_MMI_CMD_SEND_FREE_SPACE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_Free_Space,                        NULL},



#if MMI_MMS_AVAILABLE
// MMS Application //
    {IDS_MMI_CMD_MMS_COMMANDS,                         IDS_MMI_CMD_MMS_COMMANDS,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},

     // MMS Device Layer Socket Dialog
    {IDS_MMI_CMD_MMS_PUSH_NOTIFICATION_PORT,           IDS_MMI_CMD_MMS_PUSH_NOTIFICATION_PORT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMS_PUSH_NOTIFICATION_PORT,             NULL},

     // MMS Client Debug Dialog
    {IDS_MMI_CMD_MMS_DEBUG_DLG,                        IDS_MMI_CMD_MMS_DEBUG_DLG_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MMS_DEBUG_DLG,                          NULL},
#endif //#if MMI_MMS_AVAILABLE

#if BLACKBERRY_AVAILABLE > 0
// BlackBerry //
    {IDS_MMI_CMD_BLACKBERRY,                           IDS_MMI_CMD_BLACKBERRY_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_BlackBerry,                             NULL},
#endif
    
         // Java start parameter
#ifndef JAVA_SDK
   { IDS_MMI_CMD_JAPP,                                 IDS_MMI_CMD_JAPP_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                          IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL },

   { IDS_MMI_CMD_JAPP_MEMORYASS,                       IDS_MMI_CMD_JAPP_MEMORYASS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Java_Dialog,                            NULL },

   { IDS_MMI_CMD_JAPP_WORLDCLOCK,                      IDS_MMI_CMD_JAPP_WORLDCLOCK_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_JApp_WorldClock,                        NULL },

   { IDS_MMI_CMD_JAPP_STARTUPASS,                      IDS_MMI_CMD_JAPP_STARTUPASS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_JApp_StartUpAssistant,                  NULL },

   { IDS_MMI_CMD_JAPP_CALCULATOR,                      IDS_MMI_CMD_JAPP_CALCULATOR_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_JApp_Calculator,                        NULL },

   { IDS_MMI_CMD_JAPP_UNITCONVERTER,                   IDS_MMI_CMD_JAPP_UNITCONVERTER_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_JApp_UnitConverter,                     NULL },
#endif
// Change UI Language //  KZ
#ifdef LOCALIZATION_SUPPORT
    {IDS_MMI_CMD_CHANGE_UI_LANGUAGE,                   IDS_MMI_CMD_CHANGE_UI_LANGUAGE_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Change_UI_language,                        NULL},
#endif

//-- SAE_S--MOBSIM ---------------------------------------------------------
//-- SoundAE Service Tone Interface
#if ((SAE_S_TEST_ACTIVE) > 0)
     //SAE_S_TEST_Sounds(E_SAE_S_TEST_SOUND_TYPE_AMR_FILE);
     //-- sae main menue

     {IDS_MMI_CMD_SAE,                              IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_FOLDER_ORANGE_CLOSE,                       IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                           NULL},

     //-- sae arm buffer
     {IDS_MMI_CMD_SAE_S_AMR_BUFFER,                  IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_AMR_BUFFER,                     NULL},

     //-- sae dtmf buffer
     {IDS_MMI_CMD_SAE_S_DTMF_BUFFER,                 IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_DTMF_BUFFER,                    NULL},

     //-- sae iMelody buffer
     {IDS_MMI_CMD_SAE_S_IMELODY,                     IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_IMELODY,                        NULL},

     //-- sae midi buffer
     {IDS_MMI_CMD_SAE_S_MIDI_BUFFER,                 IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_MIDI_BUFFER,                    NULL},

     //-- sae srt buffer
     {IDS_MMI_CMD_SAE_S_SRT_BUFFER,                  IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_SRT_BUFFER,                     NULL},

     //-- sae srt dyn buffer
     {IDS_MMI_CMD_SAE_S_SRT_DYN,                     IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_SRT_DYN,                        NULL},

     //-- sae wav buffer
     {IDS_MMI_CMD_SAE_S_WAV_BUFFER,                  IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_WAV_BUFFER,                     NULL},

     //-- sae arm file
     {IDS_MMI_CMD_SAE_S_AMR_FILE,                    IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_AMR_FILE,                       NULL},

     //-- sae midi file
     {IDS_MMI_CMD_SAE_S_MID_FILE,                    IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_MID_FILE,                       NULL},

     //-- sae srt file
     {IDS_MMI_CMD_SAE_S_SRT_FILE,                    IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_SRT_FILE,                       NULL},

     //-- sae wav file
     {IDS_MMI_CMD_SAE_S_WAV_FILE,                    IDS_MMI_CMD_SAE_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_WAV_FILE,                       NULL},

     //-- sae stopall
     {IDS_MMI_CMD_SAE_S_STOPALL,                     IDS_MMI_CMD_SAE_S_STOPALL_TOOLTIP,
     IMG_WINDOW_RED,                                 IMG_WINDOW_RED,
     E_MMI_CMD_SAE_S_STOPALL,                        NULL},

#endif // #if ((SAE_S_TEST_ACTIVE) > 0)
     //---------------------------------------------------------------------
};
//modified by duchun for SHAPED_UI
//#ifdef SHAPED_UI
#ifdef USE_SHAPED_UI
extern const int SizeOfMMICmdEntry = sizeof(T_MMI_CMD_Entry);

#endif

BEGIN_MESSAGE_MAP(CMMICommandTree, CTreeCtrl)
    //{{AFX_MSG_MAP(CMMICommandTree)
    ON_WM_CREATE()
    ON_WM_CONTEXTMENU()
    ON_WM_RBUTTONDOWN()
    ON_COMMAND(ID_SORTCONTEXT_SORTASCENDING,  OnSortContextAscendingDescending)
    ON_COMMAND(ID_SORTCONTEXT_SORT_BY_GROUP, OnSortcontextSortByGroup)
    ON_COMMAND(ID_SORT_COLLAPSE_ALL, OnSortCollapseAll)
    ON_COMMAND(ID_SORT_EXPAND_ALL, OnSortExpandAll)
    ON_COMMAND(ID_SORTCONTEXT_SORTDESCENDING, OnSortContextAscendingDescending)
#ifdef LOCALIZATION_SUPPORT
    ON_MESSAGE(WM_UPDATE_WINDOWS_UI,          OnUpdateUI)  //added by kevin
#endif
    //}}AFX_MSG_MAP
    ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTW, 0, 0xFFFF, OnToolTipText)
    ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTA, 0, 0xFFFF, OnToolTipText)
    ON_NOTIFY_REFLECT (TVN_GETINFOTIP, OnTvnGetInfoTip)

END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMMICommandTree

/**
 *  Constructor of  CMMICommandTree.
 *  The function sets member variables with defined values.
 */
CMMICommandTree::CMMICommandTree()
{
    m_ToolTipBKColor   = RGB(195, 204, 230);
    m_ToolTipTextColor = RGB(0, 0, 0);
    m_ToolTipDelayTime = 30000;
    m_bAscending       = TRUE;
}

/**
 *  Destructor of  CMMICommandTree.
 *  It cleans up the generated objects
 */
CMMICommandTree::~CMMICommandTree()
{
    CMMICommandTreeItem *pcItem = NULL;

    for (int index = 0; index < m_cTreeItemArray.GetSize(); index++)
    {
        pcItem = m_cTreeItemArray.GetAt(index);

        if (pcItem != NULL)
            delete pcItem;
    }
}

/**
 *  This function creates an imagelist for Item Icons and calls
 *  CMMICommandTree::InitTreeItems()
 *
 *  @param   lpCreateStruct:  All new created objects
 *
 *  @return  int: must return 0 to continue the
 *                creation of the CWnd object. If the application
 *                returns -1, the window will be destroyed.
 */
int CMMICommandTree::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CTreeCtrl::OnCreate(lpCreateStruct) == -1)
        return -1;

    // Enable tooltips
    EnableToolTips(TRUE);

    // Create empty image list...
    HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 5);

    // Load 256 colour bitmap containing the images...
    HBITMAP hBitmap(HBITMAP(LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_FOLDER), IMAGE_BITMAP,
        0, 0,
        LR_CREATEDIBSECTION)));
    _ASSERTE(hBitmap);
    if (hBitmap)
    {
        // Plonk bitmap into image list...
        ImageList_AddMasked(hImageList, hBitmap, RGB(255, 255, 255));
        // Destroy bitmap
        DeleteObject(hBitmap);
    }

    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_RECEIVING_CALL)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_FUL_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_NO_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHORTMESSAGES)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CHOOSE_NETWORK)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_START_JAVA_APP)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHOW_RUN_TIME_JAVA)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_BEGIN_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_END_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SWITCHOFF)));

    m_image.m_hImageList = hImageList;
    SetImageList(&m_image, TVSIL_NORMAL);
#ifndef LOCALIZATION_SUPPORT
    // Init tree items from array array_MMI_CMD_Enties
    InitTreeItems();

//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
    // First sort alphabeticaly and by group
    OnSortContextAscendingDescending();
    OnSortcontextSortByGroup();
#endif
    // Set toltip wnd in Z order as number 1
    CWnd* pTT = GetToolTips ();
    pTT->SetWindowPos (&wndTopMost,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
#else
    RegenerateTree();
#endif
    return 0;
}

#ifdef LOCALIZATION_SUPPORT
//KZ added it
void CMMICommandTree::RegenerateTree(BOOL NeedRegen)
{
    if(NeedRegen)
        this->DeleteAllItems();
    InitTreeItems();

    // First sort alphabeticaly and by group
    SortItems(m_bAscending, E_SortAlphabetical, NULL);
    SortTree(m_bAscending,  E_SortAlphabetical, GetRootItem());
    SortItems(FALSE, E_SortGroup, NULL);

    // Set toltip wnd in Z order as number 1
    CWnd* pTT = GetToolTips ();
    pTT->SetWindowPos (&wndTopMost,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
}

LRESULT CMMICommandTree::OnUpdateUI(UINT uCode, LONG lParam)
{
    RegenerateTree(TRUE);
    return 0;
}

#endif

/**
 *  This function inits the MMI Commands in to tree items. All entries of the array \ref list_MMI_CMD_Enties
 *  will be read and processed. The function will be sort the array elements after item?s image value
 */
void CMMICommandTree::InitTreeItems()
{
    HTREEITEM hRoot = TVI_ROOT;
//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
    for( int index = 0; index < sizeof(array_MMI_CMD_Entries)/sizeof(struct_T_MMI_CMD_Entry); index++ )
    {
        if( array_MMI_CMD_Entries[index].ulCmdName == IDS_MMI_CMD_MPM_CONNECTION ){
            m_indexMPMConnection = index;
        } 

        // Is the item a root or has not child comands? if yes use return value 'hRoot'
        if (array_MMI_CMD_Entries[ index ].uiImage == IMG_FOLDER_BLUE_CLOSE   ||
            array_MMI_CMD_Entries[ index ].uiImage == IMG_FOLDER_ORANGE_CLOSE ||
            array_MMI_CMD_Entries[ index ].uiImage == IMG_WINDOW_GREEN        ||
            array_MMI_CMD_Entries[ index ].uiImage == IMG_SWITCHOFF           ||
            array_MMI_CMD_Entries[ index ].uiImage == IMG_POWER_OFF_SAVE      ||
        array_MMI_CMD_Entries[ index ].uiImage == IMG_START_JAVA_APP      ||
        array_MMI_CMD_Entries[ index ].uiImage == IMG_CHOOSE_NETWORK)
        {
            hRoot = AddMMICommandTreeItem( array_MMI_CMD_Entries[ index ]);
        }
        else
        {
            AddMMICommandTreeItem( array_MMI_CMD_Entries[ index ], hRoot);
        }
    }
#else // JAVA_SDK
    // reorder the commands and the command amount
//  int itemCount = sizeof(array_SMTK_MMI_CMD_Entries)/sizeof(struct_T_MMI_CMD_Entry) - 2;
    int itemCount = GetSizeofSMTKMPCmd();
   for( int index = 0; index < itemCount; index++ )
    {
        if( array_SMTK_MMI_CMD_Entries[index].ulCmdName == IDS_MMI_CMD_MPM_CONNECTION ){
            m_indexMPMConnection = index;
        }
       
        // Is the item a root or has not child comands? if yes use return value 'hRoot'
        if (array_SMTK_MMI_CMD_Entries[ index ].uiImage == IMG_FOLDER_ORANGE_CLOSE)
         {
            hRoot = AddMMICommandTreeItem( array_SMTK_MMI_CMD_Entries[ index ]);
        }
        else
        {
            AddMMICommandTreeItem( array_SMTK_MMI_CMD_Entries[ index ], hRoot);
        }
    }
#endif
}

/**
 *  Helper function to create a new MMICommandTreeItem.
 *  The funtion is called during CMMICommandTree::InitTreeItems function.
 *  It creates new CMMICommandTreeItem objects with appropriate values.
 *  All new created objects  will be stored in CMMICommandTree::m_cTreeItemArray
 *  to clean up the objects during desruction of CMMICommandTree class.
 *
 *  @param   cmd_entry: \ref struct_T_MMI_CMD_Entry
 *  @param   hParent: Parent item Handle to set parent item in InsertItem() function.
 *                    default value is hParent=TVI_ROOT.
 *
 *  @return  HTREEITEM: Handle of the new item.
 */
HTREEITEM CMMICommandTree::AddMMICommandTreeItem(T_MMI_CMD_Entry   cmd_entry,
                                                 HTREEITEM         hParent)
{
    HTREEITEM            hRoot;
    CMMICommandTreeItem *pcItem = NULL;
#ifdef LOCALIZATION_SUPPORT
    CLocalizationString cStrCmdName, cStrCmdToolTip;
#else
    CString cStrCmdName, cStrCmdToolTip;
#endif

    cStrCmdName   .LoadString(cmd_entry.ulCmdName);
    cStrCmdToolTip.LoadString(cmd_entry.ulCmdToolTip);

//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
    // Is there an additional check command?
    if (cmd_entry.additionalCmd == NULL)
    {
        // Create new CMMICommandTreeItem object
        pcItem = new  CMMICommandTreeItem(cStrCmdName,
                                          cStrCmdToolTip,
                                          cmd_entry.uiImage,
                                          cmd_entry.E_MMI_CMD);

        // insert a new item in a tree view control.
        hRoot  =      InsertItem(cStrCmdName,
                                 cmd_entry.uiImage,
                                 cmd_entry.uiSelectedImage,
                                 hParent);

        // set the 32-bit application-specific value
        SetItemData(hRoot, (DWORD) pcItem);

        // Add objects in an array to clean up the objects during
        // destruction of CMMICommandTree class.
        m_cTreeItemArray.Add(pcItem);

        return hRoot;
    }
    else
    {
        // Check additional condition
        if (cmd_entry.additionalCmd())
        {
            pcItem = new  CMMICommandTreeItem(cStrCmdName,
                                              cStrCmdToolTip,
                                              cmd_entry.uiImage,
                                              cmd_entry.E_MMI_CMD);

            hRoot  =      InsertItem(cStrCmdName,
                                     cmd_entry.uiImage,
                                     cmd_entry.uiSelectedImage,
                                     hParent);
            SetItemData(hRoot, (DWORD) pcItem);
            m_cTreeItemArray.Add(pcItem);
            return hRoot;
        }
    }
#else
    // Is there an additional check command?
    if (cmd_entry.ulCmdName == IDS_MMI_CMD_NETWORK_COMMANDS ||
        cmd_entry.ulCmdName == IDS_MMI_CMD_PHONE_COMMANDS )
    {
        // Create new CMMICommandTreeItem object
        pcItem = new  CMMICommandTreeItem(cStrCmdName,
                                          cStrCmdToolTip,
                                          cmd_entry.uiImage,
                                          cmd_entry.E_MMI_CMD);
        // insert a new item in a tree view control.
        hRoot  = m_hRoot =      InsertItem(cStrCmdName,
                                 cmd_entry.uiImage,
                                 cmd_entry.uiSelectedImage,
                                 hParent,
                                    m_hRoot);

        // set the 32-bit application-specific value
        SetItemData(hRoot, (DWORD) pcItem);

        // Add objects in an array to clean up the objects during
        // destruction of CMMICommandTree class.
        m_cTreeItemArray.Add(pcItem);

        return hRoot;
    }
    else if (cmd_entry.E_MMI_CMD != NULL)
    {
        // remove the item, which command is not set.
        // display the item, which have the exactly command execution.
        {
            pcItem = new  CMMICommandTreeItem(cStrCmdName,
                                              cStrCmdToolTip,
                                              cmd_entry.uiImage,
                                              cmd_entry.E_MMI_CMD);
            // insert a new item in a tree view control.
            hRoot  = m_hRoot =      InsertItem(cStrCmdName,
                                 cmd_entry.uiImage,
                                 cmd_entry.uiSelectedImage,
                                 hParent,
                                    m_hRoot);

            SetItemData(hRoot, (DWORD) pcItem);
            m_cTreeItemArray.Add(pcItem);
            return hRoot;
        }
    }

#endif
    return hParent;
}

/**
 *  Provides a Windows procedure (WindowProc) for a CWnd object.
 *  We use Windows procedure to handle WM_LBUTTONDOWN, WM_LBUTTONUP, WM_LBUTTONDBLCLK
 *  WM_TIMER messages. Some MMI commands can only called with Windows procedure.
 *
 *  @param   message: Specifies the Windows message to be processed.
 *
 *  @param   wParam:  Provides additional information
 *                    used in processing the message. The parameter value
 *                    depends on the message.
 *
 *  @param   lParam:  Provides additional information
 *                    used in processing the message. The parameter value
 *                    depends on the message.
 *
 *  @return  LRESULT: The return value depends on the
 *                    message.
 */
LRESULT CMMICommandTree::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
    // Some variables used for sending ADAC-Logo Bitmap
    char * pBuffer;
    static int  nPacketCount;      // Counter for packets to send
    const int   nPacketSize = 50;  // Number of bytes for one packet
    static int  nNofPackets;       // Number of packtes to send
    static int  nCommand;          // Flag to send command or data
    static char szSaveBuf[256];    // Buffer with original command line
    static char AdacLogoHexAsciiBuffer[2*ADAC_BINARY_BITMAP_SIZE+1];
    PID tmp = NULL;
    // --------------------------------------------------------------------------

    switch (message)
    {
        case WM_LBUTTONDOWN:
            break;
        case WM_LBUTTONUP:
            break;
        case WM_LBUTTONDBLCLK:
        {

            HTREEITEM  hItem  = GetSelectedItem();
            if ((hItem != NULL))
            {
                pBuffer = (char*) XRC_GetSerialRxBuffer(SERIAL_1);
                CMMICommandTreeItem *pcItem = NULL;

                // Get value associated with the item and cast to CMMICommandTreeItem pointer.
                pcItem = (CMMICommandTreeItem*) GetItemData(hItem);

                if (NULL != pcItem)
                {
                    E_MMI_COMMANDS E_MMI_CMD = E_MMI_CMD_NoCommand;

                    // Get the appropriate MMI command enum.
                    E_MMI_CMD = pcItem->GetEnumMMICommands();

                    //Du chun,execute SMTK phone commands in one function
                    ExecuteSMTKPhoneCommand(E_MMI_CMD);

                    
                    if (E_MMI_CMD == E_MMI_CMD_MPM_connection)
                    {
                        ChangeItemMPMConnection(hItem);                    
                    }
                    


                    // Make PhoneScreen as active window
                    GET_APP()->GetMMIDispWindow()->MakeActiveWnd();
                    return 0;
                }
            }
        }

    }// End Switch

    return CTreeCtrl::WindowProc(message, wParam, lParam);
}



void CMMICommandTree::ChangeItemMPMConnection(HTREEITEM  hItem)
{
    if ( WireSimuState == 1 ){       //To avoid run two wire simulation applications at same time;
        return;         
    }
    
    if( MPMConnectState == 1 ){ 

#ifdef JAVA_SDK
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName      = IDS_MMI_CMD_MPM_DISCONNECTION ;   
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip   = IDS_MMI_CMD_MPM_DISCONNECTION_TOOLTIP ;
#else
        array_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName           = IDS_MMI_CMD_MPM_DISCONNECTION ;   
        array_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip        = IDS_MMI_CMD_MPM_DISCONNECTION_TOOLTIP ;
#endif
        CString temp;
        temp.LoadString(IDS_MMI_CMD_MPM_DISCONNECTION);
        this->SetItemText(hItem,temp);
        this->Invalidate();

    }else{

#ifdef JAVA_SDK
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName      = IDS_MMI_CMD_MPM_CONNECTION ;   
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip   = IDS_MMI_CMD_MPM_CONNECTION_TOOLTIP ;
#else
        array_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName           = IDS_MMI_CMD_MPM_CONNECTION ;   
        array_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip        = IDS_MMI_CMD_MPM_CONNECTION_TOOLTIP ;
#endif
        CString temp;
        temp.LoadString(IDS_MMI_CMD_MPM_CONNECTION);
        this->SetItemText(hItem, temp);
        this->Invalidate();

    }
}



//@Str
extern "C" void simulate_toolkit_msg_Mopi( UINT32 fParam )
{
    psimsim->simulate_toolkit_message( (char*)fParam );
}

/*
extern "C" void SaveSIMImage(void)
{
  if( 0 != save_sim_image_when_switching_off)
    {
        cmd_save_simsim_data();
    }
    POST_MSSM_MSG_POWER_DOWN_RESP( PB_POWER_DOWN );

}
*/

extern "C" void pb_callbackSwitchOff(void) // called by pbacport.c via msmonoff process
{
    if( 0 != save_sim_image_when_switching_off)
    {
        cmd_save_simsim_data();
    }
    POST_MSSM_MSG_POWER_DOWN_RESP( PB_POWER_DOWN );
}


extern "C" void SwitchOffRequest_Mopi( UINT32 fParam )
{
    save_sim_image_when_switching_off = fParam;
    POST_MSSM_MSG_POWER_DOWN_REQ( NORMAL_SWITCHING_OFF );
}

//@Str
extern "C" void SMSSIM_ImmediateShortMessage_Mopi( UINT32 fParam )
{
    SMSSIM_ImmediateShortMessage();
}

//@Str
extern "C" void SMSSIM_IncomingShortMessage_Mopi( UINT32 fParam )
{
    SMSSIM_IncomingShortMessage();
}

//@Str
extern "C" void mm_sim_plmn_scan_rej_Mopi( UINT32 fParam )
{
    mm_sim_plmn_scan_rej();
}

//@Str
extern "C" void mm_sim_avail_plmn_ind_Mopi( UINT32 fParam )
{
    mm_sim_avail_plmn_ind();
}

//@Str
extern "C" void PowerAL_Indicate_LowPowerBegin_Mopi( UINT32 fParam )
{
    PowerAL_Indicate_LowPowerBegin();
}

//@Str
extern "C" void PowerAL_Indicate_LowPowerEnd_Mopi( UINT32 fParam )
{
    PowerAL_Indicate_LowPowerEnd();
}

//@Kremni
extern "C" void cmdSetupNitz_Mopi( UINT32 fParam )
{
    cmdSetupNitz();
}

//@Str
extern "C" void cmdChooseNetwork_Mopi( UINT32 fParam )
{
    cmdChooseNetwork();
}

//@Str
extern "C" void MsmLed_SetNextPattern_Mopi( UINT32 fParam )
{
    MsmLed_SetNextPattern( (eLedFunctions)fParam );
}

//@Str
extern "C" void MsmLed_ClearCurrentPattern_Mopi( UINT32 fParam )
{
    MsmLed_ClearCurrentPattern( (eLedFunctions)fParam );
}

//@Str
extern "C" void SMSSIM_ToggleVoiceMessage_Mopi( UINT32 fParam )
{
    SMSSIM_ToggleVoiceMessage();
}


//-- SAE_S--MOBSIM ---------------------------------------------------------
#if ((SAE_S_TEST_ACTIVE) > 0)

//extern "C"
void cmdSAE_S_TEST_Sounds_Mopi( UINT32 fParam )
{
    SAE_S_TEST_Sounds( (T_SAE_S_TEST_SOUND_TYPE) fParam );
}

//extern "C"
void cmdSAE_S_TEST_STOPALL_Mopi( UINT32 fParam )
{
   SoundAE_StopAll();
}

#endif // #if ((SAE_S_TEST_ACTIVE) > 0)



/**
 *  Helper function to call the correct mmi command function
 *
 *  @param   E_MMI_CMD: Enum of mmi commmand
 */
void CMMICommandTree::ExecuteMMICommands(E_MMI_COMMANDS E_MMI_CMD)
{

}


/**
 *  Helper function for sort feature.
 *
 *  @param   bAscending: True if sort ascending.
 *  @param   SortType: \ref enum_SortTypes
 *  @param   hParent: Handle to parent item
 *
 */
void CMMICommandTree::SortTree(BOOL bAscending, E_SortTypes SortType, HTREEITEM hParent)
{
    HTREEITEM hChild = NULL;
    HTREEITEM hPa = hParent;

    while (hPa != NULL)
    {
        if (ItemHasChildren(hPa))
        {
            SortItems(bAscending, SortType, hPa);
            SortTree(bAscending,  SortType, hChild);
        }

        hPa = GetNextSiblingItem(hPa);
    }
}

/**
 *  Helper function for sort feature.
 *
 *  @param   bAscending: True if sort ascending.
 *  @param   SortType: \ref enum_SortTypes
 *  @param   hItem: Handle to parent item
 *
 */
BOOL CMMICommandTree::SortItems(BOOL bAscending, E_SortTypes SortType, HTREEITEM hItem)
{
    TV_SORTCB tSort;


    struct_T_SortType *pSortType  = new struct_T_SortType;
    pSortType->bAscending         = bAscending;
    pSortType->SortType           = SortType;
    tSort.hParent                 = hItem;
    tSort.lpfnCompare             = CompareFunc;
    tSort.lParam                  = (LPARAM)pSortType;
    BOOL m_bReturn                = SortChildrenCB(&tSort);

    delete pSortType;

    return m_bReturn;
}

/**
 *  Callback function, which is called during a sort operation each time the relative
 *  order of two list items needs to be compared.
 *
 *  @param   lParam1: The lParam1 and lParam2 parameters correspond to the lParam
 *                    member of the TVITEM structure for the two items being compared.
 *
 *  @param   lParam2: The lParam1 and lParam2 parameters correspond to the lParam
 *                    member of the TVITEM structure for the two items being compared.
 *
 *  @param   lParamSort: The lParamSort parameter corresponds to the lParam member
 *                       of this structure.
 *
 *  @return  int: The callback function must return a negative value if the first item
 *                should precede the second, a positive value if the first item should
 *                follow the second, or zero if the two items are equivalent.
 */
int CALLBACK CMMICommandTree::CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
    CMMICommandTreeItem *pItem1  = (CMMICommandTreeItem *)lParam1;
    CMMICommandTreeItem *pItem2  = (CMMICommandTreeItem *)lParam2;
    struct_T_SortType *pSortType = (struct_T_SortType *)lParamSort;

    CString str1 = pItem1->GetLabel();
    CString str2 = pItem2->GetLabel();

    int iReturn;

    // is sorttype Alphapetical?
    if (pSortType->SortType == E_SortAlphabetical)
    {
        // compare the two strings, but
        // notice:
        // in this case, "xxxx10" comes after "xxxx2"
        CString tmpStr1, tmpStr2;
        int index = str1.FindOneOf(_T("0123456789"));
        if (index!=-1)
            tmpStr1 = str1.Right(str1.GetLength() - index);
        index = str2.FindOneOf(_T("0123456789"));
        if (index!=-1)
            tmpStr2 = str2.Right(str2.GetLength() - index);

        tmpStr1 = tmpStr1.SpanIncluding(_T("0123456789"));
        tmpStr2 = tmpStr2.SpanIncluding(_T("0123456789"));

        if ((tmpStr1 == "") && (tmpStr2 == ""))
            iReturn = str1.CompareNoCase(str2);
        else
        {
            int num1 = _ttoi(tmpStr1);
            int num2 = _ttoi(tmpStr2);

            tmpStr1 = str1.SpanExcluding(_T("0123456789"));
            tmpStr2 = str2.SpanExcluding(_T("0123456789"));

            if (tmpStr1 == tmpStr2)
            {
                if (num1 > num2)
                    iReturn = 1;
                else
                    if (num1 < num2)
                        iReturn = -1;
                    else
                        iReturn = str1.CompareNoCase(str2);
            }
            else
                iReturn = str1.CompareNoCase(str2);
        }
    }
    else //sort by group, for group sorting use image value
    {
        if (pItem1->GetImage() > pItem2->GetImage())
            iReturn = 1;

        else
            if (pItem1->GetImage() < pItem2->GetImage())
                iReturn = -1;
            else
                iReturn = 0;
    }

    // sort ascending or descending
    if (!pSortType->bAscending)
    {
        if (iReturn == 1)
            iReturn = -1;
        else
            if (iReturn == -1)
                iReturn = 1;
    }

    return iReturn;
}

/**
 *  The function changes the tooltip text. It uses the tooltip text
 *  which was added in CMMICommandTreeItem object.
 */
void CMMICommandTree::OnTvnGetInfoTip(NMHDR *pNMHDR,
                                    LRESULT *pResult)

{
    LPNMTVGETINFOTIP pGetInfoTip = (LPNMTVGETINFOTIP)pNMHDR;

    CMMICommandTreeItem *pcItem = NULL;
    CString sTipText;

    pcItem = (CMMICommandTreeItem*) GetItemData(pGetInfoTip->hItem);

    if (NULL != pcItem)
    {
        sTipText = pcItem->GetLabel() + ": \r\n" + pcItem->GetToolTipText();
    }
    else
    {
        sTipText = "No ToolTip info available";
    }

    pGetInfoTip->cchTextMax = sTipText.GetLength()+1;
    _tcscpy(pGetInfoTip->pszText, sTipText);
    *pResult = 0;
}

/**
 *  The function sets the max tooltip width, tooltip background color,
 *  tooltip text color and delay time of tooltip.
 */
BOOL CMMICommandTree::OnToolTipText(UINT id, NMHDR * pNMHDR, LRESULT * pResult)
{
    ::SendMessage(pNMHDR->hwndFrom, TTM_SETMAXTIPWIDTH, 0, 500);
    ::SendMessage(pNMHDR->hwndFrom, TTM_SETTIPBKCOLOR, (WPARAM)(COLORREF)m_ToolTipBKColor, 0);
    ::SendMessage(pNMHDR->hwndFrom, TTM_SETTIPTEXTCOLOR, (WPARAM)(COLORREF)m_ToolTipTextColor, 0);
    ::SendMessage(pNMHDR->hwndFrom, TTM_SETDELAYTIME, (WPARAM)(DWORD)TTDT_AUTOPOP, (LPARAM)(INT) m_ToolTipDelayTime);
    return false;
}


/**
 *  Called by the framework when the user has clicked the right mouse button (right clicked) in the window.
 *
 *  @param   pWnd:  Handle to the window in which the
 *                  user right clicked the mouse.
 *  @param   point: Position of the cursor, in screen
 *                  coordinates, at the time of the mouse click.
 */
void CMMICommandTree::OnContextMenu(CWnd* pWnd, CPoint point)
{
#ifdef LOCALIZATION_SUPPORT
    CLocalizationMenu menu;
#else
    CMenu menu;
#endif
    CString cStrMenu;

    if (menu.LoadMenu(IDR_SORT_MENU))
    {
        CMenu* pPopup = menu.GetSubMenu(0);
        ASSERT(pPopup != NULL);

        for (UINT i = 0; i < pPopup->GetMenuItemCount(); i++)
        {
            if (m_bAscending && (ID_SORTCONTEXT_SORTDESCENDING == pPopup->GetMenuItemID(i)))
            {
                pPopup->RemoveMenu(i, MF_BYPOSITION);
            }
            else if (!m_bAscending && (ID_SORTCONTEXT_SORTASCENDING == pPopup->GetMenuItemID(i)))
                pPopup->RemoveMenu(i, MF_BYPOSITION);
        }

        pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
    }
}


/**
 *  The framework calls this member function when the user presses the right mouse button
 *  We use this function to select item when  the context menu is shown.
 *
 *  @param   nFlags: Indicates whether various
 *                   virtual keys are down.
 *  @param   point:  Specifies the x and y coordinates
 *                   of the cursor.
 */
void CMMICommandTree::OnRButtonDown(UINT nFlags, CPoint point)
{
    HTREEITEM hitem = HitTest(point, &nFlags);

    if (hitem != NULL)
        SelectItem(hitem);
}

/**
 * Context menu function to call alphabetical sort algorithm.
 */
void CMMICommandTree::OnSortContextAscendingDescending()
{
    SortItems(m_bAscending, E_SortAlphabetical, NULL);
    SortTree(m_bAscending,  E_SortAlphabetical, GetRootItem());

    if (m_bAscending)
        m_bAscending = FALSE;
    else
        m_bAscending = TRUE;
}

/**
 *  Context menu function to call group sort algorithm.
 */
void CMMICommandTree::OnSortcontextSortByGroup()
{
    SortItems(FALSE, E_SortGroup, NULL);
}

/**
 *  Helper function to call expand or collaps functionality.
 *
 *  @param   uinCode: A flag indicating the type of
 *                    action to be taken.
 *                    TVE_COLLAPSE   Collapses the list.
 *                    TVE_EXPAND   Expands the list.
 */
void CMMICommandTree::ExpandCollaps(const UINT uinCode)
{
    HTREEITEM hItem    = GetRootItem();
    CWaitCursor wait;

    // Expand or collapse until last item.
    while (hItem != NULL)
    {
        Expand(hItem, uinCode);
        hItem = GetNextSiblingItem(hItem);
    }

    // Show the selected item.
    EnsureVisible(GetSelectedItem());
    wait.Restore();
}

/**
 *  Context menu function to call collapse all.
 */
void CMMICommandTree::OnSortCollapseAll()
{
    // call helper function.
    ExpandCollaps(TVE_COLLAPSE);
}

/**
 *  Context menu function to call expand all.
 */
void CMMICommandTree::OnSortExpandAll()
{
    // call helper function.
    ExpandCollaps(TVE_EXPAND);
}



IMPLEMENT_DYNAMIC(CMMICommandTreeItem, CObject)
/**
 *  Constructor of CMMICommandTreeItem. Is sets some member variables with values
 *  which are given during creation of a new object.
 *  Use this constructor to create new CMMICommandTreeItem object.
 *
 *  @param   cStrCmdName: name of mmi command.
 *  @param   cStrCmdToolTip: tooltip info of mmi command
 *  @param   uiImage: imagenumber
 *  @param   E_MMI_CMD: \ref E_MMI_COMMANDS
 */
CMMICommandTreeItem::CMMICommandTreeItem(CString           cStrCmdName,
                                         CString           cStrCmdToolTip,
                                         UINT              uiImage,
                                         E_MMI_COMMANDS    E_MMI_CMD)
{

   m_cmd_name         = cStrCmdName;
   m_cmd_ToolTip      = cStrCmdToolTip;
   m_uiImage          = uiImage;
   m_E_MMI_Commands   = E_MMI_CMD;

}


/**
 *  Destructor of CMMICommandTreeItem class.
 */
CMMICommandTreeItem::~CMMICommandTreeItem()
{
}

/**
 *  Returns mmi command name.
 *  @return  CString: mmi command name.
 */
CString CMMICommandTreeItem::GetLabel() const
{
    return m_cmd_name;
}

/**
 *  Returns mmi command tooltip info.
 *  @return  CString: tooltip info.
 */
CString CMMICommandTreeItem::GetToolTipText() const
{
    return m_cmd_ToolTip;
}

/**
 *  Returns mmi commands appropiate \ref E_MMI_COMMANDS
 *  @return  E_MMI_COMMANDS: \ref E_MMI_COMMANDS
 */
E_MMI_COMMANDS CMMICommandTreeItem::GetEnumMMICommands() const
{
    return m_E_MMI_Commands;
}

/**
 *  Returns image value. Image value means group affiliation.
 *  @return  UINT: gruop affiliation.
 */
UINT CMMICommandTreeItem::GetImage() const
{
    return m_uiImage;
}

bool featureIsAvailable( void )
{
    return TRUE;
}

void simulate_sim_refresh_Mopi( UINT32 param )
{
    simulate_sim_refresh( param );
}

void ExecuteSMTKPhoneCommand(E_MMI_COMMANDS E_MMI_CMD)
{
    PID tmp = NULL;
    char *message;
#ifdef MMI_NIGHTDESIGN_AVAILABLE
    if(E_MMI_CMD >= E_MMI_CMD_ND_assert_Trigger_off && E_MMI_CMD <= E_MMI_CMD_ND_release_Trigger_low_battery)
        open_nightdesign_window();
#endif

    switch (E_MMI_CMD)
    {
        case E_MMI_CMD_Disconnect_Accessory:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_NONE);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
                break;
        }
        case E_MMI_CMD_Connect_Carkit_Comfort_Voice:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_CK_COMFORT_VOICE);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }
        case E_MMI_CMD_Connect_Carkit_Comfort:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_CK_COMFORT);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }
        case E_MMI_CMD_Connect_Carkit_Prof_Bt:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_CK_PROF_BT);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
                break;
        }

        case E_MMI_CMD_Connect_Carkit_Linefit:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_CK_LINEFIT);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }

        case E_MMI_CMD_Connect_Carkit_Portable:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_CK_PORTABLE);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }
        case E_MMI_CMD_Connect_Headset_Mono:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_HEADSET_MONO);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }
        case E_MMI_CMD_Connect_Headset_Stereo:
        {
                WAS_UpdatePayLoadData(E_WAS_DEVICE_HEADSET_STEREO);
                MOPI_ExecuteFunction( NOPROCESS_PID, WAS_SendMessageToClient_Mopi, M_MMI_WAS_MSG );
            break;
        }
        case E_MMI_CMD_NoCommand: break; // do nothing
        // Handle other enum cases
        case E_MMI_CMD_MSM_Mobile_Terminating_Call:            msm_sim_mtc();                   break;
        case E_MMI_CMD_MSM_MSM_Disconnect_Call_by_Net:         msm_sim_disconnect();            break;
        case E_MMI_CMD_MSM_MSM_Interrupt_Call_Reest_Proc:      msm_sim_interrupt();             break;
        case E_MMI_CMD_MSM_MOC_disconnect_progress_is_on_off:  msm_sim_disc_progress_clear();   break;
        case E_MMI_CMD_MSM_MOC_disconnect_progress_is_off_on:  msm_sim_disc_progress_set();     break;
        case E_MMI_CMD_MSM_MOC_release_with_busy_is_on_off:    msm_sim_MOC_busy_clear();        break;
        case E_MMI_CMD_MSM_MOC_release_with_busy_is_off_on:    msm_sim_MOC_busy_set();          break;
        case E_MMI_CMD_MSM_MOC_CCBS_is_supported_off:          msm_sim_CCBS_clear();            break;
        case E_MMI_CMD_MSM_MOC_CCBS_is_not_supported_on:       msm_sim_CCBS_set();              break;
        case E_MMI_CMD_MSM_HZ_Homezone_on_off:                 msm_sim_HZ_clear();              break;
        case E_MMI_CMD_MSM_HZ_Homezone_off_on:                 msm_sim_HZ_set();                break;
        case E_MMI_CMD_MSM_Explicit_Call_Transfer:             msm_sim_ect();                   break;

// CBS: Send CBS - Message
#ifndef JAVA_SDK
        case E_MMI_CMD_CBS_Send_CBS_Message:                   open_cbs_message_box();          break;
#endif // JAVA_SDK

// MM Services
        case E_MMI_CMD_MM_No_Service:                          mm_sim_no_service();             break;
        case E_MMI_CMD_MM_Limited_Service:                     mm_sim_limited_service();        break;
        case E_MMI_CMD_MM_Full_Service:                        mm_sim_full_service();           break;
#ifndef JAVA_SDK
        case E_MMI_CMD_MM_Available_PLMN_Indication:           MOPI_ExecuteFunction( NOPROCESS_PID, mm_sim_avail_plmn_ind_Mopi, 0 ); break; //@Str
        case E_MMI_CMD_MM_PLMN_Scann_Reject:                   MOPI_ExecuteFunction( NOPROCESS_PID, mm_sim_plmn_scan_rej_Mopi, 0 ); break; //@Str
#endif // JAVA_SDK

// POWER //
        case E_MMI_CMD_Power_End_Low_Power:                    MOPI_ExecuteFunction( NOPROCESS_PID, PowerAL_Indicate_LowPowerEnd_Mopi, 0 );  break; //@Str
        case E_MMI_CMD_Power_Begin_Low_Power:                  MOPI_ExecuteFunction( NOPROCESS_PID, PowerAL_Indicate_LowPowerBegin_Mopi, 0 );break; //@Str

#ifndef JAVA_SDK
// AOC Commands //
        case E_MMI_CMD_AOC_active:                             AOC_AL_ChargingNowActive();      break;
        case E_MMI_CMD_AOC_Warnings:                           TestAOCWarnings();               break;

// CK Commands //
        case E_MMI_CMD_CK_Refresh:                             TKRefresh();                     break;
        case E_MMI_CMD_CK_Phonebook_Refresh:                   PhonebookRefresh();              break;
        case E_MMI_CMD_CK_Sim_Rom_Activation:                  simulate_sim_activation();       break;
        case E_MMI_CMD_CK_Save_SIM_Image:                      cmd_save_simsim_data();          break;

// SAT: Toolkit Commands //
        case E_MMI_CMD_00_soft_refresh: message="refresh1"; MOPI_ExecuteFunction( NOPROCESS_PID, simulate_sim_refresh_Mopi, 0 ); break;
        case E_MMI_CMD_01_hard_refresh: message="refresh2"; MOPI_ExecuteFunction( NOPROCESS_PID, simulate_sim_refresh_Mopi, 0 ); break;
        case E_MMI_CMD_02_more_time:             message="moretime";                            break;
        case E_MMI_CMD_03_play_tone:             message="playtone";                            break;
        case E_MMI_CMD_04_display_text1:         message="displaytext1";                        break;
        case E_MMI_CMD_05_display_text2:         message="displaytext2";                        break;
        case E_MMI_CMD_06_display_text3:         message="displaytext3";                        break;
        case E_MMI_CMD_07_display_text4:         message="displaytext4";                        break;
        case E_MMI_CMD_08_get_inkey:             message="getinkey";                            break;
        case E_MMI_CMD_09_response:              message="response";                            break;
        case E_MMI_CMD_10_set_up_idle_mode_text: message="setupidlemodetext";                   break;
        case E_MMI_CMD_11_call_control_1:        message="callcontrol_1";                       break;
        case E_MMI_CMD_12_call_control_2:        message="callcontrol_2";                       break;
        case E_MMI_CMD_13_call_control_3:        message="callcontrol_3";                       break;
        case E_MMI_CMD_14_call_control_4:        message="callcontrol_4";                       break;
        case E_MMI_CMD_15_call_control_5:        message="callcontrol_5";                       break;
        case E_MMI_CMD_16_get_input:             message="getinput";                            break;
        case E_MMI_CMD_17_poll_interval:         message="pollinterval";                        break;
        case E_MMI_CMD_18_polling_off:           message="pollingoff";                          break;
        case E_MMI_CMD_19_provide_local_info:    message="providelocalinfo";                    break;
        case E_MMI_CMD_20_set_up_menu:           message="setupmenu";                           break;
        case E_MMI_CMD_21_set_up_event_list:     message="setupeventlist";                      break;
        case E_MMI_CMD_22_select_item:           message="selectitem";                          break;
        case E_MMI_CMD_23_send_SMS:              message="sendsms";                             break;
        case E_MMI_CMD_24_send_SS:               message="sendss";                              break;
        case E_MMI_CMD_25_set_up_call:           message="setupcall";                           break;
        case E_MMI_CMD_26_send_USSD:             message="sendussd";                            break;
        case E_MMI_CMD_27_set_up_event_list:     message="setupeventlist";                      break;
        case E_MMI_CMD_28_timer_management:      message="timermanagement";                     break;
        case E_MMI_CMD_29_launch_browser:        message="launchbrowser";                       break;
        case E_MMI_CMD_30_language_notification: message="languagenotification";                break;
        case E_MMI_CMD_31_TKT_file_reference:    message="tktfilereference";                    break;
        case E_MMI_CMD_32_Open_Channel:          message="openchannel";                         break;
        case E_MMI_CMD_33_Send_Data:             message="senddata";                            break;
        case E_MMI_CMD_34_Receive_Data:          message="receivedata";                         break;
        case E_MMI_CMD_35_Close_Channel:         message="closechannel";                        break;
        case E_MMI_CMD_36_Get_Channel_Status:    message="getchannelstatus";                    break;
        case E_MMI_CMD_Event_Download:                         TKEventDownload();               break;

/*
// Upsim Commands

#if MMI_BROWSER_AVAILABLE > 0

        case E_MMI_CMD_Activate:                               Upsim_Browser_Start(NULLP); break;
        case E_MMI_CMD_Terminate:                              Upsim_Browser_Terminate();  break;
        case E_MMI_CMD_Load_Content:
        {
            if ( Upsim_GetFilename() == -1 )
                return;
            sprintf(mg_UrlName, "file:%s", mg_Filename);
            Upsim_GoToUrl(mg_UrlName);
            break;
        }
        case E_MMI_CMD_Send_Alert:                             Upsim_SendAlert();               break;
        case E_MMI_CMD_Remove_Alert:                           Upsim_RemoveAlert();             break;
        case E_MMI_CMD_No_security:                            Upsim_Security(kSecurityNone);   break;
        case E_MMI_CMD_Security_Class_1:                       Upsim_Security(kSecurityClass1); break;
        case E_MMI_CMD_Security_Class_2:                       Upsim_Security(kSecurityClass2); break;
        case E_MMI_CMD_Send_ProvSM:                            Upsim_SendProvSMS();             break;
        case E_MMI_CMD_Send_WAP_OTAP:                          Upsim_SendWapOTAP();             break;
#endif // MMI_BROWSER_AVAILABLE
*/
// Internet Browser Commands
        case E_MMI_CMD_BrowserActivate:                        BrowserSim_Activate();        break;
        case E_MMI_CMD_Browser_Terminate:                      BrowserSim_Terminate();       break;
        case E_MMI_CMD_Browser_LoadContent:                    BrowserSim_LoadContent();     break;
        case E_MMI_CMD_Browser_RunUnitTests:                   BrowserSim_RunUnitTests();    break;

#if USE_MMC_SIMU
// MMC Explorer Commands
        case E_MMI_CMD_MMC_Insert:                             MOPI_ExecuteFunction( NOPROCESS_PID, Simu_Mmc_NotifyInsert, 0); break;
        case E_MMI_CMD_MMC_Remove:                             MOPI_ExecuteFunction( NOPROCESS_PID, Simu_Mmc_NotifyRemove, 0); break;
/*
        case E_MMI_CMD_Get_Entries_Sizes:                      ExplorerProcTestCSMOpen(0);      break;
        case E_MMI_CMD_Read_Directory:                         ExplorerProcTestCSMOpen(1);      break;
        case E_MMI_CMD_Read_Write_Files:                       ExplorerProcTestCSMOpen(2);      break;
        case E_MMI_CMD_MMC_Select_File_W:                      mmcExplorerTestCSMOpen(2);       break;
        case E_MMI_CMD_MMC_Select_Folder_W:                    mmcExplorerTestCSMOpen(3);       break;
        case E_MMI_CMD_MMC_Save_As_Copy:                       mmcExplorerTestCSMOpen(0);       break;
        case E_MMI_CMD_MMC_Save_As_Move:                       mmcExplorerTestCSMOpen(1);       break;
*/
#endif //#if USE_MMC_SIMU

        // MMI: No CSP //
        case E_MMI_CMD_MMI_No_CSP:                             cmd_set_csp_state_false();       break;
#endif // JAVA_SDK
// SMS Commands //
        case E_MMI_CMD_SMS_Incoming_Short_Message:             MOPI_ExecuteFunction( NOPROCESS_PID, SMSSIM_IncomingShortMessage_Mopi, 0);   break; //@Str
        case E_MMI_CMD_SMS_Immediate_Message:                  MOPI_ExecuteFunction( NOPROCESS_PID, SMSSIM_ImmediateShortMessage_Mopi, 0);  break; //@Str
        case E_MMI_CMD_SMS_Status_Report:                      SMSSIM_StatusReport();
        case E_MMI_CMD_SMS_Toggle_Voice_Message:               MOPI_ExecuteFunction( NOPROCESS_PID, SMSSIM_ToggleVoiceMessage_Mopi, 0);  break; //@Str

/* Fang Yunchao modification for SMTK Localization project begin */
// #ifndef JAVA_SDK
// EMS Commands //
        case E_MMI_CMD_EMS_Build_Incoming_Short_Message:       SMSSIM_IncomingSimpleShortMsg(); break;
        case E_MMI_CMD_EMS_Send_Next_Segment_of_EMS_Message:   SMSSIM_IncomingEnhancedShortMsg();break;
 #ifndef JAVA_SDK
 /*Fang Yunchao modification for SMTK Localization project end */
// SS Commands //
        case E_MMI_CMD_SS_USSD_Notify:                         SSSIM_USSDNotify();              break;
        case E_MMI_CMD_SS_USSD_Request:                        SSSIM_USSDRequest();             break;

// RC Commands//
        case E_MMI_CMD_RC_Remote_Lock:                         RemoteLock();                    break;
        case E_MMI_CMD_RC_Remote_Unlock:                       RemoteUnlock();                  break;
        case E_MMI_CMD_RC_Command_Dialog:                      open_rc_command_dialog();        break;

// OMA: Monitor Dialog //
        case E_MMI_CMD_OMA_Monitor_Dialog:                     OpenOmaMonitorDialog();          break;

// ENIP: Commands //
        case E_MMI_CMD_ENIP_Commands:                          EnipCommandWindowInit();         break;

// Show CSM and Dialog Stack //
        case E_MMI_CMD_Show_CSM_and_Dialog_Stack:              ListViewWindowInit();            break;

// Voice Dialing / Memo, Ext. Feat
        case E_MMI_CMD_Create_Documentation:                   MSMAL_CreateParserDokumentation();break;
#if MMI_PROFILES_AVAILABLE
        case E_MMI_CMD_Initialize_Profiles:                    ProfileAL_PCSIMU_Init();         break;
#endif //MMI_PROFILES_AVAILABLE
#if MMI_VOICEDIAL_AVAILABLE
        case E_MMI_CMD_VD_TRAIN_WR_ACK_TRAIN:                  SendVoiceDialMessage(2);         break;
        case E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_OK:               SendVoiceDialMessage(3);         break;
        case E_MMI_CMD_VD_TRAIN_WR_REJ_TRAIN:                  SendVoiceDialMessage(4);         break;
        case E_MMI_CMD_VD_TRAIN_WR_IND_TIMEOUT:                SendVoiceDialMessage(5);         break;
        case E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_DIFFERENT:        SendVoiceDialMessage(6);         break;
        case E_MMI_CMD_VD_TRAIN_WR_IND_TRAIN_SIMILAR:          SendVoiceDialMessage(7);         break;
        case E_MMI_CMD_VD_TRAIN_WR_ACK_END_TRAINING:           SendVoiceDialMessage(8);         break;
        case E_MMI_CMD_VD_TRAIN_WR_REJ_END_TRAINING:           SendVoiceDialMessage(9);         break;
        case E_MMI_CMD_VD_PLAY_WR_ACK_PLAY:                    SendVoiceDialMessage(10);        break;
        case E_MMI_CMD_VD_PLAY_WR_IND_PLAYED:                  SendVoiceDialMessage(11);        break;
        case E_MMI_CMD_VD_PLAY_WR_REJ_PLAY:                    SendVoiceDialMessage(12);        break;
        case E_MMI_CMD_VD_REC_WR_ACK_RECOGNIZE:                SendVoiceDialMessage(13);        break;
        case E_MMI_CMD_VD_REC_WR_IND_RECOG_UNIQUE:             SendVoiceDialMessage(14);        break;
        case E_MMI_CMD_VD_REC_WR_IND_RECOG_UNCERTAIN:          SendVoiceDialMessage(15);        break;
        case E_MMI_CMD_VD_REC_WR_IND_RECOG_REJECTED:           SendVoiceDialMessage(16);        break;
        case E_MMI_CMD_VD_REC_WR_REJ_RECOGNIZE:                SendVoiceDialMessage(17);        break;
        case E_MMI_CMD_VD_DEL_WR_ACK_DELETE:                   SendVoiceDialMessage(18);        break;
        case E_MMI_CMD_VD_DEL_WR_ACK_DELETE_ALL:               SendVoiceDialMessage(19);        break;
#endif // MMI_VOICEDIAL_AVAILABLE

// Night Design Commands
#ifdef MMI_NIGHTDESIGN_AVAILABLE
        case E_MMI_CMD_ND_assert_Trigger_off:                   MsmLed_SetNextPattern(e_Idle);                break;
        case E_MMI_CMD_ND_assert_Trigger_PB_call:               MsmLed_SetNextPattern(e_PBookCaller);         break;
        case E_MMI_CMD_ND_assert_Trigger_other_call:            MsmLed_SetNextPattern(e_OtherCaller);         break;
        case E_MMI_CMD_ND_assert_Trigger_call_group1:           MOPI_ExecuteFunction( NOPROCESS_PID, MsmLed_SetNextPattern_Mopi, (UINT32)e_CallerGroup01 ); break; //@Str
        case E_MMI_CMD_ND_assert_Trigger_call_group2:           MOPI_ExecuteFunction( NOPROCESS_PID, MsmLed_SetNextPattern_Mopi, (UINT32)e_CallerGroup02 ); break; //@Str
        case E_MMI_CMD_ND_assert_Trigger_during_call:           MsmLed_SetNextPattern(e_DuringCall);          break;
        case E_MMI_CMD_ND_assert_Trigger_incoming_msg:          MsmLed_SetNextPattern(e_IncomingMessage);     break;
        case E_MMI_CMD_ND_assert_Trigger_alarm:                 MOPI_ExecuteFunction( NOPROCESS_PID, MsmLed_SetNextPattern_Mopi, (UINT32)e_Alarm ); break; //@Str
        case E_MMI_CMD_ND_assert_Trigger_carkit:                MOPI_ExecuteFunction( NOPROCESS_PID, MsmLed_SetNextPattern_Mopi, (UINT32)e_Carkit); break; //@Str
        case E_MMI_CMD_ND_assert_Trigger_net_search:            MsmLed_SetNextPattern(e_NetSearch);           break;
        case E_MMI_CMD_ND_assert_Trigger_low_battery:           MsmLed_SetNextPattern(e_LowBattery);          break;
        case E_MMI_CMD_ND_release_Trigger_PB_call:              MOPI_ExecuteFunction( NOPROCESS_PID, MsmLed_ClearCurrentPattern_Mopi, (UINT32)e_PBookCaller); break; //@Str
        case E_MMI_CMD_ND_release_Trigger_other_call:           MsmLed_ClearCurrentPattern(e_OtherCaller);    break;
        case E_MMI_CMD_ND_release_Trigger_call_group1:          MsmLed_ClearCurrentPattern(e_CallerGroup01);  break;
        case E_MMI_CMD_ND_release_Trigger_call_group2:          MsmLed_ClearCurrentPattern(e_CallerGroup02);  break;
        case E_MMI_CMD_ND_release_Trigger_during_call:          MsmLed_ClearCurrentPattern(e_DuringCall);     break;
        case E_MMI_CMD_ND_release_Trigger_incoming_msg:         MsmLed_ClearCurrentPattern(e_IncomingMessage);break;
        case E_MMI_CMD_ND_release_Trigger_alarm:                MsmLed_ClearCurrentPattern(e_Alarm);          break;
        case E_MMI_CMD_ND_release_Trigger_carkit:               MsmLed_ClearCurrentPattern(e_Carkit);         break;
        case E_MMI_CMD_ND_release_Trigger_net_search:           MsmLed_ClearCurrentPattern(e_NetSearch);      break;
        case E_MMI_CMD_ND_release_Trigger_low_battery:          MsmLed_ClearCurrentPattern(e_LowBattery);     break;
#endif //MMI_NIGHTDESIGN_AVAILABLE

//Audio related
        case E_MMI_CMD_AUMA_ShowPanel:                          OpenAuMaMon(); break;
#endif // JAVA_SDK


// Switch Off  //
        case E_MMI_CMD_Switch_Off:                             MOPI_ExecuteFunction( NOPROCESS_PID, SwitchOffRequest_Mopi, (UINT32)0 ); break; //@Str SwitchOffRequest();                   break;
#ifndef JAVA_SDK
// Switch Off and Save SIM Image //
        case E_MMI_CMD_Switch_Off_and_Save_SIM_Image:          MOPI_ExecuteFunction( NOPROCESS_PID, SwitchOffRequest_Mopi, (UINT32)1 ); break; //@Str SwitchOffAndSaveSIMImageRequest();    break;

// Softkeys //
        case E_MMI_CMD_Softkeys:                               openSoftKeyViewDLG();                 break;

// SyncML //
        case E_MMI_CMD_SyncML_Sync:                            saStartTestSync();                    break;
        case E_MMI_CMD_SyncML_Abort_Sync:                      saAbortTestSync();                    break;

                                                               //Bluetooth //
#if BT_AVAILABLE_PCMMI>0
        case E_MMI_CMD_Bluetooth:                              open_bt_command_dialog();             break;
#endif // BT_AVAILABLE_PCMMI

// Alarm Functionality//
        case E_MMI_CMD_Alarm_Functionality:                    OpenAlarmDlg();                       break;

// IrDA //
        case E_MMI_CMD_IrDA:                                   open_IrDA_command_dialog();           break;

// Wire simulation //
        case E_MMI_CMD_Wire_simulation:                        open_Wire_command_dialog();           break;
#endif // JAVA_SDK

// Start Java Application //
        case E_MMI_CMD_Start_Java_Application:                 startJavaApplication();               break;

// MPM Connection // 
        case E_MMI_CMD_MPM_connection:                         startMPMConnection();                 break; 

// Choose Network //
        case E_MMI_CMD_Choose_Network:                         MOPI_ExecuteFunction( NOPROCESS_PID, cmdChooseNetwork_Mopi, 0 ); break; //@Str

// Filesystem //
        case E_MMI_CMD_Send_No_Free_Space:                     FilesystemNotifyNoFreeSpace();        break;
        case E_MMI_CMD_Send_Free_Space:                        FilesystemNotifyFreeSpace();          break;


// MMS Application //
#if MMI_MMS_AVAILABLE
        case E_MMI_CMD_MMS_PUSH_NOTIFICATION_PORT:             MMSSIM_ConnectionDlg();               break;
        case E_MMI_CMD_MMS_DEBUG_DLG:                          WinMms_ShowDbgDlg();                  break;
#endif //#if MMI_MMS_AVAILABLE

// Java start parameter //
#ifndef JAVA_SDK
        case E_MMI_CMD_Java_Dialog:                            OpenJappDialogMemoryAssistant();      break;
        case E_MMI_CMD_JApp_WorldClock:                        OpenJAppDialogWorldClock();           break;
        case E_MMI_CMD_JApp_StartUpAssistant:                  OpenJAppDialogStartUpAssistant();     break;
        case E_MMI_CMD_JApp_Calculator:                        JAppCallCalculator();                 break;
        case E_MMI_CMD_JApp_UnitConverter:                     JAppCallUnitConverter();              break;
#endif

#ifdef LOCALIZATION_SUPPORT
// change UI language   //added by kevin
        case E_MMI_CMD_Change_UI_language:                      ChangeUILanguageOption();                   break;
#endif

//-- SAE_S--MOBSIM ---------------------------------------------------------
#if ((SAE_S_TEST_ACTIVE) > 0)
        case E_MMI_CMD_SAE_S_IMELODY: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_IMELODY ); break;
        case E_MMI_CMD_SAE_S_SRT_BUFFER: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_SRT_BUFFER ); break;
        case E_MMI_CMD_SAE_S_DTMF_BUFFER: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_DTMF_BUFFER ); break;
        case E_MMI_CMD_SAE_S_MIDI_BUFFER: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_MIDI_BUFFER ); break;
        case E_MMI_CMD_SAE_S_WAV_BUFFER: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_WAV_BUFFER ); break;
        case E_MMI_CMD_SAE_S_AMR_BUFFER: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_AMR_BUFFER ); break;
        case E_MMI_CMD_SAE_S_SRT_DYN: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_SRT_DYN ); break;
        case E_MMI_CMD_SAE_S_AMR_FILE: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_AMR_FILE ); break;
        case E_MMI_CMD_SAE_S_WAV_FILE: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_WAV_FILE ); break;
        case E_MMI_CMD_SAE_S_SRT_FILE: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_SRT_FILE ); break;
        case E_MMI_CMD_SAE_S_MID_FILE: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_Sounds_Mopi, (UINT32)E_SAE_S_TEST_SOUND_TYPE_MID_FILE ); break;
        case E_MMI_CMD_SAE_S_STOPALL: MOPI_ExecuteFunction( SAE_SERVICE, cmdSAE_S_TEST_STOPALL_Mopi, 0 ); break;
#endif // #if ((SAE_S_TEST_ACTIVE) > 0)

#if BLACKBERRY_AVAILABLE > 0
        case E_MMI_CMD_BlackBerry:                             OpenBlackBerryDlg();                  break;
#endif

// SHAPED_UI
#ifdef JAVA_SDK
         case E_MMI_CMD_Show_Run_Time_Heap_Info:                RunTimeHeapInfo();               break;

#endif
         case E_MMI_CMD_Setup_NITZ_Frame_Values:                MOPI_ExecuteFunction( NOPROCESS_PID, cmdSetupNitz_Mopi, 0 ); break; //@Kremni



// default
        default: ASSERT(0);
    }

    if (E_MMI_CMD >= E_MMI_CMD_00_soft_refresh && E_MMI_CMD <= E_MMI_CMD_Event_Download)
    {
        if (getCKMainState() > Sim_Init_Actions && getCKMainState() != Sim_Init_Pin_Waiting)
        {
            MOPI_ExecuteFunction( NOPROCESS_PID, simulate_toolkit_msg_Mopi, (UINT32)message );

            if (!ATAL_ToolkitActivated())
            {
                MessageBox(NULL,_T("Command will be fetched later"), _T("SIM Toolkit"), MB_ICONINFORMATION | MB_OK);
            }
        }
        else
        {
            MessageBox(NULL,_T("No card inserted or PIN entered!"), _T("ERROR SIMTOOLKIT"), MB_ICONSTOP | MB_OK);
        }
     }
}


/******************************************************************************
   Night design simulation
******************************************************************************/

#ifdef MMI_NIGHTDESIGN_AVAILABLE
static HWND hNightDesignDialog;

class NightDesignWindow : public Window
{
  public:
    static void Register(void);
    NightDesignWindow( void );
    long WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );
    void Paint (void);
};

static NightDesignWindow *pNightDesignWnd = NULL;

/* ---------------------------------------------------------- */
/* - Callback function for CreateWindow Function            - */
/* ---------------------------------------------------------- */
BOOL CALLBACK NightDesignDialogProc (HWND hwndDlg, UINT message, WPARAM wParam,
                             LPARAM lParam)
{
    switch (message)
    {
        case WM_INITDIALOG:
            return TRUE;
        case WM_CLOSE:
            /*Destroy*/DestroyWindow(hwndDlg);
            hNightDesignDialog = 0;
            pNightDesignWnd = NULL;
            return TRUE;
    }
    return FALSE;
}

long NightDesignWindow::WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam )
{
    return 0;//Pure virtual Function overridden, it has to do nothing
}


NightDesignWindow::NightDesignWindow (void)
{
    hNightDesignDialog = CreateDialog(MainApp::hInstance,MAKEINTRESOURCE(IDD_DIALOG_NIGHT_DESIGN),
        DispGetWinHandle(),(DLGPROC)NightDesignDialogProc);

    if (hNightDesignDialog == NULL)
    {
        MessageBox( DispGetWinHandle(),
            _T("Error: Could not create Night Design Dialog Window"),
            _T("PC-Simulator: Night Design Command Dialog"),
            (MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
        return;
    }
    ShowWindow(hNightDesignDialog,SW_SHOW);
}

const TCHAR* szTriggerText[11] =
{
  _T("incoming call"),
  _T("during call"),
  _T("incoming message"),
  _T("alarm"),
  _T("carkit"),
  _T("net search"),
  _T("low battery"),
  _T("switch on/off"),
  _T( "idle"),
  _T("sound player"),
  _T("off")

};

const TCHAR * szPatternText[15] =
{
   _T( "off"),
   _T( "rhythm sync."),
   _T( "speed"),
   _T("lighthouse"),
   _T( "wave"),
   _T( "beat"),
   _T( "runway"),
   _T( "trance"),
   _T( "eternity"),
   _T( "limelight"),
   _T( "blinking"),
   _T( "pulsating"),
   _T( "const. litup"),
   _T( "idle pattern"),
   _T( "always on")
};


void ShowNightDesignTrigger(UINT32             ActivationBits,
                            t_LED_Pattern      CurrentPattern,
                            t_LED_EnumFunction CurrentTrigger,
                            t_LED_EnumFunction Pipeline_0,
                            t_LED_EnumFunction Pipeline_1,
                            t_LED_EnumFunction Pipeline_2,
                            t_LED_EnumFunction Pipeline_3,
                            BOOL SchedulingAllowed,
                            BOOL DemoMode)
{
    CString                 strEntry;
    t_LED_EnumFunction      pToValue[5] = {CurrentTrigger,
                                           Pipeline_0,
                                           Pipeline_1,
                                           Pipeline_2,
                                           Pipeline_3};
    int                     pToDlgHandle[5] = {IDC_EDIT_ND_ACTIVETRIGGER,
                                               IDC_EDIT_ND_PRIO_0,
                                               IDC_EDIT_ND_PRIO_1,
                                               IDC_EDIT_ND_PRIO_2,
                                               IDC_EDIT_ND_PRIO_3};

    int i;


    for(i=0;i<5;i++)
    {
        switch(pToValue[i])
        {
            case NOTHING_TO_SCHEDULE:
                strEntry.Format( _T("%s"),"<init>" );
                break;
            case e_PBookCaller:
            case e_OtherCaller:
            case e_CallerGroup01:
            case e_CallerGroup02:
            case e_CallerGroup03:
            case e_CallerGroup04:
            case e_CallerGroup05:
            case e_CallerGroup06:
            case e_CallerGroup07:
            case e_CallerGroup08:
            case e_OtherCaller2:
                strEntry.Format(_T( "%s"),szTriggerText[0] );
                break;
            case e_DuringCall:
                strEntry.Format( _T("%s"),szTriggerText[1] );
                break;
            case e_IncomingMessage:
                strEntry.Format( _T("%s"),szTriggerText[2] );
                break;
            case e_Alarm:
                strEntry.Format( _T("%s"),szTriggerText[3] );
                break;
            case e_Carkit:
                strEntry.Format( _T("%s"),szTriggerText[4] );
                break;
            case e_NetSearch:
                strEntry.Format( _T("%s"),szTriggerText[5] );
                break;
            case e_LowBattery:
                strEntry.Format( _T("%s"),szTriggerText[6] );
                break;
            case e_SwitchOnOff:
                strEntry.Format( _T("%s"),szTriggerText[7] );
                break;
            case e_Idle:
                strEntry.Format( _T("%s"),szTriggerText[8] );
                break;
            case e_Soundplayer:
                strEntry.Format( _T("%s"),szTriggerText[9] );
                break;
            case e_LEDsOff:
                strEntry.Format( _T("%s"),szTriggerText[10] );
                break;
        }
        SetDlgItemText(hNightDesignDialog, pToDlgHandle[i], strEntry );
        SetDlgItemText(hNightDesignDialog, IDC_EDIT_ND_ACTIVEPATTERN, szPatternText[CurrentPattern] );
        if ( ActivationBits & (0x1 << CurrentPattern))
            CheckDlgButton(hNightDesignDialog, IDC_RADIO_ND_DEMOMODE, BST_CHECKED);
        else
            CheckDlgButton(hNightDesignDialog, IDC_RADIO_ND_DEMOMODE, BST_UNCHECKED);
        if(SchedulingAllowed)
            CheckDlgButton(hNightDesignDialog, IDC_RADIO__ND_SCHEDULINGALLOWED, BST_CHECKED);
        else
            CheckDlgButton(hNightDesignDialog, IDC_RADIO__ND_SCHEDULINGALLOWED, BST_UNCHECKED);

        if(DemoMode)
            CheckDlgButton(hNightDesignDialog, IDC_RADIO_ND_DEMOMODE, BST_CHECKED);
        else
            CheckDlgButton(hNightDesignDialog, IDC_RADIO_ND_DEMOMODE, BST_UNCHECKED);
    }
}

void NightDesignWindowInit(void)
{
    if ( ! MainApp::hPrevInstance )
    {
        NightDesignWindow::Register();
    }
    if (pNightDesignWnd)
    {
        ShowWindow(hNightDesignDialog,SW_SHOW);//Dialog Already there
    }
    else//Dialog not there already, create new
    {
        pNightDesignWnd = new NightDesignWindow;
    }
}

void NightDesignWindow::Paint (void)
{
}

void NightDesignWindow::Register (void)
{
}


void open_nightdesign_window(void)
{
    NightDesignWindowInit();
}


void startMPMConnection()  
{
    char portNum[30];
    sprintf(portNum,"COM%d",MPMWirePort);

    if(!CheckMPMProcess()){
        MessageBox( DispGetWinHandle(),"No Mobile Phone Manger Running!Please start MPM first!","Error",MB_ICONERROR | MB_OK);
        return;		    
    }

    if ( WireSimuState == 1 ){       //To avoid run two wire simulation applications at same time;
        MessageBox( DispGetWinHandle(),"Other wire simulation is running!Please stop them first!","Error",MB_ICONERROR | MB_OK);
        return;		    
    }else{
        if ( MPMConnectState == 0 ){
            if(!InitMPMWire()){			     //Init virtual serial port for MPM connection
                MPMConnectState = 0 ;
                MessageBox( DispGetWinHandle(),"Can not init Virtual COM port for MPM connection!","Error",MB_ICONERROR | MB_OK);
                return;					
            }	

            //Code merged from SPOITest Tool,if error happened,contact MPM guys
            IControlPtr m_IControlPtr;   
            HRESULT hr = CoInitialize(NULL); 
            hr = m_IControlPtr.CreateInstance(_uuidof(PhoneObserver ));
            m_IControlPtr->SetMode(eManualMode);
            if( m_IControlPtr->SelectConnection(_bstr_t(_T("")), _bstr_t(portNum)) != S_OK ){
                MessageBox( DispGetWinHandle(),"Send connection failed!","Error",MB_ICONERROR | MB_OK);
                MPMConnectState = 0 ;
            }else{
                MPMConnectState = 1 ;
            }
        }else{
            ExitMPMConnectionProcess();
        }		
    }
}


/////////////////////////////////////////////////////////////////////////////
// Stop NIGHT-DESIGN
/////////////////////////////////////////////////////////////////////////////

/* ---------------------------------------------------------- */
/* - Close COM Port and send disconnection command to MPM
/* ---------------------------------------------------------- */
void ExitMPMConnectionProcess()
{
    CloseMPMWire();
			
    //Code merged from SPOITest Tool,if error happened,contact MPM guys
    IControlPtr m_IControlPtr;   
    HRESULT hr = CoInitialize(NULL); 
    hr = m_IControlPtr.CreateInstance(_uuidof(PhoneObserver ));
    m_IControlPtr->SetMode(eManualMode);
    if( m_IControlPtr->SelectConnection((BSTR) NULL,(BSTR) NULL) != S_OK ){
        MessageBox( DispGetWinHandle(),"Send Disconnection failed!","Error",MB_ICONERROR | MB_OK);
	MPMConnectState = 0 ;
   }
}


BOOL CheckMPMProcess()
{
    // Get the list of process identifiers.
    DWORD aProcesses[1024], cbNeeded, cProcesses;
    unsigned int i;
    
    
    if ( !EnumProcesses( aProcesses, sizeof(aProcesses), &cbNeeded ) )
        return FALSE;

    // Calculate how many process identifiers were returned.

    cProcesses = cbNeeded / sizeof(DWORD);

    // Print the name and process identifier for each process.


    for ( i = 0; i < cProcesses; i++ ){
        if( CheckMPMProcessName(aProcesses[i] ) ==1)
            return TRUE;
    }
    return FALSE;
}

int CheckMPMProcessName(DWORD processID)
{
    char szProcessName[MAX_PATH] = "unknown";
    char MPMProcessName[200] = "Mobile Phone Manager.exe";

    // Get a handle to the process.
    HANDLE hProcess = OpenProcess( PROCESS_QUERY_INFORMATION | PROCESS_VM_READ, FALSE,processID);// Get the process name.

    if (NULL != hProcess )
    {
        HMODULE hMod;
        DWORD cbNeeded;

        if ( EnumProcessModules( hProcess, &hMod, sizeof(hMod), &cbNeeded) )
        {
            GetModuleBaseName( hProcess, hMod, szProcessName, sizeof(szProcessName) );
        }
        else return(-1);
    }
    else return(-1);

    // Print the process name and identifier.

    if( strcmp(szProcessName,MPMProcessName) == 0){
        return(1);
    }

    CloseHandle( hProcess );
    return (-1);
}

#endif      //#ifdef MMI_NIGHTDESIGN_AVAILABLE
