/*
			 Siemens AG
		 Mobile Radio Terminals
		  Munich, Germany

.AUTHOR         N.Faisst ICP CD MP GSM RD M53 (ext. MA)

.SHORT_DESCR    MFC Dialog class for editing an SMS

.SW_COMPONENT   PC-MMI-Test environment

.SW_TYPE        Support-File

.VERSION        1.1

.DATE           2001-08-21

.STATUS         OFFICAL

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
  1.0    05.04.00  N.Faisst     file created.....
  1.1   2001-08-21 H. Kratzer   ems support
  1.2   2004-05-28 Fang Yunchao(PEK) Add UNICODE support
*/
// hlp_ucs2.cpp: Implementierungsdatei
//

#include "smsafxh.h"
#include "winrc.h"
#include "sms_res.h"
#include "pcemsres.h"
//#include "smsucs2h.h"

//#include "dcsdlgh.h"
//#include "piddlgh.h"
//#include "oadlgh.h"
//#include "sctsdlgh.h"
//#include "typedlgh.h"
//#include "uddlgh.h"

#include "hlphucs2.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



void String2HexString( LPSTR aString, LPSTR HexString) {
	char tmp[ 20];
	*HexString = '\0';
	for( unsigned int i = 0; i < ( strlen( aString) - 1); i++) {
		sprintf( tmp, "%02X;", aString[ i]);
		strcat( HexString, tmp);
	}
	sprintf( tmp, "%02X", aString[ i]);
	strcat( HexString, tmp);
}

void OA2HexString( T_OA & oa, LPSTR str, BOOL bCNotation)  {
	char tmp[ 20];

	if( bCNotation) {
		sprintf( str, "0x%02X;0x%02X;",	oa.len, oa.toa);
		if( oa.len > 0) {
			for( int i = 0; i < ( ( oa.len + 1) / 2 ) - 1; i++) {
				sprintf( tmp, "0x%02X;", oa.oadata[ i]);
				strcat(str, tmp );
			}
			sprintf( tmp, "0x%02X", oa.oadata[ i]);
		}
	} else {
		sprintf( str, "%02X;%02X;",	oa.len, oa.toa);
		if( oa.len > 0) {
			for( int i = 0; i < ( ( oa.len + 1) / 2 ) - 1; i++) {
				sprintf( tmp, "%02X;", oa.oadata[ i]);
				strcat(str, tmp );
			}
			sprintf( tmp, "%02X", oa.oadata[ i]);
		}
	}
	strcat(str, tmp );				
}

void HexString2ByteArray( LPCSTR HexStr, BYTE * bArray, int & NumBytes, int MaxBytes) {
	int i =0, j = 0;
	TCHAR tempstr[ 200];
	NumBytes = 0;
	memset( bArray, '\0', MaxBytes);
	BOOL bFound = FALSE;
	while( HexStr[i]) {
		switch( HexStr[i]) {
			case SEPARATOR_CHAR :
				bFound = TRUE;
				break;
			case '\r' :
			case '\n' :
				i++;	// jump over CR And move to LF
				break;
			default :
				tempstr[ j++] = HexStr[i++];
		} 
		if( bFound || ( HexStr[i] == 0)) {
			tempstr[ j] = '\0';
			bArray[ NumBytes++] = HexStr2BYTE( tempstr);
			if( NumBytes == MaxBytes) {
				break;
			}
			j = 0;
			if( HexStr[i]) {
				i++;
			}
			bFound = FALSE;
		}
	}
}


void HexString2OA( LPCSTR str, T_OA & oa) {
	int i =0, j = 0;
	TCHAR tempstr[ 200]; 
	int Count = 0;
	memset( &oa, '\0', sizeof( T_OA));
	while( str[i]) {
		j = 0;
		while( str[ i] && ( str[ i] != SEPARATOR_CHAR)) {
			tempstr[ j++] = str[i++];
		}
		tempstr[ j] = '\0';
		Count++;
		switch( Count) {
			case 1:
				oa.len = HexStr2BYTE( tempstr);
				break;
			case 2:
				oa.toa = HexStr2BYTE( tempstr);
				break;
			default:
				if( ( Count - 3) < OA_MAX_DATA) {
					oa.oadata[ Count - 3] = HexStr2BYTE( tempstr);
				}
				break;
		}
		if( str[ i] == SEPARATOR_CHAR) i++;
	}
}


void SCTS2HexString( T_SCTS & scts, LPSTR str, BOOL bCNotation)  {
	if( bCNotation) {
		sprintf( str, "0x%02X;0x%02X;0x%02X;0x%02X;0x%02X;0x%02X;0x%02X",
				scts.Year, scts.Month, scts.Day, scts.Hour, scts.Minute,
				scts.Seconds, scts.Timezone);
	} else {
		sprintf( str, "%02X;%02X;%02X;%02X;%02X;%02X;%02X",
				scts.Year, scts.Month, scts.Day, scts.Hour, scts.Minute,
				scts.Seconds, scts.Timezone);
	}
}


void HexString2SCTS( LPCSTR str, T_SCTS & scts) {
	int i =0, j = 0;
	TCHAR tempstr[ 200];
	int Count = 0;
	memset( &scts, '\0', sizeof( T_SCTS));
	while( str[i]) {
		j = 0;
		while( str[ i] && ( str[ i] != SEPARATOR_CHAR)) {
			tempstr[ j++] = str[i++];
		}
		tempstr[ j] = '\0';
		Count++;
		switch( Count) {
			case 1:
				scts.Year = HexStr2BYTE( tempstr);
				break;
			case 2:
				scts.Month = HexStr2BYTE( tempstr);
				break;
			case 3:
				scts.Day = HexStr2BYTE( tempstr);
				break;
			case 4:
				scts.Hour = HexStr2BYTE( tempstr);
				break;
			case 5:
				scts.Minute = HexStr2BYTE( tempstr);
				break;
			case 6:
				scts.Seconds = HexStr2BYTE( tempstr);
				break;
			case 7:
				scts.Timezone = HexStr2BYTE( tempstr);
				break;
			default:
				break;
		}
		if( str[ i] == SEPARATOR_CHAR) i++;
	}
}


DWORD HexStr2DWORD( LPCTSTR hexstr) {// Fang Yunchao 2004/5/25 modification for SMTK Localization project,change LPCSTR to LPCTSTR
	  LPCTSTR sptr = hexstr;// Fang Yunchao 2004/5/25 modification for SMTK Localization project,change LPCSTR to LPCTSTR
	   if( ! _tcsnicmp( hexstr,_T( "0x"), 2)) {// Fang Yunchao 2004/5/25 modification for SMTK Localization project,change strnicmp to _tcsnicmp
		sptr = &(hexstr[2]);
	} 
	int i = 0;
	DWORD retval = 0;
	char inpchar;
	while( sptr[i]) {		
		inpchar = toupper( sptr[i]) ;
		if(( inpchar >= 'A') && (inpchar <= 'F')) {
			retval <<= 4;
			retval += ( 10 + ( inpchar - 'A'));
		}
		else if(( inpchar >= '0') && (inpchar <= '9') ){
			retval <<= 4;
			retval += ( inpchar - '0');

		} else break;  // illegal character found

		i++;
	}
	return retval;
}

#ifdef __cplusplus 
extern "C" {
#endif

void MsgBoxNotImplemented (void)
{
	TCHAR * MsgString = new TCHAR[ 1024];
	_vstprintf( MsgString, _T("Function not implemented yet \n\n Please send a simple SMS"), NULL);

	MessageBox( NULL, MsgString, _T("Warning"), MB_OK | MB_APPLMODAL | MB_ICONINFORMATION);

	delete [] MsgString;
	return;
}

void MsgBoxTestImplemented (void)
{
	TCHAR * MsgString = new TCHAR[ 1024];
	_vstprintf( MsgString, _T("Function implemented for test \n\n Better use a simple SMS"), NULL);
	 MessageBox( NULL, MsgString, _T("Warning"), MB_OK | MB_APPLMODAL | MB_ICONINFORMATION);
	delete [] MsgString;
	return;
}

void ErrorBox( char * MsgFormatString, ...) {
	va_list args;
	char * MsgString = new char[ 1024];

	va_start( args, MsgFormatString);     
	vsprintf( MsgString, MsgFormatString, args);
#ifndef _UNICODE
	MessageBox( NULL, MsgString, "Error", MB_OK | MB_ICONSTOP);
#else
	USES_CONVERSION;
	MessageBox( NULL,A2W(MsgString), _T("Error"), MB_OK | MB_ICONSTOP);
#endif
	delete [] MsgString;
}

#ifdef __cplusplus 
}
#endif
