/*! \file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME dockwnd.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE 2003-01-07

.SHORT_DESCR:   Class to get the docking window feature

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (Bardenheuer Software)
         Initial Version New UserInterface of PC-MMI-Test Environment
*/

#include "smsafxh.h"
#include "simuapph.h"
#include "dockwndh.h"
#include "mainfrmh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


BEGIN_MESSAGE_MAP(CDockingWnd, baseCDockWnd)
    //{{AFX_MSG_MAP(CDockingWnd)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/**                                                                       
 *  Constructor of CDockingWnd      
 */                                                                        
CDockingWnd::CDockingWnd()
{
}

/**                                                                       
 *  Destructor of CDockingWnd      
 */     
CDockingWnd::~CDockingWnd()
{
}

/**                                                                       
 *  Function to resize window. The function can be used during floating or 
 *  docking state of window.  
 *    
 *  @param   uiX: new width of window  
 *  @param   uiY: ne height of window  
 */                                                                        
void CDockingWnd::ReSizeWnd(UINT uiX, UINT uiY)
{
    POINT   startpoint;
    POINT   endpoint, endpointDummy;
    UINT    uiHit;
    RECT    rc;

    GetWindowRect(&rc);
    
    // Look is Docking window floating?    
    if (!IsFloating())
    {
        // If docking window is docked on top/down/left/right site 
        // then callculate start position and endposition of resize area
        if (IsTopDocked())
        {
            startpoint.x = endpoint.x = ((rc.right-rc.left)/2)+rc.left;
            startpoint.y = (rc.bottom-2);
            endpoint.y   = (rc.top+uiY);
        }
        if (IsBottomDocked())
        {
            startpoint.x = endpoint.x = ((rc.right-rc.left)/2)+rc.left;
            startpoint.y = (rc.top+2);
            endpoint.y   = (rc.top-uiY);
        }
        if (IsLeftDocked())
        {
            startpoint.x = (rc.right-2);
            startpoint.y = endpoint.y = ((rc.bottom-rc.top)/2)+rc.top;
            endpoint.x   = (rc.left+uiX);
        }
        if (IsRightDocked())
        {
            startpoint.x = (rc.left+2);
            startpoint.y = endpoint.y = ((rc.bottom-rc.top)/2)+rc.top;
            endpoint.x   = (rc.right-uiX);
        }

        uiHit = OnNcHitTest(startpoint);

        if (startpoint.x == endpoint.x &&
            startpoint.x == endpoint.x )
        {
            endpointDummy.x = endpoint.x-1;
            endpointDummy.y = endpoint.y;
            StartTracking    (uiHit, startpoint);
            OnTrackUpdateSize(CPoint(endpointDummy));
            StopTracking();
        }
      
        StartTracking    (uiHit, startpoint);
        OnTrackUpdateSize(CPoint(endpoint));
        StopTracking();
    }
    else
    {
        // Set the new size
        m_szFloat.cx = uiX;
        m_szFloat.cy = uiY;

        // Get Parent and update 
        CDockBar* pDockBar = m_pDockBar;
        ASSERT_KINDOF(CDockBar, pDockBar);
        CMiniDockFrameWnd* pDockFrame = (CMiniDockFrameWnd*)pDockBar->GetParent();
        ASSERT(pDockFrame != NULL);
        ASSERT_KINDOF(CMiniDockFrameWnd, pDockFrame);  
        pDockFrame->RecalcLayout(TRUE);
        pDockFrame->UpdateWindow();
    }
} 


