/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       Iplugininterface.h

.TODO           

.SHORT_DESCR    Pure virtual PlugIn interface functions definition. 

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br> 
------------------------------------------------------------------------------*/
#ifndef _PLUGIN_INTERFACE_H_
#define _PLUGIN_INTERFACE_H_
/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "plugintyps.h"

/* -----------------------------------------------------------------------------
DEFINES
------------------------------------------------------------------------------*/
/** @defgroup plug_in_interface_base Plug-in BASE Interface 
 *  Base interface of the plug-ins for the PC-Simulation.
 *  @{
 */


/**
 *   \def PLUGIN_API_VERSION
 *   A Versioning Macro to determine the PlugIns API version. 
 *   This macro will be use to check the interface compatibility between 
 *   the PC-Simulation and the PlugIn
 *
 *   IMPORTANT: The PLUGIN_API_VERSION must be increase by every change of 
 *   the Interface!!! Don't forget!!!
 */
#define PLUGIN_API_VERSION 0x0001 //!!!Don't forget to increase if you make a change!!!


/** \interface IPlugInInterfaceBase
 *  This interface is the base plug-in interface for the PC-Simulation. PC-Simulation should be able 
 *  to call from your plug-in every following interface functions. 
 */
interface IPlugInInterfaceBase
{
    /** 
     *   Increments the counter which represent the number of pointers to the dll.
     *   
     *   @return  UINT: a value which identies the number of pointers to the class.
     */
    virtual UINT AddRef()  PURE;

    /**
     *   Release function of the object IPlugInInterfaceBase. If the internal counter is 0 the 
     *   object will be destroyed.
     *
     *   @return  UINT: a value which identies the number of pointers to the class.
     */
    virtual UINT  Release() PURE;

    /**
     *   This function will return the PLUGIN_API_VERSION (interface version) 
     *   which was compiled with the PlugIn.
     *
     *   @return  DWORD: a value which identifies the API version of the PlugIn.
     */
    virtual DWORD GetPlugInAPIVersion() PURE;

    /**
     *   This function will return the Name and Info of the PlugIn.
     *
     *   @param  pcStrPlugInName: A pointer of CString variable to get the name of the Plugin.
     *   @param  pcStrPlugInInfo: A pointer of CString variable to get the info of the Plugin.
     */
    virtual void  GetPlugInNameInfo(CString *pcStrPlugInName, CString *pcStrPlugInInfo) PURE;

    /**
     *   This function is a message port to the loaded plug-in. You can send messages to your plug-in
     *   with the name of the plug-in, the needed message Id, additional pointer to your object (example struct pointer), 
     *   and a additional pointer of a function.  
     *
     *   @param  cStrPlugInName: The name of the plug-in which gets the message.
     *   @param  uiMsg:          The Plug-in message.
     *   @param  lParam:         Additional message-dependent information.
     *   @param  pParam:         Additional message-dependent information.
     *
     *   @return  UINT:          The result of the message processing; its value depends on the message sent.
     */
    virtual UINT  PlugInMessagePort(const CString cStrPlugInName , UINT uiMsg, LPARAM lParam, PVOID pParam) PURE;
};

#endif // _PLUGIN_INTERFACE_H_
/** @} */ // end of plug_in_interface_base
/* -----------------------------------------------------------------------------
END OF FILE Iplugininterface.h
------------------------------------------------------------------------------*/

