
//BrowseCHM_PlugInInterface.cpp

#include "StdAfx.h"
#include "browsechm_plugininterface.h"
#include "BrowseCHMDialog.h"

// The only one exported function
AFX_API_EXPORT DWORD InitPlugIn(IPlugInInterfaceBase *&ptrPlugInInterface, IApplicationInterfaceBase *ptrAppInterface)
{
    if (ptrAppInterface == NULL) //check the PC-Simulation interface 
        return PLUGIN_ERROR_APPL_INTERFACE_IS_NULLP;

    if (ptrPlugInInterface != NULL) 
        return PLUGIN_ERROR_PLUGIN_INTERFACE_IS_NOT_NULLP;

    // Check the version of the PC-Simulation API version
    if (APPLICATION_BASE_API_VERSION == ptrAppInterface->GetApplicationAPIVersion())
    {
        AFX_MANAGE_STATE(AfxGetStaticModuleState());
        // Create new plug-in object ans set the PC-Simulation interface 
        ptrPlugInInterface = new CBrowseCHM_PlugInInterface(ptrAppInterface);
        ptrPlugInInterface->AddRef(); //counter +1
        return PLUGIN_ERROR_SUCCESS;
    }
    else
    {
        return PLUGIN_ERROR_WRONG_APPL_API_VERSION;
    }
}


CBrowseCHM_PlugInInterface::CBrowseCHM_PlugInInterface(IApplicationInterfaceBase* ptrAppInterface)
{
    m_uiRefCount      = 0;                        // initialize member variable
    m_ptrAppInterface = ptrAppInterface;          // save the PC-Simu interface
    m_uiCommand      = m_ptrAppInterface->GetCommandIDs(1); // get 1 uniq command ID 
    //m_uiCommand2      = m_ptrAppInterface->GetCommandIDs(1); // get 1 uniq command ID
    m_cStrPlugInName.LoadString(IDS_PLUGIN_NAME); // load the plug-in name
    m_cStrPlugInInfo.LoadString(IDS_PLUGIN_INFO); // load the plug-in info

}

CBrowseCHM_PlugInInterface::~CBrowseCHM_PlugInInterface(void)
{

}

DWORD CBrowseCHM_PlugInInterface::GetPlugInAPIVersion()
{
    // return the plug-in Interface version 
    return PLUGIN_API_VERSION;
}

void CBrowseCHM_PlugInInterface::GetPlugInNameInfo(CString *pcStrPlugInName, 
                                                CString *pcStrPlugInInfo)
{
    *pcStrPlugInName = m_cStrPlugInName;
    *pcStrPlugInInfo = m_cStrPlugInInfo;
}

UINT CBrowseCHM_PlugInInterface::AddRef()
{ 
    m_uiRefCount++;	
    return m_uiRefCount;
}

UINT CBrowseCHM_PlugInInterface::Release()
{ 
    m_uiRefCount--;
    if (0==m_uiRefCount)
    {
        delete this;
        return 0;
    }
    else
        return m_uiRefCount;
}

UINT CBrowseCHM_PlugInInterface::PlugInMessagePort(const CString cStrPlugInName, UINT uiMsg, LPARAM lParam, PVOID pParam)
{
    if (!m_cStrPlugInName.Compare(cStrPlugInName) || !cStrPlugInName.Compare("*"))
    {
        switch (uiMsg)
        {
            case PM_CREATE_PLUGIN_MENU:
            {
                HMENU menu = (HMENU)lParam;

                AppendMenu(menu, MF_SEPARATOR, 0, "-");
                AppendMenu(menu, MF_STRING, m_uiCommand, "Show Help Files Assistant Dialog");
            }
            break;

            case PM_CREATE_PLUGIN_TOOLBAR:
            {
                AFX_MANAGE_STATE(AfxGetStaticModuleState());

                T_PlugIn_TB_Info* pTBInfo = (T_PlugIn_TB_Info*)lParam;

                if (pTBInfo != NULL)
                {
                    pTBInfo->iNumberBtn  = 1;//Number of Buttons

                    if (m_cToolBarBitmap.LoadBitmap(IDB_PLUGIN_BROWSE_CHM))
                        pTBInfo->pToolbarBmp = (long*)&m_cToolBarBitmap;

                    m_TBbutton.iBitmap   = 0;
                    m_TBbutton.idCommand = m_uiCommand;
                    m_TBbutton.fsState   = TBSTATE_ENABLED;
                    m_TBbutton.fsStyle   = TBSTYLE_BUTTON;
                    m_TBbutton.dwData    = 0;
                    m_TBbutton.iString   = 0;

                    pTBInfo->pToolbarBtn = (long*)&m_TBbutton;
                    return PM_CREATE_PLUGIN_TOOLBAR;
                }
            }
            break;
            default:
            {
                if (uiMsg == m_uiCommand)
                {
                    // Create the dialog box for Browse CHM
                    AFX_MANAGE_STATE(AfxGetStaticModuleState());
                    CBrowseCHMDialog dlg;
                    dlg.DoModal();
                }
            }
            break;
        }
    }
    return PM_MESSAGE_OK;
}
