#ifndef _MOPI_PLUGIN_INTERFACE_H_
#define _MOPI_PLUGIN_INTERFACE_H_
/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Walter Stroell

.FILENAME      MOPI_PlugInInterface.h

.VERSION       00.00.00

.DATE          2004-03-25

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Walter Stroell
         initial version
------------------------------------------------------------------------------*/


#include "Iappinterface.h"
#include "Iappinterfacemopi.h"
#include "Iplugininterface.h"


class CMOPI_PlugInInterface : public IPlugInInterfaceBase //,public CObject
{

public:
    UINT  AddRef();
    UINT  Release();
    DWORD GetPlugInAPIVersion();               
    void  GetPlugInNameInfo(CString *pcStrPlugInName, CString * pcStrPlugInInfo);
    UINT  PlugInMessagePort(const CString cStrPlugInName , UINT uiMsg, LPARAM lParam, PVOID pParam);

    CMOPI_PlugInInterface(IApplicationInterfaceBase* ptrAppInterface);
private:
    UINT                       m_uiRefCount;      ///< Counter for the number of pointers to an instance of this class.
    CString                    m_cStrPlugInName;  ///< Name of this PlugIn.
    CString                    m_cStrPlugInInfo;  ///< Short descriptin of this PlugIn.
    IApplicationInterfaceBase* m_ptrAppInterface;
    IApplicationInterfaceMOPI* m_ptrAppInterfaceMOPI;
    UINT                       m_uiCommand1;
    //UINT                       m_uiCommand2;
    TBBUTTON                   m_TBbuttons[1];
    CBitmap                    m_cToolBarBitmap;
};

// Exported Plug-In method
PLUGIN_API_EXTERN AFX_API_EXPORT DWORD InitPlugIn(IPlugInInterfaceBase *&ptrPlugInInterface, IApplicationInterfaceBase *ptrAppInterface);

#endif //_MOPI_PLUGIN_INTERFACE_H_