/*
				Siemens AG
		 Mobile Radio Terminals
			 Kamp-Lintfort, Germany

.AUTHOR			Reinhard Peters, ICM D MP RD Klf 10

.SHORT_DESCR	OMA momitor

.SW_COMPONENT	PC simulation

.STATUS			FIRST VERSION

.CHANGE_CONTROL
 Version | Date     | Changed by | Reason for Change
    1.0	   20.11.00   R. Peters	   file created
    1.1    08/01/01   R. Peters    OMA_StoreDataToFile added
    1.2    23/01/01   R. Peters    Error messages for OnSimulate added
    1.3    25/01/01   R. Peters    Functions added to simulate the sending
                                   of data to sms and to store the resulting
                                   short message to *.seo file
    1.4    01.03.01   R. Peters    Add functions to watch DDL Heap in OMA monitor
                                   Use global send function from ddl
    1.5    02.06.01   R. Peters    Handle very long file names
    1.6    21.06.01  B.Wiesweg     files with 0 bytes allowed
    1.7    04.12.01   R. Peters    Use a special medium NO_via_SIMU for the simulation
    1.8    16.01.02   R. Peters    Enhance simulation to see if sent object is received 
                                   and accepted by the receiver
    1.9    04.07.02   B. Wiesweg   DDL_SendObject now with parameter transactionId
Version   Date         Changed by 
          Reason for Change
-----------------------------------------------------------------------------------------------------
08.01.00  2002-02-08   Reinhard Peters (Klf)
          Add fields to show explorer heap sizes in OMA monitor
08.02.00  2002-09-18   Andre Schmidt (Klf)
          Insert Test Enviroment (look into ddl_test)
09.00.00  2002-10-11   Reinhard Peters (Klf)
          Bugfix: Wrong error message in case problems with opening files
09.01.01  2003-07-09   Bernhard Wiesweg (Klf)
          OMA_GetTransactionStatus changed
09.01.02  2003-10-28   Klaus Staudenmaier (ULM)
          Uncomment DbgOut in Function OMA_StoreSMSToFile because of compile
	  errors	  
09.01.03  2004-01-08   Alexander Paalvast (ICT)
          Use MOPI_ExecuteFunction to retrieve heap sizes, DDLTest_NewDataObjectReceive,
           and DDL_SendObject.
          OMA_StoreDataToFile now only uses WSS fields in structure.
09.01.04  2004-04-01   Alexander Paalvast (ICT)
          Remove calls to old Explorer functions.
09.01.05  2004-05-28   Fang Yunchao  (PEK)
          Add UNICODE Support.
*/


////////////////////////////////////////////////////////////////////////////////////////
//
// winkoma.cpp: Implementierungsdatei
//
////////////////////////////////////////////////////////////////////////////////////////
// windows stuff
#include <afxwin.h>         // MFC-Kern- und -Standardkomponenten
#include <afxext.h>         // MFC-Erweiterungen
#include <afxdlgs.h>        // Common dialogs
#include "winrc.h"
#include "winkrc.h"
#include "winkomah.h"
// form mobile software
extern "C"
{
#include "global.h"
#include "gbs.h"
#include "oma.h"
#include "llisth.h"
#include "omainth.h"
#include "ddl_prch.h"
//#include "ex_proch.h"
#include "ddl_memh.h"
#include "vcdbgout.h"	// Hilfsfunktion DbgOut() zur Ausgabe in den Debug-Stream, define LOC fr #pragma message
}
#include "mopiext.h"
////////////////////////////////////////////////////////////////////////////////////////


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
#define MAX_BUFFER_SIZE 4096
////////////////////////////////////////////////////////////////////////////////////////
CDlgOMAMonitor dlgOmaMonitor;
char SendBuffer[MAX_BUFFER_SIZE+1];
////////////////////////////////////////////////////////////////////////////////////////
#define OMATEST_ENVIROMENT OFF

#if OMATEST_ENVIROMENT == ON && MOBSIM > 0
    extern "C" void DDLTest_NewDataObjectReceive(const char* _filename/*, const protocolMedium_e _protocolMedium*/);
#endif

////////////////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------
// MOPI execution wrapper to read heap used/free byte count
//----------------------------------------------------------

typedef struct
{
    int HeapUsedOMA,  HeapFreeOMA;
    int HeapUsedExpl, HeapFreeExpl;
    int HeapUsedDDL,  HeapFreeDDL;
} T_HeapUsage;
static T_HeapUsage HeapUsage;

static void Execute_GetHeapSizes (UINT32 param)
{
    OMA_GetHeapSizes( &HeapUsage.HeapUsedOMA,  &HeapUsage.HeapFreeOMA );
    //EX_GetHeapSizes(  &HeapUsage.HeapUsedExpl, &HeapUsage.HeapFreeExpl );
    DDL_GetHeapSizes( &HeapUsage.HeapUsedDDL,  &HeapUsage.HeapFreeDDL );
}

//----------------------------------------------------------
// MOPI execution wrapper for starting sending of an object
//----------------------------------------------------------

typedef struct
{
    protocolMedium_e medium;
    T_ID             transactionID;
    char             szObName[128];
    char             szObType[128];
    char             *pData;
    unsigned int     nSize;
    BOOL             transparent;
    BOOL             bOpenAppl;
} T_SendObjectData;
static T_SendObjectData SendObjectData;

static void Execute_SendObject (UINT32 param)
{
    (void)DDL_SendObject (SendObjectData.medium, SendObjectData.transactionID, SendObjectData.szObName,
        SendObjectData.szObType, SendObjectData.pData, SendObjectData.nSize, SendObjectData.transparent,
        SendObjectData.bOpenAppl);
}

static void Call_DDL_SendObject (
                     protocolMedium_e medium,
                     T_ID             transactionID,
                     char             *szObName,
                     char             *szObType,
                     char             *pData,
                     unsigned int     nSize,
                     BOOL             transparent,
                     BOOL             bOpenAppl
                   )
{
    // Note: pData is assumed to point to a static buffer, e.g. SendBuffer.
    SendObjectData.medium = medium;
    SendObjectData.transactionID = transactionID;
    strncpy (SendObjectData.szObName, szObName, 127);
    strncpy (SendObjectData.szObType, szObType, 127);
    SendObjectData.pData = pData;
    SendObjectData.nSize = nSize;
    SendObjectData.transparent = transparent;
    SendObjectData.bOpenAppl = bOpenAppl;

    MOPI_ExecuteFunction (NOPROCESS_PID, Execute_SendObject, 0);
}

#if OMATEST_ENVIROMENT == ON && MOBSIM > 0
//----------------------------------------------------------------------------
// MOPI execution wrapper for starting sending of a large object via ddl_test
//----------------------------------------------------------------------------

static char DataObjectReceiveFilename[128];

static void Execute_NewDataObjectReceive (UINT32 param)
{
    DDLTest_NewDataObjectReceive(DataObjectReceiveFilename);
}

static void Call_DDLTest_NewDataObjectReceive(const char* szFName)
{
    strncpy (DataObjectReceiveFilename, szFName, 128);

    MOPI_ExecuteFunction (NOPROCESS_PID, Execute_NewDataObjectReceive, 0);
}

#endif // OMATEST_ENVIROMENT == ON && MOBISIM > 0

////////////////////////////////////////////////////////////////////////////////////////
extern "C" void OpenOmaMonitorDialog( void ) 
////////////////////////////////////////////////////////////////////////////////////////
// This functions open the OMA monitor window.
////////////////////////////////////////////////////////////////////////////////////////
{
	if ( dlgOmaMonitor.m_IsOpen )
	{
		dlgOmaMonitor.DestroyWindow();
		dlgOmaMonitor.m_IsOpen = FALSE;
	}
	else
	{
		dlgOmaMonitor.Create( DLG_OMAMONITOR );
		dlgOmaMonitor.ShowWindow( SW_NORMAL );
		dlgOmaMonitor.m_IsOpen= TRUE;
	}
} //  OpenOmaMonitorDialog /////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
// Dialog box CDlgOMAMonitor 
////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
CDlgOMAMonitor::CDlgOMAMonitor(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgOMAMonitor::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgOMAMonitor)
		// HINWEIS: Der Klassen-Assistent fgt hier Elementinitialisierung ein
	//}}AFX_DATA_INIT

	m_IsOpen = FALSE;
} // Construction //////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::DoDataExchange(CDataExchange* pDX)
////////////////////////////////////////////////////////////////////////////////////////
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOMAMonitor)
		// HINWEIS: Der Klassen-Assistent fgt hier DDX- und DDV-Aufrufe ein
	//}}AFX_DATA_MAP
} // DataExchange //////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CDlgOMAMonitor, CDialog)
	//{{AFX_MSG_MAP(CDlgOMAMonitor)
	ON_BN_CLICKED(IDC_BUTTON1, OnClose)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_OMAMON_SIMULATE, OnSimulate)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_OMAMON_SIMULATE2, OnSimulateSms)
END_MESSAGE_MAP()
////////////////////////////////////////////////////////////////////////////////////////


	
/////////////////////////////////////////////////////////////////////////////
// event handling CDlgOMAMonitor 
////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::OnClose() 
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
{
	m_IsOpen = False;
	DestroyWindow();	
} // OnClose ///////////////////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////////////////////////////////////
BOOL CDlgOMAMonitor::OnInitDialog() 
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
{
	CDialog::OnInitDialog();
	
	m_UpdateCount = 0;
	m_nHeapUsed = 0;
	m_nHeapFree = 0;
	Update();
	SetTimer( 1, 500, NULL );
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
} // OnInitDialog //////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::OnTimer(UINT nIDEvent) 
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
{
	switch ( nIDEvent )
	{
		case 1:
			Update();
		break;
		case 2:

		break;
	}
	CDialog::OnTimer(nIDEvent);
} // OnTimer ///////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::Update()
////////////////////////////////////////////////////////////////////////////////////////
// This function returns the entries of the list of registered media/protocols.
// Created: 25/10/2000  by R. Peters
////////////////////////////////////////////////////////////////////////////////////////
{ 
	applExtStruct*	pALElem = NULL;
	protMedProcIDSizeStruct* pOLElem = NULL;
	dataObjectExchangeStruct *udsData;
	CString			strLEntry;
	CString			strEntry;
	char			szPName[40];
	char			szObjName[20];
	int				nPSize;
	CListBox*		pObjBox = (CListBox*) GetDlgItem( IDC_OMAMON_OBJLIST );
	CListBox*		pPMBox = (CListBox*) GetDlgItem( IDC_OMAMON_MEDLIST );
	///////////////////////////////////////////////////////////////////////////////////

	// Read the list with registered objects and applications -------------------------
	if ( m_UpdateCount % 20 == 0 )
	{
        m_UpdateCount = 0;
        pObjBox->ResetContent();
		pALElem = OMA_GetApplicationObject( pALElem, szPName, szObjName ); // Init 
		while ( pALElem ) // Entry found 
		{
			// look for next entry
			pALElem = OMA_GetApplicationObject( pALElem, szPName, szObjName );
			// Put text to list box
			strLEntry.Format( _T("%s, %s"), szObjName, szPName );
			pObjBox->AddString( strLEntry );
		} // all entries from list of registered objects ----------------------------------

		// Read the list with registered protocols/media and packet size ------------------
		pPMBox->ResetContent();
		pOLElem = OMA_GetProtocolMedia( pOLElem, szPName, &nPSize ); // Init 
		while ( pOLElem ) // Entry found 
		{
			// look for next entry
			pOLElem = OMA_GetProtocolMedia( pOLElem, szPName, &nPSize );
			// Put text to list box
			strLEntry.Format( _T("%s, %d"), szPName, nPSize );
			pPMBox->AddString( strLEntry );
		} // all entries from list of registered protocols/media --------------------------
	}

    m_UpdateCount ++;

	OMA_GetTransactionStatus( &udsData );

	strEntry.Format( _T("%s"), udsData->szStText );
	SetDlgItemText( IDC_OMAMON_STATUS, strEntry );
	if ( strEntry == "undefined" ) {
		SetDlgItemText( IDC_OMAMON_BUFSIZE, strEntry );
		SetDlgItemText( IDC_OMAMON_DATSIZE, strEntry );
		SetDlgItemText( IDC_OMAMON_PACKETS, strEntry );
		SetDlgItemText( IDC_OMAMON_MOREDAT, strEntry );
	}
	else
	{
		strEntry.Format(_T( "%d"), udsData->bufferSize );
		SetDlgItemText( IDC_OMAMON_BUFSIZE, strEntry );
		strEntry.Format( _T("%d"), udsData->objectSize);
		SetDlgItemText( IDC_OMAMON_DATSIZE, strEntry );
		strEntry.Format( _T("%d"), udsData->numberOfPackets );
		SetDlgItemText( IDC_OMAMON_PACKETS, strEntry );
		if ( udsData->moreDataFlag ) 
			strEntry = _T("Yes");
		else
			strEntry = "No";
		SetDlgItemText( IDC_OMAMON_MOREDAT, strEntry );
	}

    MOPI_ExecuteFunction (NOPROCESS_PID, Execute_GetHeapSizes, 0);

    strEntry.Format( _T("%d"), HeapUsage.HeapUsedOMA );
	SetDlgItemText( IDC_OMAMON_HBUSED, strEntry );
    strEntry.Format(_T( "%d"), HeapUsage.HeapFreeOMA );
	SetDlgItemText( IDC_OMAMON_HBFREE, strEntry );

    strEntry.Format( _T("%d"), HeapUsage.HeapUsedExpl );
	SetDlgItemText( IDC_OMAMON_HBUSED3, strEntry );
    strEntry.Format( _T("%d"), HeapUsage.HeapFreeExpl );
	SetDlgItemText( IDC_OMAMON_HBFREE3, strEntry );

    strEntry.Format( _T("%d"), HeapUsage.HeapUsedDDL );
	SetDlgItemText( IDC_OMAMON_HBUSED2, strEntry );
    strEntry.Format(_T( "%d"), HeapUsage.HeapFreeDDL );
	SetDlgItemText( IDC_OMAMON_HBFREE2, strEntry );


} // CDlgOMAMonitor::Update ///////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::OnSimulate() 
///////////////////////////////////////////////////////////////////////////////////////
// This function is called when button simulate is pressed in oma monitor dialog.
// An incoming data object will be simulated, select a file and the content of this
// file will be put by the bitmap viewer process to the oma.
///////////////////////////////////////////////////////////////////////////////////////
{
    CFile cIF;						// Input File
    CFileDialog cFD( True );		// Open File Dialog
    CString strName;				// Path and Filename returned by open file dlg.
    ///////////////////////////////////////////////////////////////////////////////
    char szFName[256];					// Name of input file
#if OMATEST_ENVIROMENT == OFF && MOBSIM > 0
    char szText[256];
    char szName[256], szExt[10];
    int  nFileSize;
#endif
    int	 nResult = 0;
    CButton* pBOpen = (CButton*) GetDlgItem( IDC_OMAMON_OPENAP );
    BOOL bOpen = pBOpen->GetCheck();
    ///////////////////////////////////////////////////////////////////////////////


	if ( cFD.DoModal() == IDOK ) // show file open dialog -------------------------
	{
		strName = cFD.GetPathName( );
#ifndef _UNICODE
        	strcpy( szFName, strName );	
#else
	  	strcpy( szFName, (LPSTR)(LPCTSTR)strName );	
#endif
#if OMATEST_ENVIROMENT == ON && MOBSIM > 0
        Call_DDLTest_NewDataObjectReceive(szFName);
        }
#else
		//  Open the input file ----------------------------------------------------
#ifndef _UNICODE
		if ( cIF.Open( szFName, CFile::modeRead | CFile::typeBinary ) )
#else
		USES_CONVERSION;
		if ( cIF.Open( A2W(szFName), CFile::modeRead | CFile::typeBinary ) )
#endif
		{
			nFileSize = cIF.Read( &SendBuffer[0], MAX_BUFFER_SIZE );
			cIF.Close();
			if (nFileSize < MAX_BUFFER_SIZE) 
			{ // ? File size OK ----------------------------------------------------
				_splitpath( szFName, NULL, NULL, szName, szExt );
                                if ( strlen( szName ) > 80 )
                                       szName[80] = 0;
				strcat( szName, szExt );
                Call_DDL_SendObject( NO_via_SIMU, NO_T_ID, szName, &szExt[1], &SendBuffer[0],
					nFileSize, True, bOpen );

			} // if nFileSize > 0 --------------------------------------------------
			else // Input file empty or exeeds buffer size -------------------------
				nResult = nFileSize == 0 ? 2 : 3;
		} // Open input file -------------------------------------------------------
		else
			nResult = 1; // Input file could not be opened -------------------------
	
	}
	switch ( nResult ) // give a feedback to the user ---------------------------------
	{
		case 1:
			sprintf( szText, "Input file %s could not be opened!", szFName );
			break;
		case 2:
			sprintf( szText, "Input file %s is empty!", szFName );
			break;
		case 3:
			sprintf( szText, "Input file %s is too big", szFName );
			break;
	}
	if ( nResult > 0 )
{
#ifndef _UNICODE
		AfxMessageBox(szText );
#else
		USES_CONVERSION;
		AfxMessageBox( A2W(szText ));
#endif
}
#endif
} // OnSimulate ////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////
void CDlgOMAMonitor::OnSimulateSms() 
///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
{
	CFile cIF;						// Input File
	CFileDialog cFD( True );		// Open File Dialog
	CString strName;				// Path and Filename returned by open file dlg.
	///////////////////////////////////////////////////////////////////////////////
	char szFName[256];					// Name of input file
	char szText[256];
	char szName[20], szExt[20];
	int  nFileSize;
	int	 nResult = 0;
	///////////////////////////////////////////////////////////////////////////////
	if ( cFD.DoModal() == IDOK ) // show file open dialog -------------------------
	{
		strName = cFD.GetPathName( );
#ifndef _UNICODE
		strcpy( szFName, strName );
#else
		strcpy( szFName, (LPSTR)(LPCTSTR)strName );
#endif


		//  Open the input file ----------------------------------------------------
#ifndef _UNICODE
		if ( cIF.Open( szFName, CFile::modeRead | CFile::typeBinary ) )
#else
		USES_CONVERSION;
		if ( cIF.Open( A2W(szFName), CFile::modeRead | CFile::typeBinary ) )
#endif
		{
			nFileSize = cIF.Read( &SendBuffer[0], MAX_BUFFER_SIZE );
			cIF.Close();
			if (nFileSize < MAX_BUFFER_SIZE) 
			{ // ? File size OK ----------------------------------------------------
				_splitpath( szFName, NULL, NULL, szName, szExt );
				strcat( szName, szExt );
				strcpy( szName, "" );
                Call_DDL_SendObject( SMS_via_SMS_SEND, NO_T_ID, szName, &szExt[1], &SendBuffer[0],
					nFileSize, False, False );

			} // if nFileSize > 0 --------------------------------------------------
			else // Input file empty or exeeds buffer size -------------------------
				nResult = nFileSize == 0 ? 2 : 3;
		} // Open input file -------------------------------------------------------
		else
			nResult = 1; // Input file could not be opened -------------------------
	
	}
	switch ( nResult ) // give a feedback to the user ---------------------------------
	{
		case 1:
			sprintf( szText, "Input file %s could not be opened!", szFName );
			break;
		case 2:
			sprintf( szText, "Input file %s is empty!", szFName );
			break;
		case 3:
			sprintf( szText, "Input file %s is too big", szFName );
			break;
	}
	if ( nResult > 0 )
	{
#ifndef _UNICODE
	AfxMessageBox( szText );
#else
        USES_CONVERSION;
	AfxMessageBox( A2W(szText) );
#endif
	}
} // OnSimulateSMS ////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////
extern "C" int OMA_StoreDataToFile( sendDataStruct *pData )
///////////////////////////////////////////////////////////////////////////////////////
// This function is used by the OMA to store data to a file instead of sending
// the data only used for the pc simulation.
///////////////////////////////////////////////////////////////////////////////////////
{
    // Convert WStrings to ASCII
    char pcObjectType[EMAXPATH];
    char pcObjectName[EMAXPATH];
    (void)WStringSafe_Ucs2_To_ANSI (pcObjectName, pData->pWSSToObjectName, EMAXPATH-1);
    (void)WStringSafe_Ucs2_To_ANSI (pcObjectType, pData->pWSSToObjectType, EMAXPATH-1);

    CFile cOF;                                          // Output File
#ifndef _UNICODE
	CFileDialog cFD( False, pcObjectType );
#else
	USES_CONVERSION;
	CFileDialog cFD( False, A2W(pcObjectType ));
#endif
    CString strName;                // Path and Filename returned by open file dlg.
    int  nResult = 0;               // result of subordinated routine
    char szFName[256];              // Name of Output file
    char szText[256];               // Text for user message
    char *pszExt;
    ///////////////////////////////////////////////////////////////////////////////////
    // check if a name is given -------------------------------------------------------
    if ( strcmp( pcObjectName, "" ) == 0 )
    {
        // if not open file selection dialog ------------------------------------------
        if ( cFD.DoModal() == IDOK )
        {
            strName = cFD.GetPathName( );
#ifndef _UNICODE
            strcpy( szFName, strName );
#else
	    USES_CONVERSION;
	    strcpy( szFName, W2A(strName ));
#endif
        }
        else // no file selected ------------------------------------------------------
            nResult = 1;
    }
    else // get the given file name ---------------------------------------------------
    {
        strcpy( szFName, pcObjectName );
        strcpy( szText, "." );
        strcat( szText, pcObjectType );
        pszExt = strrchr( szFName, '.' );
        if ( !pszExt )
        {
            strcat( szFName, "." );
            strcat( szFName, pcObjectType );
        }
        else if ( strcmp( pszExt, szText ) != 0 )
        {
            strcat( szFName, "." );
            strcat( szFName, pcObjectType );
        }
    }
    if ( nResult == 0 ) // if a file name is present ----------------------------------
    {
        //  Open the input file -------------------------------------------------------
#ifndef _UNICODE
	if ( cOF.Open(szFName, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary ) )
#else
	USES_CONVERSION;
	if ( cOF.Open(A2W( szFName), CFile::modeCreate | CFile::modeWrite | CFile::typeBinary ) )
#endif
        {
            cOF.Write( pData->ptrToBuffer, pData->objectSize );
            cOF.Close();
        } // Open output file ---------------------------------------------------------
        else
            nResult = 2; // output file could not be opened ---------------------------
    }
    switch ( nResult ) // give a feedback to the user ---------------------------------
    {
        case 0:
            sprintf( szText, "Data stored to %s!", szFName );
            break;
        case 1:
            strcpy( szText, "No file name given, Abort!" );
            nResult = 2;
            break;
        case 2:
            sprintf( szText, "Output file %s could not be opened", szFName );
            nResult = 2;
            break;
    }
    strcat( szText, "\nDo you accept the data?" );
    strcat( szText, "\nPress button YES to send READY to OMA" );
    strcat( szText, "\nPress button NO to send REJECT to OMA" );
    strcat( szText, "\nPress button CANCEL to send ABORT to OMA" );
    if ( nResult == 0 )
    {
#ifndef _UNICODE
	 nResult = AfxMessageBox( szText, MB_ICONQUESTION | MB_YESNOCANCEL );
#else
	USES_CONVERSION;
	 nResult = AfxMessageBox( A2W(szText), MB_ICONQUESTION | MB_YESNOCANCEL );
#endif
        if ( nResult == IDYES )
            nResult = 0;
        else if ( nResult == IDNO )
            nResult = 1;
        else if ( nResult == IDCANCEL )
            nResult = 2;
    }
    else
    {
#ifndef _UNICODE
	AfxMessageBox( szText, MB_ICONSTOP );
#else
	AfxMessageBox( (LPCTSTR)szText, MB_ICONSTOP );
#endif
     }
    return nResult;
} // OMA_StoreDataToFile //////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////
extern "C" void OMA_StoreSMSToFile( void *pData, int nSize )
///////////////////////////////////////////////////////////////////////////////////////
// This function is used by the Smo_SPro SMS mobile orignated Send Procedure to store 
// data to a file instead of sending the data only used for the pc simulation.
///////////////////////////////////////////////////////////////////////////////////////
{
	CFile cOF;											// Output File
	CString strName;				// Path and Filename returned by open file dlg.
	int	 nResult = 0;				// result of subordinated routine
	TCHAR szFName[256];				// Name of Output file
	BOOL bFound = False;
	int  nCount = 0;
	///////////////////////////////////////////////////////////////////////////////////
    // check if a name is given -------------------------------------------------------
	CTime Time = CTime::GetCurrentTime();
	
	do
	{
		strName.Format( _T("%2.2d%2.2d%2.2d_%4.4d"), Time.GetYear(), Time.GetMonth(), 
			Time.GetDay(), nCount );
		strName += ".seo";
		_tcscpy( szFName, strName );
		if ( cOF.Open( szFName, CFile::modeRead ) ) 
		{
			cOF.Close();
			nCount++;
		}
		else
			bFound = True;
	} while ( !bFound );

//	DbgOut(__FILE__ "(%i): SMS sended to file %s", __LINE__, szFName);
	
	//  Open the input file -----------------------------------------------------------
	if ( cOF.Open( szFName, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary ) )
	{
		cOF.Write( pData, nSize );
		cOF.Close();
	} // Open output file ---------------------------------------------------------
	else
		nResult = 1; // output file could not be opened ---------------------------
} // OMA_StoreSMSToFile //////////////////////////////////////////////////////////////


// EOF ////////////////////////////////////////////////////////////////////////////////

