/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR Harpreet Singh

.FILENAME simjava.cpp

.CSVERSION 1.1

.VERSION 01.01.00

.DATE 2003-11-04

.SHORT_DESCR  dialog implementation for Memory assistant for java 

.SW_COMPONENT PC-MMI-Test Environment

.SW_TYPE 

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2003-10-22 Harpreet Singh
         Initial Version
01.01.00 2003-11-04 Christoph Scharenberg (KLF)
         mec#42634 Added interface for application
---------------------------------------------------------------------------------*/
// SimJava.cpp : implementation file
//

/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include <global.h> 
#include <afxwin.h>
#include <afxext.h>
#include <afxdlgs.h>
#include <AFXCMN.H>
#include "winrc.h" 
#include "winkrc.h"
#include "sms_res.h"
 

#include "simjava.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimJava dialog


CSimJava::CSimJava(CWnd* pParent /*=NULL*/)
	: CDialog(CSimJava::IDD, pParent)
	, m_nMemoryReq(0)
	, m_StrPath(_T(""))
{
	//{{AFX_DATA_INIT(CSimJava)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	
}


void CSimJava::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimJava)
	// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_EDIT2, m_nMemoryReq);
	DDX_CBString(pDX, IDC_EDIT3, m_StrPath);
}

BOOL CSimJava::OnInitDialog() 
{
	CDialog::OnInitDialog();
	UpdateData(false);
	return TRUE;
}


BEGIN_MESSAGE_MAP(CSimJava, CDialog)
	//{{AFX_MSG_MAP(CSimJava)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
	
	
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimJava message handlers




void CSimJava::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);

	OnOK();

}

void CSimJava::GetApplicationPath( T_WStringSafe * fpPath ) const
{
    if ( fpPath != NULL )
    {
        int Length = m_StrPath.GetLength();
        int i;

        WStringSafe_Shorten( fpPath, 0 );
        for ( i=0 ; i<Length; i++ )
        {
            WStringSafe_Append( fpPath, m_StrPath[i] );
        }
    }
}


unsigned long CSimJava::GetApplicationMemoryLimit( void ) const
{
    return (unsigned long)m_nMemoryReq;
}

/* -----------------------------------------------------------------------------
    END OF FILE simjava.cpp
------------------------------------------------------------------------------*/
