/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME mainview.cpp


.CSVERSION 1.1


.VERSION 01.01.00

.DATE 2004-02-04

.SHORT_DESCR:   MainView of the aplication

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (Bardenheuer Software)
         Initial Version New UserInterface of PC-MMI-Test Environment
01.01.00 2004-02-04 Murat Korkmaz
         Onpaint function for a new bitmap enhanced.
*/

#include "smsafxh.h"
#include "simuapph.h"
#include "mainviewh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/**                                                                       
 *  Constructor of class CMainView
 */                                                                        
CMainView::CMainView()
{
}

/**                                                                       
 *  Destructor of class CMainView     
 */                                                                        
CMainView::~CMainView()
{
}


BEGIN_MESSAGE_MAP(CMainView,CWnd )
    //{{AFX_MSG_MAP(CMainView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMainView message handlers

/**                                                                       
 *  Called by the framework before the creation of the Windows window 
 *  attached to this CWnd object. You can use CreateSolidBrush function to
 *  determine specific background color.
 *    
 *  @param   cs: The CREATESTRUCT structure defines the initialization parameters passed 
 *               to the window procedure of an application. 
 *  
 *  @return  BOOL: Nonzero if the window creation should continue; 0 to indicate creation failure.
 */                                                                        
BOOL CMainView::PreCreateWindow(CREATESTRUCT& cs) 
{
    if (!CWnd::PreCreateWindow(cs))
        return FALSE;

    // Change background color
    HBRUSH hbr = ::CreateSolidBrush(0xFFFFFF);

    cs.dwExStyle |= WS_EX_CLIENTEDGE;
    cs.style     &= ~WS_BORDER;
    cs.lpszClass  = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
                                        ::LoadCursor(NULL, IDC_ARROW), hbr, NULL);

    return CWnd::PreCreateWindow(cs);
}


BOOL GetBitmapAndPalette(UINT nIDResource, CBitmap &bitmap, CPalette &pal)
{
	LPCTSTR lpszResourceName = (LPCTSTR)nIDResource;

	HBITMAP hBmp = (HBITMAP)::LoadImage( AfxGetInstanceHandle(), 
			lpszResourceName, IMAGE_BITMAP, 0,0, LR_CREATEDIBSECTION );

	if( hBmp == NULL ) 
		return FALSE;

	bitmap.Attach( hBmp );

	// Create a logical palette for the bitmap
	DIBSECTION ds;
	BITMAPINFOHEADER &bmInfo = ds.dsBmih;
	bitmap.GetObject( sizeof(ds), &ds );

	int nColors = bmInfo.biClrUsed ? bmInfo.biClrUsed : 1 << bmInfo.biBitCount;

	// Create a halftone palette if colors > 256. 
	CClientDC dc(NULL);			// Desktop DC
	if( nColors > 256 )
		pal.CreateHalftonePalette( &dc );
	else
	{
		// Create the palette

		RGBQUAD *pRGB = new RGBQUAD[nColors];
		CDC memDC;
		memDC.CreateCompatibleDC(&dc);

		memDC.SelectObject( &bitmap );
		::GetDIBColorTable( memDC, 0, nColors, pRGB );

		UINT nSize = sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * nColors);
		LOGPALETTE *pLP = (LOGPALETTE *) new BYTE[nSize];

		pLP->palVersion = 0x300;
		pLP->palNumEntries = nColors;

		for( int i=0; i < nColors; i++)
		{
			pLP->palPalEntry[i].peRed = pRGB[i].rgbRed;
			pLP->palPalEntry[i].peGreen = pRGB[i].rgbGreen;
			pLP->palPalEntry[i].peBlue = pRGB[i].rgbBlue;
			pLP->palPalEntry[i].peFlags = 0;
		}

		pal.CreatePalette( pLP );

		delete[] pLP;
		delete[] pRGB;
	}

	return TRUE;
}


void CMainView::OnPaint() 
{
	CPaintDC dc(this);

	// Create a memory DC compatible with the paint DC
	CDC memDC;
	memDC.CreateCompatibleDC( &dc );

	CBitmap bitmap;
	CPalette palette;

	GetBitmapAndPalette( IDB_ICM_LOGO, bitmap, palette );
	memDC.SelectObject( &bitmap );

	// Select and realize the palette
	if( dc.GetDeviceCaps(RASTERCAPS) & RC_PALETTE && palette.m_hObject != NULL )
	{
		dc.SelectPalette( &palette, FALSE );
		dc.RealizePalette();
	}
	dc.BitBlt(0, 0, 410, 124, &memDC, 0, 0,SRCCOPY);
}

