/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME javaoutputview.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE  2003-09-11

.SHORT_DESCR:   Java output window

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-09-11 Murat Korkmaz 
         Initial Version      
01.00.01 2003-09-12 Frank Schultze (MCH)
         Put cursor always at end of text
01.00.02 2004-05-27 Fang Yunchao (PEK)
         Add UNICODE support
*/


#include "javaoutputviewh.h"



#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNCREATE(CJavaOutputView, CRichEditView)
BEGIN_MESSAGE_MAP(CJavaOutputView, CRichEditView)
	//{{AFX_MSG_MAP(CJavaOutputView)
    ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONUP()
    ON_COMMAND(ID_EDIT_CLEAR_ALL, OnClearAll)
	//}}AFX_MSG_MAP
    ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)
    ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnUpdateFilePrintPreview)
END_MESSAGE_MAP()

CJavaOutputView::CJavaOutputView()
{  
}

CJavaOutputView::~CJavaOutputView()
{
    m_dwRef = 0;
}

void CJavaOutputView::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();
   	if (m_font.CreatePointFont(80, _T("Tahoma")))
	   SetFont(&m_font);

	// Set the printing margins (720 twips = 1/2 inch).
	SetMargins(CRect(720, 720, 720, 720));
}

void CJavaOutputView::JavaOutput(UINT uiMessage, CString cStrOutPut)
{
    switch (uiMessage)
    {
        case 1:
        {
            CString cStrText;
            GetRichEditCtrl().GetWindowText(cStrText);
            cStrText += cStrOutPut;
            SetWindowText(cStrText);
            GetRichEditCtrl().SetSel(-1,-1);
        }
        break;
        case 2:
        {
            OnClearAll();
        }
        break;
    }
}
void CJavaOutputView::OnClearAll()
{
    SetWindowText(_T(""));
}

// CJavaOutputView diagnostics

#ifdef _DEBUG
void CJavaOutputView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CJavaOutputView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CJavaOutputView printing

BOOL CJavaOutputView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CJavaOutputView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	ClientToScreen(&point);
	OnContextMenu((CWnd* )NULL, point);
}

void CJavaOutputView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
    BOOL  bFloating = ((CDockingWnd*)GetOwner())->IsFloating();

	// TODO: Add your message handler code here
	if( point.x == -1 && point.y == -1 )
	{
		CRect	rect;		
		GetClientRect(rect);
		ClientToScreen(rect);	
		point = rect.TopLeft();	
		point.Offset(5, 5);
	}

	CMenu	menu;
	VERIFY(menu.LoadMenu(IDR_POP_JAVAOUTPUT));

	CMenu* pPopup = menu.GetSubMenu(0);	
	ASSERT(pPopup != NULL);
	CWnd* pWndPopupOwner = this;

  

	while(pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();

    if (bFloating)
    {
        pPopup->EnableMenuItem(ID_FILE_PRINT_PREVIEW, MF_GRAYED);
        pWndPopupOwner = this;
    }

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
		point.x, point.y, pWndPopupOwner);
}


void CJavaOutputView::OnUpdateFilePrintPreview(CCmdUI* pCmdUI)
{
    BOOL bEnable =  !((CDockingWnd*)GetOwner())->IsFloating();
    pCmdUI->Enable(bEnable);
}


