// ChangeUILanguage.cpp : implementation file
//
#ifdef LOCALIZATION_SUPPORT

#include "smsafxh.h"
#include "winrc.h"
#include "sms_res.h"
#include "LocalizationCtrl.h"
#include "ChangeUILanguageDlg.h"
#include "Localizationapi.h"
#include "mainfrmh.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeUILanguage dialog
//#ifdef LOCALIZATION_SUPPORT

#ifdef LOCALIZATION_SUPPORT
CChangeUILanguageDlg::CChangeUILanguageDlg(CWnd* pParent /*=NULL*/)
	: CLocalizationDialog(CChangeUILanguageDlg::IDD, pParent)
#else
CChangeUILanguageDlg::CChangeUILanguageDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CChangeUILanguageDlg::IDD, pParent)
#endif
{
	//{{AFX_DATA_INIT(CChangeUILanguage)

	m_sCurrentLang = _T("");

	//}}AFX_DATA_INIT
}


void CChangeUILanguageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeUILanguage)
	DDX_Control(pDX, IDC_AVA_LANG_COMBO, m_AvaLang);
	DDX_Text(pDX, IDC_CURRENT_LANG_EDIT, m_sCurrentLang);
	//}}AFX_DATA_MAP
}

int CChangeUILanguageDlg::EnumLang(void * UI, int CurIndex, LPCTSTR key,unsigned int fullnameID)
{
	CChangeUILanguageDlg * pDlg = (CChangeUILanguageDlg *)UI;
	ASSERT(pDlg);
#ifndef _UNICODE	
	CString str;
	str =CLocalizationCtrlInterface::GetStringFromID(fullnameID);

	pDlg->m_AvaLang.InsertString(CurIndex,(LPCTSTR)str);

	pDlg->m_AvaLang.SetItemDataPtr(CurIndex,new CString(key));
	pDlg->UpdateData(FALSE);
	pDlg->m_AvaLang.SetCurSel(0);
	return 1;
#else	
	_TCHAR				AvailableLangName[128];

	if( GetLocaleInfoW(fullnameID,LOCALE_SNATIVELANGNAME,AvailableLangName,128)) {					
		pDlg->m_AvaLang.InsertString(CurIndex,AvailableLangName);
		pDlg->m_AvaLang.SetItemDataPtr(CurIndex,new CString(key));
		pDlg->UpdateData(FALSE);
		pDlg->m_AvaLang.SetCurSel(0);
		return 1;
	}
	
	return 0;
#endif
}

void CChangeUILanguageDlg::InitLanguageOptions()
{
	m_sCurrentLang = CLocalizationCtrlInterface::GetCurrentLangFullName();
	
	EnumAvailableLanguage((LangEnum )EnumLang,this);
}

BEGIN_MESSAGE_MAP(CChangeUILanguageDlg, CDialog)
	//{{AFX_MSG_MAP(CChangeUILanguageDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeUILanguage message handlers

BOOL CChangeUILanguageDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	InitLanguageOptions();
	BOOL res = UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChangeUILanguageDlg::OnOK() 
{
	// TODO: Add extra validation here
	//change the position for SMTK Localization support
	CDialog::OnOK();
	int sel = m_AvaLang.GetCurSel();
	CString * ptr = (CString *)m_AvaLang.GetItemDataPtr(sel);
	ASSERT(ptr);
	CString CurLangAbb(CLocalizationCtrlInterface::GetCurrentAbb());
	if(CurLangAbb.Compare(*ptr) != 0){
		CLocalizationCtrlInterface::SetCurrentLanguage(*ptr);
		((CMainFrame*) GET_APP()->m_pMainWnd)->SendMessage(WM_UPDATE_WINDOWS_UI);	
	}
//	CDialog::OnOK();
	
}

void CChangeUILanguageDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	int count = m_AvaLang.GetCount();
	for(int i=0;i<count;i++){
		CString * ptr = (CString *)(m_AvaLang.GetItemDataPtr(i));
		delete ptr;
	}
	CDialog::OnClose();
}
#endif
