/*
             Siemens AG
         Mobile Radio Terminals
          Munich, Germany

.AUTHOR         Hierl Christine

.SHORT_DESCR    ENIP Simulation

.SW_COMPONENT   PC-MMI-Testumgebung

.SW_TYPE        Support-File

.VERSION        1.2.00

.DATE           19.03.03 
.STATUS         OFFICIAL

.CHANGE_CONTROL
Version |  Date  | 	Changed by	| Reason for Change
  0.0    07.07.00	R. Muenninghoff		file created
  0.1    07.12.00	R. Muenninghoff		TCP/UDP tests added    
  0.2	 10.09.01	L. Sillge     		NO_PROCESS -> NOPROCESS_PID
  0.3	 20.09.01	R. Muenninghoff		GetGostByName added
  1.0    28.08.02	C. Hierl		    Redesign
  1.1    04.10.02	C. Hierl			et_free replaced by enip_memory_release, ErrnoText() changed
  1.1.01 22.11.02   N. Haiduk           fix: unresolved external "RecvMessage" due to missing 'extern "C"
  1.1.02 09.01.03	C. Hierl			some Messages added, logbuffer enlarged, query to avoid getting logtext longer than logbuffer added		
  1.2.00 19.03.03   C. Hierl            IPv4 extentions
  1.2.01 06.08.03   P. Grubmair         start IPv6 support 
  1.2.02 19.08.03   C. Hierl            PPP Internal checkbox added, errno text adapted
  1.2.03 21.08.03   C. Hierl            FreeDlg added, LmanDlg changed
  1.2.04 25.09.03   C. Hierl            bugfix: winsock2.h included 
  1.2.05 06.11.03   C. Hierl            changes due to MOPI (MOPI_ExecuteFunction)
  1.3.05 17.12.03   P. Grubmair         support for lman_connectext in lman dialog
  1.5.06 21.06.04   Alex Nagy (BS/MCH)  PC-MMI replaced inc_private_alias.h by the C2C concept
  */ 

extern "C"
{
#include <global.h>
#include "gbs.h"
#include "gbsheap.h"
#include "llisth.h"
//#include "listview.h"
#include "etest.h"
#include "conhndl.h"
//#include "ebsdh.h"
//#include "enipsock.h"
#include "eipenv.h"

#include "eipv6cnv.h"
#include "epacket.h"

#include "xidialh.h" //for W2K
#include "etrace.h"
#include "eipcore.h" 

}

#undef s_addr
#include <winsock2.h>

#include <stdlib.h>
#include <stdio.h>

#include "winmain.h"
#include "winrc.h"
#include "commctrl.h"
#include "lmanapif.h" //for eLmanConnectionType in DLGEnipConnect

#include "mopiext.h" //for MOPI_ExecuteFunction


//extern "C" unsigned int xIpcltSetIpVersion(const unsigned int version);


extern "C" HWND DispGetWinHandle(void);
//extern "C" void on_Msg_FYH_TESTMODE(void);
extern "C" void LMAN_TestConnectGPRS(void);
extern "C" void LMAN_TestConnectCSD(void);
extern "C" void LMAN_TestDisconnect(void);
//extern "C" void	ConHndl_LoadProfileParameters(T_ConHndl_ProfileSetId ProfileSetId, T_ConHndl_ProfileId ProfileId, T_ConHndl_Bearer Bearer, T_ConHndl_ProfileParameters *pDestParameters);
//extern "C" void	ConHndl_ReadParameter(const T_ConHndl_ProfileParameters *pParameters, T_ConHndl_ParameterId ParameterId, void *pBuffer);

extern "C" void EnipTestDlgInit(UINT32);  //Init and switch on function of the Testprocess


#if PPP_MON_TEST > 0
#if TESTPROC_TEST_IF > 0

#define MsgRECEIVE 1000

#define MSGBOX_ON 0    //switch popup when Message arrives on(1) or off(0)

//only for Test of the DLL
extern "C" unsigned int xIpcltGetLocalInterfaceIdentifier(const unsigned int ti, UINT8 *const aBuffer, const unsigned int aBufferLen);

UINT8 MyInterID[8];

//extern "C" unsigned int TestSetIpVersion(const unsigned int version);
extern "C" void RecvMessage( char * , int );

void on_TEST_M_LMAN_CONNECT_RET(SLIP_Puffer *);
void on_TEST_M_LMAN_CONNECTEXT_RET(SLIP_Puffer *);
void on_TEST_LMAN_CONNECT_CNF(SLIP_Puffer *);	
void on_TEST_LMAN_CONNECT_REJ_IND(SLIP_Puffer *);
void on_TEST_M_LMAN_DISCONNECT_RET(SLIP_Puffer *);
void on_TEST_M_LMAN_DISCONNECTEXT_RET(SLIP_Puffer *);
void on_TEST_LMAN_DISCONNECT_CNF(SLIP_Puffer *);
void on_TEST_LMAN_DISCONNECT_IND(SLIP_Puffer *);
void on_TEST_RET_bsd_socket(SLIP_Puffer *);
void on_TEST_RET_bsd_sendto(SLIP_Puffer *);
void on_TEST_RET_bsd_bind(SLIP_Puffer *);
void on_TEST_LMAN_SOCK_DATA_READ(SLIP_Puffer *);
void on_TEST_RET_bsd_recvfrom(SLIP_Puffer *);
void on_TEST_RET_bsd_connect(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_CONNECTED(SLIP_Puffer *);
void on_TEST_RET_bsd_close(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_CLOSED(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_REMOTE_CLOSED(SLIP_Puffer *);
void on_TEST_RET_bsd_shutdown(SLIP_Puffer *);
void on_TEST_RET_bsd_send(SLIP_Puffer *);
void on_TEST_RET_bsd_recv(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_ACCEPTED(SLIP_Puffer *);
void on_TEST_RET_pattern_send(SLIP_Puffer *);
void on_TEST_RET_pattern_sendto(SLIP_Puffer *);
void on_TEST_RET_bsd_gethostbyname(SLIP_Puffer *);
void on_TEST_RET_sock_gethostbyaddr(SLIP_Puffer * );
void on_TEST_LMAN_SOCK_HOST_BY_NAME(SLIP_Puffer *);
void on_TEST_RET_bsd_listen(SLIP_Puffer *);
void on_TEST_RET_bsd_accept(SLIP_Puffer *);
void on_TEST_RET_bsd_ioctl(SLIP_Puffer *);
void on_TEST_RET_bsd_setsockopt(SLIP_Puffer *);
void on_TEST_RET_bsd_getlocaladdr(SLIP_Puffer *);
void on_TEST_RET_bsd_getremoteaddr(SLIP_Puffer *);
void on_TEST_RET_sock_getsockname(SLIP_Puffer *);
void on_TEST_RET_sock_getpeername(SLIP_Puffer *);

void on_TEST_RET_sock_inet_ntoa(SLIP_Puffer *);
void on_TEST_RET_sock_inet_addr(SLIP_Puffer *);
void on_TEST_RET_sock_htonl(SLIP_Puffer *);
void on_TEST_RET_sock_htons(SLIP_Puffer *);
void on_TEST_RET_sock_ntohl(SLIP_Puffer *);
void on_TEST_RET_sock_ntohs(SLIP_Puffer *);

void on_TEST_RET_sock_getsockopt(SLIP_Puffer *);

void on_TEST_ENIP_SOCK_ICMP_ERROR(SLIP_Puffer *);

void on_TEST_RET_read_profile(SLIP_Puffer *);
void on_TEST_RET_write_profile(SLIP_Puffer *);

void on_TEST_ENIP_BUFFER_FREE(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_SEND_WND_OPENED(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_SEND_TIMEOUT(SLIP_Puffer *);
void on_TEST_ENIP_SOCK_DATA_SENT(SLIP_Puffer *);
void on_TEST_LMAN_SOCK_HOST_BY_ADDR(SLIP_Puffer *);
void on_TEST_RET_sock_select(SLIP_Puffer *);

void on_TEST_RET_sock_startup(SLIP_Puffer *);
void on_TEST_RET_sock_cleanup(SLIP_Puffer *);
void on_TEST_RET_sock_getlasterror(SLIP_Puffer *);
void on_TEST_RET_sock_setlasterror(SLIP_Puffer *);


		
//-------------------------------------------------------------------

BOOL InitEnipDialog(void);
BOOL DLGEnipConnect(void);
BOOL DLGEnipCreate(int, int, int);
BOOL DLGEnipConnectSoc(void);
BOOL DLGEnipBind(void);
BOOL DLGEnipListen(void);
BOOL DLGEnipAccept(void);
BOOL DLGEnipSend(void);
BOOL DLGEnipSendto(void);
BOOL DLGEnipReceivefrom(void);
BOOL DLGEnipReceive(void);
BOOL DLGEnipCloseSoc(void);
BOOL DLGEnipDisconnect(void);
BOOL DLGEnipGetHostByName(void);
BOOL DLGEnipAGetHostByName(void);
BOOL DLGEnipShutdown(void);
BOOL DLGEnipPatternSendto(void);
BOOL DLGEnipPatternSend(void);
BOOL DLGEnipGetHostByAddr(void);
BOOL DLGEnipAGetHostByAddr(void);
BOOL DLGEnipGetPeerName(void);
BOOL DLGEnipGetSockName(void);
BOOL DLGEnipInetNtoa(void);
BOOL DLGEnipInetAddr(void);
BOOL DLGEnipSockHtonl(void);
BOOL DLGEnipSockHtons(void);
BOOL DLGEnipSockNtohl(void);
BOOL DLGEnipSockNtohs(void);
BOOL DLGEnipSockSelect(void);

bool DLGEnipWriteProfile(void);
bool DLGEnipReadProfile(void);

BOOL pppMon(void);

#endif //TESTPROC_TEST_IF
void on_MsgRECEIVE(UINT32);
void receive_SLIP_packet(  char * ,  int);
#if TESTPROC_TEST_IF > 0 

//Help functions
void PrintReleaseCause(int); // resolve ReleaseCause(=cause for lman reject indication) values and print them
void ErrnoText(void);   //resolve errno values to text and print the text in the errno-ED-Box
void SetLogText(char *); //add the passed text to the logbox


#endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST
static HWND hEnipDialog=0;
#if PPP_MON_TEST > 0
#if TESTPROC_TEST_IF > 0

//windows handles
static HWND hEnipUdp=0;
static HWND hEnipTcp=0;
static HWND hEnipLman=0;
static HWND hEnipOther=0;
static HWND hEnipDNR=0;
static HWND hEnipSockOpt=0;
static HWND hEnipProfile=0;
static HWND hEnipSelect=0;
static HWND hEnipConvert=0;
static HWND hEnipHelp=0;
static HWND hEnipFree=0;
static HWND hTab=0;
static HWND *hAktTab=0;
char DlgSlipBuffer[1500]; 
char logtext[15000];
char ltext[15000];

// 
#define MAX_NUMBER_ENIPLMAN_CIDS 10
static int enipLmanCidArrayLen = 1 ; // first entry invalid - No
static unsigned int enipLmanCidArray [MAX_NUMBER_ENIPLMAN_CIDS] = { ~(unsigned int)(0),0} ;
#define INET6_ADDRSTRLEN 46 // should be available in eipv6cnv.h 

#define MAX_NUMBER_TESTDLG_SOCKETS 5
SOCKET SocketNr[MAX_NUMBER_TESTDLG_SOCKETS /*5*/]={ -1, -1, -1, -1, -1};

SOCKET FdsReadList[10]={ -1, -1, -1, -1, -1,-1, -1, -1, -1, -1}; //fds list for sock_select
int FdsReadListIndex = 0;

SOCKET FdsWriteList[10]={ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}; //fds list for sock_select
int FdsWriteListIndex = 0;

SOCKET FdsExceptList[10]={ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}; //fds list for sock_select
int FdsExceptListIndex = 0;

int IDC_SOCNR[5]= {IDC_SOCNR1, IDC_SOCNR2, IDC_SOCNR3, IDC_SOCNR4, IDC_SOCNR5};
int IDC_PORTNR[5]= {IDC_PORTNR1, IDC_PORTNR2, IDC_PORTNR3, IDC_PORTNR4, IDC_PORTNR5};
int IDC_AF[5]= {IDC_AF1, IDC_AF2, IDC_AF3, IDC_AF4, IDC_AF5};
int IDC_PROT[5]= {IDC_PROT1, IDC_PROT2, IDC_PROT3, IDC_PROT4, IDC_PROT5};
int IDC_SOCL[5]= {IDC_SOCL1, IDC_SOCL2, IDC_SOCL3, IDC_SOCL4, IDC_SOCL5};
int IDC_CMD[2]={TP_FIONREAD, TP_FIONBIO}; //BSD_FIONREAD};
int IDC_LEV[3]={BSD_IPPROTO_IP, BSD_IPPROTO_TCP, BSD_SOL_SOCKET};
int IDC_ONAME[2]={BSD_IP_TTL, BSD_IP_TOS};
int IDC_Shutdown[3]={ BSD_SD_RECEIVE, BSD_SD_SEND, BSD_SD_BOTH};

char pBuffer[4000];
int pBufferLen=4000;

int iTpOn=0;  //help Var to decide wheather IDC_B_TP_ON_OFF was pressed one or more times
 
static SLIP_Puffer pSlipBuffer;

SOCKET shndl=-1;
struct sockaddr_in s_in;
struct sockaddr_in RecvSin;
int RecvSinLen;

extern "C" BOOL pppMonMod;
extern "C" long Testflags;
extern "C" int ENIP_TEST_IpVers;
extern "C" int gPPPInternal;

BOOL WAITFOR=0;

char errnotxt[100][50]={ //"BSD_EUNKNOWN", 
							"Failure",
							"BSD_EWOULDBLOCK", 
							"BSD_EINPROGRESS",
							//"BSD_ENOTSOCK",
							"not socket",		//3
							"BSD_EMSGSIZE",	
							//"BSD_EPROTONOSUPPORT",
							"protocol not supported",
							//"BSD_EOPNOTSUPP",
							"option not supported",
							//"BSD_ESOCKTNOSUPPORT",
							"socket type not supported",
							//"BSD_EAFNOSUPPORT",
							"address family not supported",
							"BSD_EFAULT",				
							//"BSD_EADDRINUSE",
							"socket already bound to this port",
							//"BSD_ENETDOWN",
							"No network connection",
							"BSD_ECONNABORTED",		
							//"BSD_ECONNRESET",
							"received buffered data are dropped",
							//"BSD_ENOBUFS",
							"no buffer space",
							//"BSD_EISCONN",
							"socket is already connected",
							//"BSD_ENOTCONN",
							"socket not connected",
							//"BSD_ETIMEDOUT",	
							"timed out",
							"BSD_ECONNREFUSED",		
							//"BSD_EHOSTUNREACH",
							"DNS Server unreachable",
							//"BSD_EINVAL",
							"Invalid parameter",					
							"BSD_EINTR",				
							//"BSD_ENOMEM",
							"not enough memory",
							"BSD_ENOTRECORDED",			
							"BSD_EALREADY"};
#endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST

							
//------------------------------------------------------------------------------------
// Helper functions:
int GetSocketAF( int af_id )
{
#if TESTPROC_TEST_IF > 0
#if PPP_MON_TEST > 0
 int af_index,
     s_index;

 //
 for( af_index=0; af_index<MAX_NUMBER_TESTDLG_SOCKETS; af_index++)
 {
  if( SocketNr[af_index] == (SOCKET)af_id )
  {
   s_index = af_index;
   break;
  }   
 }

 //
 if( af_index >= 5 )
  return -1;

 //
 GetDlgItemText( hEnipDialog, IDC_AF[s_index], pBuffer, pBufferLen);

 //
 if( pBuffer[3] == '4' )
  return BSD_AF_INET;
 else
 if( pBuffer[3] == '6' )
  return BSD_AF_INET6;

  #endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST

 // no valid AF
 return -1;
}

//help function, called after pressing a button to cause TestProcess calling a socket function
//as therefore GBS-functions are used, it must be done by a MOPI - process
#if PPP_MON_TEST > 0
void MOPI_DLGnewAction(unsigned short aActionId, SLIP_Puffer * pMyTXBuffer)
{

	MOPI_DLGnewActionParas.aActionId = aActionId;
    MOPI_DLGnewActionParas.pMyTXBuffer = pMyTXBuffer;

	MOPI_ExecuteFunction( NO_PROCESS_PID,DLGnewAction, (UINT32) (&MOPI_DLGnewActionParas));  
}
#endif

 void SwitchAusCmd(UINT32 cmd)   //function for Aus-Dlg, called in MOPI_ExecuteFunction as
                                 //following functions will use GBS functions, so they must be
								 //called by a MOPI-process
{

	switch(cmd)
	{
     	case IDC_B_GCON:     //connect GPRS
			LMAN_TestConnectGPRS();						
		break;
		
		case IDC_B_CCON:     //connect CSD
			LMAN_TestConnectCSD();
		break;

		case IDC_B_DISCON:     //disconnect
			LMAN_TestDisconnect();
		break;
	}
}


//------------------------------------------------------------------------------------
//dialog box procedures

// dialog box procedure for the Command Dialog if PPP_MON_TEST = 0 or TESTPROC_TEST_IF = 0
BOOL CALLBACK EnipDlgAusProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipDialog = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				return TRUE;
			}

			case WM_COMMAND:
			{
				//simulate MOPI process calling the LMAN-functions which might use GBS-functions 
				//as this one is called by an Windows-Process
				MOPI_ExecuteFunction(NO_PROCESS_PID, SwitchAusCmd, (UINT32)(LOWORD(wParam))); 

                return TRUE;
			}
	}
	return FALSE;
}

#if PPP_MON_TEST > 0
#if TESTPROC_TEST_IF > 0


/////////////////////////////////////////////
//     <DIALOG FOR FREE USE!!!>            //
/////////////////////////////////////////////

// dialog box procedure for the TabControl dialog of the Command Dialog
BOOL CALLBACK EnipFreeDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	int set1=0;
	int set2=0;
	int set3=0;
	char FreeDlgBuffer[1000];

	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipFree= 0;
				return TRUE;
			}

			case WM_INITDIALOG:   //init the boxes with values
			{
				//For example:

				SetDlgItemText( hwndDlg,IDC_E_EDIT1, "INIT");
				SetDlgItemText( hwndDlg,IDC_E_EDIT2, "AND");
				SetDlgItemText( hwndDlg,IDC_E_EDIT3, "EDIT US!");
				SetDlgItemText( hwndDlg,IDC_S_TEXT1, "all in winenip.cpp: search for <DIALOG FOR FREE USE!!!>");
				SetDlgItemText( hwndDlg,IDC_BUTT1, "GIVE US");
				SetDlgItemText( hwndDlg,IDC_BUTT2, "SOME");
				SetDlgItemText( hwndDlg,IDC_BUTT3, "TASKS!");
				SetDlgItemText( hwndDlg,IDC_BUTT4, "PRESS ME");

				//Init the combobox IDC_CB1
				SendMessage(GetDlgItem(hwndDlg, IDC_CB1), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "in winenip.cpp");  
				SendMessage(GetDlgItem(hwndDlg, IDC_CB1), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "INIT ME!!");  

				SendMessage(GetDlgItem(hwndDlg, IDC_CB1), CB_SETCURSEL, 0, 0); //1. entry preset

				//Init the combobox IDC_CB2
				SendMessage(GetDlgItem(hwndDlg, IDC_CB2), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "search for <DIALOG FOR FREE USE!!!>");  
				SendMessage(GetDlgItem(hwndDlg, IDC_CB2), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "INIT ME!!");  

				SendMessage(GetDlgItem(hwndDlg, IDC_CB2), CB_SETCURSEL, 0, 0); //1. entry preset



				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
				    case IDC_BUTT1: //button 1 was pressed 
						//add the functions to test here, e.g.:
						SetDlgItemText( hwndDlg,IDC_S_TEXT1, "button 1 was pressed");

						//Get the values of the Edit-boxes, write them in FreeDlgBuffer
						GetDlgItemText( hwndDlg, IDC_E_EDIT1, FreeDlgBuffer, sizeof(FreeDlgBuffer));
						GetDlgItemText( hwndDlg, IDC_E_EDIT2, FreeDlgBuffer, sizeof(FreeDlgBuffer));
						GetDlgItemText( hwndDlg, IDC_E_EDIT3, FreeDlgBuffer, sizeof(FreeDlgBuffer));

						return TRUE;
					break;

					case IDC_BUTT2: //button 2 was pressed

						//add the functions to test here:
						SetDlgItemText( hwndDlg,IDC_S_TEXT1, "button 2 was pressed");
						return TRUE;
					break;

					case IDC_BUTT3: //button 3 was pressed

						//add the functions to test here: 
						SetDlgItemText( hwndDlg,IDC_S_TEXT1, "button 3 was pressed");
						return TRUE;
					break;

					case IDC_C1: //somebody has clicked on check box 1 

						if (set1 == 0) //set or reset?
						{
							set1 = 1;
							//add the functions to test here :
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 1 is set");
						}
						else
						{
							set1 = 0;
							//add the functions to test here:
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 1 is reset");						
						}			
						return TRUE;
					break;
					case IDC_C2: //somebody has clicked on check box 2

						if (set2 == 0) //set or reset?
						{
							set2 = 1;
							//add the functions to test here:
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 2 is set");
						}
						else
						{
							set2 = 0;
							//add the functions to test here:
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 2 is reset");						
						}			
						return TRUE;
					break;
					case IDC_C3: //somebody has clicked on check box 3 

						if (set3 == 0) //set or reset?
						{
							set3 = 1;
							//add the functions to test here:
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 3 is set");
						}
						else
						{
							set3 = 0;
							//add the functions to test here:
							SetDlgItemText( hwndDlg,IDC_S_TEXT1, "checkbox 3 is reset");						
						}			
						return TRUE;
					break;
					
				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TabControl dialog of the Command Dialog for select
BOOL CALLBACK EnipSelectDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	int i,j;
	char text[100];

	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipSelect= 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				//init Combobox Mode:
				SendMessage(GetDlgItem(hwndDlg, IDC_C_MODE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "blocking"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_C_MODE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "nonblocking"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_C_MODE), CB_SETCURSEL, 0, 0); //1. entry preset

				//init Combobox IDC_C_ReadList & List:
				SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "NULL");  
				SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_SETCURSEL, 0, 0); //1. entry preset
				FdsReadList[0] = 0;
				FdsReadListIndex = -1;

				//init Combobox IDC_C_WriteList & List:
				SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "NULL");  
				SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_SETCURSEL, 0, 0); //1. entry preset
				FdsWriteList[0] = 0;
				FdsWriteListIndex = -1;

				//init Combobox IDC_C_ExceptList & List:
				SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "NULL");  
				SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_SETCURSEL, 0, 0); //1. entry preset
				FdsExceptList[0] = 0;
				FdsExceptListIndex = -1;

				//init EditBox Timeout:
				SetDlgItemText( hwndDlg,IDC_E_TIMEOUTS, "0");
				SetDlgItemText( hwndDlg,IDC_E_TIMEOUTU, "0");

				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					case IDC_B_SELECT:

						return DLGEnipSockSelect();
						break;

					case IDC_B_AddList:
						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						
						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_RFDS))
						{

							if (FdsReadList[0] == 0) //if there aren't any sockets in the list, NULL must be deleted
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_DELETESTRING, 0, 0);
							}
							FdsReadListIndex++;

							FdsReadList[FdsReadListIndex]=SocketNr[i];	
							sprintf(text, "s%d = %d", i+1, FdsReadList[FdsReadListIndex] );
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) text); 
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_SETCURSEL, FdsReadListIndex, 0); //select the new entry
						}
						 
						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_WFDS))
						{

							if (FdsWriteList[0] == 0) //if there aren't any sockets in the list, NULL must be deleted
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_DELETESTRING, 0, 0);
							}
							FdsWriteListIndex++; 

							FdsWriteList[FdsWriteListIndex]=SocketNr[i];	
							sprintf(text, "s%d = %d", i+1, FdsWriteList[FdsWriteListIndex] );
							SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) text); 
							SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_SETCURSEL, FdsWriteListIndex, 0); //select the new entry
						}
						
						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_EFDS))
						{

							if (FdsExceptList[0] = 0) //if there aren't any sockets in the list, NULL must be deleted
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_DELETESTRING, 0, 0);
							}
							FdsExceptListIndex++; 

							FdsExceptList[FdsExceptListIndex]=SocketNr[i];	
							sprintf(text, "s%d = %d", i+1, FdsExceptList[FdsExceptListIndex] );
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) text); 
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_SETCURSEL, FdsExceptListIndex, 0); //select the new entry
						}

						return TRUE;
						break;

					case IDC_B_DelList: //delete selected socket
						
						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_RFDS))
						{
							//from the combobox
							i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_GETCURSEL, 0, 0);
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_DELETESTRING, i, 0); 						
													
 
							if (FdsReadListIndex == 0) //it was the last item of the list => NULL must be added
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) "NULL"); 
								FdsReadList[0]=0;
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_SETCURSEL, 0, 0); //select the first entry 
								FdsReadListIndex=-1;
							}
							else
							{
								for (j=i; j != FdsReadListIndex; j++)
									FdsReadList[j]=FdsReadList[j+1];

								FdsReadList[FdsReadListIndex]=-1;
								FdsReadListIndex--;
															
								if (i != FdsReadListIndex+1)
									SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_SETCURSEL, i, 0); //select the next entry
								else
									SendMessage(GetDlgItem(hwndDlg, IDC_C_ReadList), CB_SETCURSEL, i-1, 0); //select the entry before							
							}
						}

						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_WFDS))
						{
							//from the combobox
							i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_GETCURSEL, 0, 0);
							SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_DELETESTRING, i, 0); 

							if (FdsWriteListIndex == 0) //it was the last item of the list => NULL must be added
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) "NULL"); 
								FdsWriteList[0]=0;
								SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_SETCURSEL, 0, 0); //select the first entry 
								FdsWriteListIndex=-1;
							}
							else
							{
								for (j=i; j != FdsWriteListIndex; j++)
									FdsWriteList[j]=FdsWriteList[j+1];

								FdsWriteList[FdsWriteListIndex]=-1;
								FdsWriteListIndex--;

								if (i != FdsWriteListIndex+1)
									SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_SETCURSEL, i, 0); //select the next entry
								else
									SendMessage(GetDlgItem(hwndDlg, IDC_C_WriteList), CB_SETCURSEL, i-1, 0); //select the entry before
							}
						}

						if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_EFDS))
						{
							//from the combobox
							i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_GETCURSEL, 0, 0);
							SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_DELETESTRING, i, 0); 

							if (FdsExceptListIndex == 0) //it was the last item of the list => NULL must be added
							{
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_ADDSTRING, 0,(LPARAM) (LPCTSTR) "NULL"); 
								FdsExceptList[0]=0;
								SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_SETCURSEL, 0, 0); //select the first entry 
								FdsExceptListIndex=-1;
							}
							else
							{
								for (j=i; j != FdsExceptListIndex; j++)
									FdsExceptList[j]=FdsExceptList[j+1];

								FdsExceptList[FdsExceptListIndex]=-1;
								FdsExceptListIndex--;

								if (i != FdsExceptListIndex+1)
									SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_SETCURSEL, i, 0); //select the next entry
								else
									SendMessage(GetDlgItem(hwndDlg, IDC_C_ExceptList), CB_SETCURSEL, i-1, 0); //select the entry before

							}									
						}

						return TRUE;
						break;
				}
			}
	}
	return FALSE;
}



// dialog box procedure for the TabControl dialog of the Command Dialog for convert
BOOL CALLBACK EnipConvertDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipConvert= 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				SetDlgItemText( hwndDlg,IDC_E_CONIP, "139.23.140.238");
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					case IDC_B_NTOA:
						strcpy(pBuffer, "n to a");
						SetLogText(pBuffer);
						return DLGEnipInetNtoa();
						break;

					case IDC_B_IADDR:
						strcpy(pBuffer, "inet_addr");
						SetLogText(pBuffer);
						return DLGEnipInetAddr();
						break;

					case IDC_B_htonl:
						strcpy(pBuffer, "h to n long");
						SetLogText(pBuffer);
						return DLGEnipSockHtonl();
						break;

					case IDC_B_NTOHS:
						strcpy(pBuffer, "n to h short ");
						SetLogText(pBuffer);
						return DLGEnipSockNtohs();
						break;

					case IDC_B_PTON:
						strcpy(pBuffer, "p to n not yet supported ");
						SetLogText(pBuffer);
						return TRUE;
						break;

					case IDC_B_NTOP:
						strcpy(pBuffer, "n to p not yet supported ");
						SetLogText(pBuffer);
						return TRUE;
						break;

					case IDC_B_NTOHL:
						strcpy(pBuffer, "n to h long ");
						SetLogText(pBuffer);
						return DLGEnipSockNtohl();
						break;

					case IDC_B_htons:
						strcpy(pBuffer, "h to n short");
						SetLogText(pBuffer);
						return DLGEnipSockHtons();
						break;
				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TabControl dialog of the Command Dialog for Help Socket functions
BOOL CALLBACK EnipHelpDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	int i, MyErrno;
	int esocket;

	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipHelp= 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				SetDlgItemText( hwndDlg,IDC_E_ERROR, "201");	
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					case IDC_B_STARTUP:
						MOPI_DLGnewAction (TEST_CALL_sock_startup,&pSlipBuffer);
						return TRUE;
						break;

					case IDC_B_CLEANUP:
						MOPI_DLGnewAction (TEST_CALL_sock_cleanup,&pSlipBuffer);
						return TRUE;
						break;

					case IDC_B_GETERR:
						MOPI_DLGnewAction (TEST_CALL_sock_getlasterror,&pSlipBuffer);
						return TRUE;
						break;

					case IDC_B_GETLADD:  //get local ip address
						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						esocket =SocketNr[i];				
						addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
						MOPI_DLGnewAction (TEST_CALL_bsd_getlocaladdr,&pSlipBuffer);
						return TRUE;
						break;

					case IDC_B_SETERR:
						GetDlgItemText( hwndDlg, IDC_E_ERROR, pBuffer, sizeof(pBuffer));
						MyErrno=atoi(pBuffer); 
						addParam(TEST_errno,4,&MyErrno,&pSlipBuffer);
						MOPI_DLGnewAction (TEST_CALL_sock_setlasterror,&pSlipBuffer);
						return TRUE;
						break;

					case IDC_B_GETRADD: //get remote IP address
						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						esocket =SocketNr[i];
					
						addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);

						MOPI_DLGnewAction (TEST_CALL_bsd_getremoteaddr,&pSlipBuffer);
						return TRUE;
						break;

				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TabControl dialog of the Command Dialog for reading and writing profiles
BOOL CALLBACK EnipProfileDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipProfile = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				CheckRadioButton( hwndDlg, IDC_R_GPRS, IDC_R_CSD, IDC_R_GPRS);
				CheckRadioButton( hwndDlg, IDC_R_ISDN, IDC_R_ANALOG, IDC_R_ISDN);
				EnableWindow(GetDlgItem(hwndDlg, IDC_R_ISDN), FALSE);
				EnableWindow(GetDlgItem(hwndDlg, IDC_R_ANALOG), FALSE);
				EnableWindow(GetDlgItem(hwndDlg, IDC_ED_PHONE), FALSE);
				EnableWindow(GetDlgItem(hwndDlg, IDC_ED_Apn), TRUE);
				SetDlgItemText( hwndDlg,IDC_ED_Profile, "0");
				SetDlgItemText( hwndDlg,IDC_ED_PHONE, "123454");
				SetDlgItemText( hwndDlg,IDC_ED_Apn, "sdf");
				SetDlgItemText( hwndDlg,IDC_ED_USER, "xyz");
				SetDlgItemText( hwndDlg,IDC_ED_PASSWD, "xyz");
				SetDlgItemText( hwndDlg,IDC_ED_DNS1, "139.23.140.38");
				SetDlgItemText( hwndDlg,IDC_ED_DNS2, "139.23.140.38");
				
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					case IDC_R_GPRS:
						EnableWindow(GetDlgItem(hwndDlg, IDC_R_ISDN), FALSE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_R_ANALOG), FALSE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_ED_Apn), TRUE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_ED_PHONE), FALSE);
						return TRUE;
					break;
					case IDC_R_CSD:
						EnableWindow(GetDlgItem(hwndDlg, IDC_R_ISDN), TRUE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_R_ANALOG), TRUE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_ED_Apn), FALSE);
						EnableWindow(GetDlgItem(hwndDlg, IDC_ED_PHONE), TRUE);
						return TRUE;
					break;

					case IDC_B_READ:
						return DLGEnipReadProfile();
					break;

					case IDC_B_WRITE:
						return DLGEnipWriteProfile();
					break;
				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TapControl dialog "other" of the Command Dialog, 
// "other" contains ioctl, get remote ip address, get local ip address
BOOL CALLBACK EnipOtherDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	char text[500];
	int i=0;

	UINT esocket=-1;
	UINT arg=0;
	UINT cmd=0;
 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipOther = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				SetDlgItemText( hwndDlg,IDC_ED_ARG, "0");

				//init combobox IDC_CB_CMD
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CMD), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "TP_FIONREAD"); //BSD_FIONREAD 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CMD), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "TP_FIONBIO");  //BSD_FIONBIO

				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CMD), CB_SETCURSEL, 0, 0); //1. entry preset
				
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					case IDC_B_IOCTL:
					{	
						strcpy(text,"ioctl");
						SetLogText(text);
						GetDlgItemText( hwndDlg, IDC_ED_ARG, pBuffer, sizeof(pBuffer));
						arg=atoi(pBuffer);

						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						esocket =SocketNr[i];

						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_CMD), CB_GETCURSEL, 0, 0);
						cmd =IDC_CMD[i];

						addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
						addParam(TEST_arg,4,&arg,&pSlipBuffer);
						addParam(TEST_cmd,4,&cmd,&pSlipBuffer);

						MOPI_DLGnewAction (TEST_CALL_bsd_ioctl,&pSlipBuffer); //send Message to Testprocess

					    return TRUE;	
					}
					break;

					case IDC_B_GetPeerName:
						strcpy(text,"get peer name");
						SetLogText(text);
						return DLGEnipGetPeerName();
						break;

					case IDC_B_GetSockName:
						strcpy(text,"get sock name");
						SetLogText(text);
						return DLGEnipGetSockName();
						break;





				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TapControl dialog "set socket options" of the Command Dialog, 
BOOL CALLBACK EnipSockOptDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int i;
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipSockOpt = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				SetDlgItemText( hwndDlg,IDC_ED_SOPTV, "1");
				SetDlgItemText( hwndDlg,IDC_ED_SOPTL, "4");

				//init combobox IDC_CB_LEV
				sprintf(pBuffer, "BSD_IPPROTO_IP");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 	
				sprintf(pBuffer, "BSD_IPPROTO_TCP");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
				sprintf(pBuffer, "BSD_SOL_SOCKET");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
	
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_SETCURSEL, 0, 0); //1. entry preset
				
				//init combobox IDC_CB_ONAME
				sprintf(pBuffer, "BSD_IP_TTL");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
				sprintf(pBuffer, "BSD_IP_TOS");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 

				SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_SETCURSEL, 0, 0); //1. entry preset

				return TRUE;
			}

			case WM_COMMAND:
			{
 
				switch(LOWORD(wParam))
				{
					case IDC_CB_LEV:
					{
						i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_GETCURSEL, 0, 0);
						
						//init combobox IDC_CB_ONAME
						if (i==0)  //BSD_IPPROTO_IP
						{ 
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_RESETCONTENT, 0, 0); 
							sprintf(pBuffer, "BSD_IP_TTL");
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
							IDC_ONAME[0]=BSD_IP_TTL;
							sprintf(pBuffer, "BSD_IP_TOS");
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
							IDC_ONAME[1]=BSD_IP_TOS;
							
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_SETCURSEL, 0, 0);
						}
						else if(i==1) //BSD_IPPROTO_TCP
						{
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_RESETCONTENT, 0, 0);
							sprintf(pBuffer, "BSD_TCP_NODELAY");
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
							IDC_ONAME[0]=BSD_TCP_NODELAY;
							
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_SETCURSEL, 0, 0);
						}
						else if(i==2)  //BSD_SOL_SOCKET
						{
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_RESETCONTENT, 0, 0);
							sprintf(pBuffer, "BSD_SO_RCVTIMEO");
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
							IDC_ONAME[0]=BSD_SO_RCVTIMEO;
							sprintf(pBuffer, "BSD_SO_SNDTIMEO");
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
							IDC_ONAME[1]=BSD_SO_SNDTIMEO;
							
							SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_SETCURSEL, 0, 0);
						}
					}
					break;

					case IDC_B_SOPT:  // set socket options
					{
						int esocket;
						int level;
						int optname;
						char optval[256];
						int optlen;

						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						esocket =SocketNr[i];
					
						i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_GETCURSEL, 0, 0);
						level=IDC_LEV[i];

						i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_GETCURSEL, 0, 0);
						optname=IDC_ONAME[i];

						GetDlgItemText( hwndDlg,IDC_ED_SOPTV, pBuffer, sizeof(pBuffer));
						strcpy(optval,pBuffer);

						GetDlgItemText( hwndDlg,IDC_ED_SOPTL, pBuffer, sizeof(pBuffer));
						optlen=atoi(pBuffer);

						//add message parameters
						addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
						addParam(TEST_level,4,&level,&pSlipBuffer);
						addParam(TEST_optname,4,&optname,&pSlipBuffer);
						addParam(TEST_optval,265,optval,&pSlipBuffer);
						addParam(TEST_optlen,4,&optlen,&pSlipBuffer);

						MOPI_DLGnewAction (TEST_CALL_bsd_setsockopt,&pSlipBuffer);  //send message to Testprocess

						return TRUE;
					}
					break;

					case IDC_B_GOPT:  //get Socket options
						int esocket;
						int level;
						int optname;

						i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
						esocket =SocketNr[i];
					
						i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_CB_LEV), CB_GETCURSEL, 0, 0);
						level=IDC_LEV[i];

						i=(int) SendMessage(GetDlgItem(hwndDlg, IDC_CB_ONAME), CB_GETCURSEL, 0, 0);
						optname=IDC_ONAME[i];

						//add message parameters
						addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
						addParam(TEST_level,4,&level,&pSlipBuffer);
						addParam(TEST_optname,4,&optname,&pSlipBuffer);


						MOPI_DLGnewAction (TEST_CALL_sock_getsockopt,&pSlipBuffer);  //send message to Testprocess

						return TRUE;

						break;

				}
			}
	}
	return FALSE;
}


// dialog box procedure for the TapControl dialog "DNR/get host by name" of the Command Dialog 
BOOL CALLBACK EnipDnrDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	char text[500];
 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipDNR = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				SetDlgItemText( hwndDlg,IDC_ED_NAME, "linda.dadie.com");
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{

					case IDC_B_HostByName: // get host by name
						sprintf(text, "get host by name");
						SetLogText(text);
						return (DLGEnipGetHostByName());
						break;
						
					case IDC_B_AHostByName:  //async get host by name
					{
						sprintf(text, "async get host by name");
						SetLogText(text);
						return (DLGEnipAGetHostByName());
					}
					break;

					case IDC_B_GETNODE:
						sprintf(text, "get node not impelmented yet!");
						SetLogText(text);
						return TRUE;
						break;

					case IDC_B_AGETNODE:
						sprintf(text, "async get node not implemented yet!");
						SetLogText(text);
						return TRUE;
						break;

					case IDC_B_HostByAddr:
						sprintf(text, "get host by address");
						SetLogText(text);
						return (DLGEnipGetHostByAddr());
						break;

					case IDC_B_AHostByAddr:
						sprintf(text, "async get host by address");
						SetLogText(text);
						return (DLGEnipAGetHostByAddr());
						break;

				}
			}
	}
	return FALSE;
}


// dialog box procedure for the TapControl dialog "LMAN" of the Command Dialog, 
BOOL CALLBACK EnipLmanDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int i=0;

 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipLman = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				for (i=0; i<=4; i++)
				{	
					sprintf(pBuffer, "%d", i);
					SendMessage(GetDlgItem(hwndDlg, IDC_CB_PROFILE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
				}
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_PROFILE), CB_SETCURSEL, 0, 0); //1. entry preset

				EnableWindow(GetDlgItem(hwndDlg,IDC_B_CONNECT), FALSE );
				EnableWindow(GetDlgItem(hwndDlg,IDC_B_DISCONNECT), FALSE );

				//int combobox IDC_CB_CID
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CID), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "No"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CID), CB_SETCURSEL, 0, 0); //1. entry preset
                                enipLmanCidArrayLen = 1 ;
				//int combobox IDC_CB_CONTYPE
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV4 (gprs)"); 
                                SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV4 (gprs,xtend.)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV6 (gprs)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV4 (csd)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV4 (csd,xtend.)");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "IPV6 (csd)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "PPPV4 (csd)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "PPPV6 (csd)"); 
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "W2k V4 (csd)");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "PPPIntV4 (gprs)");
                                SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) "PPPIntV4 (gprs,xtend.)");
				SendMessage(GetDlgItem(hwndDlg, IDC_CB_CONTYPE), CB_SETCURSEL, 0, 0); //1. entry preset

				//init all edit boxes with default values
				i=LMAN_OUTPUT_EVENT_DEFAULT_OFFSET;
				sprintf(pBuffer, "%d", i);
				SetDlgItemText( hwndDlg,IDC_E_EvtOff, pBuffer);
				
				i=LMAN_FLAG_ALL;
				sprintf(pBuffer, "%d", i);
				SetDlgItemText( hwndDlg,IDC_E_FlagSock, pBuffer);

				i=LMAN_FLAG_NONE;
				sprintf(pBuffer, "%d", i);
				SetDlgItemText( hwndDlg,IDC_E_FlagLman, pBuffer);

				SetDlgItemText( hwndDlg,IDC_B_TP_ON_OFF, "TP ON/INIT");

				return TRUE;
			}

			case WM_COMMAND:
			{
 
				switch(LOWORD(wParam))
				{
					    case IDC_B_CONNECT:
							return (DLGEnipConnect());	
						break; 
						case IDC_B_DISCONNECT:
							return (DLGEnipDisconnect());
						break;
						case IDC_B_TP_ON_OFF:
							if (iTpOn == 0)
							{
								//switch on Testprocess, set flags to let the data traffic flow over the Command Dialog
								//as this will cause calling GBS-functions, set process to a MOPI process
								MOPI_ExecuteFunction(NO_PROCESS_PID, EnipTestDlgInit, 0); 
							    iTpOn = 1;

								//allow pressing the other buttons
								EnableWindow(GetDlgItem(hwndDlg,IDC_B_CONNECT), TRUE );
								EnableWindow(GetDlgItem(hwndDlg,IDC_B_DISCONNECT), TRUE );
							    EnableWindow(GetDlgItem(hEnipDialog,IDC_B_PPP), TRUE );

								SetDlgItemText( hwndDlg,IDC_B_TP_ON_OFF, "TP OFF");
							}
							else
							{
								iTpOn = 0;
								//on_Msg_FYH_NORMALMODE(); //switch off Testprocess => free buffers, ... 
								//geht noch nicht, erst wenn SAPI Schnittstelle zum TP sauber gezogen ist!!!


								//disallow pressing the other buttons
								EnableWindow(GetDlgItem(hwndDlg,IDC_B_CONNECT), FALSE );
								EnableWindow(GetDlgItem(hwndDlg,IDC_B_DISCONNECT), FALSE );
							    EnableWindow(GetDlgItem(hEnipDialog,IDC_B_PPP), FALSE );

								SetDlgItemText( hwndDlg,IDC_B_TP_ON_OFF, "TP ON/INIT");

							}
							return TRUE;
						break;

				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TapControl dialog for UDP socket functions 
BOOL CALLBACK EnipUdpDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	char text[1000];

	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipUdp = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				strcpy(text, "1234567890");
				SetDlgItemText( hwndDlg,IDC_E_UDATA, text);
				strcpy(text, "4");
				SetDlgItemText( hwndDlg,IDC_E_UCOUNT, text);
				return TRUE;
			}

			case WM_COMMAND:
			{
 
				switch(LOWORD(wParam))
				{
						case IDC_B_UCREATE:
						{
  	                     if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_UDPIPVER))
							return (DLGEnipCreate(	BSD_IPPROTO_UDP, BSD_SOCK_DGRAM, BSD_AF_INET6 ));
                         else
							return (DLGEnipCreate(	BSD_IPPROTO_UDP, BSD_SOCK_DGRAM, BSD_AF_INET ));
						}
						break; 
									
						case IDC_B_UBIND:
						{
							return (DLGEnipBind());
						}
						break;
		  			    case IDC_B_SENDTO: 
						{
							return (DLGEnipSendto());
						}
						break; 
						case IDC_B_RECFROM:
						{
							return (DLGEnipReceivefrom());
						}
						break; 
						case IDC_B_UCLOSE: 
						{
							return ( DLGEnipCloseSoc());
						}
						break;
						case IDC_B_USHUT:
						{
							return (DLGEnipShutdown());
						}
						break;
						case IDC_B_PSENDTO:
							return (DLGEnipPatternSendto());
						break;
				}
			}
	}
	return FALSE;
}

// dialog box procedure for the TapControl dialog for TCP socket functions 
BOOL CALLBACK EnipTcpDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	char text[1000];
 
	switch (message)
	{
			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipTcp = 0;
				return TRUE;
			}

			case WM_INITDIALOG:
			{
				strcpy(text, "1234");
				SetDlgItemText( hwndDlg,IDC_E_TDATA, text);
				strcpy(text, "12");
				SetDlgItemText( hwndDlg,IDC_E_TCOUNT, text);
				return TRUE;
			}

			case WM_COMMAND:
			{
 				switch(LOWORD(wParam))
				{
					    case IDC_B_TCREATE: 
						{
						 sprintf(text, "create socket");
						 SetLogText(text);
	
  	                     if (BST_CHECKED==IsDlgButtonChecked( hwndDlg, IDC_C_TCPIPVER))
							return (DLGEnipCreate(	BSD_IPPROTO_TCP, BSD_SOCK_STREAM, BSD_AF_INET6 ));
                         else
							return (DLGEnipCreate(	BSD_IPPROTO_TCP, BSD_SOCK_STREAM, BSD_AF_INET ));
						}
						break; 
						case IDC_B_CONSOC:
						{
							return (DLGEnipConnectSoc());
						}
						break;
						case IDC_B_TBIND:
						{
							return (DLGEnipBind());
						}
						break; 
						case IDC_B_LISTEN:
						{
							return (DLGEnipListen());
						}
						break; 
						case IDC_B_ACCEPT:
						{
							return (DLGEnipAccept());
						}
						break; 
						case IDC_B_SEND:
						{
							return (DLGEnipSend());
						}
						break; 
						case IDC_B_REC: 
						{
							return (DLGEnipReceive());
						}
						break;
						case IDC_B_TCLOSE: 
						{
							return ( DLGEnipCloseSoc());
						}
						break; 	
						case IDC_B_TSHUT:
						{
							return (DLGEnipShutdown());
						}
						break;
						case IDC_B_PSEND:
							return (DLGEnipPatternSend());
						break;
				}
			}
	}
	return FALSE;
}
#endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST

// dialog box procedure for the Command Dialog if PPP_MON_TEST and TESTPROC_TEST_IF > 0
////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK EnipDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
////////////////////////////////////////////////////////////////////////////////
{

#if PPP_MON_TEST > 0
#if TESTPROC_TEST_IF > 0

	int i;

	if (hEnipDialog==0)
		hEnipDialog=hwndDlg;

	switch (message)
	{
			case WM_NOTIFY: 
			{	
				i=HIWORD(wParam);
				switch (i) 
				{ 
					case 0:	//Tab of Tabcontrol changes
					//case TCN_SELCHANGE: 
					{ 
							
						if ( CHECKFLAG(EnipTestactive)) //if TestProcess is switched on
						{
							int iPage = TabCtrl_GetCurSel(hTab); 
  							sprintf(pBuffer, "tab: %d", iPage);
						
							switch (iPage)
							{
								case 0:  //LMAN dialog appears => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipLman; //set hAktTab pointer to the actual Tabdialog
																
									if (hEnipLman==0)
										hEnipLman = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipLMAN), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipLmanDialogProc);		

									ShowWindow(hEnipLman, SW_SHOW); //show actual Tabdialog

									return TRUE;
								}
								break;

								case 1:    //UDP dialog appears => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipUdp; //set hAktTab pointer to the actual Tabdialog
																
									if (hEnipUdp==0)
										hEnipUdp = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipUDP), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipUdpDialogProc);		
								
									ShowWindow(hEnipUdp, SW_SHOW); 
									return TRUE;
								}
								break;

								case 2:   //TCP dialog appears => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipTcp; //set hAktTab pointer to the actual Tabdialog

									if (hEnipTcp==0)
										hEnipTcp = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipTCP), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipTcpDialogProc);		
								
									ShowWindow(hEnipTcp, SW_SHOW); 
									return TRUE;
								}
								break;

								case 3: // DNR dialog appears => call it's dialog procedure, hide all other TabDialogs
								{
																
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipDNR; //set hAktTab pointer to the actual Tabdialog

									if (hEnipDNR==0)
										hEnipDNR = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipDNR), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipDnrDialogProc);		
								
									ShowWindow(hEnipDNR, SW_SHOW); 
									return TRUE;
									
								}
								break;
								
								case 4: // SockOpt dialog appears => call it's dialog procedure, hide all other TabDialogs
								{
																
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipSockOpt; //set hAktTab pointer to the actual Tabdialog

									if (hEnipSockOpt==0)
										hEnipSockOpt = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipSockOpt),hTab, (DLGPROC)EnipSockOptDialogProc);		
								
									ShowWindow(hEnipSockOpt, SW_SHOW); 
									return TRUE;
									
								}
								break;

								case 5: //select dialog => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipSelect; //set hAktTab pointer to the actual Tabdialog

									if (hEnipSelect==0)
										hEnipSelect = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipSelect), hTab, (DLGPROC)EnipSelectDialogProc);		
								
									ShowWindow(hEnipSelect, SW_SHOW); 
									return TRUE;
								
								}
								break;

								
								case 6: //convert dialog => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipConvert; //set hAktTab pointer to the actual Tabdialog

									if (hEnipConvert==0)
										hEnipConvert = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipConvert), hTab, (DLGPROC)EnipConvertDialogProc);		
								
									ShowWindow(hEnipConvert, SW_SHOW); 
									return TRUE;
								
								}
								break;

								
								case 7: //help dialog => call it's dialog procedure, hide all other TabDialogs
								{
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipHelp; //set hAktTab pointer to the actual Tabdialog

									if (hEnipHelp==0)
										hEnipHelp = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipHelp), hTab, (DLGPROC)EnipHelpDialogProc);		
								
									ShowWindow(hEnipHelp, SW_SHOW); 
									return TRUE;
								
								}
								break;

								case 8: // "other dialog" appears => call it's dialog procedure, hide all other TabDialogs
								{
																
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipOther; //set hAktTab pointer to the actual Tabdialog

									if (hEnipOther==0)
										hEnipOther = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipOth), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipOtherDialogProc);		
								
									ShowWindow(hEnipOther, SW_SHOW); 
									return TRUE;
									
								}

								case 9: // Profile dialog appears => call it's dialog procedure, hide all other TabDialogs															
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipProfile; //set hAktTab pointer to the actual Tabdialog

									if (hEnipProfile==0)
										hEnipProfile = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipProfile), hTab, (DLGPROC)EnipProfileDialogProc);		
								
									ShowWindow(hEnipProfile, SW_SHOW); 
									return TRUE;
								break;

								case 10: // Free dialog appears => call it's dialog procedure, hide all other TabDialogs															
									if (*hAktTab != 0) //hide old Tabdialog
										ShowWindow(*hAktTab, SW_HIDE);

									hAktTab = &hEnipFree; //set hAktTab pointer to the actual Tabdialog

									if (hEnipFree==0)
										hEnipFree = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipFree), hTab, (DLGPROC)EnipFreeDialogProc);		
								
									ShowWindow(hEnipFree, SW_SHOW); 
									return TRUE;
								break;
							} //switch (i)
						}//if ( CHECKFLAG(EnipTestactive))
					} //case WM_NOTIFY
					break;                  
				}
			}
			break;

			case WM_CLOSE:
			{
				DestroyWindow(hwndDlg);
				hEnipDialog = 0;

				hEnipUdp=0;
				hEnipTcp=0;
				hEnipLman=0;
				hEnipOther=0;
				hEnipDNR=0;
				hEnipSockOpt=0;
				hEnipProfile=0;
				hEnipSelect=0;
				hEnipConvert=0;
				hEnipHelp=0;
				hEnipFree=0;
				hTab=0;
				*hAktTab=0;

				return TRUE;
			}

			case WM_INITDIALOG:
			{
				return( InitEnipDialog());
			}
			case MsgRECEIVE: //we have received the notification that there's a packet to receive; call recvfrom and and put it into the TestProcess as if 
		                     //it would have come over SAPI 
			{
				//on_MsgRECEIVE is called by a Windows process but due to usage of GBS in subfunction it has to be called by a MOPI process
				MOPI_ExecuteFunction(NO_PROCESS_PID, on_MsgRECEIVE, 0); 
				return TRUE;
			}
			break;			
			case WM_COMMAND:
			{
				switch(LOWORD(wParam))
				{
					case IDC_B_PPP:
					{							
                        //i=xIpcltGetLocalInterfaceIdentifier(0, MyInterID, 8);  //only for test of this DLL function
						return pppMon(); // activate/close PPP Monitor mode = the Testprocess is controled by PPP Monitor Scripts
					}
					break;
				}		
			}
		}
#endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST
   return FALSE;
}

//---------------------------------------------------------------------------------------

extern "C" void EnipCommandWindowInit(void)
{ 


/*    if ( ! MainApp::hPrevInstance )
    {
       EnipCommandWindow::Register();
    }
    pMainWnd = new EnipCommandWindow; 
*/

    if(hEnipDialog != NULL)
		return;

	if ((PPP_MON_TEST > 0) && (TESTPROC_TEST_IF > 0))
		hEnipDialog = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_ENIP), DispGetWinHandle(), (DLGPROC)EnipDialogProc);
	else
		hEnipDialog = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_Enip_aus), DispGetWinHandle(), (DLGPROC)EnipDlgAusProc);

	if (hEnipDialog == NULL)
	{
		print_d("ERROR in creating ENIP Command Dialog!");
		return;
	}
    ShowWindow(hEnipDialog, SW_SHOW); 
}
//--------------------------------------------------------------------------------------------


#if PPP_MON_TEST > 0
#if TESTPROC_TEST_IF > 0

// activate/close PPP Monitor mode = the Testprocess is controled by PPP Monitor Scripts
BOOL pppMon(void)
{
	int port;
	int result;
	UINT ip_addr;
	char text[1000];

	if (pppMonMod==0) // if PPP Monitor mode wasn't active, it's activated, a socket for receiving the packets of the scripts is created and bound		
	{ 					
		pppMonMod=1;
		ShowWindow(hTab, SW_HIDE); // hide TabControl/disable buttons
							
		shndl=socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP);							

		result= WSAAsyncSelect ( shndl, hEnipDialog, MsgRECEIVE, FD_READ );  //=>nonblocking mode
		if (result !=0)
		{
			sprintf(text, "error creating socket for switching in PPP Monitor mode");
			SetLogText(text);
			return FALSE;
		}

		GetDlgItemText( hEnipDialog,IDC_ED_PORT, pBuffer, sizeof(pBuffer));
		port=atoi(pBuffer);

		ip_addr=0;

        s_in.sin_family=AF_INET;
        s_in.sin_port=htons(port);
        s_in.sin_addr.s_addr=htonl(ip_addr);

 		result= bind (shndl, (struct sockaddr*) &s_in, sizeof(s_in));

		if (result != 0)
		{
			sprintf(text, "error binding socket for switching in PPP Monitor mode");
			SetLogText(text);
			return FALSE;
		}

		return TRUE;
	}						
	else // PPP Monitor mode was active, will be closed now
	{							
		pppMonMod=0;	
		WAITFOR=0;
		ShowWindow(hTab, SW_SHOW);
		if (shndl!=-1)
		{
			closesocket(shndl);
			shndl=-1;
		}
		
		return TRUE;
	}
}

void on_MsgRECEIVE(UINT32 param) // receives packets from PPP Monitor and puts them into the Testprocess
{
	int result;
	int myerrno;
	int flags=0;

	RecvSin.sin_family = AF_INET;
	RecvSinLen=sizeof(RecvSin);
	
	result=recvfrom(shndl, pBuffer, pBufferLen,flags, (struct sockaddr FAR*) &RecvSin, &RecvSinLen);
	myerrno=WSAGetLastError();
	if (result==-1)
		return;

	(void)EnipTestReadDataSAPI ((unsigned char *)pBuffer, result, 0);  //write data into Ringbuffer of TestProcess
}

#endif //TESTPROC_TEST_IF

void receive_SLIP_packet(char * pPacket, int PacketLen) //receives packets from the Testprocess and sends them to PPP Monitor
{
#if TESTPROC_TEST_IF > 0

	int result;
	int flags=0;

	result= sendto ( shndl, pPacket, PacketLen, flags, (const struct sockaddr FAR *) &RecvSin, RecvSinLen);
#endif //TESTPROC_TEST_IF 
}

#if TESTPROC_TEST_IF > 0

//--------------------------------------------------------------------------------------------

//init Command Dialog
BOOL InitEnipDialog() 
{    
	TCITEM tie; 
	int i;


	// init Tabcontrol
	hTab=GetDlgItem(hEnipDialog,  IDC_TAB1  );

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "LMAN"; 
	if (TabCtrl_InsertItem(hTab, 0, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "UDP"; 
	if (TabCtrl_InsertItem(hTab, 1, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}
	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "TCP"; 
	if (TabCtrl_InsertItem(hTab, 2, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "DNR"; 
	if (TabCtrl_InsertItem(hTab, 3, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "SockOpt"; 
	if (TabCtrl_InsertItem(hTab, 4, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "Select"; 
	if (TabCtrl_InsertItem(hTab, 5, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "Convert"; 
	if (TabCtrl_InsertItem(hTab, 6, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "Help"; 
	if (TabCtrl_InsertItem(hTab, 7, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "other"; 
	if (TabCtrl_InsertItem(hTab, 8, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "Profile"; 
	if (TabCtrl_InsertItem(hTab, 9, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = "Free"; 
	if (TabCtrl_InsertItem(hTab, 10, &tie) == -1)
	{ 
		DestroyWindow(hTab); 
		return FALSE; 
	}

	if (hEnipLman==0)
		hEnipLman = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_EnipLMAN), /*DispGetWinHandle()*/hTab, (DLGPROC)EnipLmanDialogProc);		

	hAktTab=&hEnipLman;
	
	ShowWindow(hEnipLman, SW_SHOW); 

	//init pSlipBuffer
	pSlipBuffer.iFrameLength=0;
	pSlipBuffer.pSLIPBuffer=(unsigned char *)&DlgSlipBuffer[0];
		
	//init combobox IDC_CB_SOCKET
	for (i=1; i<=5; i++)
	{	sprintf(pBuffer, "Socket %d", i);
		SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer); 
	}
	SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_SETCURSEL, 0, 0); //1. entry preset

	//init combobox IDC_CB_sHOW
	sprintf(pBuffer, "SD_RECEIVE");
	SendMessage(GetDlgItem(hEnipDialog, IDC_CB_sHOW), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer);
	sprintf(pBuffer, "SD_SEND");
	SendMessage(GetDlgItem(hEnipDialog, IDC_CB_sHOW), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer);
	sprintf(pBuffer, "SD_BOTH");
	SendMessage(GetDlgItem(hEnipDialog, IDC_CB_sHOW), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) pBuffer);

	SendMessage(GetDlgItem(hEnipDialog, IDC_CB_sHOW), CB_SETCURSEL, 0, 0); //1. entry preset

	// set default values of textboxes
	SetDlgItemText( hEnipDialog,IDC_ED_IPADDR,"127.0.0.1");   //ines:139.23.140.38
	SetDlgItemText( hEnipDialog,IDC_ED_PORT,"8888");

	SetDlgItemText( hEnipDialog,IDC_ED_PSIZE,"12");

	//init array for socket handles
	for (i=0; i<5; i++)
	{
		SocketNr[i]=-1;
	}
	
	EnableWindow(GetDlgItem(hEnipDialog,IDC_B_PPP), FALSE );

	//init errnotext (80 - 99)
	//BSD_HOST_NOT_FOUND		(_BSD_BASEERR+80)
	strcpy(errnotxt[80], "host not found");

	//BSD_TRY_AGAIN				(_BSD_BASEERR+81)
	strcpy(errnotxt[81], "try again");

	//BSD_NO_DATA					(_BSD_BASEERR+82)
	strcpy(errnotxt[82], "no data");

	//BSD_DNR_INVALID_NAME		(_BSD_BASEERR+83)
	strcpy(errnotxt[83], "DNR invalid name");

	//BSD_DNR_INVALID_RESPONSE	(_BSD_BASEERR+84)
	strcpy(errnotxt[84], "DNR invalid response");

	//BSD_DNR_NO_DNS_ADDRESS		(_BSD_BASEERR+85)
	strcpy(errnotxt[85], "DNR no DNS address");

	//BSD_NOTIMPL				(_BSD_BASEERR+99)
	strcpy(errnotxt[99], "not impl");

	return TRUE;
}

BOOL DLGEnipConnect()  //send TEST_M_LMAN_CONNECT_EXT_REQ message to testprocess
{	
	int i=0;
	int bearer;
	int profile=0;
	int EventOffset=0;
	int LFlags =0;
	int SFlags =0;
	eLmanConnectionType ConType;
	char text[500];
        bool useXtended = FALSE ;

	GetDlgItemText( hEnipLman, IDC_CB_PROFILE, pBuffer, sizeof(pBuffer));
	profile=atoi(pBuffer);

	GetDlgItemText( hEnipLman, IDC_E_EvtOff, pBuffer, sizeof(pBuffer));
	EventOffset=atoi(pBuffer);

	GetDlgItemText( hEnipLman, IDC_E_FlagSock, pBuffer, sizeof(pBuffer));
	SFlags=atoi(pBuffer);

	GetDlgItemText( hEnipLman, IDC_E_FlagLman, pBuffer, sizeof(pBuffer));
	LFlags=atoi(pBuffer);

	//get ConType & bearer
	i=(int) SendMessage(GetDlgItem(hEnipLman, IDC_CB_CONTYPE), CB_GETCURSEL, 0, 0);

	if (CB_ERR != SendMessage(GetDlgItem(hEnipLman, IDC_CB_CONTYPE), CB_GETLBTEXT, (WPARAM) i, (LPARAM) (LPCSTR)  pBuffer))
	{
		gPPPInternal=0;             //if not PPP internal, if -> set some lines later
		setModemMode(EXTERN_MODEM); //if not windows2000 connection, if -> set some lines later

		if ( 0 == strcmp(pBuffer, "IPV4 (gprs)"))
		{
			ConType=LmanConnectionType_IPV4;
			bearer=eCON_HNDL_BEARER_GPRS;
		}
		if ( 0 == strcmp(pBuffer, "IPV4 (gprs,xtend.)"))
		{
			ConType=LmanConnectionType_IPV4;
			bearer=eCON_HNDL_BEARER_GPRS;
                        useXtended = TRUE ;
		}
		if ( 0 == strcmp(pBuffer, "IPV6 (gprs)"))
		{
			ConType=LmanConnectionType_IPV6;
			bearer=eCON_HNDL_BEARER_GPRS;
                        useXtended = TRUE ;
		}
		if ( 0 == strcmp(pBuffer, "IPV4 (csd)"))
		{
			ConType=LmanConnectionType_IPV4;
			bearer=eCON_HNDL_BEARER_CSD;
		}
        if ( 0 == strcmp(pBuffer, "IPV4 (csd,xtend.)"))
		{
			ConType=LmanConnectionType_IPV4;
			bearer=eCON_HNDL_BEARER_CSD;
                        useXtended = TRUE ;
		}
		if ( 0 == strcmp(pBuffer, "IPV6 (csd)"))
		{
			ConType=LmanConnectionType_IPV6;
			bearer=eCON_HNDL_BEARER_CSD;
                        useXtended = TRUE ;
		}
		if ( 0 == strcmp(pBuffer, "PPPV4 (csd)"))
		{
			ConType=LmanConnectionType_PPPV4;
			bearer=eCON_HNDL_BEARER_CSD;
		}
		if ( 0 == strcmp(pBuffer, "PPPV6 (csd)"))
		{
			ConType=LmanConnectionType_PPPV6;
			bearer=eCON_HNDL_BEARER_CSD;
		}
		if ( 0 == strcmp(pBuffer, "W2k V4 (csd)"))
		{
			ConType=LmanConnectionType_IPV4;
			bearer=eCON_HNDL_BEARER_CSD;
#if USE_W2KSIMU > 0
			setModemMode(W2KSIM_MODEM);
#endif //USE_W2KSIMU
		}
		if ( 0 == strcmp(pBuffer, "PPPIntV4 (gprs)"))
		{
			ConType=LmanConnectionType_Default;
			bearer=eCON_HNDL_BEARER_GPRS;
			gPPPInternal = 1;
		}
		if ( 0 == strcmp(pBuffer, "PPPIntV4 (gprs,xtend.)"))
		{
			ConType=LmanConnectionType_Default;
			bearer=eCON_HNDL_BEARER_GPRS;
			gPPPInternal = 1;
                        useXtended = TRUE ;
		}
	}
	else
    {
		sprintf(text, "ERROR in SEND MESSAGE!!!");
		SetLogText(text);
	}

	addParam(TEST_Profile,4,&profile,&pSlipBuffer);
	addParam(TEST_EventOffset,4,&EventOffset,&pSlipBuffer);
    addParam(TEST_LmanNotifFlags,4,&LFlags,&pSlipBuffer);
	addParam(TEST_SocketNotifFlags,4,&SFlags,&pSlipBuffer);
	addParam(TEST_ConType,4,&ConType,&pSlipBuffer);
	addParam(TEST_Bearer,4,&bearer,&pSlipBuffer);

    if ( !useXtended ) 
    {
	MOPI_DLGnewAction (TEST_M_LMAN_CONNECT_REQ,&pSlipBuffer); //send the message to Testprocess		
    } 
    else 
    {
        if (enipLmanCidArrayLen < MAX_NUMBER_ENIPLMAN_CIDS  )
        {
            MOPI_DLGnewAction (TEST_M_LMAN_CONNECTEXT_REQ,&pSlipBuffer);
        } 
        else
        {
            sprintf(text, "too many extended connections!!!");
		    SetLogText(text);
            return FALSE ;
        }
    }
    return TRUE;
}

BOOL DLGEnipCreate(int protocol, int type, int af) // create a TCP or UDP socket
                                                   // for address family IPv4 or IPv6.
{	
//	int af;
	int i;
	int esocket;
	char text[100];
	char lpCaption[20];

	i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
	esocket =SocketNr[i];
	if (esocket!=-1)
	{
		sprintf(text, "socket %d already exists", i+1);
		strcpy(lpCaption, "create Socket!");
#if MSGBOX_ON
		MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
		return FALSE;
	}
//	af=BSD_AF_INET;
	addParam(TEST_af,4,&af,&pSlipBuffer);
	addParam(TEST_type,4,&type,&pSlipBuffer);
	addParam(TEST_protocol,4,&protocol,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_bsd_socket,&pSlipBuffer); //send the message to Testprocess

	if (af==BSD_AF_INET6)    
		SetDlgItemText( hEnipDialog,IDC_AF[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)], "ipv6");
	else
		SetDlgItemText( hEnipDialog,IDC_AF[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)], "ipv4");

	if (protocol==BSD_IPPROTO_UDP)    
		SetDlgItemText( hEnipDialog,IDC_PROT[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)], "udp");
	else
		SetDlgItemText( hEnipDialog,IDC_PROT[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)], "tcp");

	return TRUE;
}
		
BOOL DLGEnipConnectSoc()  //connect TCP socket
{
	int esocket;
	int esocket_af;
	UINT IpAddress;
    pmbyte Ipv6Address[16];
	int PortAddress;
    int cnv_result;

    //
	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];
    esocket_af = GetSocketAF( esocket );
    if( esocket_af == -1 )
     return FALSE;

    // 
	GetDlgItemText( hEnipDialog, IDC_ED_PORT, pBuffer, pBufferLen);
	PortAddress=atoi(pBuffer);

    //
	GetDlgItemText( hEnipDialog, IDC_ED_IPADDR, pBuffer, pBufferLen);


    //(#1/4) socket id: investigate
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
    //(#2/4) IP address family: investigate
    addParam(TEST_af, 4, &esocket_af,&pSlipBuffer);
    //(#3/4) socket IP address: investigate
    if( esocket_af == BSD_AF_INET )
    {
	 IpAddress=inet_addr (pBuffer);
     memcpy( (void*)Ipv6Address, &IpAddress, sizeof(UINT) );
    }
    else
/*    if( esocket_af == BSD_AF_INET6 ) */
    {
     cnv_result = inet_pton( BSD_AF_INET6, pBuffer, Ipv6Address );
    }
    
//	addParam(TEST_IpAddress, 4, &IpAddress,&pSlipBuffer);
	addParam(TEST_Ip6Address, 16, Ipv6Address, &pSlipBuffer);
    //(#4/4) port number: investigate
	addParam(TEST_PortAddress,4,&PortAddress,&pSlipBuffer);
    // action!
	MOPI_DLGnewAction (TEST_CALL_bsd_connect,&pSlipBuffer);  //send the message to Testprocess

	return TRUE;
}

BOOL DLGEnipBind() // bind socket
{
	int esocket;
	int esocket_af;
	int PortAddress;
	pmbyte ip_addr[16];

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];
    esocket_af = GetSocketAF( esocket );
    if( esocket_af == -1 )
     return FALSE;

    //
	GetDlgItemText( hEnipDialog, IDC_ED_PORT, pBuffer, pBufferLen);
	PortAddress=atoi(pBuffer);
	memset(ip_addr,0,16);

    //(#1/4) IP address family: investigate
    addParam(TEST_af, 4, &esocket_af,&pSlipBuffer);
    //(#2/4) socket id: investigate
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
    //(#3/4) IP address: don't care
	addParam(TEST_Ip6Address,16 ,ip_addr,&pSlipBuffer);
    //(#4/4) port number: investigate
	addParam(TEST_PortAddress,4,&PortAddress,&pSlipBuffer);
    // action!
	MOPI_DLGnewAction (TEST_CALL_bsd_bind,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipListen()
{
	int esocket;
	UINT backlog;

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];
	backlog=3;
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_backlog,4,&backlog,&pSlipBuffer);
	MOPI_DLGnewAction (TEST_CALL_bsd_listen,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipAccept() 
{	
	int esocket;
	int esocket_af;

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];
	esocket_af = GetSocketAF( esocket );
    if( esocket_af == -1 )
     return FALSE;
	
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_af,4,&esocket_af,&pSlipBuffer);
	MOPI_DLGnewAction (TEST_CALL_bsd_accept,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSend()
{	
	int esocket;
	int packetsize;
	int flags;

	esocket =SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];


	GetDlgItemText( hEnipDialog, IDC_ED_PSIZE, pBuffer, pBufferLen);
	packetsize=atoi(pBuffer);

	memset(pBuffer, 0, pBufferLen);
	memset(pBuffer, 'x', packetsize);
														
	flags=0;

	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_buf,packetsize,&pBuffer,&pSlipBuffer);
	addParam(TEST_flags,4,&flags,&pSlipBuffer);
					
	MOPI_DLGnewAction (TEST_CALL_bsd_send,&pSlipBuffer);
						
	return TRUE;
}

BOOL DLGEnipSendto()
{	
	int esocket;
	int esocket_af;
	int packetsize;
	UINT IpAddress;
    pmbyte Ipv6Address[16];
	int PortAddress;
	int flags;
    int cnv_result;

	esocket =SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)];
    esocket_af = GetSocketAF( esocket );
    if( esocket_af == -1 )
     return FALSE;

	memset(pBuffer, 0, pBufferLen);

//	IpAddress=inet_addr(pBuffer);

	GetDlgItemText( hEnipDialog, IDC_ED_PORT, pBuffer, pBufferLen);
	PortAddress=atoi(pBuffer);

	GetDlgItemText( hEnipDialog, IDC_ED_PSIZE, pBuffer, pBufferLen);
	packetsize=atoi(pBuffer);
	pBuffer[0]='\0';
	memset(pBuffer, 'x', packetsize);
												
	flags=0;

    //(#1/6) IP address family: investigate
    addParam(TEST_af, 4, &esocket_af,&pSlipBuffer);
    //(#2/6) socket id: investigate
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
    //(#3/6) packet size: investigate
	addParam(TEST_buf,packetsize,&pBuffer,&pSlipBuffer);
    //(#4/6) flags: investigate
	addParam(TEST_flags,4,&flags,&pSlipBuffer);
    //(#5/6) socket IP address: investigate
//(old)	addParam(TEST_IpAddress,4,&IpAddress,&pSlipBuffer);
	GetDlgItemText( hEnipDialog, IDC_ED_IPADDR, pBuffer, pBufferLen);
    if( esocket_af == BSD_AF_INET )
    {
	 IpAddress=inet_addr (pBuffer);
     memcpy( (void*)Ipv6Address, &IpAddress, sizeof(UINT) );
    }
    else
/*    if( esocket_af == BSD_AF_INET6 ) */
    {
     cnv_result = inet_pton( BSD_AF_INET6, pBuffer, Ipv6Address );
    }
//	addParam(TEST_IpAddress, 4, &IpAddress,&pSlipBuffer);
	addParam(TEST_Ip6Address, 16, Ipv6Address, &pSlipBuffer);
    //(#6/6) port number: investigate
	addParam(TEST_PortAddress,4,&PortAddress,&pSlipBuffer);
    // action!
	MOPI_DLGnewAction (TEST_CALL_bsd_sendto,&pSlipBuffer);
						
	return TRUE;
}

BOOL DLGEnipReceivefrom()
{
	int esocket;
	int testsize;
	int esocket_af ; // GRU

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_SOCKET ), CB_GETCURSEL, 0, 0)];

    esocket_af = GetSocketAF( esocket );// GRU
    if( esocket_af == -1 )
     return FALSE;

	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);

 	GetDlgItemText( hEnipDialog,IDC_ED_PSIZE, pBuffer, sizeof(pBuffer) ); 
	testsize=atoi(pBuffer);

	addParam(TEST_size,4,&testsize,&pSlipBuffer);
	addParam(TEST_af,4,&esocket_af,&pSlipBuffer); // GRU
		
	MOPI_DLGnewAction (TEST_CALL_bsd_recvfrom,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipReceive()
{	
	int esocket;
	int testsize;

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_SOCKET ), CB_GETCURSEL, 0, 0)];

	GetDlgItemText( hEnipDialog,IDC_ED_PSIZE, pBuffer, sizeof(pBuffer) ); 
	testsize=atoi(pBuffer);

	addParam(TEST_size,4,&testsize,&pSlipBuffer);
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_bsd_recv,&pSlipBuffer);
	return TRUE;
}			

BOOL DLGEnipCloseSoc()
{	
	int esocket;
	int i;

	i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);

	esocket =SocketNr[ i];

	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_bsd_close,&pSlipBuffer);
	SetDlgItemText( hEnipDialog,IDC_SOCNR[i], "x");
	SetDlgItemText( hEnipDialog,IDC_PORTNR[i], "x");
	SetDlgItemText( hEnipDialog,IDC_AF[i], "x");
	SetDlgItemText( hEnipDialog,IDC_PROT[i], "x");
	SetDlgItemText( hEnipDialog,IDC_SOCL[i], "x");

	SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)]=-1;
	return TRUE;
}		

BOOL DLGEnipDisconnect()
{
	int i,j;
    char pBuffer[40];
    bool useExtended = FALSE ;

    i=(int) SendMessage(GetDlgItem(hEnipLman, IDC_CB_CID), CB_GETCURSEL, 0, 0);
	if (CB_ERR != SendMessage(GetDlgItem(hEnipLman, IDC_CB_CID), CB_GETLBTEXT, (WPARAM) i, (LPARAM) (LPCSTR)  pBuffer))
    {
        j = sscanf(pBuffer,"%d",&i);
        if ( j > 0 ) {
            for ( j = 1 ; j < enipLmanCidArrayLen ; j++ )
            {   // find cid in array
                if ( i == enipLmanCidArray[j] )
                {
                    useExtended = TRUE ;
                    break ;
                }
            }
            if ( useExtended)
            {  
                 // delete GUI entry
                HWND hEnipLmanCid = GetDlgItem(hEnipLman, IDC_CB_CID) ;
                SendMessage(hEnipLmanCid, CB_DELETESTRING, (WPARAM)(j), 0) ; 
                // reset selection
                SendMessage(hEnipLmanCid, CB_SETCURSEL, 0, 0);
                
                // delete cid from array
                for(  ; j < (enipLmanCidArrayLen-1) ; j++)
                {
                    enipLmanCidArray[j] = enipLmanCidArray[j+1] ;
                }
                enipLmanCidArrayLen-- ;
            }
        }
    }

    if ( useExtended == FALSE )
    {
	MOPI_DLGnewAction (TEST_M_LMAN_DISCONNECT_REQ,&pSlipBuffer);
    }
    else
    {
        addParam(TEST_CID,4,&i,&pSlipBuffer);
        i = 0 ;
        addParam(TEST_TDI,4,&i,&pSlipBuffer) ;
        MOPI_DLGnewAction (TEST_M_LMAN_DISCONNECTEXT_REQ,&pSlipBuffer);
    }
							
	for (i=0; i<5; i++)
	{
		SetDlgItemText( hEnipDialog,IDC_SOCNR[i], "x");
		SetDlgItemText( hEnipDialog,IDC_PORTNR[i], "x");
		SetDlgItemText( hEnipDialog,IDC_AF[i], "x");
		SetDlgItemText( hEnipDialog,IDC_PROT[i], "x");
		SetDlgItemText( hEnipDialog,IDC_SOCL[i], "x");
		SocketNr[i]=-1;
	}
	return TRUE;
}	

BOOL DLGEnipAGetHostByName()
{
	char host_name[256];	

	GetDlgItemText( hEnipDNR,IDC_ED_NAME, host_name, sizeof(host_name) );

	addParam(TEST_host_name,strlen(host_name),&host_name,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_sock_asyncgethostbyname,&pSlipBuffer);

	return TRUE;
}

BOOL DLGEnipGetHostByName()
{
	char host_name[256];	

	GetDlgItemText( hEnipDNR,IDC_ED_NAME, host_name, sizeof(host_name) );

	addParam(TEST_host_name,strlen(host_name),&host_name,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_sock_gethostbyname,&pSlipBuffer);

	return TRUE;
}

BOOL DLGEnipGetHostByAddr()
{
	char host_addr[16];
	int host_addr_len=16;
	unsigned int IpAddress;
	
	GetDlgItemText( hEnipDialog, IDC_ED_IPADDR, host_addr, host_addr_len);
	IpAddress=inet_addr(host_addr);

	addParam(TEST_inet_IpAddress,sizeof(IpAddress),&IpAddress,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_sock_gethostbyaddr,&pSlipBuffer);

	return TRUE;

}

BOOL DLGEnipAGetHostByAddr()
{
	char host_addr[16];
	int host_addr_len=16;
	unsigned int IpAddress;

	GetDlgItemText( hEnipDialog, IDC_ED_IPADDR, host_addr, host_addr_len);
	IpAddress=inet_addr(host_addr);

	addParam(TEST_inet_IpAddress,sizeof(IpAddress),&IpAddress,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_sock_asyncgethostbyaddr,&pSlipBuffer);

	return TRUE;
}

BOOL DLGEnipShutdown()
{
	int esocket;
	int shutdown_how;

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_SOCKET ), CB_GETCURSEL, 0, 0)];

	shutdown_how = IDC_Shutdown[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_sHOW ), CB_GETCURSEL, 0, 0)];

	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_shutdown_how,4,&shutdown_how,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_bsd_shutdown,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipPatternSend()
{
	int esocket;
	int flags=0;
	int count=0;
	char buf[1024];

	memset(buf, 0, 1024);

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_SOCKET ), CB_GETCURSEL, 0, 0)];

	GetDlgItemText( hEnipTcp, IDC_E_TDATA, buf, 1024);
	GetDlgItemText( hEnipTcp, IDC_E_TCOUNT, pBuffer, pBufferLen);
	count=atoi(pBuffer);

	flags=0;
	
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_buf,strlen(buf),buf,&pSlipBuffer);
	addParam(TEST_flags,4,&flags,&pSlipBuffer);
	addParam(TEST_pattern_count,4,&count,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_pattern_send,&pSlipBuffer);
	return TRUE;

}

BOOL DLGEnipPatternSendto()
{

	int esocket;
	int count;
	int flags=0;
	char buf[1024];
	int PortAddress;
	UINT IpAddress;
	int esocket_af ;
	pmbyte DestIp6Address[16];

	memset(buf, 0, 1024);

	esocket = SocketNr[(int) SendMessage(GetDlgItem(hEnipDialog,IDC_CB_SOCKET ), CB_GETCURSEL, 0, 0)];
    esocket_af = GetSocketAF( esocket );
    if( esocket_af == -1 )
     return FALSE;

	GetDlgItemText( hEnipUdp, IDC_E_UDATA, buf, 1024);
	GetDlgItemText( hEnipUdp, IDC_E_UCOUNT, pBuffer, pBufferLen);
	count=atoi(pBuffer);

	flags=0;

	memset(DestIp6Address,0,16);
	GetDlgItemText( hEnipDialog, IDC_ED_IPADDR, pBuffer, pBufferLen);
	if (esocket_af == BSD_AF_INET ) {
	IpAddress=inet_addr(pBuffer);
		memcpy(DestIp6Address,(pmbyte *) &IpAddress,4);
	}else 
/*    if( esocket_af == BSD_AF_INET6 ) */
    {
		int cnv_result = inet_pton( BSD_AF_INET6, pBuffer, DestIp6Address );
	}


	GetDlgItemText( hEnipDialog, IDC_ED_PORT, pBuffer, pBufferLen);
	PortAddress=atoi(pBuffer);


	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);
	addParam(TEST_buf,strlen(buf),buf,&pSlipBuffer);
	addParam(TEST_flags,4,&flags,&pSlipBuffer);
    addParam(TEST_af, 4, &esocket_af,&pSlipBuffer);
	addParam(TEST_Ip6Address,16,DestIp6Address,&pSlipBuffer);
	addParam(TEST_PortAddress,4,&PortAddress,&pSlipBuffer);
	addParam(TEST_pattern_count,4,&count,&pSlipBuffer);
							
	MOPI_DLGnewAction (TEST_CALL_pattern_sendto,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipGetPeerName()
{
	int esocket;
	int i;

	i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
	esocket =SocketNr[i];
					
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_getpeername,&pSlipBuffer);
	return TRUE;
}


BOOL DLGEnipGetSockName()
{	
	int esocket;
	int i;

	i=(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);
	esocket =SocketNr[i];
					
	addParam(TEST_BSD_SOCKET,4,&esocket,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_getsockname,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipInetNtoa()
{	
	unsigned int IpAddr;

	GetDlgItemText( hEnipConvert, IDC_E_CONIP, pBuffer, pBufferLen);
	IpAddr=atoi(pBuffer);
					
	addParam(TEST_inet_IpAddress,4,&IpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_inet_ntoa,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipInetAddr()
{	
	char StrIpAddr[16];

	GetDlgItemText( hEnipConvert, IDC_E_CONIP, StrIpAddr, sizeof(StrIpAddr));
					
	addParam(TEST_buf,sizeof(StrIpAddr),StrIpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_inet_addr,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSockHtonl()
{	
	long IpAddr;

	GetDlgItemText( hEnipConvert, IDC_E_CONIP, pBuffer, pBufferLen);
	IpAddr=atoi(pBuffer);
					
	addParam(TEST_inet_IpAddress,4,&IpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_htonl,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSockHtons()
{	
	unsigned int IpAddr;

	GetDlgItemText( hEnipConvert, IDC_E_CONIP, pBuffer, pBufferLen);
	IpAddr=atoi(pBuffer);
					
	addParam(TEST_inet_IpAddress,4,&IpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_htons,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSockNtohl()
{	
	long IpAddr;

	GetDlgItemText( hEnipDialog, IDC_E_CONIP, pBuffer, pBufferLen);
	IpAddr=atoi(pBuffer);
					
	addParam(TEST_inet_IpAddress,4,&IpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_ntohl,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSockNtohs()
{	
	unsigned int IpAddr;

	GetDlgItemText( hEnipDialog, IDC_E_CONIP, pBuffer, pBufferLen);
	IpAddr=atoi(pBuffer);
					
	addParam(TEST_inet_IpAddress,4,&IpAddr,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_ntohs,&pSlipBuffer);
	return TRUE;
}

BOOL DLGEnipSockSelect(void)
{

	int timeouts, timeoutu, mode;
	int FdsReadListCount, FdsWriteListCount, FdsExceptListCount;

	
	FdsReadListCount = FdsReadListIndex + 1;
	FdsWriteListCount = FdsWriteListIndex + 1;
	FdsExceptListCount = FdsExceptListIndex + 1;
				
	addParam(TEST_readfds,sizeof(FdsReadList),FdsReadList,&pSlipBuffer);
	addParam(TEST_writefds,sizeof(FdsWriteList),FdsWriteList,&pSlipBuffer);
	addParam(TEST_exceptfds,sizeof(FdsExceptList),FdsExceptList,&pSlipBuffer);
	addParam(TEST_ReadFdsCount,4,&FdsReadListCount,&pSlipBuffer);
	addParam(TEST_WriteFdsCount,4,&FdsWriteListCount,&pSlipBuffer);
	addParam(TEST_ExceptFdsCount,4,&FdsExceptListCount,&pSlipBuffer);

	GetDlgItemText( hEnipSelect, IDC_E_TIMEOUTS, pBuffer, pBufferLen);
	timeouts=atoi(pBuffer); 
	addParam(TEST_TimeOutS,4,&timeouts,&pSlipBuffer);

	GetDlgItemText( hEnipSelect, IDC_E_TIMEOUTU, pBuffer, pBufferLen);
	timeoutu=atoi(pBuffer);
	addParam(TEST_TimeOutU,4,&timeoutu,&pSlipBuffer);

	mode=(int) SendMessage(GetDlgItem(hEnipSelect, IDC_C_MODE), CB_GETCURSEL, 0, 0);
	addParam(TEST_Mode,4,&mode,&pSlipBuffer);

	MOPI_DLGnewAction (TEST_CALL_sock_select,&pSlipBuffer);
	return TRUE;

}

//------------------------------------------------------------------------------
//Help

bool DLGEnipWriteProfile()
{
	int bearer;
	char access;
	int dummyDNS;
	int profile;


	if (BST_CHECKED==IsDlgButtonChecked( hEnipProfile, IDC_R_GPRS)) //GPRS
	{
		bearer=eCON_HNDL_BEARER_GPRS;
		GetDlgItemText( hEnipProfile, IDC_ED_Apn, pBuffer, sizeof(pBuffer));
		addParam(TEST_APN,strlen(pBuffer),pBuffer,&pSlipBuffer);
	}
	else
	{
		bearer=eCON_HNDL_BEARER_CSD;

		GetDlgItemText( hEnipProfile, IDC_ED_PHONE, pBuffer, sizeof(pBuffer));
		addParam(TEST_PHONE_NUMBER,strlen(pBuffer),pBuffer,&pSlipBuffer);

		if (BST_CHECKED==IsDlgButtonChecked( hEnipProfile, IDC_R_ISDN))
			access='i';
		else
			access=' ';
		addParam(TEST_ACCESS_TYPE,sizeof(char),&access,&pSlipBuffer);
	}
	addParam(TEST_Bearer,4,&bearer,&pSlipBuffer);

	GetDlgItemText( hEnipProfile, IDC_ED_Profile, pBuffer, sizeof(pBuffer));
	profile=atoi(pBuffer);
	addParam(TEST_Profile,4,&profile,&pSlipBuffer);

	GetDlgItemText( hEnipProfile, IDC_ED_USER, pBuffer, sizeof(pBuffer));
	addParam(TEST_USR,strlen(pBuffer),pBuffer,&pSlipBuffer);

	GetDlgItemText( hEnipProfile, IDC_ED_PASSWD, pBuffer, sizeof(pBuffer));
	addParam(TEST_PASSWORD,strlen(pBuffer),pBuffer,&pSlipBuffer);

	GetDlgItemText( hEnipProfile, IDC_ED_DNS1, pBuffer, sizeof(pBuffer));
	dummyDNS=inet_addr(pBuffer);
	addParam(TEST_DNS1,4,&dummyDNS,&pSlipBuffer);
	
	GetDlgItemText( hEnipProfile, IDC_ED_DNS2, pBuffer, sizeof(pBuffer));
	dummyDNS=inet_addr(pBuffer);
	addParam(TEST_DNS2,4,&dummyDNS,&pSlipBuffer);
	
	MOPI_DLGnewAction (TEST_CALL_write_profile,&pSlipBuffer);					
	return TRUE;

}

bool DLGEnipReadProfile()
{
	int bearer;
	int profile;

	if (BST_CHECKED==IsDlgButtonChecked( hEnipProfile, IDC_R_GPRS)) //GPRS
	{
		bearer=eCON_HNDL_BEARER_GPRS;
	}
	else
	{
		bearer=eCON_HNDL_BEARER_CSD;
	}
	addParam(TEST_Bearer,4,&bearer,&pSlipBuffer);

	GetDlgItemText( hEnipProfile, IDC_ED_Profile, pBuffer, sizeof(pBuffer));
	profile=atoi(pBuffer);
	addParam(TEST_Profile,4,&profile,&pSlipBuffer);	

	MOPI_DLGnewAction (TEST_CALL_read_profile,&pSlipBuffer);					
	return TRUE;	
}
#endif //TESTPROC_TEST_IF

//--------------------------------------------------------------------------

extern "C" void RecvMessage( char * pBuffer, int length ) // receive the messages from the Testprocess
{
#if TESTPROC_TEST_IF > 0

	SLIP_Puffer SlipBuffer;	
	int iActionID;


	SlipBuffer.pSLIPBuffer=(unsigned char *)&pBuffer[0];
	SlipBuffer.iFrameLength=length;

	iActionID = SlipBuffer.pSLIPBuffer[0];
	iActionID <<=8;
	iActionID += SlipBuffer.pSLIPBuffer[1];
			
	switch (iActionID)
	{
		case TEST_M_LMAN_CONNECT_RET:
			on_TEST_M_LMAN_CONNECT_RET(&SlipBuffer);
		break;
        case TEST_M_LMAN_CONNECTEXT_RET:
			on_TEST_M_LMAN_CONNECTEXT_RET(&SlipBuffer);
		break;

		case TEST_LMAN_CONNECT_CNF: 
			on_TEST_LMAN_CONNECT_CNF(&SlipBuffer);	
		break; 
		case TEST_LMAN_CONNECT_REJ_IND:
			on_TEST_LMAN_CONNECT_REJ_IND(&SlipBuffer);
		break;
		case TEST_M_LMAN_DISCONNECT_RET:
			on_TEST_M_LMAN_DISCONNECT_RET(&SlipBuffer);
		break;
        case TEST_M_LMAN_DISCONNECTEXT_RET:
			on_TEST_M_LMAN_DISCONNECTEXT_RET(&SlipBuffer);
		break;
		case TEST_LMAN_DISCONNECT_CNF:
			on_TEST_LMAN_DISCONNECT_CNF(&SlipBuffer);
		break;
		case TEST_LMAN_DISCONNECT_IND:
			on_TEST_LMAN_DISCONNECT_IND(&SlipBuffer);
		break;
		case TEST_RET_bsd_socket:
			on_TEST_RET_bsd_socket(&SlipBuffer);
		break;
		case TEST_RET_bsd_sendto:
			on_TEST_RET_bsd_sendto(&SlipBuffer);
		break;
		case TEST_RET_bsd_bind:
			on_TEST_RET_bsd_bind(&SlipBuffer);
		break;
		case TEST_LMAN_SOCK_DATA_READ:
			on_TEST_LMAN_SOCK_DATA_READ(&SlipBuffer);
		break;
		case TEST_RET_bsd_recvfrom:
			on_TEST_RET_bsd_recvfrom(&SlipBuffer);
		break;
		case TEST_RET_bsd_connect:
			on_TEST_RET_bsd_connect(&SlipBuffer);
		break;		
		case TEST_ENIP_SOCK_CONNECTED:
			on_TEST_ENIP_SOCK_CONNECTED(&SlipBuffer);
		break;
		case TEST_RET_bsd_close:
			on_TEST_RET_bsd_close(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_CLOSED:
			on_TEST_ENIP_SOCK_CLOSED(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_REMOTE_CLOSED:
			on_TEST_ENIP_SOCK_REMOTE_CLOSED(&SlipBuffer);
		break;
		case TEST_RET_bsd_shutdown:
			on_TEST_RET_bsd_shutdown(&SlipBuffer);
		break;
		case TEST_RET_bsd_send:
			on_TEST_RET_bsd_send(&SlipBuffer);
		break;
		case TEST_RET_bsd_recv:
			on_TEST_RET_bsd_recv(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_ACCEPTED:
			on_TEST_ENIP_SOCK_ACCEPTED(&SlipBuffer);
		break;
		case TEST_RET_pattern_send:
			on_TEST_RET_pattern_send(&SlipBuffer);
		break;
		case TEST_RET_pattern_sendto:
			on_TEST_RET_pattern_sendto(&SlipBuffer);
		break;
		case TEST_RET_sock_gethostbyname:   //return Message for gethostbyname & asyncgethostbyname
			on_TEST_RET_bsd_gethostbyname(&SlipBuffer);
		break;
		case TEST_RET_sock_gethostbyaddr: //return Message for gethostbyaddr & asyncgethostbyaddr
			on_TEST_RET_sock_gethostbyaddr(&SlipBuffer);
		break;
		case TEST_LMAN_SOCK_HOST_BY_NAME:
			on_TEST_LMAN_SOCK_HOST_BY_NAME(&SlipBuffer);
		break;
		case TEST_LMAN_SOCK_HOST_BY_ADDR:
			on_TEST_LMAN_SOCK_HOST_BY_ADDR(&SlipBuffer);
		case TEST_RET_bsd_listen:
			on_TEST_RET_bsd_listen(&SlipBuffer);
		break;
		case TEST_RET_bsd_accept:
			on_TEST_RET_bsd_accept(&SlipBuffer);
		break;
		case TEST_RET_bsd_ioctl:
			on_TEST_RET_bsd_ioctl(&SlipBuffer);
		break;
		case TEST_RET_bsd_setsockopt:
			on_TEST_RET_bsd_setsockopt(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_ICMP_ERROR:
			on_TEST_ENIP_SOCK_ICMP_ERROR(&SlipBuffer);
		break;
		case TEST_RET_bsd_getlocaladdr:
			on_TEST_RET_bsd_getlocaladdr(&SlipBuffer);
		break;
		case TEST_RET_bsd_getremoteaddr:
			on_TEST_RET_bsd_getremoteaddr(&SlipBuffer);
		break;
		case TEST_RET_sock_getpeername:
			on_TEST_RET_sock_getpeername(&SlipBuffer);
		break;
		case TEST_RET_sock_getsockname:
			on_TEST_RET_sock_getsockname(&SlipBuffer);
		break;

		case TEST_RET_read_profile:
			on_TEST_RET_read_profile(&SlipBuffer);
		break;
		case TEST_RET_write_profile:
			on_TEST_RET_write_profile(&SlipBuffer);
		break;
		case TEST_ENIP_BUFFER_FREE:
			on_TEST_ENIP_BUFFER_FREE(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_SEND_WND_OPENED:
			on_TEST_ENIP_SOCK_SEND_WND_OPENED(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_SEND_TIMEOUT:
			on_TEST_ENIP_SOCK_SEND_TIMEOUT(&SlipBuffer);
		break;
		case TEST_ENIP_SOCK_DATA_SENT:
			on_TEST_ENIP_SOCK_DATA_SENT(&SlipBuffer);
		break;
		case TEST_RET_sock_inet_ntoa:
			on_TEST_RET_sock_inet_ntoa(&SlipBuffer);
		break;
		case TEST_RET_sock_inet_addr:
			on_TEST_RET_sock_inet_addr(&SlipBuffer);
		break;
		case TEST_RET_sock_htonl:
			on_TEST_RET_sock_htonl(&SlipBuffer);
		break;
		case TEST_RET_sock_htons:
			on_TEST_RET_sock_htons(&SlipBuffer);
		break;
		case TEST_RET_sock_ntohl:
			on_TEST_RET_sock_ntohl(&SlipBuffer);
		break;
		case TEST_RET_sock_ntohs:
			on_TEST_RET_sock_ntohs(&SlipBuffer);
		break;
		case TEST_RET_sock_getsockopt:
			on_TEST_RET_sock_getsockopt(&SlipBuffer);
		break;

		case TEST_RET_sock_select:
			on_TEST_RET_sock_select(&SlipBuffer);
		break;

		case TEST_RET_sock_startup:
			on_TEST_RET_sock_startup(&SlipBuffer);
		break;

		case TEST_RET_sock_cleanup:
			on_TEST_RET_sock_cleanup(&SlipBuffer);
		break;

		case TEST_RET_sock_setlasterror:
			on_TEST_RET_sock_setlasterror(&SlipBuffer);
		break;

		case TEST_RET_sock_getlasterror:
			on_TEST_RET_sock_getlasterror(&SlipBuffer);
		break;


	}
	
	enip_memory_release(pBuffer);

#endif //TESTPROC_TEST_IF
}

#if TESTPROC_TEST_IF > 0

//--------------------------------------------------------------------------------------------

// following functions handle the return messages of the Testprocess 
// like return values or notification messages

void on_TEST_M_LMAN_CONNECT_RET(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "lman connect return" );
	strcpy(lpCaption, "TEST_M_LMAN_CONNECT_RET");
#if MSGBOX_ON	
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
    SetLogText(text);

	ErrnoText();
}

void on_TEST_M_LMAN_CONNECTEXT_RET(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

    if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_CID, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&enipLmanCidArray[enipLmanCidArrayLen],pParamPointer,iParamLength);


    sprintf(text, "%d", enipLmanCidArray[enipLmanCidArrayLen]);
    

    if (hEnipLman != NULL ) {
        SendMessage(GetDlgItem(hEnipLman, IDC_CB_CID), CB_INSERTSTRING, (WPARAM)enipLmanCidArrayLen, (LPARAM) (LPCTSTR) text ); 
	    //SendMessage(GetDlgItem(hEnipLman, IDC_CB_CID), CB_ADDSTRING, 0, (LPARAM) (LPCTSTR) text );
        SendMessage(GetDlgItem(hEnipLman, IDC_CB_CID), CB_SETCURSEL, (WPARAM)enipLmanCidArrayLen, 0);
    }
    enipLmanCidArrayLen++ ;
	sprintf(text, "lman connectext return cid %d",enipLmanCidArray[enipLmanCidArrayLen-1] );
	strcpy(lpCaption, "TEST_M_LMAN_CONNECTEXT_RET");
#if MSGBOX_ON	
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
    SetLogText(text);

	ErrnoText();
}

void on_TEST_LMAN_CONNECT_CNF(SLIP_Puffer * pRXBuffer) // connection is established
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "lman connect confirm" );
	strcpy(lpCaption, "TEST_LMAN_CONNECT_CNF");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();

}	

void on_TEST_LMAN_CONNECT_REJ_IND(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	// message parameter
 	int iReleaseCause; 


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Cause, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&iReleaseCause,pParamPointer,iParamLength);

	PrintReleaseCause(iReleaseCause);

	ErrnoText();
	
}

void on_TEST_M_LMAN_DISCONNECT_RET(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "lman disconnect return" );
	strcpy(lpCaption, "TEST_M_LMAN_DISCONNECT_RET");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
}

void on_TEST_M_LMAN_DISCONNECTEXT_RET(SLIP_Puffer * pRXBuffer)
{
    unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
    unsigned int result = 0 ;
	char text[500];
	char lpCaption[30];

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

    sprintf(text, "lman disconnect return: %x",result );
	strcpy(lpCaption, "TEST_M_LMAN_DISCONNECTEXT_RET");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
}
void on_TEST_LMAN_DISCONNECT_CNF(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "lman disconnect confirm" );
	strcpy(lpCaption, "TEST_LMAN_DISCONNECT_CNF");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_LMAN_DISCONNECT_IND(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "lman disconnect indication" );
	strcpy(lpCaption, "TEST_LMAN_DISCONNECT_IND");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}
void on_TEST_RET_bsd_socket(SLIP_Puffer * pRXBuffer)
{   
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	int socket;

	// message parameter
	UINT aSocket;     


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);

	socket =(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0);

	SocketNr[socket]=aSocket;

	sprintf(text, "%d",SocketNr[socket]);
	SetDlgItemText( hEnipDialog,IDC_SOCNR[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)], text);

	sprintf(text, "SocketID %d: %d",socket+1, aSocket);
	strcpy(lpCaption, "TEST_RET_bsd_socket");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif	
	sprintf(text," socket created: %d",SocketNr[socket]);
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_RET_bsd_sendto(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT sendto_result;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&sendto_result,pParamPointer,iParamLength);
	
	sprintf(text, "sendto result: %d", sendto_result);
	strcpy(lpCaption, "TEST_RET_bsd_sendto");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();

}

void on_TEST_RET_bsd_bind(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	int result;
	int PortAddress;

	sprintf(text, "return bsd_bind" );
	strcpy(lpCaption, "TEST_RET_bsd_bind");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif	
	SetLogText(text);
	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	if (result==0)
	{	
		GetDlgItemText( hEnipDialog, IDC_ED_PORT, text, sizeof(text));
		PortAddress=atoi(text);
		sprintf(text, "%d", PortAddress );
		SetDlgItemText( hEnipDialog,IDC_PORTNR[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],text);
		SetDlgItemText( hEnipDialog,IDC_SOCL[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],"b");

		SetLogText(text);
	}
	else
	{
		sprintf( text, "result: %d", result);
		SetLogText(text);
	}

	ErrnoText();
	
}

void on_TEST_LMAN_SOCK_DATA_READ(SLIP_Puffer * pRXBuffer)  //tells user that a data packet has arrived, which can be received 
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT aSocket;     

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);

	sprintf(text, "data packet on socket %d received!", aSocket );
	strcpy(lpCaption, "TEST_LMAN_SOCK_DATA_READ");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
}

void on_TEST_RET_bsd_recvfrom(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[20];

	// message parameter
	char  received_udpData[TESTPROC_FRAME_BUFFER_SIZE];
	UINT from_Port =0;
	int result;
	char STRfrom_Address[INET6_ADDRSTRLEN];
//	long from_Address;
	pmbyte from_Address[16] ;
	struct in_addr in;
	unsigned int af_format ;


		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(&result,pParamPointer,iParamLength);

		if (result != -1)
		{

			if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_buf, &iParamLength,pRXBuffer)) == NULL)
				return;
			memcpy(received_udpData,pParamPointer,iParamLength);
			received_udpData[iParamLength]=0;
		}
		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_af, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(&af_format,pParamPointer,iParamLength);

		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Ip6Address, &iParamLength,pRXBuffer)) == NULL)
			return;

		if ( af_format == BSD_AF_INET ) {
			memcpy(&from_Address,pParamPointer,4);
			in.S_un.S_addr= *((unsigned int *) from_Address);
		strcpy(STRfrom_Address,inet_ntoa(in));
		} else {
			memcpy(&from_Address,pParamPointer,16);
			inet_ntop( BSD_AF_INET6, from_Address , STRfrom_Address, INET6_ADDRSTRLEN);
	
		}
		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_PortAddress, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(&from_Port,pParamPointer,iParamLength);

		sprintf(text, "result: %d \nfrom_Port: %d\nfrom_Address: %s \n data: %s",result, from_Port,STRfrom_Address, received_udpData );
		strcpy(lpCaption, "TEST_RET_bsd_recvfrom");
#if MSGBOX_ON
		MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
		SetLogText(text);

	ErrnoText();	
}

void on_TEST_RET_bsd_connect(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "RET_bsd_connect" );
	strcpy(lpCaption, "TEST_RET_bsd_connect");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	ErrnoText();
	
	SetLogText(text);
}

void on_TEST_ENIP_SOCK_CONNECTED(SLIP_Puffer * pRXBuffer) //peer has accepted the connection
{
	int Port;
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT aSocket;     

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);

	sprintf(text, "socket %d connected", aSocket );
	strcpy(lpCaption, "TEST_ENIP_SOCK_CONNECTED");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
		
	GetDlgItemText( hEnipDialog, IDC_ED_PORT, text, sizeof(text));
	Port=atoi(text);
	sprintf(text, "%d", Port );
	SetDlgItemText( hEnipDialog,IDC_PORTNR[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],text);
	SetDlgItemText( hEnipDialog,IDC_SOCL[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],"c");

	ErrnoText();
	
}

void on_TEST_RET_bsd_close(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "return bsd_close" );
	strcpy(lpCaption, "TEST_RET_bsd_close");
#if MSGBOX_ON	
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_ENIP_SOCK_CLOSED(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	// message parameter
	UINT aSocket;     


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);
	
	sprintf(text, "enip sock %d closed", aSocket );
	strcpy(lpCaption, "TEST_ENIP_SOCK_CLOSED");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_ENIP_SOCK_REMOTE_CLOSED(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	int i;

	// message parameter
	UINT aSocket;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);

	sprintf(text, "sock %d remote closed", aSocket );
	strcpy(lpCaption, "TEST_ENIP_SOCK_REMOTE_CLOSED");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();

	for (i=0; SocketNr[i]!=(int)aSocket ; i++)
	{
		if (i==5)
			return;
	}
	SetDlgItemText( hEnipDialog,IDC_SOCL[i],"x");
}

void on_TEST_RET_bsd_shutdown(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	// message parameter
	int result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	if (result==0)
	{	
		GetDlgItemText( hEnipDialog, IDC_CB_sHOW, text, sizeof(text));
		if (strcmp(text, "0"))
			strcpy(text, "sr");
		else if	(strcmp(text, "1"))
			strcpy(text, "ss");
		else if (strcmp(text, "2"))
		   strcpy(text, "sb");

		SetDlgItemText( hEnipDialog,IDC_SOCL[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],text);
	}

	sprintf(text, "return bsd_shutdown result: %d", result );

	strcpy(lpCaption, "TEST_RET_bsd_shutdown");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);;

	ErrnoText();
	
}

void on_TEST_RET_bsd_send(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	
	// message parameter
    UINT send_result;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&send_result,pParamPointer,iParamLength);

	sprintf(text, "send_result: %d",send_result);
	strcpy(lpCaption, "TEST_RET_bsd_send");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_RET_bsd_recv(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	char received_TCPData[TESTPROC_FRAME_BUFFER_SIZE];
	UINT result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "Bytes_received: %d \ndata: ",result);
	if (result != -1)
	{
		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_buf, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(received_TCPData,pParamPointer,iParamLength);
		received_TCPData[iParamLength]=0;
		strcat(text, received_TCPData);
	}

	strcpy(lpCaption, "TEST_RET_bsd_recv");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_ENIP_SOCK_ACCEPTED(SLIP_Puffer * pRXBuffer)
{

	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT aSocket;     

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&aSocket,pParamPointer,iParamLength);

	sprintf(text, "socket %d accepted", aSocket );
	strcpy(lpCaption, "TEST_ENIP_SOCK_ACCEPTED");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_RET_pattern_send(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	
	// message parameter
    UINT pattern_send_result;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&pattern_send_result,pParamPointer,iParamLength);

	sprintf(text, "pattern_send_result: %d",pattern_send_result);
	strcpy(lpCaption, "TEST_RET_pattern_send");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_RET_pattern_sendto(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	
	// message parameter
    UINT pattern_sendto_result;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&pattern_sendto_result,pParamPointer,iParamLength);

	sprintf(text, "pattern_sendto_result: %d",pattern_sendto_result);
	strcpy(lpCaption, "TEST_RET_pattern_sendto");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	ErrnoText();
	
}

void on_TEST_RET_bsd_gethostbyname(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT gethostbyname_result;


	char gethostbyname_name[1000];
	char gethostbyname_aliases[1000];
	UINT gethostbyname_addrtype;	
	UINT gethostbyname_length;
    int gethostbyname_addresses;
	UINT gethostbyname_QueryID;	
	char IP_addr_str[16];
	struct in_addr in;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_result,pParamPointer,iParamLength);

	if (gethostbyname_result!=0)
	{
		sprintf(text, "gethostbyname_result: %d", gethostbyname_result); 
		SetLogText(text);
		return;
	}

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_name, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(gethostbyname_name,pParamPointer,iParamLength);
	gethostbyname_name[iParamLength]=0;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_aliases, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(gethostbyname_aliases,pParamPointer,iParamLength);
	gethostbyname_aliases[iParamLength]=0;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_addrtype, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&gethostbyname_addrtype,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_length, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_length,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_addresses,pParamPointer,iParamLength);
	in.S_un.S_addr=gethostbyname_addresses;
	strcpy(IP_addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_QueryID, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_QueryID,pParamPointer,iParamLength);


	sprintf(text, "gethostbyname_result: %d, gethostbyname_QueryID: %d, gethost_name: %s, gethostbyname_aliases: %s, gethostbyname_addrtype: %d, gethostbyname_length: %d, gethostbyname_addresses: %s",gethostbyname_result,gethostbyname_QueryID, gethostbyname_name, gethostbyname_aliases, gethostbyname_addrtype, gethostbyname_length, IP_addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_gethostbyname");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);

	SetDlgItemText( hEnipDialog,IDC_ED_IPADDR,IP_addr_str );

	ErrnoText();
	
}

void on_TEST_RET_sock_gethostbyaddr(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT gethostbyname_result;


	char gethostbyname_name[1000];
	char gethostbyname_aliases[1000];
	UINT gethostbyname_addrtype;	
	UINT gethostbyname_length;
    int gethostbyname_addresses;
	UINT gethostbyname_QueryID;	
	char IP_addr_str[16];
	struct in_addr in;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_result,pParamPointer,iParamLength);

	if (gethostbyname_result!=0)
	{
		sprintf( text, "gethostbyname_result: %d",gethostbyname_result );
		SetLogText(text);
		return;
	}

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_name, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(gethostbyname_name,pParamPointer,iParamLength);
	gethostbyname_name[iParamLength]=0;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_aliases, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(gethostbyname_aliases,pParamPointer,iParamLength);
	gethostbyname_aliases[iParamLength]=0;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_addrtype, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&gethostbyname_addrtype,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_length, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_length,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_addresses,pParamPointer,iParamLength);
//	enip_ipc_inet_ntoa(gethostbyname_addresses, IP_addr_str, sizeof(IP_addr_str));
	in.S_un.S_addr=gethostbyname_addresses;
	strcpy(IP_addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_QueryID, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&gethostbyname_QueryID,pParamPointer,iParamLength);


	sprintf(text, "gethostbyname_result: %d, gethostbyname_QueryID: %d, gethost_name: %s, gethostbyname_aliases: %s, gethostbyname_addrtype: %d, gethostbyname_length: %d, gethostbyname_addresses: %s",gethostbyname_result,gethostbyname_QueryID, gethostbyname_name, gethostbyname_aliases, gethostbyname_addrtype, gethostbyname_length, IP_addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_gethostbyname");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	SetDlgItemText( hEnipDNR,IDC_ED_NAME, gethostbyname_name );

	ErrnoText();

}

void on_TEST_LMAN_SOCK_HOST_BY_NAME(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT MSG_hostbyname_result;
    UINT MSG_hostbyname_QueryID;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&MSG_hostbyname_result,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_QueryID, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&MSG_hostbyname_QueryID,pParamPointer,iParamLength);

	sprintf(text, "MSG_hostbyname_result: %d, MSG_host_QueryID: %d",MSG_hostbyname_result, MSG_hostbyname_QueryID);
	strcpy(lpCaption, "TEST_LMAN_SOCK_HOST_BY_NAME");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
	
}

void on_TEST_LMAN_SOCK_HOST_BY_ADDR(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	UINT MSG_hostbyaddr_result;
    UINT MSG_hostbyaddr_QueryID;


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&MSG_hostbyaddr_result,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_gethost_QueryID, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&MSG_hostbyaddr_QueryID,pParamPointer,iParamLength);

	sprintf(text, "MSG_hostbyaddr_result: %d, MSG_host_QueryID: %d",MSG_hostbyaddr_result, MSG_hostbyaddr_QueryID);
	strcpy(lpCaption, "TEST_LMAN_SOCK_HOST_BY_ADDR");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();

}

void on_TEST_RET_bsd_listen(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT listen_result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&listen_result,pParamPointer,iParamLength);

	sprintf(text, "listen_result: %d",listen_result);
	strcpy(lpCaption, "TEST_RET_bsd_listen");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	if (listen_result==0)
	{
		SetDlgItemText( hEnipDialog,IDC_SOCL[(int) SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_GETCURSEL, 0, 0)],"l");
	}

	SetLogText(text);
	ErrnoText();
	
}

void on_TEST_RET_bsd_accept(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	int socket;
	// char Ip_Addr_str[16];
	struct in_addr in;

	// message parameter
    UINT bsd_socket;
	UINT inet_IpAddress;
	int  af_socket ; // address family
	pmbyte SrcIp6Address[16] ;
	char textSrcIp6Address[50];


	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_af, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&af_socket,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Ip6Address, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&SrcIp6Address,pParamPointer,iParamLength);

	if (af_socket == BSD_AF_INET ) {
	//enip_ipc_inet_ntoa(inet_IpAddress, Ip_Addr_str, 16);
		memcpy(&inet_IpAddress,SrcIp6Address,16) ;
	in.S_un.S_addr=inet_IpAddress;
		strcpy(textSrcIp6Address,inet_ntoa(in));
	} else {
		inet_pton( BSD_AF_INET6, textSrcIp6Address, SrcIp6Address );
	}
	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;	
	memcpy(&bsd_socket,pParamPointer,iParamLength);


	for (socket=0; socket<5; socket++)
	{
		if (SocketNr[socket]==-1)
			break;
		else if (socket==4)
		{
#if MSGBOX_ON			
			MessageBox( hEnipDialog, "no free socket!", "", MB_OK);
#endif
			return;
		}
	}
	SocketNr[socket]=bsd_socket;
	if (bsd_socket!=-1)
	{
		SetDlgItemText( hEnipDialog,IDC_SOCL[socket],"a");
		SetDlgItemText( hEnipDialog,IDC_PROT[socket],"tcp");
		SetDlgItemText( hEnipDialog,IDC_PORTNR[socket],"");
		sprintf(text, "%d",bsd_socket );
		SetDlgItemText( hEnipDialog,IDC_SOCNR[socket],text);
		SendMessage(GetDlgItem(hEnipDialog, IDC_CB_SOCKET), CB_SETCURSEL, socket, 0); 
	}

	sprintf(text, "SocketID %d: %d IP_Addr: %s",socket+1, bsd_socket, textSrcIp6Address);
	strcpy(lpCaption, "TEST_RET_bsd_accept");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
	
}

void on_TEST_RET_bsd_ioctl(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT arg;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_arg, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&arg,pParamPointer,iParamLength);

	sprintf(text, "arg: %d",arg);
	strcpy(lpCaption, "on_TEST_RET_bsd_ioctl");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
	
}

void on_TEST_RET_bsd_setsockopt(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT setsockopt_result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&setsockopt_result,pParamPointer,iParamLength);

	sprintf(text, "setsockopt_result: %d",setsockopt_result);
	strcpy(lpCaption, "TEST_RET_bsd_setsockopt");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
	
}

void on_TEST_RET_bsd_getlocaladdr(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	char Ip_Addr_str[16];
	struct in_addr in;

	// message parameter
    UINT result;
	UINT inet_IpAddress;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&inet_IpAddress,pParamPointer,iParamLength);
	//enip_ipc_inet_ntoa(inet_IpAddress, Ip_Addr_str, 16);
	in.S_un.S_addr=inet_IpAddress;
	strcpy(Ip_Addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "getlocaladdr_result: %d\nlocal ip-addr:%s",result, Ip_Addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_getlocaladdr");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();

}

void on_TEST_RET_bsd_getremoteaddr(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	char Ip_Addr_str[16];
	struct in_addr in;

	// message parameter
    UINT result;
	UINT inet_IpAddress;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&inet_IpAddress,pParamPointer,iParamLength);
	//enip_ipc_inet_ntoa(inet_IpAddress, Ip_Addr_str, 16);
	in.S_un.S_addr=inet_IpAddress;
	strcpy(Ip_Addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "getremoteaddr_result: %d\nremote ip-addr:%s",result, Ip_Addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_getremoteaddr");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();

}

void on_TEST_RET_sock_getsockname(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	char Ip_Addr_str[16];
	struct in_addr in;

	// message parameter
    UINT result;
	UINT inet_IpAddress;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&inet_IpAddress,pParamPointer,iParamLength);
	//enip_ipc_inet_ntoa(inet_IpAddress, Ip_Addr_str, 16);
	in.S_un.S_addr=inet_IpAddress;
	strcpy(Ip_Addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "getsockname_result: %d\nsock ip-addr:%s",result, Ip_Addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_getremoteaddr");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();

}
void on_TEST_RET_sock_getpeername(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	char Ip_Addr_str[16];
	struct in_addr in;

	long result;

	// message parameter
	UINT inet_IpAddress;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&inet_IpAddress,pParamPointer,iParamLength);
	//enip_ipc_inet_ntoa(inet_IpAddress, Ip_Addr_str, 16);
	in.S_un.S_addr=inet_IpAddress;
	strcpy(Ip_Addr_str,inet_ntoa(in));

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "getpeername_result: %d\npeer ip-addr:%s",result, Ip_Addr_str);
	strcpy(lpCaption, "TEST_RET_bsd_getremoteaddr");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}


void on_TEST_RET_sock_inet_ntoa(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char StrIpAddr[16];

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char)TEST_buf , &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(StrIpAddr,pParamPointer,iParamLength);
	
	if (0 != StrIpAddr) 
	{
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, StrIpAddr);
		sprintf(text, "addr: %s",StrIpAddr);
	}
	else
	{
		sprintf(text, "ntoa returned NULL");
	}


#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_inet_ntoa");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_inet_addr(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	pmuint32 IpAddr;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&IpAddr,pParamPointer,iParamLength);
	
	if (IpAddr != IP_INADDR_NONE) 
	{
		sprintf(text, "%u", IpAddr);
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, text);
		sprintf(text, "addr: %d",IpAddr);
	}
	else
	{
		sprintf(text, "IpAddr = IP_INADDR_NONE");
	}

#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_inet_addr");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_htonl(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	pmuint32 IpAddr;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&IpAddr,pParamPointer,iParamLength);
	
	if (IpAddr != IP_INADDR_NONE) 
	{
		sprintf(text, "%d", IpAddr);
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, text);
		sprintf(text, "addr: %d",IpAddr);
	}
	else
	{
		sprintf(text, "IpAddr = IP_INADDR_NONE");
	}

#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_htonl");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_htons(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	pmuint16 IpAddr;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&IpAddr,pParamPointer,iParamLength);
	
	if (IpAddr != IP_INADDR_NONE) 
	{
		sprintf(text, "%d", IpAddr);
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, text);
		sprintf(text, "addr: %d",IpAddr);
	}
	else
	{
		sprintf(text, "IpAddr = IP_INADDR_NONE");
	}

#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_htons");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_ntohl(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	pmuint32 IpAddr;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&IpAddr,pParamPointer,iParamLength);
	
	if (IpAddr != IP_INADDR_NONE) 
	{
		sprintf(text, "%d", IpAddr);
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, text);
		sprintf(text, "addr: %d",IpAddr);
	}
	else
	{
		sprintf(text, "IpAddr = IP_INADDR_NONE");
	}

#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_ntohl");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_ntohs(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	pmuint16 IpAddr;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_inet_IpAddress, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&IpAddr,pParamPointer,iParamLength);
	
	if (IpAddr != IP_INADDR_NONE) 
	{
		sprintf(text, "%d", IpAddr);
		SetDlgItemText( hEnipConvert,IDC_E_CONIP, text);
		sprintf(text, "addr: %d",IpAddr);
	}
	else
	{
		sprintf(text, "IpAddr = IP_INADDR_NONE");
	}

#if MSGBOX_ON
	strcpy(lpCaption, "TEST_RET_sock_ntohs");
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();
}


void on_TEST_RET_sock_getsockopt(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    UINT getsockopt_result;
	char optval[256];
	int optlen;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&getsockopt_result,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_optlen, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&optlen,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_optval, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(optval,pParamPointer,iParamLength);
	
	optval[optlen+1]=0; //=> string

	if (getsockopt_result==0)
	{
		SetDlgItemText( hEnipSockOpt,IDC_ED_SOPTV, optval);
		sprintf(text, "%d", optlen);
		SetDlgItemText( hEnipSockOpt,IDC_ED_SOPTL, text);
	}


	sprintf(text, "getsockopt_result: %d, optval=%s, optlen=%d",getsockopt_result,optval, optlen);
	strcpy(lpCaption, "TEST_RET_sock_getsockopt");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();

}


void on_TEST_RET_sock_select(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    int result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "selcet result: %d", result);
	strcpy(lpCaption, "TEST_RET_sock_select");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();

}


void on_TEST_RET_sock_startup(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    int result;
	long lConfigData;             
	long lVersionInfo;	         
	long lMaxSocket;	             
	long lENIPProperties;         

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_lConfigData, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&lConfigData,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_lVersionInfo, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&lVersionInfo,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_lMaxSocket, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&lMaxSocket,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_lENIPProperties, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&lENIPProperties,pParamPointer,iParamLength);

	sprintf(text, "startup result: %d, lConfigData: %d  \n lVersionInfo: %d, lMaxSocket: %d, lENIPProperties: %d", result, lConfigData, lVersionInfo, lMaxSocket, lENIPProperties  );

	strcpy(lpCaption, "TEST_RET_sock_startup");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();

}


void on_TEST_RET_sock_cleanup(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    int result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "cleanup result: %d", result);
	strcpy(lpCaption, "TEST_RET_sock_cleanup");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif

	SetLogText(text);
	ErrnoText();

}

void on_TEST_RET_sock_getlasterror(SLIP_Puffer *pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
    int result;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_result, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&result,pParamPointer,iParamLength);

	sprintf(text, "get last error result = %d", result);
	strcpy(lpCaption, "TEST_RET_sock_getlasterror");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
}

void on_TEST_RET_sock_setlasterror(SLIP_Puffer *pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "set last error returned.");
	strcpy(lpCaption, "TEST_RET_sock_setlasterror");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	SetLogText(text);
	ErrnoText();
}









//------------------------------------------------------------------------------
//messages

void on_TEST_ENIP_SOCK_ICMP_ERROR(SLIP_Puffer * pRXBuffer) // tells user that an ICMP error has occured 
{
	char text[500];
	char lpCaption[30];
	int isock;
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&isock,pParamPointer,iParamLength);

	sprintf(text, "ENIP SOCK ICMP ERROR on socket %d", isock );
	strcpy(lpCaption, "TEST_ENIP_SOCK_ICMP_ERROR");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}

void on_TEST_ENIP_SOCK_SEND_WND_OPENED(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "a send window of a socket is opened again (one or more slots are free now)." );
	strcpy(lpCaption, "on_TEST_ENIP_SOCK_SEND_WND_OPENED");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}

void on_TEST_ENIP_BUFFER_FREE(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];

	sprintf(text, "buffer free" );
	strcpy(lpCaption, "on_Test_ENIP_BUFFER_FREE");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}

void on_TEST_ENIP_SOCK_SEND_TIMEOUT(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];
	int isock;
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&isock,pParamPointer,iParamLength);


	sprintf(text, "the optional socket SND Timer on socket %d is expired", isock );
	strcpy(lpCaption, "on_TEST_ENIP_SOCK_SEND_TIMEOUT");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}

void on_TEST_ENIP_SOCK_DATA_SENT(SLIP_Puffer * pRXBuffer)
{
	char text[500];
	char lpCaption[30];
		int isock;
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_BSD_SOCKET, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&isock,pParamPointer,iParamLength);

	sprintf(text, "all ICMP or UDP data on socket %d have been sent", isock );
	strcpy(lpCaption, "on_TEST_ENIP_SOCK_DATA_SENT");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
		logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

	ErrnoText();
}





void on_TEST_RET_read_profile(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];
	struct in_addr in;

	// message parameter
	unsigned long dummyDNS=0;
    UINT bearer;
	UINT profile;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Profile, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&profile,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_USR, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(pBuffer,pParamPointer,iParamLength);
	pBuffer[iParamLength]=0;
	SetDlgItemText( hEnipProfile,IDC_ED_USER, pBuffer);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_PASSWORD, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(pBuffer,pParamPointer,iParamLength);
	pBuffer[iParamLength]=0;
	SetDlgItemText( hEnipProfile,IDC_ED_PASSWD, pBuffer);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_DNS1, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&dummyDNS,pParamPointer,iParamLength);
	in.S_un.S_addr=dummyDNS;
	strcpy(pBuffer,inet_ntoa(in));

	SetDlgItemText( hEnipProfile,IDC_ED_DNS1, pBuffer);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_DNS2, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&dummyDNS,pParamPointer,iParamLength);
	in.S_un.S_addr=dummyDNS;
	strcpy(pBuffer,inet_ntoa(in));
	SetDlgItemText( hEnipProfile,IDC_ED_DNS2, pBuffer);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Bearer, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&bearer,pParamPointer,iParamLength);

	if (bearer==eCON_HNDL_BEARER_GPRS)
	{
		CheckRadioButton( hEnipProfile, IDC_R_GPRS, IDC_R_CSD, IDC_R_GPRS);	
		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_APN, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(pBuffer,pParamPointer,iParamLength);
		pBuffer[iParamLength]=0;
		SetDlgItemText( hEnipProfile,IDC_ED_Apn, pBuffer);
		sprintf(text, "bearer: %d\nprofile: %d written",bearer, profile);
	}
	else
	{
		CheckRadioButton( hEnipProfile, IDC_R_GPRS, IDC_R_CSD, IDC_R_CSD);
		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_PHONE_NUMBER, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(pBuffer,pParamPointer,iParamLength);
		pBuffer[iParamLength]=0;
		SetDlgItemText( hEnipProfile,IDC_ED_PHONE, pBuffer);

		if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_ACCESS_TYPE, &iParamLength,pRXBuffer)) == NULL)
			return;
		memcpy(pBuffer,pParamPointer,iParamLength);
				
		if (pBuffer[0]== 'i')
			CheckRadioButton( hEnipProfile, IDC_R_ISDN, IDC_R_ANALOG, IDC_R_ISDN);
		else
			CheckRadioButton( hEnipProfile, IDC_R_ISDN, IDC_R_ANALOG, IDC_R_ANALOG);
		sprintf(text, "bearer: %d\nprofile: %d written",bearer, profile);
	}
	sprintf(text, "bearer: %d\nprofile: %d read",bearer, profile);
	strcpy(lpCaption, "TEST_RET_read_profile");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);
}

void on_TEST_RET_write_profile(SLIP_Puffer * pRXBuffer)
{
	unsigned short iParamLength;	//	length of parameter data
	unsigned char* pParamPointer;	//	pointer to parameter data
	char text[500];
	char lpCaption[30];

	// message parameter
	unsigned long dummyDNS=0;
    UINT bearer;
	UINT profile;

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Bearer, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&bearer,pParamPointer,iParamLength);

	if((pParamPointer = (unsigned char *)getParamPointer ((unsigned char) TEST_Profile, &iParamLength,pRXBuffer)) == NULL)
		return;
	memcpy(&profile,pParamPointer,iParamLength);

	sprintf(text, "bearer: %d\nprofile: %d written",bearer, profile);
	strcpy(lpCaption, "TEST_RET_write_profile");
#if MSGBOX_ON
	MessageBox( hEnipDialog, text, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);
}

//--------------------------------------------------------------------------------------------

// resolve value of errno variable an print it
void ErrnoText(void) 
{
	char errtext[100];

	if (bsd_errno==0)
		strcpy(errtext,"0");
	else
		sprintf(errtext,"%d: %s",bsd_errno, errnotxt[bsd_errno-_BSD_BASEERR] );
	
	SetDlgItemText( hEnipDialog,IDC_S_ERRNO, errtext);
	bsd_errno=0;
}


// resolve ReleaseCause(=cause for lman reject indication) values and print them
void PrintReleaseCause( int iReleaseCause) 
{
	char text[1000];
	char msgtext[500];
	char lpCaption[30];

	strcpy(msgtext,"");
	

	switch(iReleaseCause) 
	{
		case 12827:
			strcpy(text, "321B: APN is missing or unknown.");
		break;
		case 12829:
			strcpy(text, "321D: Authentication failed.");
		break;


		case 12826:
			strcpy(text, "321A: Insufficient_resources.");
		break;
		case 12828:
			strcpy(text, "321C: PDP address or PDP type are unknown.");
		break;
		case 12830:
			strcpy(text, "321E: Activation rejected by GGSN");
		break;
		case 12831:
			strcpy(text, "321F: Activation rejected reason unspecified.");
		break;
		case 12832:
			strcpy(text, "3220: Service option not supported.");
		break;
		case 12833:
			strcpy(text, "3221: Insufficient subscription: service option not subscribed");
		break;
		case 12834:
			strcpy(text, "3222: Service option temporarily out of order.");
		break;
		case 12835:
			strcpy(text, "3223: NSAPI already used.");
		break;
		case 12837:
			strcpy(text, "3225: QoS not accepted.");
		break;
		case 12881:
			strcpy(text, "3251: Invalid transaction identifier value.");
		break;
		case 12895:
			strcpy(text, "325F: Semantically incorrect message.");
		break;
		case 12896:
			strcpy(text, "3260: Invalid mandatory information.");
		break;
		case 12897:
			strcpy(text, "3261: Message type non existent or not implemented.");
		break;
		case 12898:
			strcpy(text, "3262: Message type not compatible with the protocol state.");
		break;
		case 12899:
			strcpy(text, "3263: Information element non existent or not implemented.");
		break;
		case 12900:
			strcpy(text, "3264: Conditional IE error.");
		break;
		case 12901:
			strcpy(text, "3265: Message not compatible with the protocol state.");
		break;
		case 12911:
			strcpy(text, "326F: Protocol error unspecified");
		break;
		case 13059:
			strcpy(text, "3303: SM_Cause_Timer_T3380_expiry");
		break;
		case 13060:
			strcpy(text, "3304: SM_Cause_DeactAct:");
		break;
		case 13061:
			strcpy(text, "3305: SM_Cause_DeactActReject:");
		break;
		case 13062:
			strcpy(text, "3306: SM_Cause_DeactActStaticPDPaddressCollision");
		break;


		case 12825:
			strcpy(text, "3219: Network failure: LLC or SNDCP failure.");
		break;
		case 12836:
			strcpy(text, "3224: Regular_deactivation");
		break;
		case 12838:
			strcpy(text, "3226: Network failure: unspecified.");
		break;
		case 12839:
			strcpy(text, "3227: Reactivation_required.");
		break;


		case 12563:
			strcpy(text, "3113: The MS is switched off.");
		break;
		case 12592:
			strcpy(text, "3130: MS initiated detach (e.g. due to an appropriate request from the application).");
		break;
		case 12594:
			strcpy(text, "3132: The net has detached the MS.");
		break;
		case 12291:
			strcpy(text, "3003: Illegal MS.");
		break;
		case 12294:
			strcpy(text, "3006: Illegal ME.");
		break;
		case 12295:
			strcpy(text, "3007: Insufficient subscription: GPRS is not subscribed.");
		break;
		case 12296:
			strcpy(text, "3008: Insufficient subscription: GSM and GPRS is not subscribed.");
		break;
		case 12545:
			strcpy(text, "3101: Authentication failed.");
		break;
		case 12564:
			strcpy(text, "3114: Internal reject after one of the 'denied' cases.");
		break;
		case 12565:
			strcpy(text, "3115: No SIM is inserted in the ME.");
		break;


		case 12297:
			sprintf(text, "%x: This cause may be sent to the MS in case of inter-SGSN routing area update.",iReleaseCause);
		break;
		case 12298:
			sprintf(text, "%x: The periodic update could not be performed, e.g. due to no coverage",iReleaseCause);
		break;
		case 12299:
			sprintf(text, "%x: No roaming agreement with the camped on PLMN",iReleaseCause);
		break;
		case 12300:
			sprintf(text, "%x: The current location area is not allowed.",iReleaseCause);
		break;
		case 12301:
			sprintf(text, "%x: The current location area is not allowed.",iReleaseCause);
		break;
		case 12302:
			sprintf(text, "%x: No GPRS roaming agreement with the camped on PLMN",iReleaseCause);
		break;
		case 12566:
			sprintf(text, "%x: Currently a detach procedure is running. A new attach is not possible before \nthe detach has been performed.",iReleaseCause);
		break;
		case 12593:
			sprintf(text, "%x: Network failure: the MS shall perform a new attach in order to recover.",iReleaseCause);
		break;
		case 12595:
			sprintf(text, "%x: Network failure: the MS shall perform a new attach in order to recover.",iReleaseCause);
		break;


		case 61697:
			sprintf(text, "%x: Action is temporary not allowed (e.g. Mobile is busy with previous GPRS action).",iReleaseCause);
		break;
		case 61698:
			sprintf(text, "%x: Application uses wrong PDP Type when answering mobile terminated activation.",iReleaseCause);
		break;
		case 61699:
			sprintf(text, "%x: GPRS Data service profile is not valid/complete.",iReleaseCause);
		break;
		case 61700:
			sprintf(text, "%x: PDP Type or Address received from network is not valid of doesn't fit the requested type.",iReleaseCause);
		break;


		case 61956:
			sprintf(text, "%x: GPRS Data service profile not valid or complete.",iReleaseCause);
		break;
		case 61957:
			sprintf(text, "%x: CSD Data service profile not valid or complete.",iReleaseCause);
		break;
		case 61973:
			sprintf(text, "%x: CSD Modem answered call request NO CARRIER (call estabishment failed).",iReleaseCause);
		break;
		case 61974:
			sprintf(text, "%x: CSD Modem answered call request with NO DIALTONE \n(no call possible at the moment e.g. no network available).",iReleaseCause);
		break;
		case 61975:
			sprintf(text, "%x: CSD Modem answered call request with BUSY (called subscriber is busy).",iReleaseCause);
		break;
		case 61976:
			sprintf(text, "%x: CSD Modem call establishment timed out (e.g. called subscriber modem doesn't answer).",iReleaseCause);
		break;
		case 61977:
			sprintf(text, "%x: CSD Modem established call lost (e.g. called subscriber hang up, network lost).",iReleaseCause);
		break;
		case 61969:
			sprintf(text, "%x: CSD Modem Instance in already in use (e.g. Data cable is connected when WAP CSD \nconnection shall be established).",iReleaseCause);
		break;
		case 61970:
			sprintf(text, "%x: CSD Modem is not responding.",iReleaseCause);
		break;
		case 61971:
			sprintf(text, "%x: CSD Modem returned ERROR.",iReleaseCause);
		break;
		case 61972:
			sprintf(text, "%x: CSD Modem doesn't answered not within specified time.",iReleaseCause);
		break;


		case 64001:
			sprintf(text, "%x: Mandatory parameter of the CSD profile is missing.\nMandatory Parameter: Dial up number",iReleaseCause);
		break;
		case 64002:
			sprintf(text, "%x: CH_CAUSE_GPRS_RESOURCES_STILL_IN_USE",iReleaseCause);
		break;
		case 64003:
			sprintf(text, "%x: CH_CAUSE_CSD_RESOURCES_STILL_IN_USE	",iReleaseCause);
		break;
		case 64004:
			sprintf(text, "%x: CH_CAUSE_GPRS_BROWSER_TIME_OUT",iReleaseCause);
		break;
		case 64005:
			sprintf(text, "%x: CH_CAUSE_CSD_BROWSER_TIME_OUT",iReleaseCause);
		break;


		case 13063:
			sprintf(text, "%x: Timer expired after waiting for GAPi reaction.",iReleaseCause);
		break;
		case 12544:
			sprintf(text, "%x: Failure unspecified.",iReleaseCause);
		break;
		case 61951:
			sprintf(text, "%x: Failure unspecified",iReleaseCause);
		break;
		case 61953:
			sprintf(text, "%x: Mobile temporary busy due to previous conflicting action",iReleaseCause);
		break;
		case 61955:
			sprintf(text, "%x: Data service profile not valid or complete",iReleaseCause);
		break;
		case 62207:
			sprintf(text, "%x: cause unspecified",iReleaseCause);
		break;
		case 62209:
			sprintf(text, "%x: PPP LCP Protocol terminated (e.g. protocol timeout)",iReleaseCause);
		break;
		case 62463:
			sprintf(text, "%x: Cause unspecified.",iReleaseCause);
		break;



		case 61954:
			strcpy(text, "F202: Invalid bearer setting");
		break;


		default:
			sprintf(text, "release cause: %x", iReleaseCause );		
		break;
	}

	if ((iReleaseCause >=12800) && (iReleaseCause <=13311))
		sprintf(msgtext, "source: GPRS SESSION MANAGER \n");
	
	if ((iReleaseCause >=12288) && (iReleaseCause <=12799))
		sprintf(msgtext, "source: GPRS MOBILITY MANAGER\n");

	if ((iReleaseCause >=61696) && (iReleaseCause <=61951))
		sprintf(msgtext, "source: GPRS APPLICATION PROGRAMMING INTERFACE\n");
	
	if ((iReleaseCause >=61952) && (iReleaseCause <=62207))
		sprintf(msgtext, "source: LINKMANAGER\n");
	
	if ((iReleaseCause >=62208) && (iReleaseCause <=62463))
		sprintf(msgtext, "source: EMBEDDED NETCORE IP\n");
	if ((iReleaseCause >=64000) && (iReleaseCause <=64255))
		sprintf(msgtext, "source: CONNECTION HANDLER\n");


	strcpy(lpCaption, "lman connect reject indication");
	strcat(msgtext, text);
#if MSGBOX_ON
	MessageBox( hEnipDialog, msgtext, lpCaption, MB_OK);
#endif
	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(text));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
			logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);

}

void SetLogText(char * text)   //print text to logbox
{
	char logtext[1500];
	char ltext[1500];

	GetDlgItemText( hEnipDialog,IDC_LOGBOX, logtext, sizeof(logtext));
	if (strlen(logtext) > (sizeof(logtext)-1000)) //avoid getting logtext larger then the buffer
		logtext[1500]=0;		//throw the last bytes away 
	sprintf(ltext,"%s %c%c %s", text, 0x0D, 0x0A, logtext);
	SetDlgItemText( hEnipDialog,IDC_LOGBOX, ltext);
}



#endif //TESTPROC_TEST_IF
#endif //PPP_MON_TEST
