#ifndef SIMUMTTH_H
#define SIMUMTTH_H
/** @file */
/* -----------------------------------------------------------------------------
Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Jens Scharnow (KLF-5918)

.FILENAME simumtth.h


.CSVERSION 1.1


.VERSION 01.01.00

.DATE 2003-07-15

.SHORT_DESCR public header which describes functions to control the mtt communication from the simulation

.SW_COMPONENT 

.SW_TYPE public header

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2003-02-25 Jens Scharnow (KLF-5918) (KLF_EXT)
         Initial Version
01.01.00 2003-07-15 Jens Scharnow (KLF-5918) (KLF_EXT)
         Added new defines for registry configuration
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include <global.h>
#include <ddlcdsiz.h>
#include "mtt_gbsh.h"

/* -----------------------------------------------------------------------------
    DEFINES
------------------------------------------------------------------------------*/
#define MTT_MAX_PACKET_SIZE    DISP_BUFF_SIZE

#define MTT_TCP_DEFAULT_PORT   651

#define MTT_SIMU_PORT_ENV      "MTT_SIMU_PORT"

#define MTT_NUM_DELAY_TIMES    3
/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    CONSTANTS
------------------------------------------------------------------------------*/

const int MTT_SIMU_DEFAULT_DELAY_TIMES[MTT_NUM_DELAY_TIMES]=
{
    200, //   MTT_KEY_PRESS,
    200, //   MTT_KEY_RELEASE,
    50   //   MTT_FETCH_DISPLAY
};

extern const char* MTT_SIMU_DELAY_STRINGS[MTT_NUM_DELAY_TIMES]; // definition in simumtt.c
//    "MTT_SIMU_DELAY_PRESS",
//    "MTT_SIMU_DELAY_RELEASE",
//    "MTT_SIMU_DELAY_FETCH_DISPLAY"


/* -----------------------------------------------------------------------------
    PROTOTYPES
------------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif


/**
 *  callback function for incoming TCP packages coming from MTT
 * 
 *  \param iMessage windows message identifier
 *  \param wParam   parameter from window message
 *  \param lParam   parameter from window message
 *  \return 0 - if window message was not processed
 */
int mtt_tcp_notify (UINT iMessage, WPARAM wParam, LPARAM lParam);

/**
 *  function to activate the tcp/ip server which communicates with MTT
 * 
 *  \param nPortNo  the number of the port to be used
 *  \param  int nDelayTimes[MTT_NUM_DELAY_TIMES] the delay times to be used
 */

void mtt_tcp_activate(int nPortNo, int nDelayTimes[MTT_NUM_DELAY_TIMES]);

/* --------------------------------------------------------------------------- */
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* SIMUMTTH_H */

/* -----------------------------------------------------------------------------
    END OF FILE simumtth.h
----------------------------------------------------------------------------- */
