/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME outputwnd.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE 2003-09-11

.SHORT_DESCR:   Output window

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00  2003-09-11 Murat Korkmaz 
         Initial Version      
*/

#include "smsafxh.h"
#include "simuapph.h"
#include "outputwndh.h"



#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


BEGIN_MESSAGE_MAP(COutputWnd, CDockingWnd)
    //{{AFX_MSG_MAP(COutputWnd)
    ON_WM_CREATE()
    ON_WM_SIZE()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/**                                                                       
 *  Constructor of CDebugOutputWnd.  
 */  
COutputWnd::COutputWnd()
{

}

/**                                                                       
 *  Destructor of COutputWnd.  
 */
COutputWnd::~COutputWnd()
{

}


/**                                                                       
 *  The function creates an object of JavaOutputView.  
 */      
int COutputWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CDockingWnd::OnCreate(lpCreateStruct) == -1)
        return -1;


    if (!m_cJOutputView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
        CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST+2, NULL))
    {
        TRACE0("Failed to create view window\n");
        return -1;
    }
    
    m_cJOutputView.GetRichEditCtrl().SetReadOnly();
    return 0;
}

/**                                                                       
 *   Funtion to resize also child windows  
 */   
void COutputWnd::OnSize(UINT nType, int cx, int cy) 
{
    CDockingWnd::OnSize(nType, cx, cy);
    m_cJOutputView.SetWindowPos (NULL, -1, -1, cx, cy, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}


BOOL COutputWnd::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{  
    return CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void COutputWnd::JavaOutput(UINT uiMessage, CString cStrOutPut)
{
    m_cJOutputView.JavaOutput(uiMessage,cStrOutPut);
}
