/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME mmicmdwnd.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE 2003-01-07

.SHORT_DESCR:   Docking MMI commmand window. Owner class of MMI Commands

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (Bardenheuer Software)
         Initial Version New UserInterface of PC-MMI-Test Environment
*/

#include "smsafxh.h"
#include "simuapph.h"

#include "mmicmdwndh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


BEGIN_MESSAGE_MAP(CMMICommandWnd, CDockingWnd)
    //{{AFX_MSG_MAP(CMMICommandWnd)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_LBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()



/**                                                                       
 *  Constructor of CMMICommandWnd.  
 */                                                                        
CMMICommandWnd::CMMICommandWnd()
{

}
/**                                                                       
 *  Destructor of CMMICommandWnd.  
 */ 
CMMICommandWnd::~CMMICommandWnd()
{

}

/**                                                                       
 *  The function creates an object of CMMICommandTree.  
 */                                                                        
int CMMICommandWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CDockingWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    CRect rectDummy;
    rectDummy.SetRectEmpty ();

    // Set style
    const DWORD dwViewStyle =   WS_CHILD | WS_VISIBLE | TVS_HASLINES | 
                                TVS_LINESATROOT | TVS_HASBUTTONS | TVS_SHOWSELALWAYS|TVS_INFOTIP;

    // Create an object of CMMICommandTree
    if (!m_wndMMICommandTree.Create (dwViewStyle, rectDummy, this, 44))
    {
        TRACE0("Failed to create MMI Command Tree!!\n");
        return -1;      // fail to create
    }
    return 0;
}

/**                                                                       
 *   Funtion to resize also child windows  
 */                                                                        
void CMMICommandWnd::OnSize(UINT nType, int cx, int cy) 
{
    CDockingWnd::OnSize(nType, cx, cy);

    m_wndMMICommandTree.SetWindowPos (NULL, -1, -1, cx, cy,
        SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}

/**                                                                       
 *  Function to set focus if the user has clicked with the 
 *  leftmousebutton.  
 */                                                                        
void CMMICommandWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
    m_wndMMICommandTree.SetActiveWindow();
    m_wndMMICommandTree.SetFocus();
    CDockingWnd::OnLButtonDown(nFlags,  point);
}
