/*! \file 

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME DispWnd.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE 2003-01-07

.SHORT_DESCR:   Parent of MMIDispWindow class

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (Bardenheuer Software)
         Initial Version New UserInterface of PC-MMI-Test Environment

*/

#include "smsafxh.h"
#include "simuapph.h"
#include "dockwndh.h"
#include "dispwndh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


BEGIN_MESSAGE_MAP(CDispWnd, CWnd)
    //{{AFX_MSG_MAP(CDispWnd)
        // NOTE - the ClassWizard will add and remove mapping macros here.
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/**                                                                       
 *  Constructor of CDispWnd  
 */                                                                        
CDispWnd::CDispWnd()
{
}

/**                                                                       
 *  Destructor of CDispWnd  
 */   
CDispWnd::~CDispWnd()
{
}

/**                                                                       
 *  Called by the framework before the creation of the Windows window attached to
 *  this CWnd object. To change  background color use CreateSolidBrush function 
 *  to create a new HBRUSH. 
 *    
 *  @param   cs: The CREATESTRUCT structure defines the initialization parameters passed to
 *               the window procedure of an application. 
 * 
 *  @return  BOOL: Nonzero if the window creation should continue;  
 *                 0 to indicate creation failure.
 */                                                                        
BOOL CDispWnd::PreCreateWindow(CREATESTRUCT& cs) 
{    
    if (!CWnd::PreCreateWindow(cs))
        return FALSE;

    // If you want to change  background color of mobile phonescreen,
    // than use this function.
    HBRUSH hbr = ::CreateSolidBrush(0xFFFFFF);

    cs.dwExStyle |= WS_EX_CONTROLPARENT;
    cs.style     &= ~WS_BORDER;
    cs.lpszClass  = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
                                        ::LoadCursor(NULL, IDC_ARROW), hbr, NULL);

    return CWnd::PreCreateWindow(cs);
}


void CDispWnd::Redraw()
{
    CRect rect;
    CDockingWnd* pcDock = (CDockingWnd*)GetOwner();

    if (pcDock != NULL)
    {
        pcDock->GetWindowRect(&rect);
        RedrawWindow( rect, NULL, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ERASE ); 
    }
}
