/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR Steffen Zwedler

.FILENAME aumamon.cpp




.CSVERSION 1.1

.VERSION 01.00.00

.SHORT_DESCR 

.SW_COMPONENT 

.SW_TYPE 

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00  Steffen Zwedler (ULM)
         Initial Version

01.01.00 2004-03-09 Pankaj Sharma (ULM)
         Modify some of the AuMa Purposes
	 
01.01.00 2004-03-09 Pankaj Sharma (ULM)
         Disabled some of the AuMa Purposes
	 
01.02.00 2004-03-09 Tillmann Richter (ULM)
         disabled echo and noise flag due to 
	 ADD Interface change (->2)
01.02.01 2004-06-03  Fang Yunchao(PEK)
		 Add UNICODE support
------------------------------------------------------------------------------*/


/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    EXIT DEFINES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    DEFINES
------------------------------------------------------------------------------*/


/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL CONSTANTS
------------------------------------------------------------------------------*/




// AuMaMon.cpp : Defines the class behaviors for the application.
//

#include "smsafxh.h"
#include "AuMaMon.h"

extern "C"
{
#include "auma_main.h"
#include "auma_app.h"
#include "auma_debug.h"
#include "conv_asc.h"
}

CAuMaMonDlg::CAuMaMonDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAuMaMonDlg::IDD, pParent)
    , m_process_state(_T("n/a"))
    , m_purpose(_T("n/a"))
    , m_audio_state(_T("n/a"))
    , m_repeat_count(_T("n/a"))
    , m_repeat_delay(_T("n/a"))
    , m_slider_mode(_T("n/a"))
    , m_volume(_T("n/a"))
    , m_vr_mode(_T("n/a"))
    , handle(NULL)
    , m_nTimer(0)
    , m_log_destination(_T("n/a"))
    , m_log_source(_T("n/a"))
    {
}

void CAuMaMonDlg::DoDataExchange(CDataExchange* pDX)
{
CDialog::DoDataExchange(pDX);
DDX_Control(pDX, IDC_ASP, m_asp);
DDX_Control(pDX, IDC_CONDITIONAL, m_conditional_events);
DDX_Control(pDX, IDC_CURRENT_ACTIVE, m_current_active_events);
DDX_Control(pDX, IDC_ECHO_CANCELLATION, m_echo_cancellation);
DDX_Control(pDX, IDC_FADING, m_fading);
DDX_Control(pDX, IDC_HANDSFREE, m_handsfree);
DDX_Control(pDX, IDC_LIGHT, m_light);
DDX_Control(pDX, IDC_MICRO_MUTE, m_microphone_mute);
DDX_Control(pDX, IDC_NOISE_REDUCTION, m_noise_reduction);
DDX_Control(pDX, IDC_PAUSED, m_paused_events);
DDX_Text(pDX, IDC_PROCESS_STATE, m_process_state);
DDX_Text(pDX, IDC_PURPOSE, m_purpose);
DDX_Text(pDX, IDC_AUDIO_STATE, m_audio_state);
DDX_Text(pDX, IDC_REPEAT_COUNT, m_repeat_count);
DDX_Text(pDX, IDC_REPEAT_DELAY, m_repeat_delay);
DDX_Text(pDX, IDC_SLIDER_MODE, m_slider_mode);
DDX_Control(pDX, IDC_VIBRA, m_vibra);
DDX_Text(pDX, IDC_VOLUME, m_volume);
DDX_Text(pDX, IDC_VR_MODE, m_vr_mode);
DDX_Text(pDX, IDC_LOG_DESTINATION, m_log_destination);
DDX_Text(pDX, IDC_LOG_SOURCE, m_log_source);
}

BEGIN_MESSAGE_MAP(CAuMaMonDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_LBN_SELCHANGE(IDC_CURRENT_ACTIVE, OnLbnSelchangeCurrentActive)
    ON_LBN_SELCHANGE(IDC_PAUSED, OnLbnSelchangePaused)
    ON_LBN_SELCHANGE(IDC_CONDITIONAL, OnLbnSelchangeConditional)
    ON_WM_TIMER()
    ON_WM_CLOSE()
    ON_WM_DESTROY()
    ON_BN_CLICKED(IDOK,OnBnClickedOK)
END_MESSAGE_MAP()


// CAuMaMonDlg message handlers

BOOL CAuMaMonDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_nTimer=SetTimer(1,500,0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAuMaMonDlg::OnDestroy()
{
    KillTimer(m_nTimer);
}

void CAuMaMonDlg::OnClose()
{
    DestroyWindow();
}

void CAuMaMonDlg::OnBnClickedOK()
{
    DestroyWindow();
}

void CAuMaMonDlg::OnPaint() 
{
	if (IsIconic())
	{
	}
	else
	{   
	    if(this->handle!=NULLP)
	        this->UpdateDisplay();
		CDialog::OnPaint();
	}
}

void CAuMaMonDlg::UpdateDisplay()
{
        LPTSTR buffer;
        CString comboBoxString;
        int currentPos=CB_ERR;
        T_AuMa_AudioEventHandle* testHandle;
        T_AuMa_LL_Handle* conditionHandle;
        
        //Set Process State
        buffer=m_process_state.GetBuffer(50);        
        switch(AuMa_Debug_GetProcessState())
        {
            case E_AUMA_PROCESS_STATE_UNINITIALIZED:
             _tcscpy(buffer,_T("Unitialized"));
            break;
            
            case E_AUMA_PROCESS_STATE_IDLE:
          	_tcscpy(buffer,_T("Idle"));
            break;
            
            case E_AUMA_PROCESS_STATE_ACTIVE:
             _tcscpy(buffer,_T("Active"));
            break;
            
            case E_AUMA_PROCESS_STATE_WFCONNAPI:
           	_tcscpy(buffer,_T("Wait for ConnApi"));
            break;
            
            case E_AUMA_PROCESS_STATE_WFACCRECONFIGURE:
           	_tcscpy(buffer,_T("Wait for Acc. Reconf."));
			break;
            
            default:
           	_tcscpy(buffer,_T("ERROR"));
            break;
        }
        m_process_state.ReleaseBuffer();        
        
        if(AuMa_Debug_GetProcessState()==E_AUMA_PROCESS_STATE_UNINITIALIZED)
            return;
        
        //Update Current Active List
        m_current_active_events.ResetContent();
        AuMa_Debug_ResetElementPointer(AuMa_Debug_GetCurrentActiveEventsList());
        while((testHandle=AuMa_Debug_GetCurrHandle())!=NULLP)
        {
            comboBoxString.Format(_T("%#p"), testHandle);
            currentPos=m_current_active_events.AddString(comboBoxString);
            if(currentPos!=CB_ERR && currentPos!=CB_ERRSPACE)
            {
                m_current_active_events.SetItemDataPtr(currentPos,(void*)testHandle);
                if(testHandle==handle)
                {
                    m_current_active_events.SetCurSel(currentPos);
                }
            }
            (void)AuMa_Debug_GetNextHandle();
        }
        
        //Update Current Active List
        m_paused_events.ResetContent();
        AuMa_Debug_ResetElementPointer(AuMa_Debug_GetPausedEventsList());
        while((testHandle=AuMa_Debug_GetCurrHandle())!=NULLP)
        {
            comboBoxString.Format(_T("%#p"), testHandle);
            currentPos=m_paused_events.AddString(comboBoxString);
            if(currentPos!=CB_ERR && currentPos!=CB_ERRSPACE)
            {
                m_paused_events.SetItemDataPtr(currentPos,(void*)testHandle);
                if(testHandle==handle)
                {
                    m_paused_events.SetCurSel(currentPos);
                }
            }
            (void)AuMa_Debug_GetNextHandle();
        }

        //Update Conditional Start List
        m_conditional_events.ResetContent();
        AuMa_Debug_ResetElementPointer(AuMa_Debug_GetActionStartList());
        while((conditionHandle=AuMa_Debug_GetCurrElement())!=NULLP)
        {
            if(conditionHandle->hasCondition)
            {
                comboBoxString.Format(_T("%#p, will start/continue at the end of %#p"), AuMa_Debug_GetCurrHandle(),AuMa_Debug_GetCurrConditionHandle());
            }
            else
            {
                comboBoxString.Format(_T("%#p, will start immediately"), AuMa_Debug_GetCurrHandle());
            }
            
            currentPos=m_conditional_events.AddString(comboBoxString);
            if(currentPos!=CB_ERR && currentPos!=CB_ERRSPACE)
            {
                m_conditional_events.SetItemDataPtr(currentPos,(void*)AuMa_Debug_GetCurrHandle());
                if(testHandle==handle)
                {
                    m_conditional_events.SetCurSel(currentPos);
                }
            }
            (void)AuMa_Debug_GetNextHandle();
        }        
        
        if(!AuMa_Debug_IsHandleValid(handle))
            return;
        
        //Set ASP tick
        if(AuMa_Debug_GetAspFlagFromHandle(handle))
            m_asp.SetCheck(BST_CHECKED);
        else
            m_asp.SetCheck(BST_UNCHECKED);
            
        //Set Audio state
        buffer=m_audio_state.GetBuffer(50);        
        switch(AuMa_Debug_GetAudioEventStateFromHandle(handle))
        {
            case E_AUMA_STATE_IDLE:
            _tcscpy(buffer,_T("Idle"));
            break;

            case E_AUMA_STATE_STARTED:
            _tcscpy(buffer,_T("Started"));
            break;
            
            case E_AUMA_STATE_PAUSED:
            _tcscpy(buffer,_T("Paused"));
            break;
            
            case E_AUMA_STATE_STOPPED:
            _tcscpy(buffer,_T("Stopped"));
            break;
            
            case E_AUMA_STATE_WFOPENCHANNEL:
            _tcscpy(buffer,_T("Wait for OpenCh."));
            break;
            
            case E_AUMA_STATE_WFSTART:
            _tcscpy(buffer,_T("Wait for Start"));
            break;
            
            case E_AUMA_STATE_WFSTOP:
            _tcscpy(buffer,_T("Wait for Stop"));
            break;
            
            case E_AUMA_STATE_WFCLOSECHANNEL:
            _tcscpy(buffer,_T("Wait for CloseCh."));
            break;
            
            case E_AUMA_STATE_WFPAUSE:
            _tcscpy(buffer,_T("Wait for Pause"));
            break;
            
            case E_AUMA_STATE_WFRESUME:
            _tcscpy(buffer,_T("Wait for Resume"));

            break;
            
            case E_AUMA_STATE_WFCONTINUESTART:
            _tcscpy(buffer,_T("Wait for Cont.Start"));
            break;
            
            case E_AUMA_STATE_WFCONTINUEPAUSE:
            _tcscpy(buffer,_T("Wait for Cont.Pause"));
            break;
            
            default:
             _tcscpy(buffer,_T("ERROR"));
            break;
   
        } 
        m_audio_state.ReleaseBuffer();
        
        //Set Echo Cancellation Tick
        //if(AuMa_Debug_GetECFlagFromHandle(handle))
        //    m_echo_cancellation.SetCheck(BST_CHECKED);
        //else
        m_echo_cancellation.SetCheck(BST_UNCHECKED);
            
        //Set Fading Tick
        if(AuMa_Debug_GetFadingFlagFromHandle(handle))
            m_fading.SetCheck(BST_CHECKED);
        else
            m_fading.SetCheck(BST_UNCHECKED);
            
        //Set Handsfree Tick
        if(AuMa_Debug_GetHandsfreeFlagFromHandle(handle))
            m_handsfree.SetCheck(BST_CHECKED);
        else
            m_handsfree.SetCheck(BST_UNCHECKED);
        
        //Set Light Tick
        if(AuMa_Debug_GetLightHandle()!=NULLP)
            m_light.SetCheck(BST_CHECKED);
        else
            m_light.SetCheck(BST_UNCHECKED);
            
        //Set Logical Destination
        buffer=m_log_destination.GetBuffer(50);
        switch(AuMa_Debug_GetLogDestFromHandle(handle))
        {
            case E_ADD_LOGICALDEST_VIBRA:
            _tcscpy(buffer,_T("Vibra"));
            break;
            
            case E_ADD_LOGICALDEST_RHYTHMCALLBACK:
            _tcscpy(buffer,_T("Light"));
            break;
            
            case E_ADD_LOGICALDEST_HANDSET_PLAY:
             _tcscpy(buffer,_T("Mobile Phone: Play"));
            break;
            
            case E_ADD_LOGICALDEST_HANDSET_RECORD:
            _tcscpy(buffer,_T("Mobile Phone: Record"));
            break;
            
            case E_ADD_LOGICALDEST_BLUETOOTH_PLAY:
            _tcscpy(buffer,_T("Bluetooth: Play"));
            break;
            
            case E_ADD_LOGICALDEST_BLUETOOTH_RECORD:
             _tcscpy(buffer,_T("Bluetooth: Record"));
            break;
            
            case E_ADD_LOGICALDEST_WIRED_PLAY:
            
	    _tcscpy(buffer,_T("Wired Acc.: Play"));
            break;
            
            case E_ADD_LOGICALDEST_WIRED_RECORD:
            _tcscpy(buffer,_T("Wired Acc.: Record"));
            break;
            
            default:
            _tcscpy(buffer,_T("ERROR"));
	    break;

        }
        m_log_destination.ReleaseBuffer();
        
        //Set Logical Source
        buffer=m_log_source.GetBuffer(50);
        switch(AuMa_Debug_GetLogSrcFromHandle(handle))
        {
           case E_ADD_LOGICALSRC_DATA_HANDLE:
            _tcscpy(buffer,_T("Data Handle"));
            break;
            
            case E_ADD_LOGICALSRC_DSP_POWER_VU:
            _tcscpy(buffer,_T("DSP VU"));
            break;
            
            case E_ADD_LOGICALSRC_FMRADIO:
            _tcscpy(buffer,_T("FM Radio"));
            break;
    
            case E_ADD_LOGICALSRC_VOICECALL:
            _tcscpy(buffer,_T("Voice Call"));
            break;
            
            default:
            _tcscpy(buffer,_T("ERROR"));
            break;

        }
        m_log_source.ReleaseBuffer();

        //Set Microphone Mute Tick
        if(AuMa_Debug_GetMicMuteFlagFromHandle(handle))
            m_microphone_mute.SetCheck(BST_CHECKED);
        else
            m_microphone_mute.SetCheck(BST_UNCHECKED);

        //Set Noise Reduction Tick
        //if(AuMa_Debug_GetNRFlagFromHandle(handle))
        //    m_noise_reduction.SetCheck(BST_CHECKED);
        //else
        m_noise_reduction.SetCheck(BST_UNCHECKED);

       
        //Set Purpose
        buffer=m_purpose.GetBuffer(50);
        switch(AuMa_Debug_GetPurposeFromHandle(handle))
        {
            case E_AUMA_PURPOSE_MTC:
            _tcscpy(buffer,_T("MTC Ringtone"));
            break;
            
            case E_AUMA_PURPOSE_SMS:
            _tcscpy(buffer,_T("SMS"));
            break;
            
            case E_AUMA_PURPOSE_MMS:
	    _tcscpy(buffer,_T("MMS"));
            break;
            
            case E_AUMA_PURPOSE_CBS:
            _tcscpy(buffer,_T("CBS"));
            break;
            
            case E_AUMA_PURPOSE_VOICEMEMO_RECORD:
             _tcscpy(buffer,_T("Voicememo Record"));
    	    break;
            
            case E_AUMA_PURPOSE_APPLICATION_RECORD:
            _tcscpy(buffer,_T("Application Record"));
            break;
            
            case E_AUMA_PURPOSE_ALARMCLOCK:
             _tcscpy(buffer,_T("Alarm Clock"));
            break;
            
            case E_AUMA_PURPOSE_ORGANIZER_ALARM:
            _tcscpy(buffer,_T("Organizer Alarm"));
	    break;
            
            case E_AUMA_PURPOSE_LOW_POWER:
            _tcscpy(buffer,_T("Low-Power Signal"));
            break;
            
            case E_AUMA_PURPOSE_SERVICE_TONES:
            _tcscpy(buffer,_T("Service Tone"));
            break;
            
            case E_AUMA_PURPOSE_VR:
            _tcscpy(buffer,_T("Voice Recognition"));
            break;
            
            case E_AUMA_PURPOSE_APPLICATION_PLAYBACK:
            _tcscpy(buffer,_T("Application Playback"));// Fang Yunchao 2004/5/25 modification for SMTK Localization project,add _T( ),change strcpy to _tcscpy
            break;
            
            case E_AUMA_PURPOSE_VOICECALL:
            _tcscpy(buffer,_T("Voice Call"));
            break;
            
            case E_AUMA_PURPOSE_FMRADIO:
            _tcscpy(buffer,_T("FM Radio"));
            break;
            
            case E_AUMA_PURPOSE_SLIDER:
             _tcscpy(buffer,_T("Slider"));
            break;
//////////////////////////////////////////////////////
/*
            case E_AUMA_PURPOSE_PTT:
            strcpy(buffer,"PTT");
            break;

            case E_AUMA_PURPOSE_INFO_TONES:
            strcpy(buffer,"Info Tone");
            break;

            case E_AUMA_PURPOSE_KEY_TONES:
            strcpy(buffer,"Key Tone");
            break;

            case E_AUMA_PURPOSE_CALLWAITING_TONES:
            strcpy(buffer,"CallWaiting Tone");
            break;
*/
/////////////////////////////////////////////////////////

            default:
            _tcscpy(buffer,_T("ERROR"));
            break;
        }
        m_purpose.ReleaseBuffer();
        
        //Set Repeat Count
        buffer=m_repeat_count.GetBuffer(50);
         _itot(AuMa_Debug_GetRptCntFromHandle(handle),buffer,10);
        if(AuMa_Debug_GetRptCntFromHandle(handle)==1)
        _tcscat(buffer,_T(" time"));
        else             
     	_tcscat(buffer,_T(" times"));
	

        //Set Repeat Delay
        buffer=m_repeat_delay.GetBuffer(50);
        _itot(AuMa_Debug_GetRptDlyFromHandle(handle),buffer,10);
        if(AuMa_Debug_GetRptDlyFromHandle(handle)==1)
      	_tcscat(buffer,_T(" millisecond"));
        else
        _tcscat(buffer,_T(" milliseconds"));

        
        //Set Slider Mode
        buffer=m_slider_mode.GetBuffer(50);
        switch(AuMa_Debug_GetSlModeFromHandle(handle))
        {
           case E_ADD_SLIDER_MODE_NO_SLIDER:
            _tcscpy(buffer,_T("ProSlider(TM) not used/found"));
            break;
            
            case E_ADD_SLIDER_MODE_OPEN:
            _tcscpy(buffer,_T("ProSlider(TM) Open"));
   	    break;
            
            case E_ADD_SLIDER_MODE_CLOSED:
            _tcscpy(buffer,_T("ProSlider(TM) Closed"));
            break;
            
            default:
            _tcscpy(buffer,_T("ERROR"));
            break;
			
        }
        m_slider_mode.ReleaseBuffer();
        
        //Set Vibra Tick
        if(AuMa_Debug_GetVibraHandle()!=NULLP)
            m_light.SetCheck(BST_CHECKED);
        else
            m_light.SetCheck(BST_UNCHECKED);
            
        //Set Volume
        buffer=m_volume.GetBuffer(50);
        switch(AuMa_Debug_GetVolumeFromHandle(handle))
        {
            case E_ADD_SETUP_VOLUME_MUTE:
             _tcscpy(buffer,_T("Mute"));
            break;
            
            case E_ADD_SETUP_VOLUME_1:
            _tcscpy(buffer,_T("Volume 1"));
	    break;
            
            case E_ADD_SETUP_VOLUME_2:
            _tcscpy(buffer,_T("Volume 2"));
            break;
            
            case E_ADD_SETUP_VOLUME_3:
            _tcscpy(buffer,_T("Volume 3"));
            break;
    
            case E_ADD_SETUP_VOLUME_4:
            _tcscpy(buffer,_T("Volume 4"));
            break;
            
            case E_ADD_SETUP_CRESCENDO:
            _tcscpy(buffer,_T("Crescendo"));
            break;
            
            default:
            _tcscpy(buffer,_T("ERROR"));
            break;

        }
        m_volume.ReleaseBuffer();
        
        //Set VR Mode
        buffer=m_vr_mode.GetBuffer(50);        
        switch(AuMa_Debug_GetVRModeFromHandle(handle))
        {
          case E_ADD_VOICE_RECOGNITION_MODE_NO:
            _tcscpy(buffer,_T("No Voice-Recognition"));
            break;
            
            case E_ADD_VOICE_RECOGNITION_MODE_TRAIN:
            _tcscpy(buffer,_T("Training"));
            break;
            
            case E_ADD_VOICE_RECOGNITION_MODE_RECOGNIZE:
            _tcscpy(buffer,_T("Recognition"));
            break;
            
            default:
            _tcscpy(buffer,_T("ERROR"));
            break;
        }
        m_vr_mode.ReleaseBuffer();
 }

void CAuMaMonDlg::OnLbnSelchangeCurrentActive()
{
    //Retrieve the void* of the selected handle. This points to the handle.
    T_AuMa_AudioEventHandle* selectedHandle=(T_AuMa_AudioEventHandle*)m_current_active_events.GetItemDataPtr(m_current_active_events.GetCurSel());
    this->handle=selectedHandle;
    UpdateDisplay();
}

void CAuMaMonDlg::OnLbnSelchangePaused()
{
    T_AuMa_AudioEventHandle* selectedHandle=(T_AuMa_AudioEventHandle*)m_paused_events.GetItemDataPtr(m_paused_events.GetCurSel());
    this->handle=selectedHandle;        
    UpdateDisplay();
}

void CAuMaMonDlg::OnLbnSelchangeConditional()
{
    T_AuMa_AudioEventHandle* selectedHandle=(T_AuMa_AudioEventHandle*)m_conditional_events.GetItemDataPtr(m_conditional_events.GetCurSel());
    this->handle=selectedHandle;        
    UpdateDisplay();
}

void CAuMaMonDlg::OnTimer(UINT nIDEvent)
{
    if(nIDEvent==m_nTimer)
    {
        this->UpdateDisplay();
        this->UpdateData(FALSE);            
    }
}

