/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       pluginframework.h

.TODO           

.SHORT_DESCR    Framework for the plugins which were loaded. 

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br> 
01.00.01  2004-01-22 Murat Korkmaz       DockControlBarLeftOf for created toolbars
                                         added<br>
01.01.00  2004-02-09 Murat Korkmaz       preprocessor JAVA_SDK added
01.01.01  2004-02-25 Murat Korkmaz       LoadLibrary changed to AfxLoadLibrary
01.02.00  2004-04-05 Murat Korkmaz       Function HelperInitPlugIn modified
01.02.01  2004-04-06 L.Khera(SISL,India) GetPlugInToolBar() added
------------------------------------------------------------------------------*/
#ifndef JAVA_SDK
/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "pluginmanager.h"


IMPLEMENT_DYNCREATE(CPlugInFrameWork, CCmdTarget)

BEGIN_MESSAGE_MAP(CPlugInFrameWork, CCmdTarget)
    //{{AFX_MSG_MAP(CPlugInFrameWork)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/**
 *   Base Constructor of the CPlugInFrameWork.
 */
CPlugInFrameWork::CPlugInFrameWork()
{
}

/**
 *   Default Constructor of the CPlugInFrameWork.
 *   
 *   @param ptrAppInterface: base application interface pointer.
 */
CPlugInFrameWork::CPlugInFrameWork(CPlugInManager* pcPlugInManager, CAppiBase* ptrAppInterface)
{
    ASSERT (ptrAppInterface != NULL);
    ASSERT (pcPlugInManager != NULL);

    m_pPlugInHinstance   = NULL;
    m_ptrPlugInInterface = NULL;
    m_pFuncPlugInInit    = NULL;
    m_bToolbarIsCreated  = FALSE;
    m_ptrAppInterface    = ptrAppInterface;
    m_pcPlugInManager    = pcPlugInManager;
}

/**
 *   Destructor of the Class CPlugInFrameWork.
 */
CPlugInFrameWork::~CPlugInFrameWork()
{
}

/**
 *   This function loads the plug-in dll and stores HMODULE of the
 *   plug in in to the member variable m_pPlugInHinstance.
 *
 *   @param cStrFileName: Filena and path where the plug-in resides.
 *
 *   @return DWORD: If return value is different to PLUGIN_ERROR_SUCCESS
 *                  then an error is occured. 
 */
DWORD CPlugInFrameWork::LoadPlugIn(CString cStrFileName)
{
    HMODULE hModule = AfxLoadLibrary(cStrFileName);

    if (hModule != NULL)
    {
        m_pPlugInHinstance = hModule;
        return PLUGIN_ERROR_SUCCESS;
    }
    else
    {
       return PLUGIN_ERROR_PLUGIN_COULD_NOT_LOAD;
    }
}

/**
 *   This function frees the plug-in and calls the plug-in function 
 *   Release() which frees all allocated memmories in the plug-in. 
 *
 *   @return DWORD: If return value is different to PLUGIN_ERROR_SUCCESS
 *                  then an error is occured. 
 */
DWORD CPlugInFrameWork::FreePlugIn()
{
    DWORD dwReturn = PLUGIN_ERROR_SUCCESS;

    if (m_ptrPlugInInterface != NULL)
    {
        m_ptrPlugInInterface->Release();
        m_ptrPlugInInterface = NULL;
        m_pFuncPlugInInit    = NULL;
    }

    if (m_pPlugInHinstance != NULL)
    {
        if (AfxFreeLibrary(m_pPlugInHinstance))
        {
            m_pPlugInHinstance   = NULL;   
        }
        else
        {
            dwReturn = PLUGIN_ERROR_FREE_PLUGIN;
        }
    }
   
    return dwReturn;
}

/**
 *   This function initalizes the plug-in. Initializing means: 
 *   - Get the plug-in exported function "InitPlugIn", 
 *   - change the interface m_ptrAppInterface and get the base plug-in interface, 
 *   - get the plug-in API version and compare,
 *   - call default routine HelperInitPlugIn() to create plug-in menus, toolbar.
 *
 *   @return DWORD: If return value is different to PLUGIN_ERROR_SUCCESS
 *                  then an error is occured. 
 */
DWORD CPlugInFrameWork::InitPlugIn()
{
    ASSERT (m_pPlugInHinstance != NULL);
    ASSERT (m_ptrAppInterface != NULL);

    DWORD dwReturn = PLUGIN_ERROR_SUCCESS;

    if (m_pPlugInHinstance != NULL)
    {
        m_pFuncPlugInInit = (PLUGININITFUNC)GetProcAddress(m_pPlugInHinstance, _T("InitPlugIn"));
        if (m_pFuncPlugInInit != NULL)
        {
            dwReturn = m_pFuncPlugInInit(m_ptrPlugInInterface, m_ptrAppInterface);
            if (PLUGIN_ERROR_SUCCESS == dwReturn)
            {
                if (m_ptrPlugInInterface != NULL)
                {
                    m_uiPlugInAPIVersion = m_ptrPlugInInterface->GetPlugInAPIVersion();
                    if (m_uiPlugInAPIVersion == PLUGIN_API_VERSION )
                    {
                        // Get the name and information of the plugin
                        m_ptrPlugInInterface->GetPlugInNameInfo(&m_cStrPlugInName, &m_cStrPlugInInfo);
                        if (!m_pcPlugInManager->IsPlugInLoaded(m_cStrPlugInName))
                        {
                            HelperInitPlugIn();
                            dwReturn = PLUGIN_ERROR_SUCCESS;
                        }
                        else
                        {
                            dwReturn = PLUGIN_ERROR_PLUGIN_ALREADY_LOADED;
                        }
                    }
                    else
                        dwReturn = PLUGIN_ERROR_WRONG_PLUGIN_API_VERSION;
                }
                else
                {
                    dwReturn = PLUGIN_ERROR_INIT_PLUGIN_FNC_NOT_FOUND;
                }
            }
        }
        else
        {
            dwReturn = PLUGIN_ERROR_INIT_FUNCTION_NOT_LOAD;
        }
    }
    else
    {
        dwReturn = PLUGIN_ERROR_HINSTANCE_IS_NULLP;
    }
    return dwReturn;
}

/**
 *   Helper function to create plug-in menus and toolbar. 
 *   The created menus will be under main menu "Tools".
 *   
 *   @return DWORD: If return value is different to PLUGIN_ERROR_SUCCESS
 *                  then an error is occured. 
 */
DWORD CPlugInFrameWork::HelperInitPlugIn()
{
    ASSERT (m_ptrPlugInInterface != NULL);

    DWORD  dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | 
                     CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC;

    CMainFrame* pcMainFrm = ((CMainFrame*)GET_APP()->m_pMainWnd);

    CMenu* pMenu = pcMainFrm->GetMenu();
    if (pMenu != NULL)
    {
        int iMenuItems = pMenu->GetMenuItemCount(); 
        CString rString;
        for (int i=0; i<iMenuItems; i++)
        {
            pMenu->GetMenuString(i, rString, MF_BYPOSITION);
            if(!rString.Compare("Tools"))
            {
                pMenu = pMenu->GetSubMenu(i);
    
                // Send message to plug-in to create plug-in menus
                m_ptrPlugInInterface->PlugInMessagePort(m_cStrPlugInName,
                                                        PM_CREATE_PLUGIN_MENU, 
                                                        (LPARAM)pMenu->m_hMenu, 
                                                        0);
                i = iMenuItems;
            }
        }
    }

    // allow to create only on toolbar each plug-in
    if (!m_bToolbarIsCreated)
    {
        m_bToolbarIsCreated = TRUE;
        // Send message to plug-in to create plug-in toolbar, if return val is PM_CREATE_PLUGIN_TOOLBAR
        // then create a plug-in toolbar.
        if (PM_CREATE_PLUGIN_TOOLBAR == m_ptrPlugInInterface->PlugInMessagePort(m_cStrPlugInName, 
                                                                                PM_CREATE_PLUGIN_TOOLBAR,
                                                                                (LPARAM)&m_T_ToolbarInfo, 
                                                                                NULL))
        {
            if (m_cToolbar.CreateEx(pcMainFrm, TBSTYLE_FLAT,dwStyle))
            {
                m_cToolbar.SetWindowText(m_cStrPlugInName);
                m_cToolbar.GetToolBarCtrl().AddBitmap(m_T_ToolbarInfo.iNumberBtn, (CBitmap*)m_T_ToolbarInfo.pToolbarBmp);
                m_cToolbar.GetToolBarCtrl().AddButtons(m_T_ToolbarInfo.iNumberBtn, (LPTBBUTTON)m_T_ToolbarInfo.pToolbarBtn);
                m_cToolbar.EnableDocking(CBRS_ALIGN_ANY);
                pcMainFrm->DockControlBar(&m_cToolbar);
                pcMainFrm->DockControlBarLeftOf( &m_cToolbar,&pcMainFrm->m_wndToolBarFlexshell);
            }
        }
    }
    return PLUGIN_ERROR_SUCCESS;
}

/**
 *   Function to send messages to loaded plug-in. 
 *   
 *   @param cStrPlugInName: The name of the plug-in, or * 
 *   @param uiMsg         : Specifies the message to be sent.
 *   @param lParam        : Specifies additional message-dependent information.
 *   @param pParam        : Specifies additional message-dependent information. 
 *
 *   @return UINT         : Okay if PM_MESSAGE_OK is returned.
 */
UINT CPlugInFrameWork::PlugInMessagePort(const CString cStrPlugInName , UINT uiMsg, LPARAM lParam, PVOID pParam)
{
    ASSERT (m_ptrPlugInInterface != NULL);

    return m_ptrPlugInInterface->PlugInMessagePort(cStrPlugInName, uiMsg, lParam, pParam);
}

/**
 *   Function to get the base plug-in interface. 
 *   
 *   @return IPlugInInterfaceBase: pointer to an IPlugInInterfaceBase object.
 */
IPlugInInterfaceBase*  CPlugInFrameWork::GetPlugInInterface()
{
    return m_ptrPlugInInterface;
}

/**
 *   Function to get the name of the plug-in. 
 *   
 *   @return CString: The name of the plug-in.
 */
CString CPlugInFrameWork::GetPlugInName() const
{
    return m_cStrPlugInName;
}

/**
 *   Function to get the information of the plug-in. 
 *   
 *   @return CString: The information of the plug-in.
 */
CString CPlugInFrameWork::GetPlugInInfo() const
{
    return m_cStrPlugInInfo;
}

/**
 *   Function to get the API version of the plug-in. 
 *   
 *   @return UINT: The API version of the plug-in.
 */
UINT CPlugInFrameWork::GetPlugInAPIVersion() const
{
    return m_uiPlugInAPIVersion;
}

/**
 *   Function to set the plug-in file name and residing path. 
 *   
 *   @param cStrFilePath: Path where the plug-in resides.
 *   @param cStrFileName: File name of the plug-in.
 */
void  CPlugInFrameWork::SetPlugInFilePathFileName(CString cStrFilePath, CString cStrFileName)
{
    m_cStrPlugInFilePath = cStrFilePath;
    m_cStrPlugInFileName = cStrFileName;
}

/**
 *   Function to get the plug-in file name and residing path. 
 *   
 *   @param *cStrFilePath: pointer to a CString variable to get the plug-in path.
 *   @param *cStrFileName: pointer to a CString variable to get the plug-in file name.
 */
void  CPlugInFrameWork::GetPlugInFilePathFileName(CString *cStrFilePath, CString *cStrFileName)
{
    *cStrFilePath = m_cStrPlugInFilePath;
    *cStrFileName = m_cStrPlugInFileName;
}

/**
 *   Function to get the plug-in Toolbar. 
 */
CToolBar& CPlugInFrameWork::GetPlugInToolBar()
{
    return m_cToolbar;
}

#endif //JAVA_SDK
/* -----------------------------------------------------------------------------
END OF FILE pluginframework.h
------------------------------------------------------------------------------*/

