/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       plugintyps.h

.TODO           

.SHORT_DESCR    Typ defines for the PlugIn interface. 

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br> 
01.00.01  2004-01-27 Walter Stroell      MOPI typedef removed 
------------------------------------------------------------------------------*/
#ifndef _PLUGIN_TYPS_H_
#define _PLUGIN_TYPS_H_
/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "pluginerror.h"
/* -----------------------------------------------------------------------------
DEFINES
------------------------------------------------------------------------------*/

/** @defgroup plug_in_Typs Plug-in Types
 *  Type definition for plug-in interfaces.
 *  @ingroup plug_in_interface_base
 *  @{
 */

//! Information for the creation of a plug-in toolbar.
struct struct_T_PlugIn_ToolBar_Info
{
    int            iNumberBtn;         ///< Number of buttons in Toolbar
    LPCTSTR        lpszBtn;            ///< Address of a buffer that contains one or more null-terminated strings.
    long*          pToolbarBtn;        ///< Pointer to a TBBUTTON array
    long*          pToolbarBmp;        ///< Pointer to a CBitmap object which contains the Toolbar Bitmap
};

//! Creates a type name for struct_T_PlugIn_ToolBar_Info 
typedef struct struct_T_PlugIn_ToolBar_Info T_PlugIn_TB_Info;


//! memory object information
struct struct_T_PMOPI_MemObjectInfo
{
    //! name of the memory object
    char       *name;
    //! type of the memory object
    char       *type; // derived from MOPI internal uInfo
    //! total size of all blocks in bytes (in case of heap equals uSize)
    UINT32      uTotalSize;
    //! size of the heap or one block in bytes
    UINT32      uSize;
    //! number of blocks with size 'uSize' (contains 1 in case of heap)
    UINT16      uBlockCount;
    //! first address of the memory area
    void       *pStart;
    //! the highest used address up to now
    void       *pHighestAddress;
    //! the most bytes allocated up to now
    UINT32      maxAlloc;
    //! the total bytes allocated at present
    UINT32      curAlloc;
    //! the maximum number of allocated blocks up to now
    UINT32      numAlloc;
    //! the number of allocated blocks at present
    UINT32      cnumAlloc;
};

#endif // _PLUGIN_TYPS_H_

/** @} */ // end of plug_in_Typs
/* -----------------------------------------------------------------------------
END OF FILE plugintyps.h
------------------------------------------------------------------------------*/
