
#ifndef _BROWSE_CHM_DIALOG_H_
#define _BROWSE_CHM_DIALOG_H_

#pragma once
#include "resource.h"
#include "afxwin.h"

// CBrowseCHMDialog dialog

class CBrowseCHMDialog : public CDialog
{
	DECLARE_DYNAMIC(CBrowseCHMDialog)

public:
	CBrowseCHMDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~CBrowseCHMDialog();

// Dialog Data
	enum { IDD = IDD_DIALOG_BROWSE_CHM };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
   	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
public:
    afx_msg void OnBnClickedButtonBrowseChmFiles();
    afx_msg void OnBnClickedButtonChmOpen();

private:

    //enumeration for types of help docs (can be extended)
    enum TypesOfHelpDocuments
    {
        eTypeCHM = 0,
        eTypeDOC = 1,
        eTotalTypes//KEEP IT LAST ALWAYS
    };

    //static member variables
    static CString PatternsToFind [eTotalTypes];
    static CString ApplicationsForHelpDocuments [eTotalTypes];

    //private functions
    LONG Read_PCSIMU_InstallPathFromRegistry ( CString &strInstallPath );
    LONG Read_ApplicationPathFromRegistry ( CString strApplicationToFind, CString &strApplicationPath );
    void SearchAllFoldersForHelpFiles ( CString strSearchPath );
    void FindHelpFilesAndPopulateListBox ( CString strSearchPath, TypesOfHelpDocuments nType );
    void DisplayErrorMessage(LPCTSTR strErrorPrompt, LPCTSTR strTrailingMsg = NULL);
    void CalculateOriginalHozizontalExtentOfListBox ();
    void CalculateNewHozizontalExtentOfListBox (CString strFilePath);
    void CreateTmpDirectory();
    BOOL IsTmpFolderValid(void);
    BOOL OpenUsingTmpFolder(CString strFileSelected);
    void CopyFileInTmpFolder(CString& strFilePath);

    //member variables
    CListBox m_objCHMListBox;
    CButton m_objButtonOpen;
    int m_nNewHorizontalExtentOfListBox;
    int m_nOriginalHorizontalExtentOfListBox;
    CString m_strProjectPath, m_strTmpFolder;

public:
    afx_msg void OnLbnDblclkListboxChmFilesList();
    afx_msg void OnLbnSelchangeListboxChmFilesList();
    afx_msg void OnBnClickedCancel();
};
#endif//_BROWSE_CHM_DIALOG_H_