/*! \file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR     Marian Kremnican (BTS)

.FILENAME setuinitz.cpp


.CSVERSION 1.1

.VERSION 01.00.04

.DATE 2004-11-08

.SHORT_DESCR:   interface of mmi command window

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change

01.00.00 2004-07-09 Marian Kremnican (BTS)
         Initial Version. New UserInterface for entering the NITZ frame data
01.00.01 2004-07-13 Marian Kremnican (BTS)
         Data exchange type modified to DDX_Text for m_CE_DST item in DoDataExchange procedure.
01.00.02 2004-07-18 Fang Yunchao(PEK)
         Modification for UNICODE Support
01.00.03 2004-09-06 Marian Kremnican (BTS)
         UCS2 support, encoding the input strings in UpdateNitzInfos procedure.
01.00.04 2004-11-08 Marian Kremnican (BTS)
         UCS2 support, swap bytes before "sending" to be conformed with MM information frame.
*/

#include <global.h>
#include "sms_res.h"
#include "smsafxh.h"
#include "setupnitz.h"
#include "mm_al.h"
#include "..\..\private_pc\setupnitz.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupNitz dialog


CSetupNitz::CSetupNitz(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupNitz::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupNitz)
    m_CE_LongName =  _T("");
    m_CE_ShortName =  _T("");
    m_CE_DateTime =  _T("");
    m_CE_TZ = 0;
    m_CE_DST = 0;
    m_CE_UDT_TZ = 0;
    m_IE_LN = FALSE;
    m_IE_SN = FALSE;        // information element short name
    m_IE_TZ = FALSE;        // information element time zone
    m_IE_UTZ = FALSE;       // information element UTD
    m_IE_DST = FALSE;       // information element DST
	//}}AFX_DATA_INIT
}


void CSetupNitz::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CsetupNitz)
    DDX_Text(pDX, IDC_LONG_NAME, m_CE_LongName);
    DDX_Text(pDX, IDC_SHORT_NAME, m_CE_ShortName);
    DDX_Text(pDX, IDC_TZ, m_CE_TZ);
    DDV_MinMaxInt( pDX, m_CE_TZ, -48, 48 );
    DDX_Text(pDX, IDC_DST, m_CE_DST);
    DDV_MinMaxInt( pDX, m_CE_DST, 0, 2 ); 
    DDX_Text(pDX, IDC_UTZ, m_CE_UDT_TZ);
    DDV_MinMaxInt( pDX, m_CE_UDT_TZ, -48, 48 );
    DDX_Text(pDX, IDC_DATETIME, m_CE_DateTime);
    DDX_Check(pDX, IDC_ADD_LN, m_IE_LN);
    DDX_Check(pDX, IDC_ADD_SN, m_IE_SN);
    DDX_Check(pDX, IDC_ADD_TZ, m_IE_TZ);
    DDX_Check(pDX, IDC_ADD_DST, m_IE_DST);
    DDX_Check(pDX, IDC_ADD_UTZ, m_IE_UTZ);
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupNitz, CDialog)
	//{{AFX_MSG_MAP(CSetupNitz)
    ON_BN_CLICKED(IDC_INVALNITZ, OnCmdInvalnitz)
    ON_BN_CLICKED(IDC_ADD_LN, OnCheckAddLn)
    ON_BN_CLICKED(IDC_ADD_SH, OnCheckAddSh)
    ON_BN_CLICKED(IDC_ADD_TZ, OnCheckAddTz)
    ON_BN_CLICKED(IDC_ADD_DST, OnCheckAddDst)
    ON_BN_CLICKED(IDC_ADD_UTZ, OnCheckAddUtz)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupNitz message handlers

void CSetupNitz::OnCancel()
{
    CDialog::OnCancel();
}

void CSetupNitz::OnCmdInvalnitz()
{
    UINT32 InvalMask = 0;

    // check which all the IE are selectet, invalidate them
    if( m_IE_LN )
        InvalMask |= kMMRflag_MMR_SERVICE_PLMN_LONG_NAME_IND;
    if( m_IE_SN )
        InvalMask |= kMMRflag_MMR_SERVICE_PLMN_SHORT_NAME_IND;
    if( m_IE_TZ )
        InvalMask |= kMMRflag_MMR_NETWORK_TIMEZONE_IND;
    if( m_IE_UTZ )
        InvalMask |= kMMRflag_MMR_UNIVERSAL_TIME_IND;
    if( m_IE_DST )
        InvalMask |= kMMRflag_MMR_DAYLIGHTSAVING_TIME_IND;

    if( InvalMask )
        MmAla_InvalidateNitzInfo ( InvalMask );

    EndDialog( IDOK );
}

void CSetupNitz::UpdateNitzInfos()
{
    BOOL change = FALSE;
    char *ansi_txt;
    AUTO_pWSTRING(WS,20);
    COleDateTime DaTi;
    UINT8 udt[7];           // store place for coded universal Date and Time GSM 3.40
    UINT16 nameLen, i, tmp;

/* This part is a modified copy of l3_nitz.c which resides in S_psl3core */
/* ---------------------------------------------------------- */
/*              Update all IE's                               */
/* ---------------------------------------------------------- */

    /* full network name */
    if( m_IE_LN )       //if( m_IE_LN.GetState() & 0x1 )
    {
        change = True;
        /*
        eMMAL_prv_NN_SMSCB_CodingScheme  = 0x00       // as in mm2_ies.h
        eMMAL_prv_NN_UCS2                = 0x01       // as in mm2_ies.h
        */
        ansi_txt = ( char *) m_CE_LongName.GetString();
        nameLen = m_CE_LongName.GetLength();
        if( WString_ANSI_To_Ucs2(pWS, ansi_txt, nameLen) == 0 )
        {
            /* the network sends a MSB of UCS2 first, swap the UCS2 shorts now */
            for( i = 1; i <= pWS->buffer[0]; i++)
            {
                tmp = pWS->buffer[i];
                pWS->buffer[i] = (( tmp & 0xff00 ) >> 8 ) | (( tmp & 0x00FF ) << 8 );
            }

            MmAla_UpdateNetworkName( eMMAL_prv_NN_UCS2,
                                  0,
                                0,
                                (unsigned char *) &(pWS->buffer[1]),
                                eMMAL_NetworkNameFull,
                                ( 2*( pWS->buffer[0] )),     // bytes to copy
                                MMAL_PLMN_getActual());
        }
    }

    /* short network name */
    if( m_IE_SN )
    {
        change = True;
        ansi_txt = ( char *) m_CE_ShortName.GetString();
        nameLen = m_CE_ShortName.GetLength();
        if( WString_ANSI_To_Ucs2(pWS, ansi_txt, nameLen) == 0 )
        {
            /* the network sends a MSB of UCS2 first, swap the UCS2 shorts now */
            for( i = 1; i <= pWS->buffer[0]; i++)
            {
                tmp = pWS->buffer[i];
                pWS->buffer[i] = (( tmp & 0xff00 ) >> 8 ) | (( tmp & 0x00FF ) << 8 );
            }

            MmAla_UpdateNetworkName( eMMAL_prv_NN_UCS2,
                                0,
                                0,
                                (unsigned char *) &(pWS->buffer[1]),
                                eMMAL_NetworkNameShort,
                                ( 2*( pWS->buffer[0] )),     // bytes to copy
                                MMAL_PLMN_getActual());
        }
    }

    /* time zone */
    if( m_IE_TZ )
    {
        change = True;
        MmAla_UpdateTimezone( EncodeTZ( m_CE_TZ ));
        if( m_IE_DST )
        {
            MmAla_UpdateDaylightSavingTime( (UINT8) m_CE_DST );
        }
        else
        {
            /* if no DST info is sent then a possibly old DST value is made invalid */
            MmAla_InvalidateNitzInfo( kMMRflag_MMR_DAYLIGHTSAVING_TIME_IND );
        }
    }

    /* time zone and time */
    if( m_IE_UTZ )
    {
        DaTi.ParseDateTime( (LPTSTR) m_CE_DateTime.GetString(), 0, LANG_USER_DEFAULT );
        if(DaTi.GetStatus() == 0 )
        {
            change = True;
            // encode the Date/Time according to GSM 3.40
            udt[0] = GetSemiOkt((UINT8) ( DaTi.GetYear()%100 ));
            udt[1] = GetSemiOkt((UINT8) ( DaTi.GetMonth() ));
            udt[2] = GetSemiOkt((UINT8) ( DaTi.GetDay() ));
            udt[3] = GetSemiOkt((UINT8) ( DaTi.GetHour() ));
            udt[4] = GetSemiOkt((UINT8) ( DaTi.GetMinute() ));
            udt[5] = GetSemiOkt((UINT8) ( DaTi.GetSecond() ));
            udt[6] = EncodeTZ( m_CE_UDT_TZ );

            MmAla_UpdateTimeAndTimezone( udt );
            if( m_IE_DST )
            {
                MmAla_UpdateDaylightSavingTime( (UINT8) m_CE_DST );
            }
            else
            {
                /* if no DST info is sent then a possibly old DST value is made invalid */
                MmAla_InvalidateNitzInfo( kMMRflag_MMR_DAYLIGHTSAVING_TIME_IND );
            }
        }
        else
        {
            AfxMessageBox(_T("Invalid Date-Time entry!"));//add _T() by Fang Yunchao
        }
    }

/* ---------------------------------------------------------- */
/*              NITZ info update is complete                  */
/* ---------------------------------------------------------- */
/* MMAL is indicated that the update is done; MMAL may inform registered entities
   (is needed only if at least one information message has been received correctly) */
    if ( change )
    {
        MmAla_NITZInfoUpdateComplete();
    }
}

void CSetupNitz::OnCheckAddLn()
{
    // enable/disable input for long name
	UpdateData( TRUE );
	GetDlgItem( IDC_LONG_NAME )->EnableWindow( m_IE_LN );
    UpdateWindow();
}

void CSetupNitz::OnCheckAddSh()
{
    // enable/disable input for short name
	UpdateData( TRUE );
	GetDlgItem( IDC_SHORT_NAME )->EnableWindow( m_IE_SN );
    UpdateWindow();
}

void CSetupNitz::OnCheckAddTz()
{
    // enable/disable input for stand alone TZ
	UpdateData( TRUE );
	GetDlgItem( IDC_TZ )->EnableWindow( m_IE_TZ );
    UpdateWindow();
}

void CSetupNitz::OnCheckAddDst()
{
    // enable/disable input for DST
	UpdateData( TRUE );
	GetDlgItem( IDC_DST )->EnableWindow( m_IE_DST );
    UpdateWindow();
}

void CSetupNitz::OnCheckAddUtz()
{
    // enable/disable input for UTZ
	UpdateData( TRUE );
	GetDlgItem( IDC_DATETIME )->EnableWindow( m_IE_UTZ );
	GetDlgItem( IDC_UTZ )->EnableWindow( m_IE_UTZ );
    UpdateWindow();
}

UINT8 CSetupNitz::GetSemiOkt( UINT8 val )
{
    return (( val%10 ) << 4 ) | (( val/10 ) & 0xF );
}

UINT8 CSetupNitz::EncodeTZ( int val )
{
    UINT8 tmp;
// limit is -48 / +48
    if( val < 0 )
        tmp = ( -val );
    else
        tmp = val;

    if( tmp > 48 )
        tmp = 48;

    tmp = GetSemiOkt( tmp );

    if( val < 0 )
        tmp |= 0x8;     // make it negative

    return tmp;
}
