/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Norbert Barisits

.FILENAME      MOPI_PlugInDlg.cpp

.VERSION       00.00.01

.DATE          2004-06-17

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Norbert Barisits
         initial version
00.00.01 2004-06-17  Walter Stroell (VIE)
         memory consumed added for process and task resources
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "mmsystem.h"
#include "mopi.h"
#include "mopi_pctrl.h"
#include "mopi_timer.h"
#include "mopi_sync.h"
#include "mopi_msg.h"
#include "mopi_mem.h"
#include "MOPI_PlugIn.h"
#include "MOPI_PlugInDlg.h"
#include "MOPI_MemDetailDlg.h"
#include "MOPI_GrpDetailDlg.h"
#include "MOPI_SetupDlg.h"
#include "Iappinterfacemopi.h"
#include ".\mopi_plugindlg.h"

const char * GroupStateString( T_IMOPI_GroupState_Enum state );
const char * ProcStateString( T_IMOPI_ProcessState_Enum state );
const char * TimerTypeString( T_IMOPI_TimerType type );
const char * TimerStateString( UINT16 state );
const char * MsgTypeString( T_IMOPI_MsgTypeEnum msgType );

// CMOPI_PlugInDlg dialog

IMPLEMENT_DYNAMIC(CMOPI_PlugInDlg, CDialog)
CMOPI_PlugInDlg::CMOPI_PlugInDlg(IApplicationInterfaceMOPI* ipMOPI, UINT uiType, CWnd* pParent /*=NULL*/)
	: CDialog(CMOPI_PlugInDlg::IDD, pParent)
{
    ASSERT (ipMOPI != NULL);
    m_ipMOPI = ipMOPI;
    m_uiType = uiType;
    m_created = false;
    m_eType = eDlgNotUsed;
    m_lastEType = eDlgNotUsed;
}


CMOPI_PlugInDlg::~CMOPI_PlugInDlg()
{
}


void CMOPI_PlugInDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CMOPI_PlugInDlg)
    DDX_Control(pDX, IDC_TREE, m_cTree);
    DDX_Control(pDX, IDC_LIST, m_cList);
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMOPI_PlugInDlg, CDialog)
    ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, OnTvnSelchangedTree)
    ON_WM_SIZE()
    ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnNMDblclkList)
    ON_WM_TIMER()
    ON_BN_CLICKED(IDC_BUTTONREFRESH, OnBnClickedButtonrefresh)
    ON_NOTIFY(NM_DBLCLK, IDC_TREE, OnNMDblclkTree)
END_MESSAGE_MAP()


BOOL CMOPI_PlugInDlg::OnInitDialog()
{
    HTREEITEM hItem;
    HTREEITEM hItem2;

    CDialog::OnInitDialog();

    // setup treeview
    hItem  = m_cTree.InsertItem( _T("Setup") );                    m_cTree.SetItemData( hItem,  eDlgSetup );
    hItem  = m_cTree.InsertItem( _T("Resource Usage") );           m_cTree.SetItemData( hItem,  eDlgResourceUsage );
    hItem  = m_cTree.InsertItem( _T("Memory") );                   m_cTree.SetItemData( hItem,  eDlgMemory );
    hItem2 = m_cTree.InsertItem( _T("Heap"), hItem );              m_cTree.SetItemData( hItem2, eDlgHeap );
    hItem2 = m_cTree.InsertItem( _T("Blockpool"), hItem );         m_cTree.SetItemData( hItem2, eDlgBlockpool );
    hItem  = m_cTree.InsertItem( _T("ProcessControl") );           m_cTree.SetItemData( hItem,  eDlgProcessControl );
    hItem2 = m_cTree.InsertItem( _T("SA-Processes"), hItem );      m_cTree.SetItemData( hItem2, eDlgSAProcesses );
    hItem2 = m_cTree.InsertItem( _T("ProcessGroups"), hItem );     m_cTree.SetItemData( hItem2, eDlgProcessGroups );
    hItem2 = m_cTree.InsertItem( _T("Systemtasks"), hItem );       m_cTree.SetItemData( hItem2, eDlgSystemtasks );
    hItem2 = m_cTree.InsertItem( _T("Interrupttasks"), hItem );    m_cTree.SetItemData( hItem2, eDlgInterrupttasks );
    hItem  = m_cTree.InsertItem( _T("Message Handling") );         m_cTree.SetItemData( hItem,  eDlgMessageHandling );
    hItem2 = m_cTree.InsertItem( _T("Message Log"), hItem );       m_cTree.SetItemData( hItem2, eDlgMsgLog );
    hItem  = m_cTree.InsertItem( _T("Queue Management") );         m_cTree.SetItemData( hItem,  eDlgQueueManagement );
    hItem2 = m_cTree.InsertItem( _T("Process Queues"), hItem );    m_cTree.SetItemData( hItem2, eDlgProcQueueDetail );
    hItem2 = m_cTree.InsertItem( _T("Pending Queues"), hItem );    m_cTree.SetItemData( hItem2, eDlgPendQueueDetail );
    hItem  = m_cTree.InsertItem( _T("Timer Management") );         m_cTree.SetItemData( hItem,  eDlgTimerManagement );
    hItem2 = m_cTree.InsertItem( _T("Timer"), hItem );             m_cTree.SetItemData( hItem2, eDlgTimers );
    hItem  = m_cTree.InsertItem( _T("Sync. Management") );         m_cTree.SetItemData( hItem,  eDlgSyncManagement );
    hItem2 = m_cTree.InsertItem( _T("Mutexes"), hItem );           m_cTree.SetItemData( hItem2, eDlgMutexes );

    m_created = true;
    CRect clRect;
    GetWindowRect( clRect );
    clRect.right = clRect.left + 830;
    clRect.bottom = clRect.top + 452;
    MoveWindow( clRect, true );

    if (m_ipMOPI != NULL)
    {
        SetWindowText( (LPCTSTR)m_ipMOPI->GetInfo( eVersionInfo ) );
    }

    SetTimer( 1, 1000, 0 );

    ListView_SetExtendedListViewStyleEx( GetDlgItem( IDC_LIST )->m_hWnd,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE );
    return TRUE;
}


void CMOPI_PlugInDlg::OnOK()
{
    DestroyWindow();
}


void CMOPI_PlugInDlg::OnCancel()
{
    DestroyWindow();
}


void CMOPI_PlugInDlg::OnNMDblclkTree(NMHDR *pNMHDR, LRESULT *pResult)
{
    *pResult = 0;
    HTREEITEM hItem = m_cTree.GetSelectedItem();
    CString name = m_cTree.GetItemText( hItem );

    if (name == "Setup")
    {
        MOPI_SetupDlg dlg( m_ipMOPI );
        dlg.DoModal();
    }
}


void CMOPI_PlugInDlg::OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult)
{
    LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
    DWORD_PTR selection;
    *pResult = 0;

    if (lpnmitem->iItem == -1)
    {
        return;
    }

    selection = m_cList.GetItemData( lpnmitem->iItem );

    switch( m_eType )
    {
    case eDlgHeap:
    case eDlgBlockpool:
	{
		MOPI_MemDetailDlg dlg( m_ipMOPI, selection );
		dlg.DoModal();
	}
	break;
    case eDlgProcessGroups:
	{
        MOPI_GrpDetailDlg dlg( selection );
        dlg.DoModal();
	}    
	break;
    }
}


void CMOPI_PlugInDlg::OnTvnSelchangedTree(NMHDR *pNMHDR, LRESULT *pResult)
{
    LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
    *pResult = 0;

    HTREEITEM hCurrent = m_cTree.GetSelectedItem();
	if( hCurrent )
    {
		m_eType = (eMopiResourceType)m_cTree.GetItemData( hCurrent );
        UserSelChange();
    }
}


void CMOPI_PlugInDlg::OnTimer(UINT nIDEvent)
{
    if (((CButton*)(GetDlgItem(IDC_CHECK_AUTOREFRESH)))->GetCheck())
    {
        OnBnClickedButtonrefresh();
    }
}


void CMOPI_PlugInDlg::OnBnClickedButtonrefresh()
{
    UserSelChange();
}


void CMOPI_PlugInDlg::OnSize(UINT nType, int cx, int cy)
{
    CDialog::OnSize(nType, cx, cy);

    if (m_created == false)
        return;

    CRect clRect;
    CRect treeRect;
    CRect listRect;
    CRect bRect;
    int   value;

    GetClientRect( clRect );

    GetDlgItem(IDC_TREE)->GetWindowRect( treeRect );
    ScreenToClient( treeRect );

    GetDlgItem(IDC_LIST)->GetWindowRect( listRect );
    ScreenToClient( listRect );

    treeRect.left = BORDER_WIDTH;
    treeRect.top  = BORDER_WIDTH;
    treeRect.right = treeRect.left + TREE_WIDTH;
    treeRect.bottom = clRect.bottom - BUTTON_HEIGHT - (BORDER_WIDTH * 2);
    GetDlgItem(IDC_TREE)->MoveWindow( treeRect );

    listRect.left = treeRect.right + BORDER_WIDTH;
    listRect.top  = BORDER_WIDTH;
    listRect.right = listRect.left + TREE_WIDTH;
    value = clRect.right - BORDER_WIDTH;
    if (listRect.right < value)
        listRect.right = value;
    listRect.bottom = clRect.bottom - BUTTON_HEIGHT - (BORDER_WIDTH * 2);
    GetDlgItem(IDC_LIST)->MoveWindow( listRect );

    GetDlgItem(IDC_BUTTONREFRESH)->GetWindowRect( bRect );
    ScreenToClient( bRect );
    bRect.left   = BORDER_WIDTH;
    bRect.right  = bRect.left + BUTTON_WIDTH;
    bRect.bottom = clRect.bottom - BORDER_WIDTH;
    bRect.top    = bRect.bottom - BUTTON_HEIGHT;
    GetDlgItem(IDC_BUTTONREFRESH)->MoveWindow( bRect );

    GetDlgItem(IDC_CHECK_AUTOREFRESH)->GetWindowRect( bRect );
    ScreenToClient( bRect );
    bRect.left   = BUTTON_WIDTH + (2 * BORDER_WIDTH);
    bRect.right  = bRect.left + BUTTON_WIDTH;
    bRect.bottom = clRect.bottom - BORDER_WIDTH;
    bRect.top    = bRect.bottom - BUTTON_HEIGHT;
    GetDlgItem(IDC_CHECK_AUTOREFRESH)->MoveWindow( bRect );

    GetDlgItem(IDOK)->GetWindowRect( bRect );
    ScreenToClient( bRect );
    bRect.right  = clRect.right - BORDER_WIDTH;
    bRect.left   = bRect.right - BUTTON_WIDTH;
    bRect.bottom = clRect.bottom - BORDER_WIDTH;
    bRect.top    = bRect.bottom - BUTTON_HEIGHT;
    GetDlgItem(IDOK)->MoveWindow( bRect );
}


void CMOPI_PlugInDlg::UserSelChange()
{
    ASSERT (m_ipMOPI != NULL);
    if (m_ipMOPI != NULL)
    {
        m_cList.SetRedraw( FALSE );
        // store last type
        m_lastEType = m_eType;
        // Delete all items (Rows)
        m_cList.DeleteAllItems();
        // Delete all of the columns
        int nColumnCount = m_cList.GetHeaderCtrl()->GetItemCount();
        for (int i = 0; i < nColumnCount; i++)
        {
            m_cList.DeleteColumn( 0 );
        }

        // display requested resource
        switch( m_eType )
        {
        case eDlgMemory:
            Display_Memory();
            break;
        case eDlgHeap:
            Display_Heap();
            break;
        case eDlgBlockpool:
            Display_Blockpool();
            break;
        case eDlgResourceUsage:
			Display_ResourceUsage();
			break;
		case eDlgProcessControl:
			Display_ProcessUse( (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources ) );
			break;
        case eDlgSAProcesses:
			Display_SAProcesses( (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources ) );
			break;
        case eDlgProcessGroups:
			Display_ProcGroups( (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources ) );
			break;
        case eDlgSystemtasks:
			Display_Tasks( (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources ), IMOPI_RESTYPE_TASK );
			break;
        case eDlgInterrupttasks:
			Display_Tasks( (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources ), IMOPI_RESTYPE_HISR );
			break;
        case eDlgMessageHandling:
            Display_MsgHndlResources( (T_IMOPI_MsgResources*)m_ipMOPI->GetInfo( eMsgHndlResources ) );
            break;
        case eDlgQueueManagement:
            Display_QueueResources( (T_IMOPI_QueueResources*)m_ipMOPI->GetInfo( eQueueResources ) );
            break;
        case eDlgTimerManagement:
            Display_TimerResources( (T_IMOPI_TimerResources*)m_ipMOPI->GetInfo( eTimerResources ) );
            break;
        case eDlgSyncManagement:
            Display_SyncResources( (T_IMOPI_SyncResources*)m_ipMOPI->GetInfo( eSyncResources ) );
            break;
        case eDlgMutexes:
            Display_Mutexes( (T_IMOPI_SyncResources*)m_ipMOPI->GetInfo( eSyncResources ) );
            break;
        case eDlgTimers:
            Display_Timers( (T_IMOPI_TimerResources*)m_ipMOPI->GetInfo( eTimerResources ) );
            break;
        case eDlgMsgLog:
            Display_MsgLog( (T_IMOPI_MsgLog*)m_ipMOPI->GetInfo( eMsgLog ) );
            break;
		case eDlgProcQueueDetail:
			Display_ProcessQueues( (T_IMOPI_QueueResources*)m_ipMOPI->GetInfo( eQueueResources ) );
			break;
		case eDlgPendQueueDetail:
			Display_PendingQueues( (T_IMOPI_QueueResources*)m_ipMOPI->GetInfo( eQueueResources ) );
			break;
		}
        m_cList.SetRedraw( TRUE );
    }
}

void CMOPI_PlugInDlg::Display_ResourceUsage()
{
    CString  cStr;
    int i = 0, j;
    T_IMOPI_ResourceTable* pResTable =
        (T_IMOPI_ResourceTable*)m_ipMOPI->GetInfo( eTaskProcResources );
    T_IMOPI_QueueResources* pQueueRes =
        (T_IMOPI_QueueResources*)m_ipMOPI->GetInfo( eQueueResources );
    T_IMOPI_TimerResources* pTimerRes =
        (T_IMOPI_TimerResources*)m_ipMOPI->GetInfo( eTimerResources );
    T_IMOPI_SyncResources* pSyncRes =
        (T_IMOPI_SyncResources*)m_ipMOPI->GetInfo( eSyncResources );
    T_IMOPI_MsgResources* pMsgHndlRes =
        (T_IMOPI_MsgResources*)m_ipMOPI->GetInfo( eMsgHndlResources );
    T_IMOPI_MemInfo* pMemInfo =
        (T_IMOPI_MemInfo*)m_ipMOPI->GetInfo( eMemInfo );

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 150, i++ );
    m_cList.InsertColumn( i, _T("Current"), LVCFMT_LEFT, 70, i++ );
    m_cList.InsertColumn( i, _T("Max"), LVCFMT_LEFT, 70, i++ );
    m_cList.InsertColumn( i, _T("Configured"), LVCFMT_LEFT, 70, i++ );

    i = 0;
    j = 1;
    m_cList.InsertItem( i, _T("Process groups") );
    cStr.Format( "%d", pResTable->tResGroups );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pResTable->tResMaxGroups );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_PROC_GROUP );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Group processes") );
    cStr.Format( "%d", pResTable->tResGroupProc );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pResTable->tResMaxGroupProc );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_GROUP_PROCESSES );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("System tasks") );
    cStr.Format( "%d", pResTable->tResTasks );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pResTable->tResMaxTasks );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_MTASKS );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Interrupt tasks") );
    cStr.Format( "%d", pResTable->tResHisrs );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pResTable->tResMaxHisrs );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_MHISRS );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Standalone processes") );
    cStr.Format( "%d", pResTable->tResSaProcs );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pResTable->tResMaxSaProcs );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_SA_PROCESSES );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Pending queues") );
    cStr.Format( "%d", pQueueRes->pQueues.nbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pQueueRes->pQueues.maxNbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_PQUEUES );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Timers") );
    cStr.Format( "%d", pTimerRes->timerRes.nbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pTimerRes->timerRes.maxNbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_TIMER );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Mutexes") );
    cStr.Format( "%d", pSyncRes->mutexRes.nbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pSyncRes->mutexRes.maxNbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_MUTEXES );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Transactions") );
    cStr.Format( "%d", pMsgHndlRes->transRes.nbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pMsgHndlRes->transRes.maxNbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_TRANSACTIONS );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Message receivers") );
    cStr.Format( "%d", pMsgHndlRes->msgRecRes.nbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pMsgHndlRes->msgRecRes.maxNbrOfRes );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_MSGRECEIVERS );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Heap elements") );
    cStr.Format( "%d", pMemInfo->imopiNumOfHeaps );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pMemInfo->imopiMaxNumOfHeaps );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_MEMORY_POOLS );
    m_cList.SetItemText( i++, j++, cStr );

    j = 1;
    m_cList.InsertItem( i, _T("Blockpool elements") );
    cStr.Format( "%d", pMemInfo->imopiNumOfBps );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", pMemInfo->imopiMaxNumOfBps );
    m_cList.SetItemText( i, j++, cStr );
    cStr.Format( "%d", IMOPI_NUMOF_PARTITION_POOLS );
    m_cList.SetItemText( i++, j++, cStr );
}


void CMOPI_PlugInDlg::Display_PendingQueues( T_IMOPI_QueueResources *pRes )
{
    CString  cStr;
    int      i = 0;
	int      l = 0;
    T_IMOPI_PQueue *pQueue;

    // setup listview
    m_cList.InsertColumn( i, _T("CEP-Id"),      LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("msg queued"),  LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("msg max"),     LVCFMT_LEFT,  80, i++ );

    i = 0;
	pQueue = (T_IMOPI_PQueue*)pRes->pQueues.pFirstRes;
    while ( pQueue != 0 )
    {
		l = 1;
		if ( pQueue->pFirstMsg != 0 )
		{
			cStr.Format( "0x%04X",  pQueue->pFirstMsg->mopiHeader.targetCep );
		}
		else
		{
			cStr.Format( "%s", "undefined");
		}
		m_cList.InsertItem(  i, cStr );
		cStr.Format( "%d",  pQueue->msgCount );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%d",  pQueue->maxCount );
		m_cList.SetItemText( i, l++, cStr );
		i++;
		pQueue = (T_IMOPI_PQueue*)pQueue->resBase.pNext;
    }
    if (i == 0)
    {
        m_cList.InsertItem( 0, _T("no pending queues") );
    }
}

void CMOPI_PlugInDlg::Display_ProcessQueues( T_IMOPI_QueueResources *pRes )
{
    CString  cStr;
    int      i = 0;
	int      l = 0;
    T_IMOPI_Queue    *pQueue;

    // setup listview
    m_cList.InsertColumn( i, _T("Proc. name"),     LVCFMT_LEFT, 150, i++ );
    m_cList.InsertColumn( i, _T("CEP-Id"),         LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("Msg"),            LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("max. Msg"),       LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("pend. Msg"),      LVCFMT_LEFT,  100, i++ );
    m_cList.InsertColumn( i, _T("max. pend. Msg"), LVCFMT_LEFT,  100, i++ );

    i = 0;
	pQueue = (T_IMOPI_Queue*)pRes->queues.pFirstRes;
    while ( pQueue != 0 )
    {
		l = 1;
		cStr.Format( "%s",  ((T_IMOPI_ProcessBase*)pQueue->pProcess)->pName );
		m_cList.InsertItem(  i, cStr );
		cStr.Format( "0x%04X",  ((T_IMOPI_ProcessBase*)pQueue->pProcess)->cepId );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%d",  pQueue->msgCount );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%d",  pQueue->maxCount );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%d",  pQueue->msgPCount );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%d",  pQueue->maxPCount );
		m_cList.SetItemText( i, l++, cStr );
		i++;
		pQueue = (T_IMOPI_Queue*)pQueue->resBase.pNext;
	}
    if (i == 0)
    {
        m_cList.InsertItem( 0, _T("no processes with messages queued") );
    }
}

void CMOPI_PlugInDlg::Display_MsgLog( T_IMOPI_MsgLog *pLog )
{
    CString  cStr;
    int      i = 0;
	int      l = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Timestamp"),     LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("CEP-Id target"), LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("CEP-Id source"), LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("msg id"),        LVCFMT_LEFT,  80, i++ );
    m_cList.InsertColumn( i, _T("msg type"),      LVCFMT_LEFT,  80, i++ );

    i = 0;

    while ( ( i < IMOPI_MSG_LOG_BUFFER_ENTRIES ) &&
		    ( pLog->logBuf[ i ].msgType != ImopiMtUndefined ) )
    {
        l = 1;
		cStr.Format( "0x%08X", pLog->logBuf[ i ].timestamp );
		m_cList.InsertItem(  i, cStr );
		cStr.Format( "0x%04X",  pLog->logBuf[ i ].targetCepId );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "0x%04X",  pLog->logBuf[ i ].sourceCepId );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "0x%04X", pLog->logBuf[ i ].msgId );
		m_cList.SetItemText( i, l++, cStr );
		cStr.Format( "%s", MsgTypeString( pLog->logBuf[ i ].msgType ) );
		m_cList.SetItemText( i, l++, cStr );
		i++;
    }
    if (i == 0)
    {
        m_cList.InsertItem( 0, _T("no log entry") );
    }
}

void CMOPI_PlugInDlg::Display_Timers( T_IMOPI_TimerResources *pRes )
{
    CString  cStr;
    int      i = 0;
	int      j = 0;
	int      l = 0;
    T_IMOPI_Timer          *pTimer;

    // setup listview
    m_cList.InsertColumn( i, _T("CEP-Id"),   LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("type"),     LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("state"),    LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("msg id"),   LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("callback"), LVCFMT_LEFT,  80, i++ );

    i = 0;

    pTimer = (T_IMOPI_Timer*)(pRes->timerRes.pFirstRes);
    while ( pTimer != 0 )
    {
        j = 1;
		if ( pTimer->state != MOPI_Timer_Inactive )
		{
			cStr.Format( "0x%04X", pTimer->targetCep );
			m_cList.InsertItem(  l, cStr );
			cStr.Format( "%s",  TimerTypeString( pTimer->type ) );
			m_cList.SetItemText( l, j++, cStr );
			cStr.Format( "%s", TimerStateString( pTimer->state ) );
			m_cList.SetItemText( l, j++, cStr );
			cStr.Format( "0x%04X", pTimer->msgId );
			m_cList.SetItemText( l, j++, cStr );
			cStr.Format( "0x%08X", pTimer->pCallback );
			m_cList.SetItemText( l, j++, cStr );
			l++;
		}
		pTimer = (T_IMOPI_Timer*)pTimer->resBase.pNext;
		i++;
    }
    if (i == 0)
    {
        m_cList.InsertItem( 0, _T("no timer created") );
    }
	else if ( l == 0 )
	{
        m_cList.InsertItem( 0, _T("no active timer") );
	}
}

void CMOPI_PlugInDlg::Display_Mutexes( T_IMOPI_SyncResources *pRes )
{
    CString  cStr;
    int      i = 0;
	int      j = 0;
	int      l = 0;
    T_IMOPI_ResourceHeader *pTask;
    T_IMOPI_Mutex          *pMutex;

    // setup listview
    m_cList.InsertColumn( i, _T("Task-name"),  LVCFMT_LEFT, 150, i++ );
    m_cList.InsertColumn( i, _T("Task-Id"),    LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("lock count"), LVCFMT_LEFT,  60, i++ );

    i = 0;

    pMutex = (T_IMOPI_Mutex*)(pRes->mutexRes.pFirstRes);
    while ( pMutex != 0 )
    {
        pTask = (T_IMOPI_ResourceHeader*)(pMutex->pTask);
        j = 1;
		if ( pMutex->lockCount != 0 )
        {
            cStr.Format( "%s", pTask->pTaskConfig->pTaskName );
            m_cList.InsertItem(  l, cStr );
            cStr.Format( "0x%02X", pTask->pTaskConfig->taskId );
            m_cList.SetItemText( l, j++, cStr );
            cStr.Format( "%d", pMutex->lockCount );
            m_cList.SetItemText( l, j++, cStr );
			l++;
        }
		pMutex = (T_IMOPI_Mutex*)pMutex->resBase.pNext;
        i++;
    }
    if (i == 0)
    {
        m_cList.InsertItem( 0, _T("no mutexes created") );
    }
	else if ( l == 0 )
	{
        m_cList.InsertItem( 0, _T("no mutex locked") );
	}
}


void CMOPI_PlugInDlg::Display_SyncResources( T_IMOPI_SyncResources *pRes )
{
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    m_cList.InsertItem( i, _T("mutexes") );
    cStr.Format( "%d", pRes->mutexRes.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
    
	m_cList.InsertItem( i, _T("max. mutexes") );
    cStr.Format( "%d", pRes->mutexRes.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
}

void CMOPI_PlugInDlg::Display_TimerResources( T_IMOPI_TimerResources *pRes )
{
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    m_cList.InsertItem( i, _T("timers") );
    cStr.Format( "%d", pRes->timerRes.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
    
	m_cList.InsertItem( i, _T("max. timers") );
    cStr.Format( "%d", pRes->timerRes.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
}


void CMOPI_PlugInDlg::Display_QueueResources( T_IMOPI_QueueResources *pRes )
{
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    m_cList.InsertItem( i, _T("message queues") );
    cStr.Format( "%d", pRes->queues.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
    
	m_cList.InsertItem( i, _T("max. message queues") );
    cStr.Format( "%d", pRes->queues.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );

    m_cList.InsertItem( i, _T("pending queues") );
    cStr.Format( "%d", pRes->pQueues.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
    
	m_cList.InsertItem( i, _T("max. pending queues") );
    cStr.Format( "%d", pRes->pQueues.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );

}


void CMOPI_PlugInDlg::Display_MsgHndlResources( T_IMOPI_MsgResources *pRes )
{
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    m_cList.InsertItem( i, _T("curr. wait for message") );
    cStr.Format( "%d", pRes->msgRecRes.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );
    
	m_cList.InsertItem( i, _T("max. wait for message") );
    cStr.Format( "%d", pRes->msgRecRes.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("curr. transactions") );
    cStr.Format( "%d", pRes->transRes.nbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("max. transactions") );
    cStr.Format( "%d", pRes->transRes.maxNbrOfRes );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("next transaction-id") );
    cStr.Format( "%d", pRes->transactionId );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("msglog - write pos") );
    cStr.Format( "%d", pRes->pMsgLog->logWrite );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("msglog - count") );
    cStr.Format( "%d", pRes->pMsgLog->logCount );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("msglog - buffer entries") );
    cStr.Format( "%d", IMOPI_MSG_LOG_BUFFER_ENTRIES );
    m_cList.SetItemText( i++, 1, cStr );
}


void CMOPI_PlugInDlg::Display_Tasks( T_IMOPI_ResourceTable *pResTable, T_IMOPI_ResourceType type )
{
    CString  cStr;
    int      i = 0;
	int 	 p = 0;
	T_IMOPI_ResourceHeader *pRes;

    // setup listview
    m_cList.InsertColumn( i, _T("Name"),         LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Task-Id"),      LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("Prio"),         LVCFMT_LEFT,  40, i++ );
    m_cList.InsertColumn( i, _T("Trace mask"),   LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("mem consumed"), LVCFMT_LEFT, 100, i++ );

	i = 0;
	for ( p=0; p<IMOPI_MAXRESOURCES;p++)
	{
		pRes = (T_IMOPI_ResourceHeader*)(pResTable->pResource[p]);
		if ( pRes != 0 && pRes->resType == type )
		{
            int j = 1;
            cStr.Format( "%s", pRes->pTaskConfig->pTaskName );
            m_cList.InsertItem(  i, cStr );
            cStr.Format( "0x%02X", pRes->pTaskConfig->taskId );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pRes->pTaskConfig->taskPriority );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%04X", pRes->traceMask );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%04X", pRes->memConsumed );
            m_cList.SetItemText( i, j++, cStr );
            i++;
		}
	}
    if (i == 0)
    {
        m_cList.InsertItem( i, _T("no tasks created") );
    }
}


void CMOPI_PlugInDlg::Display_ProcGroups( T_IMOPI_ResourceTable* pResTable )
{
    CString  cStr;
    int      i = 0;
	int 	 p = 0;
	T_IMOPI_ProcessGroup *pGroup;
    T_IMOPI_GroupProcess *pProc;

    // setup listview
    m_cList.InsertColumn( i, _T("Name"),       LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Task-Id"),    LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("Prio"),       LVCFMT_LEFT,  40, i++ );
    m_cList.InsertColumn( i, _T("Type"),       LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("State"),      LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("processes"),  LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("current"),    LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("first RDY"),  LVCFMT_LEFT,  70, i++ );

	i = 0;
	for ( p=0; p<IMOPI_MAXRESOURCES;p++)
	{
		pGroup = (T_IMOPI_ProcessGroup*)(pResTable->pResource[p]);
		if ( pGroup != 0 && pGroup->resHeader.resType == IMOPI_RESTYPE_PROCESSGROUP )
		{
            int j = 1;
            cStr.Format( "%s", pGroup->resHeader.pTaskConfig->pTaskName );
            m_cList.InsertItem(  i, cStr );
            m_cList.SetItemData( i, (DWORD_PTR)pGroup );
            cStr.Format( "0x%02X", pGroup->resHeader.pTaskConfig->taskId );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pGroup->resHeader.pTaskConfig->taskPriority );
            m_cList.SetItemText( i, j++, cStr );
			cStr.Format( "%s", pGroup->type == ImopiGtStatic ? "static" : "dynamic" );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%s", GroupStateString( pGroup->state ) );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pGroup->actProcesses );
            m_cList.SetItemText( i, j++, cStr );
            if ( ( pProc = pGroup->pActProcess ) != 0 )
			{
				cStr.Format( "0x%04X", pProc->procBase.cepId );
			}
			else
			{
				cStr.Format( "%s", "" );
			}
            m_cList.SetItemText( i, j++, cStr );
            if ( ( pProc = pGroup->pFirstReadyProcess ) != 0 )
			{
				cStr.Format( "0x%04X", pProc->procBase.cepId );
			}
			else
			{
				cStr.Format( "%s", "" );
			}
			m_cList.SetItemText( i, j++, cStr );
			i++;
		}
	}
    if (i == 0)
    {
        m_cList.InsertItem( i, _T("no process groups created") );
    }
}


void CMOPI_PlugInDlg::Display_SAProcesses( T_IMOPI_ResourceTable* pResTable )
{
    CString  cStr;
    int      i = 0;
	int 	 p = 0;
	T_IMOPI_SAProcess *pProc;

    // setup listview
    m_cList.InsertColumn( i, _T("Name"),            LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("CEP-Id"),          LVCFMT_LEFT,  50, i++ );
    m_cList.InsertColumn( i, _T("Prio"),            LVCFMT_LEFT,  40, i++ );
    m_cList.InsertColumn( i, _T("State"),           LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("Trace mask"),      LVCFMT_LEFT,  70, i++ );
    m_cList.InsertColumn( i, _T("Msg"),             LVCFMT_LEFT,  40, i++ );
    m_cList.InsertColumn( i, _T("max. Msg"),        LVCFMT_LEFT,  60, i++ );
    m_cList.InsertColumn( i, _T("mem consumed"),    LVCFMT_LEFT,  90, i++ );

	i = 0;
	for ( p=0; p<IMOPI_MAXRESOURCES;p++)
	{
		pProc = (T_IMOPI_SAProcess*)(pResTable->pResource[p]);
		if ( pProc != 0 && pProc->resHeader.resType == IMOPI_RESTYPE_SAPROCESS )
		{
            int j = 1;
            cStr.Format( "%s", pProc->procBase.pName );
            m_cList.InsertItem(  i, cStr );
            cStr.Format( "0x%04X", pProc->procBase.cepId );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pProc->resHeader.pTaskConfig->taskPriority );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%s", ProcStateString(pProc->procBase.state) );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%04X", pProc->procBase.traceMask );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pProc->procBase.queue.msgCount );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pProc->procBase.queue.maxCount );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%04X", pProc->procBase.memConsumed );
            m_cList.SetItemText( i, j++, cStr );
            i++;	
		}
	}
    if (i == 0)
    {
        m_cList.InsertItem( i, _T("no stand-alone process created") );
    }
}


void CMOPI_PlugInDlg::Display_NotImpl()
{
    // setup listview
    m_cList.InsertColumn( 0, _T(""), LVCFMT_LEFT, 300, 0 );
    m_cList.InsertItem( 0, _T("Function not yet implemented") );
}


void CMOPI_PlugInDlg::Display_ProcessUse( T_IMOPI_ResourceTable* pResTable )
{
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 200, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    m_cList.InsertItem( i, _T("process groups") );
    cStr.Format( "%d", pResTable->tResGroups );
    m_cList.SetItemText( i++, 1, cStr );

    m_cList.InsertItem( i, _T("max. process groups") );
    cStr.Format( "%d", pResTable->tResMaxGroups );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("SA-processes") );
    cStr.Format( "%d", pResTable->tResSaProcs );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("max. SA-processes") );
    cStr.Format( "%d", pResTable->tResMaxSaProcs );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("system tasks") );
    cStr.Format( "%d", pResTable->tResTasks );
    m_cList.SetItemText( i++, 1, cStr );

	m_cList.InsertItem( i, _T("max. system tasks") );
    cStr.Format( "%d", pResTable->tResMaxTasks );
    m_cList.SetItemText( i++, 1, cStr );

    m_cList.InsertItem( i, _T("interrupt tasks") );
    cStr.Format( "%d", pResTable->tResHisrs );
    m_cList.SetItemText( i++, 1, cStr );

    m_cList.InsertItem( i, _T("max. interrupt tasks") );
    cStr.Format( "%d", pResTable->tResMaxHisrs );
    m_cList.SetItemText( i++, 1, cStr );
}


void CMOPI_PlugInDlg::Display_Memory()
{
    CString  cStr;
    int      i = 0;

    T_IMOPI_MemObject *pMemObj = (T_IMOPI_MemObject*)m_ipMOPI->GetInfo( eNonPermSysHeap );
    T_IMOPI_MemObject *pNextMemObj = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Type"), LVCFMT_LEFT, 90, i++ );
    m_cList.InsertColumn( i, _T("Description"), LVCFMT_LEFT, 190, i++ );
    m_cList.InsertColumn( i, _T("Value"), LVCFMT_LEFT, 100, i++ );

    i = 0;
    while (pMemObj)
    {
        if (pMemObj == (T_IMOPI_MemObject*)m_ipMOPI->GetInfo( eNonPermSysHeap ))
        {
            m_cList.InsertItem( i++, _T("Non permanent") );
            pNextMemObj = (T_IMOPI_MemObject*)m_ipMOPI->GetInfo( ePermSysHeap );
        }
        else
        {
            m_cList.InsertItem( i++, _T("Permanent") );
            pNextMemObj = 0;
        }

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("size of the heap in bytes") );
        cStr.Format( "%d", pMemObj->uSize );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("max bytes allocated") );
        cStr.Format( "%d", pMemObj->maxAlloc[0] );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("current bytes allocated") );
        cStr.Format( "%d", pMemObj->curAlloc[0] );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("current bytes free") );
        cStr.Format( "%d", pMemObj->uSize - pMemObj->curAlloc[0] );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("max number of allocated blocks") );
        cStr.Format( "%d", pMemObj->numAlloc[0] );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("current number of allocated blocks") );
        cStr.Format( "%d", pMemObj->cnumAlloc[0] );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("first address of the memory area") );
        cStr.Format( "0x%x", pMemObj->pStart );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i, _T("") );
        m_cList.SetItemText( i, 1, _T("highest used address") );
        cStr.Format( "0x%x", pMemObj->pHighestAddress );
        m_cList.SetItemText( i++, 2, cStr );

        m_cList.InsertItem( i++, _T("") );
        pMemObj = pNextMemObj;
    }
}


void CMOPI_PlugInDlg::Display_Heap()
{
    T_IMOPI_MemObject *pFirstMemObj = (T_IMOPI_MemObject*)m_ipMOPI->GetInfo( eFirstMemObject );
    T_IMOPI_MemObject *pMemObj = pFirstMemObj;
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Name"), LVCFMT_LEFT, 150, i++ );
    m_cList.InsertColumn( i, _T("Size"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("CurMem"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("MaxMem"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("CurNum"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("MaxNum"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("Start"), LVCFMT_LEFT, 80, i++ );
    m_cList.InsertColumn( i, _T("Highest"), LVCFMT_LEFT, 80, i++ );

    while (pMemObj)
    {
        if ((pMemObj->uInfo & eImopiMemObjectHeapType) == eImopiMemObjectHeap)
        {
            int j = 1;
            i = 0;
            cStr.Format( "%s", pMemObj->name );
            m_cList.InsertItem( i, cStr );
            m_cList.SetItemData( i, (DWORD_PTR)pMemObj );

            cStr.Format( "%d", pMemObj->uTotalSize );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->curAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->maxAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->cnumAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->numAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%X", pMemObj->pStart );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%X", pMemObj->pHighestAddress );
            m_cList.SetItemText( i, j++, cStr );
            i++;
        }
        pMemObj = pMemObj->pNext;
    }
}


void CMOPI_PlugInDlg::Display_Blockpool()
{
    T_IMOPI_MemObject *pFirstMemObj = (T_IMOPI_MemObject*)m_ipMOPI->GetInfo( eFirstMemObject );
    T_IMOPI_MemObject *pMemObj = pFirstMemObj;
    CString  cStr;
    int      i = 0;

    // setup listview
    m_cList.InsertColumn( i, _T("Name"), LVCFMT_LEFT, 150, i++ );
    m_cList.InsertColumn( i, _T("Size"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("BlkSize"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("BlkCount"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("CurNum"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("MaxNum"), LVCFMT_LEFT, 60, i++ );
    m_cList.InsertColumn( i, _T("Start"), LVCFMT_LEFT, 80, i++ );
    m_cList.InsertColumn( i, _T("Highest"), LVCFMT_LEFT, 80, i++ );

    while (pMemObj)
    {
        if ((pMemObj->uInfo & eImopiMemObjectHeapType) == eImopiMemObjectBlock)
        {
            int j = 1;
            i = 0;
            cStr.Format( "%s", pMemObj->name );
            m_cList.InsertItem( i, cStr );
            m_cList.SetItemData( i, (DWORD_PTR)pMemObj );

            cStr.Format( "%d", pMemObj->uTotalSize );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->uSize );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->uBlockCount );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->curAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMemObj->maxAlloc[0] );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%X", pMemObj->pStart );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%X", pMemObj->pHighestAddress );
            m_cList.SetItemText( i, j++, cStr );
            i++;
        }
        pMemObj = pMemObj->pNext;
    }
}


const char * ProcStateString( T_IMOPI_ProcessState_Enum state )
{
    switch ( state )
    {
	case ImopiPsDormant:
		return ("dormant");
	case ImopiPsReady:
		return ("ready");
	case ImopiPsRunning:
		return ("running");
	case ImopiPsBlocked:
		return ("blocked");
	case ImopiPsDestroyPending:
		return ("destroy pend.");
    default:
        return( "unknown");
    }
}    


const char * GroupStateString( T_IMOPI_GroupState_Enum state )
{
    switch ( state )
    {
	case ImopiGsInit:
		return ("init");
	case ImopiGsActive:
		return ("active");
	case ImopiGsDestroyPending:
		return ("destroy pend.");
	case ImopiGsRescheduleFirst:
	case ImopiGsReschedule:
	case ImopiGsRescheduleProcDest:
		return ("reschedule");
    default:
        return( "unknown");
    }
}    

const char * TimerTypeString( T_IMOPI_TimerType type )
{
    switch ( type )
    {
	case ImopiMopiTimer:
		return ("MOPI");
	case ImopiGbsMsgTimer:
		return ("GBSMsg");
	case ImopiGbsCallbackTimer:
		return ("GBSCb");
    default:
        return( "unknown");
    }
}

const char * TimerStateString( UINT16 state )
{
    switch ( state )
    {
	case MOPI_Timer_Inactive:
		return ("inactiv");
	case MOPI_Timer_Running:
		return ("running");
	case MOPI_Timer_Expired:
		return ("expired");
    default:
        return( "unknown");
    }
}

const char * MsgTypeString( T_IMOPI_MsgTypeEnum msgType )
{
    switch ( msgType )
    {
	case ImopiMtMopi:
		return ("MOPI");
	case ImopiMtGbs:
		return ("GBS");
	case ImopiMtGbsSBit:
		return ("SBIT");
	case ImopiMtMopiTimeout:
		return ("TOUT");
	case ImopiMtGbsMsgTimeout:
		return ("GBSTOUT");
	case ImopiMtGbsCbTimeout:
		return ("GBSCBTOUT");
    default:
        return( "unknown");
    }
}

