/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Walter Stroell

.FILENAME      MOPI_PostMsgDlg.h

.VERSION       00.00.00

.DATE          2004-03-25

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Walter Stroell
         initial version
------------------------------------------------------------------------------*/
#pragma once
#include "afxwin.h"
#include "Iappinterfacemopi.h"

interface IApplicationInterfaceMOPI;

// MOPI_MsgPostDlg dialog

class MOPI_MsgPostDlg : public CDialog
{
	DECLARE_DYNAMIC(MOPI_MsgPostDlg)

public:
	MOPI_MsgPostDlg(IApplicationInterfaceMOPI* ipMOPI, CWnd* pParent = NULL);   // standard constructor
	virtual ~MOPI_MsgPostDlg();

// Dialog Data
	enum { IDD = IDD_DIALOG_MSGPOST };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    IApplicationInterfaceMOPI* m_ipMOPI;
	T_Cmd_PostMsg			   m_pMsg;
	bool                       m_cepSrcValid;
	bool                       m_cepTargetValid;
	bool                       m_msgIdValid;
	bool                       m_payloadLengthValid;
	bool                       m_payloadValid;

	DECLARE_MESSAGE_MAP()
	CEdit m_cEditCepSource;
	CEdit m_cEditCepTarget;
	CEdit m_cEditMsgId;
	CEdit m_cEditMsgLength;
	CEdit m_cEditMsgPayload;
public:
//	afx_msg void OnEnChangeEditcepsrc();
	afx_msg void OnEnUpdateEditcepsrc();
	afx_msg void OnEnChangeEditceptarget();
	afx_msg void OnEnChangeEditmsgid();
	afx_msg void OnEnChangeEditmsglength();
	afx_msg void OnEnChangeEditmsgpayload();
	afx_msg void OnBnClickedPost();
	bool         Hex2Val( const char* s, int& value, unsigned int limit );
};
