/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Norbert Barisits

.FILENAME      MOPI_MemDetailDlg.cpp

.VERSION       00.00.00

.DATE          2004-03-25

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Norbert Barisits
         initial version
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "mopi.h"
#include "Iappinterfacemopi.h"
#include "MOPI_PlugIn.h"
#include "MOPI_MemDetailDlg.h"
#include "MOPI_MemDumpDlg.h"

#define MOPI_MEM_DATA(pHeader)  ((unsigned char *)((T_IMOPI_MemBlockHeader *)pHeader + 1))

// MOPI_MemDetailDlg dialog

IMPLEMENT_DYNAMIC(MOPI_MemDetailDlg, CDialog)
MOPI_MemDetailDlg::MOPI_MemDetailDlg( IApplicationInterfaceMOPI* ipMOPI, DWORD_PTR pMO, CWnd* pParent /*=NULL*/)
	: CDialog(MOPI_MemDetailDlg::IDD, pParent)
{
    m_ipMOPI = ipMOPI;
    m_pMO = pMO;
}

MOPI_MemDetailDlg::~MOPI_MemDetailDlg()
{
}

void MOPI_MemDetailDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_LIST, m_cList);
}


BEGIN_MESSAGE_MAP(MOPI_MemDetailDlg, CDialog)
    ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnNMDblclkList1)
END_MESSAGE_MAP()


// MOPI_MemDetailDlg message handlers
BOOL MOPI_MemDetailDlg::OnInitDialog() 
{
    CDialog::OnInitDialog();
    ASSERT (m_pMO != NULL);

    if (m_pMO != NULL)
    {
        CString  cStr;
        int      i;
        T_IMOPI_MemObject *pMemObj = (T_IMOPI_MemObject*)m_pMO;
        T_IMOPI_MemBlockHeader_Tag *pMB = pMemObj->pFirstMemBlockHeader;

        SetWindowText( (LPCTSTR)pMemObj->name );

        // Delete all items (Rows)
        m_cList.DeleteAllItems();
        // Delete all of the columns
        int nColumnCount = m_cList.GetHeaderCtrl()->GetItemCount();
        for (i = 0; i < nColumnCount; i++)
        {
            m_cList.DeleteColumn( 0 );
        }

        i = 0;
        // setup listview
        m_cList.InsertColumn( i, _T("Start"),    LVCFMT_LEFT, 90, i++ );
        m_cList.InsertColumn( i, _T("Size"),     LVCFMT_LEFT, 60, i++ );
        m_cList.InsertColumn( i, _T("CepID"),    LVCFMT_LEFT, 60, i++ );
        m_cList.InsertColumn( i, _T("Filename"), LVCFMT_LEFT, 200, i++ );
        m_cList.InsertColumn( i, _T("Linenum"),  LVCFMT_LEFT, 60, i++ );

        i = 0;
        while (pMB)
        {
            int j = 1;
            cStr.Format( "0x%08X", MOPI_MEM_DATA( pMB ) );
            m_cList.InsertItem( i, cStr );
            m_cList.SetItemData( i, (DWORD_PTR)pMB );

            cStr.Format( "%d", pMB->uSize );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "0x%04X", pMB->cepId );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%s", pMB->filename );
            m_cList.SetItemText( i, j++, cStr );
            cStr.Format( "%d", pMB->lineNumber );
            m_cList.SetItemText( i, j++, cStr );
            i++;
            pMB = pMB->pNext;
        }
        if (i == 0)
        {
            m_cList.InsertItem( i, _T("no memory used") );
        }
    }
   
    ListView_SetExtendedListViewStyleEx( GetDlgItem( IDC_LIST )->m_hWnd,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE );
    return TRUE;
}


void MOPI_MemDetailDlg::OnNMDblclkList1(NMHDR *pNMHDR, LRESULT *pResult)
{
    LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
    DWORD_PTR selection;
    *pResult = 0;

    if (lpnmitem->iItem == -1)
    {
        return;
    }

    selection = m_cList.GetItemData( lpnmitem->iItem );

    if( selection != 0 )
    {
		MOPI_MemDumpDlg dlg( m_ipMOPI, selection );
		dlg.DoModal();
    }
}
