/*
             Siemens AG
         Mobile Radio Terminals
          Munich, Germany

.AUTHOR         A. Graeupel, Siemens Wireless Terminals

.SHORT_DESCR    Implementation of ListViewWindow for different Linked List items

.SW_COMPONENT   PC-MMI-Simulation

.SW_TYPE        Support-File

.VERSION        1.07.00

.DATE           09/03/03

.STATUS         Textfirst VERSION

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
-------------------------------------------------------------------------------
  1.0    08/15/97  A. Graeupel  file created......
  1.1    16.10.97  C. Schenkel  show dialogstack from selected csm (not only from active!)
                                reset csm_selection if new csm / dialog arrives
  1.2    25.01.00  N.Faisst     added cast DLGPROC due to migration Borland C -> MS-VC
  1.3    04.02.00  H. Sauer     not resetting csm list in case of invalid hlistview
  1.4    07.12.00  N. Does      isnsert new TextidFieds
  1.5    06.11.01  N. Haiduk    csm_stack -> mg_llCSMStack

  01-05-01 2002-02-22 Bettina Stingl
                      Removed relative paths from open statements
  01.05.02 2002-08-21 S. Gerber (Mch)
                      use CSMGetStack() instead of extern declaration
  01.06.00 2003-08-11 M. Korkmaz 
                      Enhancement of function for new clam shell (CS) display
  01.07.00 2003-09-03 M. Korkmaz 
                      Enhancement of function reset_csm_list(enum AListView view)
                     
*/

#define DEPTHWITHOUTTEXT      (310)
#define DEPTHWITHTEXT         (640)
#define WIDTHWITHCLAMSHELL    (990)
#define WIDTHWITHOUTCLAMSHELL (520)

#include "smsafxh.h"
#include "simuapph.h"
#include "winmain.h"
#include "winrc.h"


extern "C"
{
//#include <windows.h>
#include "global.h"
#include "llisth.h"
#include "listview.h"
#include "csm.h"
}


#include <stdio.h>
#include "tt.h"



typedef struct T_TextIDList
{
    T_TextIDList* next;
    char*         text;
    int           id;
    int           length;
} T_TextIDList ;

typedef struct T_UserTextIDList
{
    T_UserTextIDList* next;
    char*             text;
    int               id;
} T_UserTextIDList;


static int FILEDONE;                    // state of reading ttid and ttuser 1=ttid is read 2 both read
static DWORD Tid;                       // number of prozess
static T_TextIDList *Textfirst;         // first pointer of TTid-list
static T_UserTextIDList *UserTextFirst; // firts pointer of TTuserid-list
#define AVAILIBLE_TEXT() ( \
                            (0==strncmp(Helptextsecond,"TXT",3))|| \
                            (0==strncmp(Helptextsecond,"SKP",3))|| \
                            (0==strncmp(Helptextsecond,"TEXT",4)) )

#define ALLOWED_TEXT()   (' '==Helptext[0]) || \
                         (','==Helptext[0]) || \
                         ('{'==Helptext[0]) || \
                         ( 9 ==Helptext[0])



/* ===========================================================================================
 Function func
 Callback function the tread, which read the ttid and ttuserid
 param none


  the ttuserid will be greped after following instruction:
  line muust start with space, ',', tabulator or {
  First string is not allowed to start with / this seems to be a comment
  in the first three text must the word contain "TEXT"
==============================================================================================
*/
DWORD WINAPI Func(void)
{
    FILE* f;
    void *next;
    char Helptext[400];             // text for the character array
    char Helptextsecond[300];       // text for the define name
    char Define[200];               // text for the define
    int  number=0;                  // ID of the textid
    int  result=0;                  // check variable if in the ttiduser the usertext are found
    int  runningnumberoftextid=0;   // int which represent the id (pay attention with this number)
    char Firsttext[100];            // firsttext of scantext
    char Secondtext[100];           // secondtext of scantext
    char Thirdtext[100];            // thirdtext of scantext
    char *Erg;                      // result of textsearch

    UserTextFirst=NULL;
    Textfirst = NULL;
// load normaltext
// originally:  f = fopen(".\\include\\ttid.h","r");
   f = fopen("\\inc\\ttid.h","r"); // Better determine path dynamically !

    if (f==NULL)
    {
        strcpy(Helptext,"Keine TTID.h gefunden");
        SetListViewItem(ALV_TEXT,-1,Helptext);
        ExitThread(0);
        return 0;
    }
    while ((!feof(f)) && (fgets(Helptext,300,f)!=NULL))
    {
        if (3==sscanf(Helptext,"%s %s %i",Define,Helptextsecond,&number))
        {
            if ((0==strcmp(Define,"#define")) &&
                (AVAILIBLE_TEXT()))

            {
                // in ttih it must be a line with TXT_
                // and one with Len_
                (void*)next = malloc(sizeof(T_TextIDList));
                ((T_TextIDList*)(next))->text = (char*)malloc(strlen(Helptextsecond)+1);
                strcpy(((T_TextIDList*)(next))->text,Helptextsecond);
                ((T_TextIDList*)(next))->id         = number;
                fgets(Helptext,300,f);
                sscanf(Helptext,"%s %s %i",Define,Helptextsecond,&number);
                ((T_TextIDList*)(next))->length     = number;
                ((T_TextIDList*)(next))->next       = Textfirst;
                Textfirst = (T_TextIDList*) next;
            }

        }

    }
    fclose(f);
    FILEDONE = 1;
// load Usertext
// originally:  f = fopen(".\\include\\ttuserid.h","r");
   f = fopen("\\inc\\ttuserid.h","r"); // Better determine path dynamically !

    if (f==NULL)
    {
        strcpy(Helptext,"Keine ttuserid.h gefunden");
        SetListViewItem(ALV_USERTEXT,-1,Helptext);
        ExitThread(0);
        return 0;
    }
    result = 0; // Positon in ttuserid not found
    while ((!feof(f)) && (fgets(Helptext,300,f)!=NULL))
    {
        if (NULL  != strstr(Helptext,"TT_FIRSTUSERID"))
        {
            result                = 1; // start reading Usertextid
            runningnumberoftextid = TT_FIRSTUSERID;
        }

        if (NULL  != strstr(Helptext,"TTLastUserText"))
        {
            result                = 0; // Last UserTextid was read
        }

        if (1==result)
        {
            // find the correct text an insert it
            strcpy(Firsttext,"");
            strcpy(Secondtext,"");
            strcpy(Thirdtext,"");
            Erg = NULL;
            sscanf(Helptext,"%s %s %s",Firsttext,Secondtext,Thirdtext);
            // check in which of these numbers the correct textname
            // the first text can start with , and space nothing else
            if (ALLOWED_TEXT())
            {
                // Check in which text is the textname
                if (NULL!=strstr(Firsttext,"TEXT"))
                {
                    Erg = Firsttext;
                }
                else if (NULL!=strstr(Secondtext,"TEXT"))
                {
                    Erg = Secondtext;
                }
                else if (NULL!=strstr(Thirdtext,"TEXT"))
                {
                    Erg = Thirdtext;
                }
                else
                    Erg = NULL;

                if ((NULL != Erg) && ('/'!=Firsttext[0])) // no comments
                {
                    // found a text an insert in the list
                    next = malloc(sizeof(T_UserTextIDList));
                    ((T_UserTextIDList*)next)->id   = runningnumberoftextid;
                    runningnumberoftextid = runningnumberoftextid + 1;
                    ((T_UserTextIDList*)next)->next = UserTextFirst;
                    ((T_UserTextIDList*)next)->text = (char*)malloc(strlen(Erg)+1);
                    strcpy(((T_UserTextIDList*)next)->text,Erg);
                    UserTextFirst = (T_UserTextIDList*)next;
                }


            }

        }
    }

    FILEDONE = 2;
    ExitThread(0);
    return 0;
}



extern "C" HWND DispGetWinHandle(void);

static HWND hlistview=NULLP;
//static char szDialo[]=""

#pragma warn -par
BOOL CALLBACK ListViewDlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    void *next;

    bool ret = FALSE;
        switch (message)
        {
                case WM_CLOSE:
                case WM_DESTROY:
                        DestroyWindow(hwndDlg);
                        hlistview = 0;
                        while (Textfirst!=NULL)
                        {
                            next=(void*)Textfirst;
                            Textfirst=Textfirst->next;
                            free(((T_TextIDList*)next)->text);
                            free(((T_TextIDList*)next));
                        }
                        while (UserTextFirst!=NULL)
                        {
                            next=(void*)UserTextFirst;
                            UserTextFirst=UserTextFirst->next;
                            free(((T_UserTextIDList*)next)->text);
                            free(((T_UserTextIDList*)next));

                        }
                return TRUE;
/*                case WM_ACTIVATE:
                        if (LOWORD(wParam) != WA_INACTIVE)
                        {

                                if (GetFocus() != DispGetWinHandle())
                                {
                                        SetFocus(DispGetWinHandle());
                                        return TRUE;
                                }
                        }
                        break;
*/
                case WM_WINDOWPOSCHANGED:
                case WM_RBUTTONUP:
                case WM_LBUTTONUP:
                case WM_LBUTTONDBLCLK:
                        if (GetFocus() != DispGetWinHandle())
                        {
                          SetFocus(DispGetWinHandle());
                        }
                break;
                case WM_COMMAND:
                {
                    if (IDC_RADIOBTEXT==wParam )
                    {
                      int       nCheckState;
                      HWND      hButton;
                      RECT      winpos;


                      hButton = GetDlgItem(hwndDlg,IDC_RADIOBTEXT);
                      nCheckState = SendMessage(hButton, BM_GETCHECK, 0, 0);

                      // Position der Stateboxberechnen
                      GetWindowRect(hlistview,&winpos);
                      if (nCheckState)
                      {
                        winpos.bottom = DEPTHWITHTEXT;
                      }
                      else
                      {
                        winpos.bottom = DEPTHWITHOUTTEXT;
                      }
                      SetWindowPos(hlistview,HWND_TOP,winpos.left,winpos.top,
                                                      winpos.right-winpos.left,
                                                      winpos.bottom,
                                                      SWP_SHOWWINDOW);
                    }
                else
                    if (IDC_RADIOBCSHELL==wParam )
                    {
                        int       nCheckState, widht;
                        HWND      hButton;
                        RECT      winpos;

                        hButton = GetDlgItem(hwndDlg,IDC_RADIOBCSHELL);
                        nCheckState = SendMessage(hButton, BM_GETCHECK, 0, 0);

                        // Position der Stateboxberechnen
                        GetWindowRect(hlistview,&winpos);
                        if (nCheckState)
                        {
                             widht = WIDTHWITHCLAMSHELL-50;
                        }
                        else
                        {
                             widht  = WIDTHWITHOUTCLAMSHELL-50;
                        }
                        SetWindowPos(hlistview,HWND_TOP,winpos.left,winpos.top,
                                                        widht,
                                                        winpos.bottom-winpos.top,
                                                        SWP_SHOWWINDOW);
                    }
                 else
                  switch (HIWORD(wParam))
                  {
                    case LBN_SETFOCUS:
                        break;
                    //case click / dblclick on Listbox_element
                    case LBN_SELCHANGE:
                    case LBN_DBLCLK:
                    {
                        int  index = LB_ERR;
                        UINT uiLow = LOWORD(wParam);

                        if (uiLow == IDC_LISTBOX1 || uiLow == IDC_LISTBOX5)
                            index = SendDlgItemMessage(hlistview,uiLow,LB_GETCURSEL,0,0);

                        if(index != LB_ERR)
                        {
                          //csm_stack_element is selcted -> show dialog_stack
                            if(uiLow == IDC_LISTBOX1)
                            {
                                SendDlgItemMessage(hlistview,IDWS_LISTBOX2,LB_RESETCONTENT,0,0);
                                update_selected_dialog_stack(index);  
                            }
                            else
                            {
                                SendDlgItemMessage(hlistview,IDWS_LISTBOX3,LB_RESETCONTENT,0,0);
                                update_selected_dialog_stack(index);
                            }
                            ret = TRUE;
                        }
                    break;
                    }
                    default:
                    if (GetFocus() != DispGetWinHandle())
                    {
                        SetFocus(DispGetWinHandle());
                    }
                  }
                  return ret;
                }

        default: ;
        }
        return FALSE;
}
#pragma warn +par
             
                                
extern "C" void ListViewWindowInit(void)
{
        if (hlistview == NULLP)
        {
#ifdef _MSC_VER
                hlistview = CreateDialog(MainApp::hInstance,MAKEINTRESOURCE(DLG_STACKVIEW),DispGetWinHandle(),(DLGPROC)ListViewDlgProc);
#else
                hlistview = CreateDialog(MainApp::hInstance,MAKEINTRESOURCE(DLG_STACKVIEW),DispGetWinHandle(),(FARPROC)ListViewDlgProc);
#endif

                if (hlistview == NULLP)
                {
                        print_d("ERROR in creating ListViewDlg!");
                        return;
                }
                // position is relatively to Display Window underneath, right border aligned
                RECT displrect, viewrect,winpos;
                LONG dx, dy;

                GetWindowRect(DispGetWinHandle(),&displrect);
                GetWindowRect(hlistview,&viewrect);

                dx = viewrect.right - viewrect.left;
                dy = viewrect.bottom - viewrect.top;

                viewrect.top = displrect.bottom + 10;
                viewrect.bottom = viewrect.top + dy;

                viewrect.right = displrect.right;
                viewrect.left = viewrect.right - dx;

                MoveWindow(hlistview,viewrect.left,viewrect.top,dx,dy,TRUE);

                ShowWindow(hlistview,SW_SHOW);
                update_selected_dialog_stack(0x7FFF);


                GetWindowRect(hlistview,&winpos);
                winpos.bottom = DEPTHWITHOUTTEXT;

                SetWindowPos(hlistview,HWND_TOP,50,50,
                            WIDTHWITHOUTCLAMSHELL-50,
                            winpos.bottom,SWP_SHOWWINDOW);

                FILEDONE = 0;
                Tid      = 0;
                CreateThread(NULL,1000, (LPTHREAD_START_ROUTINE)Func,0,0,&Tid);
                // do not know, why the scrollbar is not dynamicall displaid
                // so I send it.
                SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_SETHORIZONTALEXTENT,1000,0);
                SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_SETHORIZONTALEXTENT,1000,0);
        }
        LLPrint( CSMGetStack(),"print caused by ListViewWindowInit" ); // update views immediately
}


/* ======================================================================================
Function to delete all entries from one listbox
Param number of listbox
=========================================================================================
*/
extern "C" void ClearListView(enum AListView view)
{
        if(hlistview == NULLP)
                return; // no window, no clean up

        switch (view)
        {
            case ALV_DialogStack:
                SendDlgItemMessage(hlistview,IDWS_LISTBOX2,LB_RESETCONTENT,0,0);
                break;
            case ALV_TEXT:
                SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_RESETCONTENT,0,0);
                break;
            case ALV_USERTEXT:
                  // not implementated: makes no sence
                  // wie have got a stack
                break;
            case ALV_StatemachineStack:
                SendDlgItemMessage(hlistview,IDC_LISTBOX1,LB_RESETCONTENT,0,0);
                break;

            case CS_DialogStack:
                SendDlgItemMessage(hlistview,IDWS_LISTBOX3,LB_RESETCONTENT,0,0);
                break;
            case CS_TEXT:
                SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_RESETCONTENT,0,0);
                break;
            case CS_USERTEXT:
                  // not implementated: makes no sence
                  // wie have got a stack
                break;
            case CS_StatemachineStack:
                SendDlgItemMessage(hlistview,IDC_LISTBOX5,LB_RESETCONTENT,0,0);
                break;
        }
}

/* ======================================================================
Function to delete all entries from one listbox
Param number of listbox
Param id of textID
=========================================================================
*/
extern "C" void DeleteListViewEntry(enum AListView view, int textID)
{
    int     ActPos      = 0;        // position of the searchtext
    int     Found       = 0;        // text was found
    char    Searchtext[300];        // Buffer to fill in
    int     Numberofentries=0;      // Number of Counts
    char    *HelpText;
    int     ID=0;

    if(hlistview == NULLP)
            return; // no window, no clean up


    switch (view)
    {
        case ALV_USERTEXT:
                    Numberofentries = SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_GETCOUNT ,0,0);
                    ActPos = Numberofentries-1;
                    // there are two possibels to display the id
                    // Text_NAME (ID) Text
                    // ID Text
                    while ((ActPos>=0)&&(Found==0))
                    {
                        SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_GETTEXT ,ActPos,(LPARAM) Searchtext);
                        HelpText=strstr(Searchtext,"(");
                        if (HelpText == NULL)
                            sscanf(Searchtext,"%i",&ID);
                        else
                            sscanf(HelpText,"(%i)",&ID);
                        if (ID == textID)
                            Found = 1;
                        else ActPos = ActPos-1;
                    }
                    if (Found==1) SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_DELETESTRING ,ActPos,0);
                break;

        case CS_USERTEXT:
                    Numberofentries = SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_GETCOUNT ,0,0);
                    ActPos = Numberofentries-1;
                    // there are two possibels to display the id
                    // Text_NAME (ID) Text
                    // ID Text
                    while ((ActPos>=0)&&(Found==0))
                    {
                        SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_GETTEXT ,ActPos,(LPARAM) Searchtext);
                        HelpText=strstr(Searchtext,"(");
                        if (HelpText == NULL)
                            sscanf(Searchtext,"%i",&ID);
                        else
                            sscanf(HelpText,"(%i)",&ID);
                        if (ID == textID)
                            Found = 1;
                        else ActPos = ActPos-1;
                    }
                    if (Found==1) SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_DELETESTRING ,ActPos,0);
                break;
        default:
            break;
    }
}

/* ============================================================================================
Function to call the destructor
Param none
============================================================================================= */
extern "C" void DestroyListView(void)
{
    if (NULLP != hlistview)
                    SendMessage(hlistview,WM_DESTROY,0,0);
}


char text[400]="\0";
char text1[400]="\0";

/* ============================================================================================
Function to make a new entries in one listbox
Param number of listbox
Param number of listindex
Param pointer to string
============================================================================================= */
extern "C" void SetListViewItem(enum AListView view, int listindex, const char *itemstring)
{
        if(hlistview == NULLP)
                return; // no window, no output


        switch (view)
        {
            case ALV_DialogStack:
            {
                SendDlgItemMessage(hlistview,IDWS_LISTBOX2,LB_DELETESTRING,(WPARAM)listindex,0);
                SendDlgItemMessage(hlistview,IDWS_LISTBOX2,LB_INSERTSTRING,(WPARAM)listindex,(LPARAM)itemstring);
            }
            break;
            case ALV_TEXT:
            {
                // Look for the correct TextID
                // first we look if the id is alread insert
                // there are two possibilities
                // Textname () length text
                // or id length text
                int CountEntries = SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_GETCOUNT ,0,0);
                char Searchtext[300],*HelpText;
                int ID = 0;
                int textID = 0;

                sscanf(itemstring,"%i",&textID);

                CountEntries     = CountEntries - 1;

                while (CountEntries >= 0)
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_GETTEXT ,CountEntries,(LPARAM) Searchtext);
                    HelpText=strstr(Searchtext,"(");
                    if (HelpText == NULL)
                        sscanf(Searchtext,"%i",&ID);
                    else
                        sscanf(HelpText,"(%i)",&ID);

                    if (ID == textID) return;

                    CountEntries = CountEntries - 1;
                }
                    
                // ID was not found, look for the correct name
                if (0<FILEDONE)
                {
                    T_TextIDList *next=Textfirst;
                    int ID;
                    int WStringLength;
                    char outputtext[300]="\0";
                    char *Helptext = NULLP;

                    sscanf(itemstring,"%i %i %s",&ID,&WStringLength,outputtext); // which ID
                    Helptext = strstr(itemstring,outputtext);
                    if (NULLP!=Helptext) strcpy(outputtext,Helptext); // text with space

                    while (NULL!=next)
                    {
                        if (ID==next->id)
                        {
                            sprintf(text,"%30s (%4i) %3i<%3i %s",next->text,next->id,
                                          next->length,WStringLength,outputtext);
                            next = NULL;    // correct entrance
                            strcpy(text1,"hallo");
                            SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_ADDSTRING,0,(LPARAM)text);
                            ID=-1;          // no more search
                        }
                        if (NULL!=next) 
                            next=next->next;
                    }

                    if (-1!=ID)
                        SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
                else
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX4,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
            }
            break;
            case ALV_USERTEXT:
            {
                if (1<FILEDONE)
                {
                    char text[400]="\0";
                    T_UserTextIDList *next=UserTextFirst;
                    int ID;
                    char outputtext[300];
                    char *Helptext = NULLP;

                    sscanf(itemstring,"%i %s",&ID,outputtext);
                    Helptext = strstr(itemstring,outputtext);
                    if (NULLP != Helptext ) strcpy(outputtext,Helptext);
                    while (NULL!=next)
                    {
                        if (ID==next->id)
                        {
                            sprintf(text,"%30s (%4i) %s",next->text,next->id
                                          ,outputtext);
                            next = NULL; // not more search
                            ID   = -1;   // correct entrance
                            SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_ADDSTRING,0,(LPARAM)text);
                        }
                    if (NULL!=next) 
                        next=next->next;
                    }
                    if (-1!=ID)
                        SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
                else
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX3,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
            }
            break;
            case ALV_StatemachineStack:
            {
                SendDlgItemMessage(hlistview,IDC_LISTBOX1,LB_DELETESTRING,(WPARAM)listindex,0);
                SendDlgItemMessage(hlistview,IDC_LISTBOX1,LB_INSERTSTRING,(WPARAM)listindex,(LPARAM)itemstring);
            }
            break;
////////////Clamshell Display
            case CS_DialogStack:
            {
                SendDlgItemMessage(hlistview,IDWS_LISTBOX3,LB_DELETESTRING,(WPARAM)listindex,0);
                SendDlgItemMessage(hlistview,IDWS_LISTBOX3,LB_INSERTSTRING,(WPARAM)listindex,(LPARAM)itemstring);        
            }
            break;
            case CS_TEXT:
            {
                // Look for the correct TextID
                // first we look if the id is alread insert
                // there are two possibilities
                // Textname () length text
                // or id length text
                int CountEntries = SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_GETCOUNT ,0,0);
                char Searchtext[300],*HelpText;
                int ID = 0;
                int textID = 0;

                sscanf(itemstring,"%i",&textID);

                CountEntries     = CountEntries - 1;

                while (CountEntries >= 0)
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_GETTEXT ,CountEntries,(LPARAM) Searchtext);
                    HelpText=strstr(Searchtext,"(");
                    if (HelpText == NULL)
                        sscanf(Searchtext,"%i",&ID);
                    else
                        sscanf(HelpText,"(%i)",&ID);
                    if (ID == textID) 
                        return;

                    CountEntries = CountEntries - 1;
                }

                // ID was not found, look for the correct name
                if (0<FILEDONE)
                {
                    T_TextIDList *next=Textfirst;
                    int ID;
                    int WStringLength;
                    char outputtext[300]="\0";
                    char *Helptext = NULLP;

                    sscanf(itemstring,"%i %i %s",&ID,&WStringLength,outputtext); // which ID
                    Helptext = strstr(itemstring,outputtext);
                    if (NULLP!=Helptext) strcpy(outputtext,Helptext); // text with space

                while (NULL!=next)
                {
                    if (ID==next->id)
                    {
                        sprintf(text,"%30s (%4i) %3i<%3i %s",next->text,next->id,
                                        next->length,WStringLength,outputtext);
                        next = NULL;    // correct entrance
                        strcpy(text1,"hallo");
                        SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_ADDSTRING,0,(LPARAM)text);
                        ID=-1;          // no more search
                    }
                    if (NULL!=next) next=next->next;
                }

                if (-1!=ID)
                    SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
                else
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX7,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
             } 
            break;
            case CS_StatemachineStack:
            {
                SendDlgItemMessage(hlistview,IDC_LISTBOX5,LB_DELETESTRING,(WPARAM)listindex,0);
                SendDlgItemMessage(hlistview,IDC_LISTBOX5,LB_INSERTSTRING,(WPARAM)listindex,(LPARAM)itemstring);     
            }
            break;
            case CS_USERTEXT:
            {
                if (1<FILEDONE)
                {
                    char text[400]="\0";
                    T_UserTextIDList *next=UserTextFirst;
                    int ID;
                    char outputtext[300];
                    char *Helptext = NULLP;

                    sscanf(itemstring,"%i %s",&ID,outputtext);
                    Helptext = strstr(itemstring,outputtext);
                    if (NULLP != Helptext ) strcpy(outputtext,Helptext);
                    while (NULL!=next)
                    {
                        if (ID==next->id)
                        {
                            sprintf(text,"%30s (%4i) %s",next->text,next->id
                                          ,outputtext);
                            next = NULL; // not more search
                            ID   = -1;   // correct entrance
                            SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_ADDSTRING,0,(LPARAM)text);
                        }
                    if (NULL!=next) 
                        next=next->next;
                    }
                    if (-1!=ID)
                        SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
                else
                {
                    SendDlgItemMessage(hlistview,IDC_LISTBOX6,LB_ADDSTRING,0,(LPARAM)itemstring);
                }
            } 
            break;
            default:
              break;
        }
}

//if selected csm is not the aktive_csm, set aktive_csm as selected
void reset_csm_list(enum AListView view)
{

    if(hlistview == NULLP)
        return;     // no window, no reset / boundschecker ! (sauerh)

    int i, nr;
    UINT uiIDC = IDC_LISTBOX1;
    switch (view)
    {
        case CS_StatemachineStack: 
        {
            uiIDC = IDC_LISTBOX5;
        }
        break;
        default: uiIDC = IDC_LISTBOX1;
    }
    i  = SendDlgItemMessage(hlistview,uiIDC,LB_GETCURSEL,0,0);
    nr = SendDlgItemMessage(hlistview,uiIDC,LB_GETCOUNT,0,0)- 1;
    
    if(i!=nr)
       SendDlgItemMessage(hlistview,uiIDC,LB_SETCURSEL,(WPARAM)nr,0);

}
