/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR Wolfgang Goedde

.FILENAME alarmsetdlg.c

.CSVERSION 1.1

.VERSION 01.00.01

.DATE 2002-09-12

.SHORT_DESCR  dialog implementation for changing alarm settings

.SW_COMPONENT PC-MMI-Test Environment

.SW_TYPE 

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2002-08-30 Wolfgang Goedde (KLF_EXT)
         Initial Version
01.00.01 2002-09-12 Jens Scharnow (KLF)
         Changed message when alarm is triggered
------------------------------------------------------------------------------*/


/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include "AlarmSetDlgh.h"
#include "sms_res.h"

extern "C"
{
    #include <global.h>
    #include "gbs.h"
    #include "app_msg.h"
    #include "procid.h"
    #include "alclkalh.h"
}

// sorry, but couldn't avoid this
extern "C" void* SendMessageU(PID pidDest,unsigned int nMId,SMP_TYPE param, ...);
/* -----------------------------------------------------------------------------
    EXIT DEFINES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    DEFINES
------------------------------------------------------------------------------*/
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL CONSTANTS
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL VARIABLES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL PROTOTYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION EXPORTED FUNCTIONS
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION LOCAL FUNCTIONS
------------------------------------------------------------------------------*/

CAlarmSetDlg::CAlarmSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAlarmSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAlarmSetDlg)
	m_nAlarmClockHour = 0;
	m_nAlarmClockMin = 0;
	m_nAlarmClockSec = 0;
    m_bAlarmClockActive = FALSE;
    m_strStatus = _T("ready.");
    //}}AFX_DATA_INIT
}

//------------------------------------------------------------------------------
void CAlarmSetDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAlarmSetDlg)
	DDX_Control(pDX, IDS_ALARM_SEC, m_SpinSec);
	DDX_Control(pDX, IDS_ALARM_MIN, m_SpinMin);
	DDX_Control(pDX, IDS_ALARM_HOUR, m_SpinHour);
    DDX_Text(pDX, IDE_ALARM_HOUR, m_nAlarmClockHour);
	DDX_Text(pDX, IDE_ALARM_MIN, m_nAlarmClockMin);
	DDX_Text(pDX, IDS_ALARM_SEC, m_nAlarmClockSec);
    DDX_Check(pDX, IDC_ALARM_ACTIV_CLOCK, m_bAlarmClockActive);
    DDV_MinMaxInt(pDX, m_nAlarmClockSec, 0, 59);
    DDV_MinMaxInt(pDX, m_nAlarmClockMin, 0, 59);
    DDV_MinMaxInt(pDX, m_nAlarmClockHour, 0, 23);
    DDX_Text(pDX, IDS_STATUS, m_strStatus);
	//}}AFX_DATA_MAP

}

//------------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CAlarmSetDlg, CDialog)
	//{{AFX_MSG_MAP(CAlarmSetDlg)
	ON_BN_CLICKED(IDB_ALARM_TRIGGER, OnAlarmTrigger)
    ON_BN_CLICKED(IDB_ALARM_READ_CLOCK, OnAlarmReadClock)
    ON_BN_CLICKED(IDB_ALARM_WRITE_CLOCK, OnAlarmWriteClock)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//------------------------------------------------------------------------------
BOOL CAlarmSetDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_SpinHour.SetRange(0,23);
    m_SpinMin.SetRange(0,59);
    m_SpinSec.SetRange(0,59);
	return TRUE;
}

//------------------------------------------------------------------------------
void CAlarmSetDlg::OnAlarmTrigger() 
{
    // posts a message in order to pop up an alarm immediately
    static int i=0;
    // due to simu-problems (double declared functions) the following constants cannot be included:
    // enAlarmClockMode=5,
    // E_RTCAL_RTC_MMI_ALARM=0
    GbsPostMessageW2(MMI_PID, M_RTC_MMI_ALARM, 5, 0, 0);
    m_strStatus.Format(_T("trigger[%d]"), ++i);
    UpdateData(false);
}

//------------------------------------------------------------------------------
void CAlarmSetDlg::OnAlarmReadClock() 
{
    // read all alarm clock related data from simulated eefull
	AlarmClock_ReadAlarmClockData();

    m_nAlarmClockHour =AlarmClock_GetHour();
    m_nAlarmClockMin  =AlarmClock_GetMinute();

    m_bAlarmClockActive=AlarmClock_IsAlarmActive();
    m_strStatus=_T("alarm clock data has been read.");
    UpdateData(false);
}

//------------------------------------------------------------------------------
void CAlarmSetDlg::OnAlarmWriteClock() 
{
    UpdateData(true);

    // write all alarm clock related data to simulated eefull
    AlarmClock_SetWeekdays(0x7f);
    AlarmClock_SetHour(m_nAlarmClockHour);
    AlarmClock_SetMinute(m_nAlarmClockMin);	
    (m_bAlarmClockActive) ? AlarmClock_SetMode(AcActive) : AlarmClock_UnsetMode(AcActive);
    
    AlarmClock_WriteAlarmClockData();
    AlarmClock_SetNewAlarmClockData(true);
    m_strStatus=_T("alarm clock data has been written.");
    UpdateData(false);
}

/* -----------------------------------------------------------------------------
    END OF FILE alarmsetdlg.cpp
------------------------------------------------------------------------------*/

