/* -----------------------------------------------------------------------------

 Copyright (C) Siemens AG 1994-2001,  ALL RIGHTS RESERVED

 This software is protected by the inclusion of the above copyright
 notice. This software may not be provided or otherwise made available
 to, or used by, any other person. No title to or ownership of the
 software is  hereby  transferred.
 The information contained in this document is considered the
 CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
 not be disclosed or discussed with anyone who is not employed by
 Siemens AG, unless the individual / company
 (i) has an express need to know such information, and
 (ii) disclosure of information is subject to the terms of a duly
 executed Confidentiality and Non-Disclosure Agreement between
 Siemens AG and the individual / company.



.AUTHOR         Zhang Jing (SLC)

.FILENAME       sp_vsmemdc.cpp

.VERSION        01.00.00

.DATE           2004-02-17

.SHORT_DESCR    memory DC for drawing 

.SW_COMPONENT   MMI PC-SIMULATION

.SW_TYPE        

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2004-02-17  Zhang Jing (SLC)
         Initial version

*/


#include "smsafxh.h"
#include "sp_vsmemdch.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CXTMemDC, CDC);

//////////////////////////////////////////////////////////////////////
// CXTMemDC - implementation

CXTMemDC::CXTMemDC(CDC* pDC, const CRect& rect, COLORREF clrColor/*=xtAfxData.clr3DFace*/)
{
	ASSERT(pDC != NULL);
	m_pDC = pDC;
	
	// If rect is NULL, use the device context's clip box.
	if (rect.IsRectEmpty())
		m_pDC->GetClipBox(&m_rc);
	else
		m_rc.CopyRect(&rect);

    // Create the memory DC, set Map Mode
	if (CreateCompatibleDC(m_pDC))
	{
		SetMapMode(m_pDC->GetMapMode());
		
		// Create a bitmap big enough to hold the window's image
		m_bitmap.CreateCompatibleBitmap(m_pDC, m_rc.Width(), m_rc.Height());
		
		// Select the bitmap into the memory DC
		m_pOldBitmap = SelectObject(&m_bitmap);
		
		// Repaint the background, this takes the place of WM_ERASEBKGND.
		if (clrColor != -1) 
			FillSolidRect(m_rc, clrColor);
		
		m_bValid = TRUE;
	}

	// Something bad happened, could be GDI leak, didn't create device context.
	else
	{
		m_bValid = FALSE;
		m_pOldBitmap = NULL;
	}
}

CXTMemDC::~CXTMemDC()
{
	if (m_bValid)
	{
		// Blt it
		m_pDC->BitBlt(m_rc.left, m_rc.top, m_rc.Width(), m_rc.Height(),
			this, 0, 0, SRCCOPY);            
	}

	// Select the original bitmap back in
	if (m_pOldBitmap != NULL)
		SelectObject(m_pOldBitmap);

	DeleteDC();
}

