/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       Iappinterface.h

.TODO           

.SHORT_DESCR    Pure virtual interface functions definition (from PC-SIMU for the Plugins).
.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br> 
------------------------------------------------------------------------------*/
#ifndef _APPLICATION_INTERFACE_H_
#define _APPLICATION_INTERFACE_H_

/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "plugintyps.h"
/* -----------------------------------------------------------------------------
DEFINES
------------------------------------------------------------------------------*/
/** @defgroup app_interface_base PC-Simulation BASE Interface 
 *  Base interface from PC-Simulation to all plug-ins.
 *  @{
 */

/**
 *   \def APPLICATION_BASE_API_VERSION
 *   A Versioning Macro to determine the Applications API version. 
 *   This macro will be use to check the interface compatibility between 
 *   the Application and the PlugIn
 *
 *   IMPORTANT: The APPLICATION_API_VERSION must be increase by every change of 
 *   the base Interface!!! Don't forget!!!
 */
#define APPLICATION_BASE_API_VERSION 0x0001

/* -----------------------------------------------------------------------------
TYPES
--------------------------------------------------------------------------------*/
// 
/*!
 * typdef of pseudo  IApplicationInterfaceMOPI to get compiled.
 * we don't need know how the IApplicationInterfaceMOPI should look like.
 */
typedef interface IApplicationInterfaceMOPI IApplicationInterfaceMOPI;

/** \interface IApplicationInterfaceBase
 *  Base PC-Simulation interface for all plug-ins. Every plug-in can call the following 
 *  interface functions.
 */
interface IApplicationInterfaceBase
{
    /**
     *   This function will return the APPLICATION_API_VERSION (interface version) 
     *   which was compiled with the PlugIn.
     *
     *   @return  DWORD: a value which identifies the BASE API version of the PlugIn.
     */
    virtual DWORD GetApplicationAPIVersion() PURE;

    /**
     *   This function returns commands IDs for plug-ins.
     *   The range of commands are between PLUGIN_COMMAND_START_ID 
     *   and PLUGIN_COMMAND_END_ID.
     *
     *   @param  num: number of requested command ID.
     *   @return UINT: free command ID. 
     */
    virtual UINT GetCommandIDs(int num) PURE;

    /**
     *   This function gives the MOPI Application interfaces for the MOPI_PlugIn.dll.
     *
     *   @param  ptrMOPIAppInterface: the addres of the IApplicationInterfaceMOPI object.
     *   @return BOOL: TRUE if IApplicationInterfaceMOPI is available. 
     */
    virtual BOOL GetMOPIApplicationInterface(IApplicationInterfaceMOPI *&ptrMOPIAppInterface) PURE; 
};

#endif //_APPLICATION_INTERFACE_H_
/** @} */ // end of plug_in_interface_base
/* -----------------------------------------------------------------------------
END OF FILE Iappinterface.h
------------------------------------------------------------------------------*/

